/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DateCellRenderer
extends DefaultTableCellRenderer {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public DateCellRenderer() {
        this(0);
    }

    public DateCellRenderer(int alignment) {
        this.setHorizontalAlignment(alignment);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (value == null) {
            this.setText("--");
        } else {
            this.setText(this.dateFormat.format(((Calendar)value).getTime()));
        }
        return this;
    }
}

