/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class DeployInDebugModeDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private DebugOptions debugOptions = new DebugOptions();
    private boolean isDebugChannel = false;
    public static final String NEW_CHANNELS = "Debug Channel";
    JLabel debugLabel;
    JLabel libraryChannelsSelectAllLabel;
    JLabel libraryChannelsDeselectAllLabel;
    private JCheckBox deployUndeployCheckBox;
    private JCheckBox attachmentBatchCheckBox;
    private JCheckBox sourceConnectorBatchCheckBox;
    private JCheckBox sourceFilterTransformerCheckBox;
    private JCheckBox destinationFilterTransformerCheckBox;
    private JCheckBox destinationScriptsCheckBox;
    private JCheckBox destinationRespCheckBox;
    private JPanel notificationPanel;
    private JButton cancelButton;
    private JButton okButton;

    public DeployInDebugModeDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.setDefaultCloseOperation(2);
        DisplayUtil.setResizable(this, false);
        this.setPreferredSize(new Dimension(400, 300));
        this.setModal(true);
        this.initComponents();
        this.initLayout();
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
    }

    private void initLayout() {
        this.notificationPanel.add((Component)this.debugLabel, "alignx left");
        this.notificationPanel.add((Component)this.libraryChannelsSelectAllLabel, "alignx left");
        this.notificationPanel.add((Component)this.libraryChannelsDeselectAllLabel, "alignx left");
        this.notificationPanel.add((Component)this.deployUndeployCheckBox, "newline, left");
        this.notificationPanel.add((Component)this.attachmentBatchCheckBox, "newline, left");
        this.notificationPanel.add((Component)this.sourceConnectorBatchCheckBox, "newline, left");
        this.notificationPanel.add((Component)this.sourceFilterTransformerCheckBox, "newline, left");
        this.notificationPanel.add((Component)this.destinationFilterTransformerCheckBox, "newline, left");
        this.notificationPanel.add((Component)this.destinationScriptsCheckBox, "newline, left");
        this.notificationPanel.add((Component)this.destinationRespCheckBox, "newline, left");
        this.add((Component)this.notificationPanel, "grow, push, span");
        this.add((Component)new JSeparator(), "grow, gaptop 4, span");
        this.add((Component)this.okButton, " gapleft 110, gapright 10, width 60, spany 2");
        this.add((Component)this.cancelButton, "gapright 110, width 60, spany 2");
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 12", "[]", "[fill][]"));
        this.setTitle(NEW_CHANNELS);
        this.notificationPanel = new JPanel();
        this.notificationPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, fill", "[200!][]", "[25!]0[]"));
        this.debugLabel = new JLabel("Select channel script to debug");
        this.libraryChannelsSelectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.libraryChannelsSelectAllLabel.setForeground(Color.BLUE);
        this.libraryChannelsSelectAllLabel.setCursor(new Cursor(12));
        this.libraryChannelsSelectAllLabel.setToolTipText("Select all channel scripts.");
        this.libraryChannelsSelectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DeployInDebugModeDialog.this.deployUndeployCheckBox.setSelected(true);
                DeployInDebugModeDialog.this.attachmentBatchCheckBox.setSelected(true);
                DeployInDebugModeDialog.this.sourceConnectorBatchCheckBox.setSelected(true);
                DeployInDebugModeDialog.this.sourceFilterTransformerCheckBox.setSelected(true);
                DeployInDebugModeDialog.this.destinationFilterTransformerCheckBox.setSelected(true);
                DeployInDebugModeDialog.this.destinationScriptsCheckBox.setSelected(true);
                DeployInDebugModeDialog.this.destinationRespCheckBox.setSelected(true);
            }
        });
        this.libraryChannelsDeselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.libraryChannelsDeselectAllLabel.setForeground(Color.BLUE);
        this.libraryChannelsDeselectAllLabel.setCursor(new Cursor(12));
        this.libraryChannelsDeselectAllLabel.setToolTipText("Deselect all channel scripts.");
        this.libraryChannelsDeselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DeployInDebugModeDialog.this.deployUndeployCheckBox.setSelected(false);
                DeployInDebugModeDialog.this.attachmentBatchCheckBox.setSelected(false);
                DeployInDebugModeDialog.this.sourceConnectorBatchCheckBox.setSelected(false);
                DeployInDebugModeDialog.this.sourceFilterTransformerCheckBox.setSelected(false);
                DeployInDebugModeDialog.this.destinationFilterTransformerCheckBox.setSelected(false);
                DeployInDebugModeDialog.this.destinationScriptsCheckBox.setSelected(false);
                DeployInDebugModeDialog.this.destinationRespCheckBox.setSelected(false);
            }
        });
        this.deployUndeployCheckBox = new JCheckBox("Deploy/Undeploy/Preprocessor/Postprocessor scripts");
        this.attachmentBatchCheckBox = new JCheckBox("Attachment/Batch scripts");
        this.sourceConnectorBatchCheckBox = new JCheckBox("Source connector scripts");
        this.sourceFilterTransformerCheckBox = new JCheckBox("Source filter/transformer");
        this.destinationFilterTransformerCheckBox = new JCheckBox("Destination filter/transformer");
        this.destinationScriptsCheckBox = new JCheckBox("Destination connector scripts");
        this.destinationRespCheckBox = new JCheckBox("Destination response transformer");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployInDebugModeDialog.this.close();
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DeployInDebugModeDialog.this.deployUndeployCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setDeployUndeployPreAndPostProcessorScripts(true);
                }
                if (DeployInDebugModeDialog.this.attachmentBatchCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setAttachmentBatchScripts(true);
                }
                if (DeployInDebugModeDialog.this.sourceConnectorBatchCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setSourceConnectorScripts(true);
                }
                if (DeployInDebugModeDialog.this.sourceFilterTransformerCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setSourceFilterTransformer(true);
                }
                if (DeployInDebugModeDialog.this.destinationFilterTransformerCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setDestinationFilterTransformer(true);
                }
                if (DeployInDebugModeDialog.this.destinationScriptsCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setDestinationConnectorScripts(true);
                }
                if (DeployInDebugModeDialog.this.destinationRespCheckBox.isSelected()) {
                    DeployInDebugModeDialog.this.debugOptions.setDestinationResponseTransformer(true);
                }
                DeployInDebugModeDialog.this.isDebugChannel = true;
                DeployInDebugModeDialog.this.dispose();
            }
        });
        this.pack();
    }

    private void close() {
        this.dispose();
    }

    @Override
    public void onCloseAction() {
        this.close();
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public boolean getIsDebugChannel() {
        return this.isDebugChannel;
    }
}

