/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.ItemSelectionTable;
import com.mirth.connect.client.ui.components.ItemSelectionTableModel;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.donkey.model.message.RawMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class EditMessageDialog
extends MirthDialog
implements DropTargetListener {
    private Frame parent;
    private String channelId;
    private String dataType;
    private List<String> content = new ArrayList<String>();
    public JPanel buttonPanel;
    private JButton closeButton1;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private MirthSyntaxTextArea messageContent;
    private MirthTable mirthTable1;
    private JButton newButton;
    private JButton openBinaryFileButton;
    private JButton openTextFileButton;
    private JButton processMessageButton;
    private JLabel sourceMapLabel;
    private JScrollPane sourceMapScrollPane;
    private MirthTable sourceMapTable;

    public EditMessageDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.pack();
        new DropTarget(this.messageContent, this);
    }

    public void setPropertiesAndShow(String message, String dataType, String channelId, Map<Integer, String> destinationConnectors, List<Integer> selectedMetaDataIds, Map<String, Object> sourceMap) {
        this.channelId = channelId;
        this.setMessage(message, dataType);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.initDestinationConnectorTable(destinationConnectors, selectedMetaDataIds);
        this.initSourceMapTable(sourceMap);
        this.setVisible(true);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setMessage(String message, String dataType) {
        this.dataType = dataType;
        this.setCorrectDocument(this.messageContent, message, dataType);
        this.messageContent.setCaretPosition(0);
    }

    private void initDestinationConnectorTable(Map<Integer, String> destinationConnectors, List<Integer> selectedMetaDataIds) {
        this.mirthTable1 = new ItemSelectionTable();
        this.mirthTable1.setModel(new ItemSelectionTableModel<Integer, String>(destinationConnectors, selectedMetaDataIds, "Destination", "Included"));
        this.jScrollPane1.setViewportView((Component)((Object)this.mirthTable1));
    }

    private void initSourceMapTable(Map<String, Object> sourceMap) {
        Object[][] data = new Object[sourceMap.size()][2];
        int i = 0;
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        this.sourceMapTable = new MirthTable();
        this.sourceMapTable.setModel(new RefreshTableModel(data, new Object[]{"Variable", "Value"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }
        });
        this.sourceMapTable.setDragEnabled(false);
        this.sourceMapTable.setRowSelectionAllowed(true);
        this.sourceMapTable.setSelectionMode(0);
        this.sourceMapTable.setRowHeight(20);
        this.sourceMapTable.setFocusable(false);
        this.sourceMapTable.setOpaque(true);
        this.sourceMapTable.getTableHeader().setResizingAllowed(false);
        this.sourceMapTable.getTableHeader().setReorderingAllowed(false);
        this.sourceMapTable.setSortable(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.sourceMapTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.sourceMapTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    EditMessageDialog.this.deleteButton.setEnabled(EditMessageDialog.this.sourceMapTable.getSelectedRow() > -1);
                }
            }
        });
        class SourceMapTableCellEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            private JTable table;
            private Component editingComponent;
            private JTextField textField;
            private JCheckBox checkBox;
            private int column;
            private boolean keyColumn;
            private Object originalValue;
            private Object newValue;

            public SourceMapTableCellEditor(JTable table, int column, boolean keyColumn) {
                this.table = table;
                this.column = column;
                this.keyColumn = keyColumn;
                this.textField = new JTextField();
                this.textField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        textField.setCaretPosition(textField.getText().length());
                    }
                });
                this.checkBox = new JCheckBox();
                this.checkBox.setHorizontalAlignment(0);
                this.editingComponent = this.textField;
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt == null) {
                    return false;
                }
                if (evt instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)evt;
                    int row = this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    Object obj = this.table.getValueAt(row, this.column);
                    if (obj instanceof Boolean) {
                        return true;
                    }
                    return mouseEvent.getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.originalValue = value;
                this.newValue = null;
                if (value instanceof Boolean) {
                    this.editingComponent = this.checkBox;
                    this.checkBox.setSelected((Boolean)value);
                    this.checkBox.setForeground(table.getSelectionForeground());
                    this.checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.editingComponent = this.textField;
                    this.textField.setText(String.valueOf(value));
                }
                return this.editingComponent;
            }

            @Override
            public Object getCellEditorValue() {
                if (this.newValue != null) {
                    return this.newValue;
                }
                return this.originalValue;
            }

            @Override
            public boolean stopCellEditing() {
                if (!this.acceptValue()) {
                    super.cancelCellEditing();
                } else {
                    this.newValue = this.editingComponent == this.checkBox ? Boolean.valueOf(this.checkBox.isSelected()) : this.textField.getText();
                }
                return super.stopCellEditing();
            }

            private boolean acceptValue() {
                if (this.editingComponent == this.checkBox) {
                    return this.checkBox.isSelected() != ((Boolean)this.originalValue).booleanValue();
                }
                String value = this.textField.getText();
                if (this.keyColumn) {
                    if (StringUtils.isBlank((CharSequence)value)) {
                        return false;
                    }
                    for (int i = 0; i < this.table.getRowCount(); ++i) {
                        if (!value.equals(this.table.getValueAt(i, this.column))) continue;
                        return false;
                    }
                }
                return !value.equals(this.originalValue);
            }
        }
        this.sourceMapTable.getColumnModel().getColumn(0).setCellEditor(new SourceMapTableCellEditor((JTable)((Object)this.sourceMapTable), 0, true));
        this.sourceMapTable.getColumnModel().getColumn(1).setCellEditor(new SourceMapTableCellEditor((JTable)((Object)this.sourceMapTable), 1, false));
        class SourceMapTableCellRenderer
        extends DefaultTableCellRenderer {
            private JTextField textField = new JTextField();
            private JCheckBox checkBox;

            public SourceMapTableCellRenderer() {
                this.textField.setBorder(null);
                this.checkBox = new JCheckBox();
                this.checkBox.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent component;
                if (value instanceof Boolean) {
                    component = this.checkBox;
                    this.checkBox.setSelected((Boolean)value);
                } else {
                    component = this.textField;
                    this.textField.setText(String.valueOf(value));
                }
                if (isSelected) {
                    ((Component)component).setForeground(table.getSelectionForeground());
                    ((Component)component).setBackground(table.getSelectionBackground());
                } else {
                    ((Component)component).setForeground(table.getForeground());
                    ((Component)component).setBackground(table.getBackground());
                }
                return component;
            }
        }
        this.sourceMapTable.getColumnModel().getColumn(1).setCellRenderer(new SourceMapTableCellRenderer());
        this.sourceMapScrollPane.setViewportView((Component)((Object)this.sourceMapTable));
        this.deleteButton.setEnabled(false);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                dtde.rejectDrag();
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    this.messageContent.setText(this.messageContent.getText() + FileUtils.readFileToString((File)file, (String)"UTF-8"));
                }
            }
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    private void setCorrectDocument(MirthSyntaxTextArea textPane, String message, String dataType) {
        SyntaxDocument newDoc = new SyntaxDocument();
        if (message != null) {
            TokenMarker tokenMarker;
            if (dataType != null && (tokenMarker = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getTokenMarker()) != null) {
                newDoc.setTokenMarker(tokenMarker);
            }
            textPane.setDocument(newDoc);
            textPane.setText(message);
        } else {
            textPane.setDocument(newDoc);
            textPane.setText("");
        }
        textPane.setCaretPosition(0);
    }

    private String getNewSourceMapKey() {
        String key;
        int num = 1;
        while (this.sourceMapKeyExists(key = "key" + num++)) {
        }
        return key;
    }

    private boolean sourceMapKeyExists(String key) {
        for (int row = 0; row < this.sourceMapTable.getRowCount(); ++row) {
            if (!key.equals(this.sourceMapTable.getValueAt(row, 0))) continue;
            return true;
        }
        return false;
    }

    private int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    private int getSelectedColumn(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingColumn();
        }
        return table.getSelectedColumn();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.newButton = new JButton();
        this.processMessageButton = new JButton();
        this.messageContent = new MirthSyntaxTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.mirthTable1 = new MirthTable();
        this.jLabel1 = new JLabel();
        this.buttonPanel = new JPanel();
        this.openBinaryFileButton = new JButton();
        this.openTextFileButton = new JButton();
        this.sourceMapLabel = new JLabel();
        this.sourceMapScrollPane = new JScrollPane();
        this.sourceMapTable = new MirthTable();
        this.closeButton1 = new JButton();
        this.deleteButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Message");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.newButton.setText("New");
        this.newButton.setToolTipText("Close this message sender dialog.");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMessageDialog.this.newButtonActionPerformed(evt);
            }
        });
        this.processMessageButton.setText("Process Message");
        this.processMessageButton.setToolTipText("Process the message displayed in the editor above.");
        this.processMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMessageDialog.this.processMessageButtonActionPerformed(evt);
            }
        });
        this.messageContent.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setViewportView((Component)((Object)this.mirthTable1));
        this.jLabel1.setText("Send to the following destination(s):");
        this.buttonPanel.setBackground(new Color(255, 255, 255));
        this.openBinaryFileButton.setText("Open Binary File...");
        this.openBinaryFileButton.setToolTipText("<html>Open a binary file into the editor above.<br>The file will be encoded and displayed as Base64.</html>");
        this.openBinaryFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMessageDialog.this.openBinaryFileButtonActionPerformed(evt);
            }
        });
        this.openTextFileButton.setText("Open Text File...");
        this.openTextFileButton.setToolTipText("Open a text file into the editor above.");
        this.openTextFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMessageDialog.this.openTextFileButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, buttonPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.openTextFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openBinaryFileButton)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openBinaryFileButton, -1, -1, Short.MAX_VALUE).addComponent(this.openTextFileButton)));
        this.sourceMapLabel.setText("Include the following source map variables:");
        this.sourceMapScrollPane.setViewportView((Component)((Object)this.sourceMapTable));
        this.closeButton1.setText("Close");
        this.closeButton1.setToolTipText("Close this message sender dialog.");
        this.closeButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMessageDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Close this message sender dialog.");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMessageDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jLabel1, -1, 584, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(this.messageContent, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.sourceMapLabel, -1, 584, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.sourceMapScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.deleteButton, -1, -1, Short.MAX_VALUE).addComponent(this.newButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.processMessageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton1))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.messageContent, -1, 331, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceMapLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceMapScrollPane, -2, 80, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 6, -2).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.processMessageButton).addComponent(this.closeButton1)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void openBinaryFileButtonActionPerformed(ActionEvent evt) {
        this.messageContent.setEnabled(true);
        List<byte[]> contentByte = this.parent.browseForMultipleFileBytes(null);
        this.content = new ArrayList<String>();
        if (contentByte != null) {
            if (contentByte.size() == 1) {
                this.messageContent.setText(new String(Base64.encodeBase64Chunked((byte[])contentByte.get(0))));
            } else {
                for (byte[] singleByte : contentByte) {
                    String encodedString = new String(Base64.encodeBase64Chunked((byte[])singleByte));
                    this.content.add(encodedString);
                }
                this.messageContent.setText("Multiple Messages Selected");
                this.messageContent.setEnabled(false);
            }
        }
    }

    private void openTextFileButtonActionPerformed(ActionEvent evt) {
        this.messageContent.setEnabled(true);
        this.content = this.parent.browseForMultipleFileStrings(null);
        if (this.content != null) {
            if (this.content.size() == 1) {
                this.messageContent.setText(this.content.get(0));
            } else {
                this.messageContent.setText("Multiple Messages Selected");
                this.messageContent.setEnabled(false);
            }
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        if (this.sourceMapTable.isEditing()) {
            this.sourceMapTable.getCellEditor().stopCellEditing();
        }
        ((DefaultTableModel)this.sourceMapTable.getModel()).addRow(new Object[]{this.getNewSourceMapKey(), ""});
        this.sourceMapTable.setRowSelectionInterval(this.sourceMapTable.getRowCount() - 1, this.sourceMapTable.getRowCount() - 1);
        this.sourceMapTable.scrollRowToVisible(this.sourceMapTable.getRowCount() - 1);
    }

    private void processMessageButtonActionPerformed(ActionEvent evt) {
        ItemSelectionTableModel model = (ItemSelectionTableModel)this.mirthTable1.getModel();
        List metaDataIds = model.getKeys(true);
        if (metaDataIds.size() == model.getRowCount()) {
            metaDataIds = null;
        }
        if (this.sourceMapTable.isEditing()) {
            this.sourceMapTable.getCellEditor(this.getSelectedRow(this.sourceMapTable), this.getSelectedColumn(this.sourceMapTable)).stopCellEditing();
        }
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        for (int row = 0; row < this.sourceMapTable.getRowCount(); ++row) {
            String key = (String)this.sourceMapTable.getModel().getValueAt(row, 0);
            Object value = this.sourceMapTable.getModel().getValueAt(row, 1);
            sourceMap.put(key, value);
        }
        if (this.messageContent.getText().equals("Multiple Messages Selected")) {
            for (String file : this.content) {
                this.parent.processMessage(this.channelId, new RawMessage(file, metaDataIds, sourceMap));
            }
        } else {
            this.parent.processMessage(this.channelId, new RawMessage(this.messageContent.getText(), metaDataIds, sourceMap));
        }
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedRow;
        if (this.sourceMapTable.isEditing()) {
            this.sourceMapTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRow = this.getSelectedRow(this.sourceMapTable)) != -1) {
            ((DefaultTableModel)this.sourceMapTable.getModel()).removeRow(selectedRow);
            if (this.sourceMapTable.getRowCount() > 0) {
                if (selectedRow >= this.sourceMapTable.getRowCount()) {
                    this.sourceMapTable.setRowSelectionInterval(this.sourceMapTable.getRowCount() - 1, this.sourceMapTable.getRowCount() - 1);
                } else {
                    this.sourceMapTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
            } else {
                this.deleteButton.setEnabled(false);
            }
        }
    }
}

