/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URLDecoder;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class ErrorDialog
extends MirthDialog {
    private Frame parent;
    private JButton cancel;
    private JTextPane errorContent;
    private JLabel image;
    private JScrollPane jScrollPane1;
    private JTextPane question;
    private JScrollPane questionPane;

    public ErrorDialog(java.awt.Frame owner, String message) {
        super((Window)owner);
        this.initialize(message);
    }

    public ErrorDialog(Dialog owner, String message) {
        super((Window)owner);
        this.initialize(message);
    }

    private void initialize(String message) {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.question.setBackground(UIManager.getColor("Control"));
        this.errorContent.setBackground(UIManager.getColor("Control"));
        this.image.setIcon((Icon)UIManager.get("OptionPane.errorIcon"));
        this.questionPane.setBorder(null);
        try {
            message = URLDecoder.decode(message, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadContent(message);
        this.errorContent.setCaretPosition(0);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.cancel.requestFocusInWindow();
        this.setVisible(true);
    }

    public void loadContent(String message) {
        this.errorContent.setText(message);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.errorContent = new JTextPane();
        this.questionPane = new JScrollPane();
        this.question = new JTextPane();
        this.image = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Error");
        this.cancel.setText("Close");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.cancelActionPerformed(evt);
            }
        });
        this.errorContent.setBackground(new Color(224, 223, 227));
        this.errorContent.setEditable(false);
        this.jScrollPane1.setViewportView(this.errorContent);
        this.question.setBackground(new Color(224, 223, 227));
        this.question.setBorder(null);
        this.question.setEditable(false);
        this.question.setText("An unexpected error has occurred.");
        this.question.setFocusable(false);
        this.questionPane.setViewportView(this.question);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cancel, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.image).addGap(20, 20, 20).addComponent(this.questionPane, -1, 396, Short.MAX_VALUE).addGap(20, 20, 20)).addComponent(this.jScrollPane1, -1, 404, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.image, GroupLayout.Alignment.LEADING, -2, 35, -2).addComponent(this.questionPane, GroupLayout.Alignment.LEADING, -2, 35, -2)).addGap(15, 15, 15).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel).addContainerGap()));
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

