/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.BareBonesBrowserLaunch;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthHeadingPanel;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.UserDialogInterface;
import com.mirth.connect.client.ui.UserEditPanel;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.User;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FirstLoginDialog
extends JDialog
implements UserDialogInterface {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private boolean result = false;
    private static Preferences preferences;
    private JPanel channelOverview;
    private JButton finishButton;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextPane jTextPane1;
    private MirthHeadingPanel mirthHeadingPanel1;
    private JCheckBox registerCheckBox;
    private JCheckBox userConsentCheckBox;
    private UserEditPanel userEditPanel;
    private JTextPane contentTextPane;

    public FirstLoginDialog(User currentUser) {
        super((java.awt.Frame)((Object)PlatformUI.MIRTH_FRAME));
        this.initComponents();
        DisplayUtil.setResizable(this, false);
        this.finishButton.setEnabled(false);
        this.userEditPanel.setUser(this, currentUser);
        this.userEditPanel.setRequiredFields(false, true);
        if (currentUser.getId() == 1) {
            this.registerCheckBox.setVisible(false);
        }
        this.jLabel2.setForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FirstLoginDialog.this.parent.logout(false, true);
            }
        });
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
    }

    @Override
    public void setFinishButtonEnabled(boolean enabled) {
        this.finishButton.setEnabled(enabled);
    }

    @Override
    public void triggerFinishButton() {
        this.finishButtonActionPerformed(null);
    }

    private void initComponents() {
        this.channelOverview = new JPanel();
        this.finishButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.mirthHeadingPanel1 = new MirthHeadingPanel();
        this.jLabel2 = new JLabel();
        this.userEditPanel = new UserEditPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.registerCheckBox = new JCheckBox();
        this.userConsentCheckBox = new JCheckBox();
        this.contentTextPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Welcome to BridgeLink");
        this.channelOverview.setBackground(new Color(255, 255, 255));
        this.channelOverview.setName("");
        this.finishButton.setText("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FirstLoginDialog.this.finishButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 18));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("<html>Welcome to BridgeLink<sup>&#174;</sup> by Innovar Healthcare</html>");
        GroupLayout mirthHeadingPanel1Layout = new GroupLayout(this.mirthHeadingPanel1);
        this.mirthHeadingPanel1.setLayout(mirthHeadingPanel1Layout);
        mirthHeadingPanel1Layout.setHorizontalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 353, Short.MAX_VALUE).addContainerGap()));
        mirthHeadingPanel1Layout.setVerticalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 27, Short.MAX_VALUE).addContainerGap()));
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setBackground(new Color(250, 250, 210));
        this.jTextPane1.setText("You may now customize your BridgeLink user account information. You also have the option of changing your account password.");
        this.jTextPane1.setAutoscrolls(false);
        this.jTextPane1.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextPane1.setEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.registerCheckBox.setBackground(new Color(255, 255, 255));
        this.registerCheckBox.setSelected(false);
        this.registerCheckBox.setText("Register user with Innovar Healthcare");
        this.registerCheckBox.setToolTipText("<html>Register your user information with Innovar Healthcare to help us<br>improve the product and provide better service.</html>");
        this.registerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FirstLoginDialog.this.registerCheckBoxActionPerformed(evt);
            }
        });
        this.userConsentCheckBox.setBackground(new Color(255, 255, 255));
        this.userConsentCheckBox.setSelected(true);
        this.userConsentCheckBox.setText("I consent to receive email updates and marketing messages from Innovar Healthcare.");
        this.userConsentCheckBox.setToolTipText("<html></html>");
        this.contentTextPane.setContentType("text/html");
        this.contentTextPane.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;For more information on the processing of your personal data, click <a href=\"https://www.nextgen.com/privacy-policy\">here to find our Privacy Policy.</a></html>");
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(set, 1.0f);
        StyleConstants.setFontSize(set, 10);
        StyleConstants.setFontFamily(set, "Tahoma");
        StyledDocument doc = this.contentTextPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, set, false);
        this.contentTextPane.setParagraphAttributes(set, true);
        this.contentTextPane.setEditable(false);
        this.contentTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(evt.getURL().toURI());
                        } else {
                            BareBonesBrowserLaunch.openURL(evt.getURL().toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        GroupLayout channelOverviewLayout = new GroupLayout(this.channelOverview);
        this.channelOverview.setLayout(channelOverviewLayout);
        channelOverviewLayout.setHorizontalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addContainerGap(305, Short.MAX_VALUE).addComponent(this.finishButton).addGap(9, 9, 9)).addComponent(this.mirthHeadingPanel1, -1, 431, Short.MAX_VALUE).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap().addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 353, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 353, Short.MAX_VALUE).addGroup(channelOverviewLayout.createSequentialGroup().addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userEditPanel, -2, -1, -2)).addGap(0, 19, Short.MAX_VALUE))).addContainerGap()));
        channelOverviewLayout.setVerticalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addComponent(this.mirthHeadingPanel1, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userEditPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        this.finishButton.requestFocus();
        String validateUserMessage = this.userEditPanel.validateUser();
        if (validateUserMessage != null) {
            this.parent.alertWarning(this, validateUserMessage);
        } else {
            User user = this.userEditPanel.getUser();
            if (this.userConsentCheckBox.isSelected()) {
                user.setUserConsent(Boolean.valueOf(true));
            }
            boolean success = false;
            success = this.parent.updateCurrentUser(this, user, this.userEditPanel.getPassword());
            if (!success) {
                return;
            }
            if (this.registerCheckBox.isSelected()) {
                this.parent.registerUser(user);
            }
            try {
                User currentUser = this.parent.getCurrentUser((Component)((Object)this.parent));
                this.parent.mirthClient.setUserPreference(currentUser.getId(), "firstlogin", "false");
                if (Integer.valueOf(currentUser.getId()) == 1) {
                    String userInfo = currentUser.getUsername() + "," + currentUser.getFirstName() + "," + currentUser.getLastName() + "," + currentUser.getEmail() + "," + currentUser.getCountry() + "," + currentUser.getStateTerritory() + "," + currentUser.getPhoneNumber() + "," + currentUser.getOrganization() + "," + currentUser.getRole() + "," + currentUser.getIndustry() + "," + currentUser.getDescription() + ",END";
                    preferences = Preferences.userNodeForPackage(Mirth.class);
                    preferences.put("userLoginInfo", userInfo);
                }
            }
            catch (ClientException e) {
                this.parent.alertThrowable(this, e);
            }
            this.result = true;
            this.dispose();
        }
    }

    private void registerCheckBoxActionPerformed(ActionEvent evt) {
        boolean allRequired = this.registerCheckBox.isSelected();
        allRequired = false;
        if (allRequired) {
            this.userConsentCheckBox.setSelected(true);
            this.userConsentCheckBox.setEnabled(true);
        } else {
            this.userConsentCheckBox.setSelected(false);
            this.userConsentCheckBox.setEnabled(false);
        }
        this.userEditPanel.setRequiredFields(allRequired, true);
    }

    public boolean getResult() {
        return this.result;
    }
}

