/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ConnectServiceUtil;
import com.mirth.connect.client.core.ForbiddenException;
import com.mirth.connect.client.core.RequestAbortedException;
import com.mirth.connect.client.core.UnauthorizedException;
import com.mirth.connect.client.core.Version;
import com.mirth.connect.client.core.VersionMismatchException;
import com.mirth.connect.client.ui.AboutMirth;
import com.mirth.connect.client.ui.AttachmentExportDialog;
import com.mirth.connect.client.ui.AuthorizationControllerFactory;
import com.mirth.connect.client.ui.BareBonesBrowserLaunch;
import com.mirth.connect.client.ui.ChannelPanel;
import com.mirth.connect.client.ui.ChannelSetup;
import com.mirth.connect.client.ui.CharsetEncodingInformation;
import com.mirth.connect.client.ui.CustomErrorDialog;
import com.mirth.connect.client.ui.DashboardPanel;
import com.mirth.connect.client.ui.DeleteStatisticsDialog;
import com.mirth.connect.client.ui.DeployInDebugModeDialog;
import com.mirth.connect.client.ui.EditMessageDialog;
import com.mirth.connect.client.ui.ErrorDialog;
import com.mirth.connect.client.ui.FindRplDialog;
import com.mirth.connect.client.ui.GlobalScriptsPanel;
import com.mirth.connect.client.ui.LicenseClient;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.LoginPanel;
import com.mirth.connect.client.ui.MessageExportDialog;
import com.mirth.connect.client.ui.MessageImportDialog;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthFileFilter;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.QueuingSwingWorker;
import com.mirth.connect.client.ui.QueuingSwingWorkerTask;
import com.mirth.connect.client.ui.RemoveMessagesDialog;
import com.mirth.connect.client.ui.ReprocessMessagesDialog;
import com.mirth.connect.client.ui.SettingsPane;
import com.mirth.connect.client.ui.SettingsPanelResources;
import com.mirth.connect.client.ui.StatusBar;
import com.mirth.connect.client.ui.StatusUpdater;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.UserDialog;
import com.mirth.connect.client.ui.UserPanel;
import com.mirth.connect.client.ui.alert.AlertEditPanel;
import com.mirth.connect.client.ui.alert.AlertPanel;
import com.mirth.connect.client.ui.alert.DefaultAlertEditPanel;
import com.mirth.connect.client.ui.alert.DefaultAlertPanel;
import com.mirth.connect.client.ui.browsers.event.EventBrowser;
import com.mirth.connect.client.ui.browsers.message.MessageBrowser;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserChannelModel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplatePanel;
import com.mirth.connect.client.ui.components.rsta.ac.js.MirthJavaScriptLanguageSupport;
import com.mirth.connect.client.ui.dependencies.ChannelDependenciesWarningDialog;
import com.mirth.connect.client.ui.extensionmanager.ExtensionManagerPanel;
import com.mirth.connect.client.ui.tag.SettingsPanelTags;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.model.ApiProvider;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.DashboardChannelInfo;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertInfo;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertStatus;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import com.mirth.connect.plugins.DataTypeClientPlugin;
import com.mirth.connect.util.ChannelDependencyException;
import com.mirth.connect.util.ChannelDependencyGraph;
import com.mirth.connect.util.DirectedAcyclicGraphNode;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.MigrationUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.action.ActionFactory;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.syntax.jedit.JEditTextArea;

public class Frame
extends JXFrame {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    public Client mirthClient;
    public DashboardPanel dashboardPanel = null;
    public ChannelPanel channelPanel = null;
    public SettingsPane settingsPane = null;
    public UserPanel userPanel = null;
    public ChannelSetup channelEditPanel = null;
    public EventBrowser eventBrowser = null;
    public MessageBrowser activeBrowser = null;
    public MessageBrowser messageBrowser = null;
    public MessageBrowser enhancedMessageBrowser = null;
    public boolean multiChannelMessageBrowsingEnabled = false;
    public AlertPanel alertPanel = null;
    public AlertEditPanel alertEditPanel = null;
    public CodeTemplatePanel codeTemplatePanel = null;
    public GlobalScriptsPanel globalScriptsPanel = null;
    public ExtensionManagerPanel extensionsPanel = null;
    public JXTaskPaneContainer taskPaneContainer;
    public List<DashboardStatus> status = null;
    public List<User> users = null;
    public ActionManager manager = ActionManager.getInstance();
    public JPanel contentPanel;
    public BorderLayout borderLayout1 = new BorderLayout();
    public StatusBar statusBar;
    public JSplitPane splitPane = new JSplitPane();
    public JScrollPane taskPane = new JScrollPane();
    public JScrollPane contentPane = new JScrollPane();
    public Component currentContentPage = null;
    public JXTaskPaneContainer currentTaskPaneContainer = null;
    public JScrollPane container;
    public EditMessageDialog editMessageDialog = null;
    public JXTaskPane viewPane;
    public JXTaskPane otherPane;
    public JXTaskPane dashboardTasks;
    public JPopupMenu dashboardPopupMenu;
    public JXTaskPane eventTasks;
    public JPopupMenu eventPopupMenu;
    public JXTaskPane messageTasks;
    public JPopupMenu messagePopupMenu;
    public JXTaskPane details;
    public JXTaskPane channelEditTasks;
    public JPopupMenu channelEditPopupMenu;
    public JXTaskPane userTasks;
    public JPopupMenu userPopupMenu;
    public JXTaskPane alertTasks;
    public JPopupMenu alertPopupMenu;
    public JXTaskPane alertEditTasks;
    public JPopupMenu alertEditPopupMenu;
    public JXTaskPane globalScriptsTasks;
    public JPopupMenu globalScriptsPopupMenu;
    public JXTaskPane extensionsTasks;
    public JPopupMenu extensionsPopupMenu;
    public JLabel padlockWarning;
    public JXTitledPanel rightContainer;
    private ExecutorService statusUpdaterExecutor = Executors.newSingleThreadExecutor();
    private Future<?> statusUpdaterJob = null;
    public static Preferences userPreferences;
    private boolean connectionError;
    private ArrayList<CharsetEncodingInformation> availableCharsetEncodings = null;
    private List<String> charsetEncodings = null;
    public boolean isEditingChannel = false;
    private boolean isEditingAlert = false;
    private LinkedHashMap<String, String> workingStatuses = new LinkedHashMap();
    public LinkedHashMap<String, String> dataTypeToDisplayName;
    public LinkedHashMap<String, String> displayNameToDataType;
    private Map<String, PluginMetaData> loadedPlugins;
    private Map<String, ConnectorMetaData> loadedConnectors;
    private Map<String, Integer> safeErrorFailCountMap = new HashMap<String, Integer>();
    private Map<Component, String> componentTaskMap = new HashMap<Component, String>();
    private boolean acceleratorKeyPressed = false;
    private boolean canSave = true;
    private RemoveMessagesDialog removeMessagesDialog;
    private MessageExportDialog messageExportDialog;
    public MessageExportDialog enhancedMessageExportDialog;
    private MessageImportDialog messageImportDialog;
    private AttachmentExportDialog attachmentExportDialog;
    private KeyEventDispatcher keyEventDispatcher = null;
    private int deployedChannelCount;
    private DebugOptions debugOptions;
    private static final int REFRESH_BLOCK_SIZE = 100;

    public Frame() {
        Platform.setImplicitExit((boolean)false);
        LanguageSupportFactory.get().addLanguageSupport("text/javascript", MirthJavaScriptLanguageSupport.class.getName());
        this.rightContainer = new JXTitledPanel();
        this.taskPaneContainer = new JXTaskPaneContainer();
        StringBuilder titleText = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)PlatformUI.ENVIRONMENT_NAME)) {
            titleText.append(PlatformUI.ENVIRONMENT_NAME + " - ");
        }
        if (!StringUtils.isBlank((CharSequence)PlatformUI.SERVER_NAME)) {
            titleText.append(PlatformUI.SERVER_NAME);
        } else {
            titleText.append(PlatformUI.SERVER_URL);
        }
        titleText.append(" - BridgeLink Administrator");
        this.setTitle(titleText.toString());
        this.setDefaultCloseOperation(0);
        this.setIconImage(UIConstants.MIRTH_FAVICON.getImage());
        this.makePaneContainer();
        this.connectionError = false;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (Frame.this.channelEditPanel != null && Frame.this.channelEditPanel.filterPane != null) {
                    Frame.this.channelEditPanel.filterPane.resizePanes();
                }
                if (Frame.this.channelEditPanel != null && Frame.this.channelEditPanel.transformerPane != null) {
                    Frame.this.channelEditPanel.transformerPane.resizePanes();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Frame.this.logout(true)) {
                    System.exit(0);
                }
            }
        });
        this.keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                Frame.this.updateAcceleratorKeyPressed(e);
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    public void setCharsetEncodings() {
        if (this.availableCharsetEncodings != null) {
            return;
        }
        try {
            this.charsetEncodings = this.mirthClient.getAvailableCharsetEncodings();
            this.availableCharsetEncodings = new ArrayList();
            this.availableCharsetEncodings.add(new CharsetEncodingInformation("DEFAULT_ENCODING", "Default"));
            for (int i = 0; i < this.charsetEncodings.size(); ++i) {
                String canonical = this.charsetEncodings.get(i);
                this.availableCharsetEncodings.add(new CharsetEncodingInformation(canonical, canonical));
            }
        }
        catch (Exception e) {
            this.alertError((Component)((Object)this), "Error getting the charset list:\n " + String.valueOf(e));
        }
    }

    public void setupCharsetEncodingForConnector(JComboBox charsetEncodingCombobox) {
        this.setupCharsetEncodingForConnector(charsetEncodingCombobox, false);
    }

    public void setupCharsetEncodingForConnector(JComboBox charsetEncodingCombobox, boolean allowNone) {
        if (this.availableCharsetEncodings == null) {
            this.setCharsetEncodings();
        }
        if (this.availableCharsetEncodings == null) {
            this.logger.error("Error, the are no encodings detected.");
            return;
        }
        charsetEncodingCombobox.removeAllItems();
        for (int i = 0; i < this.availableCharsetEncodings.size(); ++i) {
            charsetEncodingCombobox.addItem(this.availableCharsetEncodings.get(i));
            if (!allowNone || i != 0) continue;
            charsetEncodingCombobox.addItem(new CharsetEncodingInformation("NONE", "None"));
        }
    }

    public void setPreviousSelectedEncodingForConnector(JComboBox charsetEncodingCombobox, String selectedCharset) {
        this.setPreviousSelectedEncodingForConnector(charsetEncodingCombobox, selectedCharset, false);
    }

    public void setPreviousSelectedEncodingForConnector(JComboBox charsetEncodingCombobox, String selectedCharset, boolean allowNone) {
        if (this.availableCharsetEncodings == null) {
            this.setCharsetEncodings();
        }
        if (this.availableCharsetEncodings == null) {
            this.logger.error("Error, there are no encodings detected.");
            return;
        }
        if (selectedCharset == null || selectedCharset.equalsIgnoreCase("DEFAULT_ENCODING")) {
            charsetEncodingCombobox.setSelectedIndex(0);
        } else if (allowNone && selectedCharset.equalsIgnoreCase("NONE")) {
            charsetEncodingCombobox.setSelectedIndex(1);
        } else if (this.charsetEncodings.contains(selectedCharset)) {
            int index = this.availableCharsetEncodings.indexOf(new CharsetEncodingInformation(selectedCharset, selectedCharset));
            if (index < 0) {
                this.logger.error("Synchronization lost in the list of the encoding characters.");
                index = 0;
            }
            if (allowNone && index > 0) {
                ++index;
            }
            charsetEncodingCombobox.setSelectedIndex(index);
        } else {
            this.alertInformation((Component)((Object)this), "Sorry, the JVM of the server can't support the previously selected " + selectedCharset + " encoding. Please choose another one or install more encodings in the server.");
            charsetEncodingCombobox.setSelectedIndex(0);
        }
    }

    public String getSelectedEncodingForConnector(JComboBox charsetEncodingCombobox) {
        try {
            return ((CharsetEncodingInformation)charsetEncodingCombobox.getSelectedItem()).getCanonicalName();
        }
        catch (Throwable t) {
            this.alertInformation((Component)((Object)this), "Error " + String.valueOf(t));
            return "DEFAULT_ENCODING";
        }
    }

    public void setupFrame(Client mirthClient) throws ClientException {
        SettingsPanelTags tagsPanel;
        SettingsPanelResources resourcesPanel;
        LoginPanel login = LoginPanel.getInstance();
        this.editMessageDialog = new EditMessageDialog();
        this.mirthClient = mirthClient;
        login.setStatus("Loading extensions...");
        try {
            this.loadExtensionMetaData();
        }
        catch (ClientException e) {
            this.alertError((Component)((Object)this), "Unable to load extensions.");
            throw e;
        }
        AuthorizationControllerFactory.getAuthorizationController().initialize();
        this.channelPanel = new ChannelPanel();
        this.channelPanel.retrieveGroups();
        this.channelPanel.retrieveDependencies();
        LoadedExtensions.getInstance().initialize();
        this.codeTemplatePanel = new CodeTemplatePanel(this);
        LoadedExtensions.getInstance().startPlugins();
        mirthClient.setRecorder(LoadedExtensions.getInstance().getRecorder());
        User currentUser = this.getCurrentUser((Component)((Object)this));
        this.statusBar = new StatusBar(currentUser);
        this.statusBar.setBorder(BorderFactory.createEmptyBorder());
        this.channelPanel.initPanelPlugins();
        this.dataTypeToDisplayName = new LinkedHashMap();
        this.displayNameToDataType = new LinkedHashMap();
        for (Map.Entry<String, DataTypeClientPlugin> entry : LoadedExtensions.getInstance().getDataTypePlugins().entrySet()) {
            this.dataTypeToDisplayName.put(entry.getKey(), entry.getValue().getDisplayName());
            this.displayNameToDataType.put(entry.getValue().getDisplayName(), entry.getKey());
        }
        this.setInitialVisibleTasks();
        login.setStatus("Loading preferences...");
        userPreferences = Preferences.userNodeForPackage(Mirth.class);
        userPreferences.put("defaultServer", PlatformUI.SERVER_URL);
        login.setStatus("Loading GUI components...");
        this.splitPane.setDividerSize(0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.contentPanel = (JPanel)this.getContentPane();
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder());
        this.taskPane.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.setBorder(BorderFactory.createEmptyBorder());
        this.buildContentPanel(this.rightContainer, this.contentPane, false);
        this.updateBackgroundColor(currentUser);
        this.splitPane.add((Component)this.rightContainer, "right");
        this.splitPane.add((Component)this.taskPane, "left");
        this.taskPane.setMinimumSize(new Dimension(170, 0));
        this.splitPane.setDividerLocation(170);
        this.contentPanel.add((Component)this.statusBar, "South");
        this.contentPanel.add((Component)this.splitPane, "Center");
        try {
            PlatformUI.SERVER_ID = mirthClient.getServerId();
            PlatformUI.SERVER_VERSION = mirthClient.getVersion();
            PlatformUI.SERVER_TIMEZONE = mirthClient.getServerTimezone();
            PlatformUI.SERVER_TIME = mirthClient.getServerTime();
            this.setTitle(this.getTitle() + " - (" + PlatformUI.SERVER_VERSION + ")");
            PlatformUI.BUILD_DATE = mirthClient.getBuildDate();
            try {
                ObjectXMLSerializer.getInstance().init(PlatformUI.SERVER_VERSION);
            }
            catch (Exception exception) {}
        }
        catch (ClientException e) {
            this.alertError((Component)((Object)this), "Could not get server information.");
        }
        try {
            JavaScriptSharedUtil.setRhinoLanguageVersion((int)mirthClient.getRhinoLanguageVersion());
        }
        catch (ClientException e) {
            this.alertError((Component)((Object)this), "Could not get Rhino language version.");
        }
        this.statusBar.setTimezoneText(PlatformUI.SERVER_TIMEZONE);
        this.statusBar.setServerTime(PlatformUI.SERVER_TIME);
        if (this.settingsPane == null) {
            this.settingsPane = new SettingsPane();
        }
        if ((resourcesPanel = (SettingsPanelResources)this.settingsPane.getSettingsPanel("Resources")) != null) {
            resourcesPanel.doRefresh();
        }
        if ((tagsPanel = (SettingsPanelTags)this.settingsPane.getSettingsPanel("Tags")) != null) {
            tagsPanel.doRefresh();
        }
        this.setCurrentTaskPaneContainer(this.taskPaneContainer);
        login.setStatus("Loading dashboard...");
        this.doShowDashboard();
        login.setStatus("Loading channel editor...");
        this.channelEditPanel = new ChannelSetup();
        login.setStatus("Loading alert editor...");
        if (this.alertEditPanel == null) {
            this.alertEditPanel = new DefaultAlertEditPanel();
        }
        login.setStatus("Loading message browser...");
        this.messageBrowser = new MessageBrowser();
        this.codeTemplatePanel.doRefreshCodeTemplates(false);
        LicenseClient.start();
        AbstractAction logout = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame.this.logout(false, false);
            }
        };
        PublicServerSettings publicServerSettings = mirthClient.getPublicServerSettings();
        if (publicServerSettings.getAdministratorAutoLogoutIntervalEnabled().booleanValue()) {
            InactivityListener listener = new InactivityListener((Window)((Object)this), logout, publicServerSettings.getAdministratorAutoLogoutIntervalField());
            listener.start();
        }
    }

    public void setupBackgroundPainters(Color color) {
        MattePainter taskPanePainter = new MattePainter((Paint)new GradientPaint(0.0f, 0.0f, color, 0.0f, 1.0f, color));
        taskPanePainter.setPaintStretched(true);
        this.taskPaneContainer.setBackgroundPainter((Painter)taskPanePainter);
        MattePainter contentTitlePainter = new MattePainter((Paint)new GradientPaint(0.0f, 0.0f, color, 0.0f, 1.0f, color));
        contentTitlePainter.setPaintStretched(true);
        this.rightContainer.setTitlePainter((Painter)contentTitlePainter);
    }

    public void dispose() {
        super.dispose();
        if (this.statusBar != null) {
            this.statusBar.shutdown();
        }
    }

    private void loadExtensionMetaData() throws ClientException {
        this.loadedPlugins = this.mirthClient.getPluginMetaData();
        this.loadedConnectors = this.mirthClient.getConnectorMetaData();
        HashSet<String> apiProviderPackages = new HashSet<String>();
        HashSet<String> apiProviderClasses = new HashSet<String>();
        for (Object extensionMetaData : CollectionUtils.union(this.loadedPlugins.values(), this.loadedConnectors.values())) {
            MetaData metaData = (MetaData)extensionMetaData;
            if (!this.mirthClient.isExtensionEnabled(metaData.getName())) continue;
            for (ApiProvider provider : metaData.getApiProviders(Version.getLatest())) {
                switch (provider.getType()) {
                    case SERVLET_INTERFACE_PACKAGE: 
                    case CORE_PACKAGE: {
                        apiProviderPackages.add(provider.getName());
                        break;
                    }
                    case SERVLET_INTERFACE: 
                    case CORE_CLASS: {
                        apiProviderClasses.add(provider.getName());
                        break;
                    }
                }
            }
        }
        this.mirthClient.registerApiProviders(apiProviderPackages, apiProviderClasses);
    }

    private void buildContentPanel(JXTitledPanel container, JScrollPane component, boolean opaque) {
        container.getContentContainer().setLayout(new BorderLayout());
        container.setBorder(null);
        container.setTitleFont(new Font("Tahoma", 1, 18));
        container.setTitleForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.padlockWarning = new JLabel();
        this.padlockWarning.setText("    ");
        this.padlockWarning.setFont(new Font("Tahoma", 1, 14));
        this.padlockWarning.setForeground(Color.WHITE);
        JLabel mirthConnectImage = new JLabel();
        ImageIcon imageIcon = UIConstants.MIRTHCONNECT_LOGO_GRAY;
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(218, 29, 4);
        imageIcon = new ImageIcon(newimg);
        mirthConnectImage.setIcon(imageIcon);
        mirthConnectImage.setToolTipText("BridgeLink");
        mirthConnectImage.setCursor(new Cursor(12));
        mirthConnectImage.setVerticalAlignment(3);
        mirthConnectImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BareBonesBrowserLaunch.openURL("https://www.innovarhealthcare.com");
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 20.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1200;
        gbc.fill = 1;
        this.padlockWarning.setBorder(BorderFactory.createEmptyBorder(5, 0, 4, 0));
        mirthConnectImage.setBorder(BorderFactory.createEmptyBorder(5, 0, 4, 20));
        JPanel top = (JPanel)container.getComponent(0);
        top.add((Component)this.padlockWarning, gbc);
        top.add(mirthConnectImage);
        component.setBorder(new LineBorder(Color.GRAY, 1));
        component.setHorizontalScrollBarPolicy(31);
        component.setVerticalScrollBarPolicy(21);
        container.getContentContainer().add(component);
    }

    public void setPanelName(String name) {
        this.rightContainer.setTitle(name);
        this.statusBar.setStatusText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startWorking(String displayText) {
        String id = null;
        LinkedHashMap<String, String> linkedHashMap = this.workingStatuses;
        synchronized (linkedHashMap) {
            if (this.statusBar != null) {
                id = UUID.randomUUID().toString();
                this.workingStatuses.put(id, displayText);
                this.statusBar.setWorking(true);
                this.statusBar.setText(displayText);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorking(String workingId) {
        LinkedHashMap<String, String> linkedHashMap = this.workingStatuses;
        synchronized (linkedHashMap) {
            if (this.statusBar != null && workingId != null) {
                this.workingStatuses.remove(workingId);
                if (this.workingStatuses.size() > 0) {
                    this.statusBar.setWorking(true);
                    this.statusBar.setText(new LinkedList<String>(this.workingStatuses.values()).getLast());
                } else {
                    this.statusBar.setWorking(false);
                    this.statusBar.setText("");
                }
            }
        }
    }

    public void setupChannel(Channel channel, String groupId) {
        this.setBold(this.viewPane, -1);
        this.setCurrentContentPage(this.channelEditPanel);
        this.setFocus(this.channelEditTasks);
        this.setVisibleTasks(this.channelEditTasks, this.channelEditPopupMenu, 0, 0, false);
        this.confirmLeave();
        this.channelEditPanel.addChannel(channel, groupId);
    }

    public void editChannel(Channel channel) {
        String alertMessage = this.channelEditPanel.checkInvalidPluginProperties(channel);
        if (StringUtils.isNotBlank((CharSequence)alertMessage) && !this.alertOption((Component)((Object)this), alertMessage + "\nWhen this channel is saved, those properties will be lost. You can choose to import/edit\nthis channel at a later time after verifying that all necessary extensions are properly loaded.\nAre you sure you wish to continue?")) {
            return;
        }
        this.confirmLeave();
        this.setBold(this.viewPane, -1);
        this.setCurrentContentPage(this.channelEditPanel);
        this.setFocus(this.channelEditTasks);
        this.setVisibleTasks(this.channelEditTasks, this.channelEditPopupMenu, 0, 4, false);
        this.channelEditPanel.editChannel(channel);
    }

    public void setupAlert(Map<String, Map<String, String>> protocolOptions) {
        this.setBold(this.viewPane, -1);
        this.setCurrentContentPage(this.alertEditPanel);
        this.setFocus(this.alertEditTasks);
        this.setVisibleTasks(this.alertEditTasks, this.alertEditPopupMenu, 0, 0, false);
        this.alertEditPanel.addAlert(protocolOptions);
    }

    public void editAlert(AlertModel alertModel, Map<String, Map<String, String>> protocolOptions) {
        if (this.alertEditPanel.editAlert(alertModel, protocolOptions)) {
            this.setBold(this.viewPane, -1);
            this.setCurrentContentPage(this.alertEditPanel);
            this.setFocus(this.alertEditTasks);
            this.setVisibleTasks(this.alertEditTasks, this.alertEditPopupMenu, 0, 0, false);
        }
    }

    public void editGlobalScripts() {
        this.setBold(this.viewPane, -1);
        this.setCurrentContentPage(this.globalScriptsPanel);
        this.setFocus(this.globalScriptsTasks);
        this.setVisibleTasks(this.globalScriptsTasks, this.globalScriptsPopupMenu, 0, 0, false);
        this.setPanelName("Global Scripts");
    }

    public void setCurrentContentPage(Component contentPageObject) {
        if (contentPageObject == this.currentContentPage) {
            return;
        }
        if (this.currentContentPage != null) {
            this.contentPane.getViewport().remove(this.currentContentPage);
        }
        this.contentPane.getViewport().add(contentPageObject);
        this.currentContentPage = contentPageObject;
        if (this.statusUpdaterJob != null && !this.statusUpdaterJob.isDone()) {
            this.statusUpdaterJob.cancel(true);
        }
        if (this.currentContentPage == this.dashboardPanel || this.currentContentPage == this.alertPanel) {
            this.statusUpdaterJob = this.statusUpdaterExecutor.submit(new StatusUpdater());
        }
    }

    private void setCurrentTaskPaneContainer(JXTaskPaneContainer container) {
        if (container == this.currentTaskPaneContainer) {
            return;
        }
        if (this.currentTaskPaneContainer != null) {
            this.taskPane.getViewport().remove((Component)this.currentTaskPaneContainer);
        }
        this.taskPane.getViewport().add((Component)container);
        this.currentTaskPaneContainer = container;
    }

    private void makePaneContainer() {
        this.createViewPane();
        this.createChannelEditPane();
        this.createDashboardPane();
        this.createEventPane();
        this.createMessagePane();
        this.createUserPane();
        this.createAlertPane();
        this.createAlertEditPane();
        this.createGlobalScriptsPane();
        this.createExtensionsPane();
        this.createOtherPane();
    }

    private void setInitialVisibleTasks() {
        this.setVisibleTasks(this.viewPane, null, 0, -1, true);
        this.setVisibleTasks(this.alertTasks, this.alertPopupMenu, 0, -1, true);
        this.setVisibleTasks(this.alertTasks, this.alertPopupMenu, 4, -1, false);
        this.setVisibleTasks(this.alertEditTasks, this.alertEditPopupMenu, 0, 0, false);
        this.setVisibleTasks(this.alertEditTasks, this.alertEditPopupMenu, 1, 1, true);
        this.setVisibleTasks(this.channelEditTasks, this.channelEditPopupMenu, 0, 15, false);
        this.setVisibleTasks(this.channelEditTasks, this.channelEditPopupMenu, 14, 14, true);
        this.setVisibleTasks(this.dashboardTasks, this.dashboardPopupMenu, 0, 0, true);
        this.setVisibleTasks(this.dashboardTasks, this.dashboardPopupMenu, 1, -1, false);
        this.setVisibleTasks(this.eventTasks, this.eventPopupMenu, 0, 2, true);
        this.setVisibleTasks(this.messageTasks, this.messagePopupMenu, 0, -1, true);
        this.setVisibleTasks(this.messageTasks, this.messagePopupMenu, 6, -1, false);
        this.setVisibleTasks(this.messageTasks, this.messagePopupMenu, 7, 7, true);
        this.setVisibleTasks(this.userTasks, this.userPopupMenu, 0, 1, true);
        this.setVisibleTasks(this.userTasks, this.userPopupMenu, 2, -1, false);
        this.setVisibleTasks(this.globalScriptsTasks, this.globalScriptsPopupMenu, 0, 0, false);
        this.setVisibleTasks(this.globalScriptsTasks, this.globalScriptsPopupMenu, 1, -1, true);
        this.setVisibleTasks(this.extensionsTasks, this.extensionsPopupMenu, 0, 0, true);
        this.setVisibleTasks(this.extensionsTasks, this.extensionsPopupMenu, 1, -1, false);
        this.setVisibleTasks(this.otherPane, null, 0, -1, true);
    }

    private void createViewPane() {
        this.viewPane = new JXTaskPane();
        this.viewPane.setTitle("BridgeLink");
        this.viewPane.setName("view");
        this.viewPane.setFocusable(false);
        this.addTask("doShowDashboard", "Dashboard", "Contains information about your currently deployed channels.", "D", new ImageIcon(Frame.class.getResource("images/application_view_detail.png")), this.viewPane, null);
        this.addTask("doShowChannel", "Channels", "Contains various operations to perform on your channels.", "C", new ImageIcon(Frame.class.getResource("images/application_form.png")), this.viewPane, null);
        this.addTask("doShowUsers", "Users", "Contains information on users.", "U", new ImageIcon(Frame.class.getResource("images/group.png")), this.viewPane, null);
        this.addTask("doShowSettings", "Settings", "Contains local and system settings.", "S", new ImageIcon(Frame.class.getResource("images/wrench.png")), this.viewPane, null);
        this.addTask("doShowAlerts", "Alerts", "Contains alert settings.", "A", new ImageIcon(Frame.class.getResource("images/error.png")), this.viewPane, null);
        this.addTask("doShowEvents", "Events", "Show the event logs for the system.", "E", new ImageIcon(Frame.class.getResource("images/table.png")), this.viewPane, null);
        this.addTask("doShowExtensions", "Extensions", "View and manage BridgeLink extensions", "X", new ImageIcon(Frame.class.getResource("images/plugin.png")), this.viewPane, null);
        this.setNonFocusable(this.viewPane);
        this.taskPaneContainer.add(this.viewPane);
        this.viewPane.setVisible(true);
    }

    private void createAlertPane() {
        this.alertTasks = new JXTaskPane();
        this.alertPopupMenu = new JPopupMenu();
        this.alertTasks.setTitle("Alert Tasks");
        this.alertTasks.setName("alert");
        this.alertTasks.setFocusable(false);
        this.addTask("doRefreshAlerts", "Refresh", "Refresh the list of alerts.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doNewAlert", "New Alert", "Create a new alert.", "N", new ImageIcon(Frame.class.getResource("images/error_add.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doImportAlert", "Import Alert", "Import an alert from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doExportAlerts", "Export All Alerts", "Export all of the alerts to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doExportAlert", "Export Alert", "Export the currently selected alert to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doDeleteAlert", "Delete Alert", "Delete the currently selected alert.", "L", new ImageIcon(Frame.class.getResource("images/error_delete.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doEditAlert", "Edit Alert", "Edit the currently selected alert.", "", new ImageIcon(Frame.class.getResource("images/application_form_edit.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doEnableAlert", "Enable Alert", "Enable the currently selected alert.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")), this.alertTasks, this.alertPopupMenu);
        this.addTask("doDisableAlert", "Disable Alert", "Disable the currently selected alert.", "", new ImageIcon(Frame.class.getResource("images/control_stop_blue.png")), this.alertTasks, this.alertPopupMenu);
        this.setNonFocusable(this.alertTasks);
        this.taskPaneContainer.add(this.alertTasks);
    }

    private void createAlertEditPane() {
        this.alertEditTasks = new JXTaskPane();
        this.alertEditPopupMenu = new JPopupMenu();
        this.alertEditTasks.setTitle("Alert Edit Tasks");
        this.alertEditTasks.setName("alertEdit");
        this.alertEditTasks.setFocusable(false);
        this.addTask("doSaveAlerts", "Save Alert", "Save all changes made to this alert.", "", new ImageIcon(Frame.class.getResource("images/disk.png")), this.alertEditTasks, this.alertEditPopupMenu);
        this.addTask("doExportAlert", "Export Alert", "Export the currently selected alert to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.alertEditTasks, this.alertEditPopupMenu);
        this.setNonFocusable(this.alertEditTasks);
        this.taskPaneContainer.add(this.alertEditTasks);
    }

    private void createChannelEditPane() {
        this.channelEditTasks = new JXTaskPane();
        this.channelEditPopupMenu = new JPopupMenu();
        this.channelEditTasks.setTitle("Channel Tasks");
        this.channelEditTasks.setName("channelEdit");
        this.channelEditTasks.setFocusable(false);
        this.addTask("doSaveChannel", "Save Changes", "Save all changes made to this channel.", "", new ImageIcon(Frame.class.getResource("images/disk.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doValidate", "Validate Connector", "Validate the currently visible connector.", "", new ImageIcon(Frame.class.getResource("images/accept.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doNewDestination", "New Destination", "Create a new destination.", "N", new ImageIcon(Frame.class.getResource("images/add.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doDeleteDestination", "Delete Destination", "Delete the currently selected destination.", "L", new ImageIcon(Frame.class.getResource("images/delete.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doCloneDestination", "Clone Destination", "Clones the currently selected destination.", "", new ImageIcon(Frame.class.getResource("images/page_copy.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doEnableDestination", "Enable Destination", "Enable the currently selected destination.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doDisableDestination", "Disable Destination", "Disable the currently selected destination.", "", new ImageIcon(Frame.class.getResource("images/control_stop_blue.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doMoveDestinationUp", "Move Dest. Up", "Move the currently selected destination up.", "", new ImageIcon(Frame.class.getResource("images/arrow_up.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doMoveDestinationDown", "Move Dest. Down", "Move the currently selected destination down.", "", new ImageIcon(Frame.class.getResource("images/arrow_down.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doEditFilter", "Edit Filter", "Edit the filter for the current connector.", "F", new ImageIcon(Frame.class.getResource("images/table_edit.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doEditTransformer", "Edit Transformer", "Edit the transformer for the current connector.", "T", new ImageIcon(Frame.class.getResource("images/table_edit.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doEditResponseTransformer", "Edit Response", "Edit the response transformer for the current connector.", "R", new ImageIcon(Frame.class.getResource("images/table_edit.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doImportConnector", "Import Connector", "Import the currently displayed connector from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doExportConnector", "Export Connector", "Export the currently displayed connector to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doExportChannel", "Export Channel", "Export the currently selected channel to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doValidateChannelScripts", "Validate Script", "Validate the currently viewed script.", "", new ImageIcon(Frame.class.getResource("images/accept.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doDebugDeployFromChannelView", "Debug Channel", "Deploy the currently selected channel in Debug mode.", "", new ImageIcon(Frame.class.getResource("images/bug_go.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.addTask("doDeployFromChannelView", "Deploy Channel", "Deploy the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/arrow_redo.png")), this.channelEditTasks, this.channelEditPopupMenu);
        this.setNonFocusable(this.channelEditTasks);
        this.taskPaneContainer.add(this.channelEditTasks);
    }

    private void createDashboardPane() {
        this.dashboardTasks = new JXTaskPane();
        this.dashboardPopupMenu = new JPopupMenu();
        this.dashboardTasks.setTitle("Dashboard Tasks");
        this.dashboardTasks.setName("dashboard");
        this.dashboardTasks.setFocusable(false);
        this.addTask("doRefreshStatuses", "Refresh", "Refresh the list of statuses.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doSendMessage", "Send Message", "Send messages to the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/email_go.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doShowMessages", "View Messages", "Show the messages for the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/page_white_stack.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doRemoveAllMessages", "Remove All Messages", "Remove all Messages in this channel.", "", new ImageIcon(Frame.class.getResource("images/email_delete.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doClearStats", "Clear Statistics", "Reset the statistics for this channel.", "", new ImageIcon(Frame.class.getResource("images/chart_bar_delete.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doStart", "Start", "Start the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doPause", "Pause", "Pause the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/control_pause_blue.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doStop", "Stop", "Stop the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/control_stop_blue.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doHalt", "Halt", "Halt the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/stop.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doUndeployChannel", "Undeploy Channel", "Undeploys the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/arrow_undo.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doStartConnector", "Start", "Start the currently selected connector.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.addTask("doStopConnector", "Stop", "Stop the currently selected connector.", "", new ImageIcon(Frame.class.getResource("images/control_stop_blue.png")), this.dashboardTasks, this.dashboardPopupMenu);
        this.setNonFocusable(this.dashboardTasks);
        this.taskPaneContainer.add(this.dashboardTasks);
    }

    private void createEventPane() {
        this.eventTasks = new JXTaskPane();
        this.eventPopupMenu = new JPopupMenu();
        this.eventTasks.setTitle("Event Tasks");
        this.eventTasks.setName("event");
        this.eventTasks.setFocusable(false);
        this.addTask("doRefreshEvents", "Refresh", "Refresh the list of events with the given filter.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.eventTasks, this.eventPopupMenu);
        this.addTask("doExportAllEvents", "Export All Events", "Export all events to a file on the server.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.eventTasks, this.eventPopupMenu);
        this.setNonFocusable(this.eventTasks);
        this.taskPaneContainer.add(this.eventTasks);
    }

    private void createMessagePane() {
        this.messageTasks = new JXTaskPane();
        this.messagePopupMenu = new JPopupMenu();
        this.messageTasks.setTitle("Message Tasks");
        this.messageTasks.setName("message");
        this.messageTasks.setFocusable(false);
        this.addTask("doRefreshMessages", "Refresh", "Refresh the list of messages with the current search criteria.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doSendMessage", "Send Message", "Send a message to the channel.", "", new ImageIcon(Frame.class.getResource("images/email_go.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doImportMessages", "Import Messages", "Import messages from a file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doExportMessages", "Export Results", "Export all messages in the current search.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doRemoveAllMessages", "Remove All Messages", "Remove all messages in this channel.", "", new ImageIcon(Frame.class.getResource("images/email_delete.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doRemoveFilteredMessages", "Remove Results", "Remove all messages in the current search.", "", new ImageIcon(Frame.class.getResource("images/email_delete.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doRemoveMessage", "Remove Message", "Remove the selected Message.", "", new ImageIcon(Frame.class.getResource("images/delete.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doReprocessFilteredMessages", "Reprocess Results", "Reprocess all messages in the current search.", "", new ImageIcon(Frame.class.getResource("images/reprocess_results.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doReprocessMessage", "Reprocess Message", "Reprocess the selected message.", "", new ImageIcon(Frame.class.getResource("images/reprocess_message.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("viewImage", "View Attachment", "View Attachment", "View the attachment for the selected message.", new ImageIcon(Frame.class.getResource("images/attach.png")), this.messageTasks, this.messagePopupMenu);
        this.addTask("doExportAttachment", "Export Attachment", "Export Attachment", "Export the selected attachment to a file.", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.messageTasks, this.messagePopupMenu);
        this.setNonFocusable(this.messageTasks);
        this.taskPaneContainer.add(this.messageTasks);
    }

    private void createUserPane() {
        this.userTasks = new JXTaskPane();
        this.userPopupMenu = new JPopupMenu();
        this.userTasks.setTitle("User Tasks");
        this.userTasks.setName("user");
        this.userTasks.setFocusable(false);
        this.addTask("doRefreshUser", "Refresh", "Refresh the list of users.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.userTasks, this.userPopupMenu);
        this.addTask("doNewUser", "New User", "Create a new user.", "N", new ImageIcon(Frame.class.getResource("images/user_add.png")), this.userTasks, this.userPopupMenu);
        this.addTask("doEditUser", "Edit User", "Edit the currently selected user.", "I", new ImageIcon(Frame.class.getResource("images/user_edit.png")), this.userTasks, this.userPopupMenu);
        this.addTask("doDeleteUser", "Delete User", "Delete the currently selected user.", "L", new ImageIcon(Frame.class.getResource("images/user_delete.png")), this.userTasks, this.userPopupMenu);
        this.setNonFocusable(this.userTasks);
        this.taskPaneContainer.add(this.userTasks);
    }

    private void createGlobalScriptsPane() {
        this.globalScriptsTasks = new JXTaskPane();
        this.globalScriptsPopupMenu = new JPopupMenu();
        this.globalScriptsTasks.setTitle("Script Tasks");
        this.globalScriptsTasks.setName("script");
        this.globalScriptsTasks.setFocusable(false);
        this.addTask("doSaveGlobalScripts", "Save Scripts", "Save all changes made to all scripts.", "", new ImageIcon(Frame.class.getResource("images/disk.png")), this.globalScriptsTasks, this.globalScriptsPopupMenu);
        this.addTask("doValidateCurrentGlobalScript", "Validate Script", "Validate the currently viewed script.", "", new ImageIcon(Frame.class.getResource("images/accept.png")), this.globalScriptsTasks, this.globalScriptsPopupMenu);
        this.addTask("doImportGlobalScripts", "Import Scripts", "Import all global scripts from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.globalScriptsTasks, this.globalScriptsPopupMenu);
        this.addTask("doExportGlobalScripts", "Export Scripts", "Export all global scripts to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.globalScriptsTasks, this.globalScriptsPopupMenu);
        this.setNonFocusable(this.globalScriptsTasks);
        this.taskPaneContainer.add(this.globalScriptsTasks);
    }

    private void createExtensionsPane() {
        this.extensionsTasks = new JXTaskPane();
        this.extensionsPopupMenu = new JPopupMenu();
        this.extensionsTasks.setTitle("Extension Tasks");
        this.extensionsTasks.setName("extensions");
        this.extensionsTasks.setFocusable(false);
        this.addTask("doRefreshExtensions", "Refresh", "Refresh loaded plugins.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.extensionsTasks, this.extensionsPopupMenu);
        this.addTask("doEnableExtension", "Enable Extension", "Enable the currently selected extension.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")), this.extensionsTasks, this.extensionsPopupMenu);
        this.addTask("doDisableExtension", "Disable Extension", "Disable the currently selected extension.", "", new ImageIcon(Frame.class.getResource("images/control_stop_blue.png")), this.extensionsTasks, this.extensionsPopupMenu);
        this.addTask("doShowExtensionProperties", "Show Properties", "Display the currently selected extension properties.", "", new ImageIcon(Frame.class.getResource("images/application_view_list.png")), this.extensionsTasks, this.extensionsPopupMenu);
        this.addTask("doUninstallExtension", "Uninstall Extension", "Uninstall the currently selected extension", "", new ImageIcon(Frame.class.getResource("images/plugin_delete.png")), this.extensionsTasks, this.extensionsPopupMenu);
        this.setNonFocusable(this.extensionsTasks);
        this.taskPaneContainer.add(this.extensionsTasks);
    }

    private void createOtherPane() {
        this.otherPane = new JXTaskPane();
        this.otherPane.setTitle("Other");
        this.otherPane.setName("other");
        this.otherPane.setFocusable(false);
        this.addTask("goToNotifications", "Notifications", "View notifications from Innovar Healthcare.", "", new ImageIcon(Frame.class.getResource("images/flag_orange.png")), this.otherPane, null);
        this.addTask("goToUserAPI", "View User API", "View documentation for the BridgeLink User API.", "", new ImageIcon(Frame.class.getResource("images/page_white_text.png")), this.otherPane, null);
        this.addTask("goToClientAPI", "View Client API", "View documentation for the BridgeLink Client API.", "", new ImageIcon(Frame.class.getResource("images/page_white_text.png")), this.otherPane, null);
        this.addTask("doHelp", "Help", "View the BridgeLink wiki.", "", new ImageIcon(Frame.class.getResource("images/help.png")), this.otherPane, null);
        this.addTask("goToAbout", "About BridgeLink", "View the about page for BridgeLink.", "", new ImageIcon(Frame.class.getResource("images/information.png")), this.otherPane, null);
        this.addTask("goToMirth", "Visit innovarhealthcare", "View innovarhealthcare's homepage.", "", new ImageIcon(Frame.class.getResource("images/house.png")), this.otherPane, null);
        this.addTask("doReportIssue", "Report Issue", "Visit BridgeLink's issue tracker.", "", new ImageIcon(Frame.class.getResource("images/bug.png")), this.otherPane, null);
        this.addTask("doLogout", "Logout", "Logout and return to the login screen.", "", new ImageIcon(Frame.class.getResource("images/disconnect.png")), this.otherPane, null);
        this.setNonFocusable(this.otherPane);
        this.taskPaneContainer.add(this.otherPane);
        this.otherPane.setVisible(true);
    }

    public JXTaskPane getOtherPane() {
        return this.otherPane;
    }

    public void updateNotificationTaskName(int notifications) {
        Object taskName = "Notifications";
        if (notifications > 0) {
            taskName = (String)taskName + " (" + notifications + ")";
        }
        ((JXHyperlink)this.otherPane.getContentPane().getComponent(0)).setText((String)taskName);
    }

    public int addTask(String callbackMethod, String displayName, String toolTip, String shortcutKey, ImageIcon icon, JXTaskPane pane, JPopupMenu menu) {
        return this.addTask(callbackMethod, displayName, toolTip, shortcutKey, icon, pane, menu, (Object)this);
    }

    public int addTask(String callbackMethod, String displayName, String toolTip, String shortcutKey, ImageIcon icon, JXTaskPane pane, JPopupMenu menu, Object handler) {
        BoundAction boundAction = ActionFactory.createBoundAction((String)callbackMethod, (String)displayName, (String)shortcutKey);
        if (icon != null) {
            boundAction.putValue("SmallIcon", (Object)icon);
        }
        boundAction.putValue("ShortDescription", (Object)toolTip);
        boundAction.registerCallback(handler, callbackMethod);
        Component component = pane.add((Action)boundAction);
        this.getComponentTaskMap().put(component, callbackMethod);
        if (menu != null) {
            menu.add((Action)boundAction);
        }
        return pane.getContentPane().getComponentCount() - 1;
    }

    public Map<Component, String> getComponentTaskMap() {
        return this.componentTaskMap;
    }

    public boolean alertOption(Component parentComponent, String message) {
        int option = JOptionPane.showConfirmDialog(this.getVisibleComponent(parentComponent), message, "Select an Option", 0);
        return option == 0;
    }

    public boolean alertOkCancel(Component parentComponent, String message) {
        int option = JOptionPane.showConfirmDialog(this.getVisibleComponent(parentComponent), message, "Select an Option", 2);
        return option == 0;
    }

    public ConflictOption alertConflict(Component parentComponent, String message, int count) {
        JCheckBox conflictCheckbox = new JCheckBox("Do this for the next " + String.valueOf(count - 1) + " conflicts");
        conflictCheckbox.setSelected(false);
        Object[] params = new Object[]{message, conflictCheckbox};
        int jOption = JOptionPane.showConfirmDialog(this.getVisibleComponent(parentComponent), params, "Select an Option", 0);
        boolean isSelected = conflictCheckbox.isSelected();
        ConflictOption conflictOption = null;
        conflictOption = jOption == 0 ? (isSelected ? ConflictOption.YES_APPLY_ALL : ConflictOption.YES) : (isSelected || jOption == -1 ? ConflictOption.NO_APPLY_ALL : ConflictOption.NO);
        return conflictOption;
    }

    public boolean alertRefresh() {
        boolean cancelRefresh = false;
        if (PlatformUI.MIRTH_FRAME.isSaveEnabled()) {
            int option = JOptionPane.showConfirmDialog((Component)((Object)PlatformUI.MIRTH_FRAME), "<html>Any unsaved changes will be lost.<br>Would you like to continue?</html>", "Warning", 0);
            if (option == 1 || option == -1) {
                cancelRefresh = true;
            } else {
                this.setSaveEnabled(false);
            }
        }
        return cancelRefresh;
    }

    public void alertInformation(Component parentComponent, String message) {
        JOptionPane.showMessageDialog(this.getVisibleComponent(parentComponent), message, "Information", 1);
    }

    public void alertWarning(Component parentComponent, String message) {
        JOptionPane.showMessageDialog(this.getVisibleComponent(parentComponent), message, "Warning", 2);
    }

    public void alertError(Component parentComponent, String message) {
        JOptionPane.showMessageDialog(this.getVisibleComponent(parentComponent), message, "Error", 0);
    }

    public void alertCustomError(Component parentComponent, String message, String question) {
        Window owner = this.getWindowForComponent(parentComponent = this.getVisibleComponent(parentComponent));
        if (owner instanceof java.awt.Frame) {
            new CustomErrorDialog((java.awt.Frame)owner, message, question);
        } else {
            new CustomErrorDialog((Dialog)owner, message, question);
        }
    }

    public void alertThrowable(Component parentComponent, Throwable t) {
        this.alertThrowable(parentComponent, t, null);
    }

    public void alertThrowable(Component parentComponent, Throwable t, String customMessage) {
        this.alertThrowable(parentComponent, t, customMessage, true);
    }

    public void alertThrowable(Component parentComponent, Throwable t, boolean showMessageOnForbidden) {
        this.alertThrowable(parentComponent, t, null, showMessageOnForbidden);
    }

    public void alertThrowable(Component parentComponent, Throwable t, String customMessage, boolean showMessageOnForbidden) {
        this.alertThrowable(parentComponent, t, customMessage, showMessageOnForbidden, null);
    }

    public void alertThrowable(Component parentComponent, Throwable t, String customMessage, String safeErrorKey) {
        this.alertThrowable(parentComponent, t, customMessage, true, safeErrorKey);
    }

    public void alertThrowable(Component parentComponent, Throwable t, String customMessage, boolean showMessageOnForbidden, String safeErrorKey) {
        if (this.connectionError) {
            return;
        }
        if (safeErrorKey != null) {
            this.increaseSafeErrorFailCount(safeErrorKey);
            if (this.getSafeErrorFailCount(safeErrorKey) < 3) {
                return;
            }
        }
        parentComponent = this.getVisibleComponent(parentComponent);
        Object message = StringUtils.trimToEmpty((String)customMessage);
        boolean showDialog = true;
        if (t != null) {
            t.printStackTrace();
            if (t instanceof ExecutionException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t.getCause() != null && t.getCause() instanceof ClientException) {
                t = t.getCause();
            }
            if (StringUtils.isBlank((CharSequence)message) && StringUtils.isNotBlank((CharSequence)t.getMessage())) {
                message = t.getMessage();
            }
            if (t instanceof ClientException) {
                if (t instanceof ForbiddenException || t.getCause() != null && t.getCause() instanceof ForbiddenException) {
                    message = "You are not authorized to perform this action.\n\n" + (String)message;
                    if (!showMessageOnForbidden) {
                        showDialog = false;
                    }
                } else {
                    if (StringUtils.contains((CharSequence)t.getMessage(), (CharSequence)"Received close_notify during handshake")) {
                        return;
                    }
                    if (t.getCause() != null && t.getCause() instanceof IllegalStateException && this.mirthClient.isClosed()) {
                        return;
                    }
                    if (t instanceof UnauthorizedException || t.getCause() != null && t.getCause() instanceof UnauthorizedException) {
                        this.connectionError = true;
                        this.statusUpdaterExecutor.shutdownNow();
                        this.alertWarning(parentComponent, "Sorry your connection to BridgeLink has either timed out or there was an error in the connection.  Please login again.");
                        if (!this.exportChannelOnError()) {
                            return;
                        }
                        this.mirthClient.close();
                        this.dispose();
                        LoginPanel.getInstance().initialize(PlatformUI.SERVER_URL, PlatformUI.CLIENT_VERSION, "", "");
                        return;
                    }
                    if (t.getCause() != null && t.getCause() instanceof HttpHostConnectException && (StringUtils.contains((CharSequence)t.getCause().getMessage(), (CharSequence)"Connection refused") || StringUtils.contains((CharSequence)t.getCause().getMessage(), (CharSequence)"Host is down"))) {
                        this.connectionError = true;
                        this.statusUpdaterExecutor.shutdownNow();
                        Object server = !StringUtils.isBlank((CharSequence)PlatformUI.SERVER_NAME) ? PlatformUI.SERVER_NAME + "(" + PlatformUI.SERVER_URL + ")" : PlatformUI.SERVER_URL;
                        this.alertWarning(parentComponent, "The BridgeLink server " + (String)server + " is no longer running.  Please start it and log in again.");
                        if (!this.exportChannelOnError()) {
                            return;
                        }
                        this.mirthClient.close();
                        this.dispose();
                        LoginPanel.getInstance().initialize(PlatformUI.SERVER_URL, PlatformUI.CLIENT_VERSION, "", "");
                        return;
                    }
                }
            }
            for (String stackFrame : ExceptionUtils.getStackFrames((Throwable)t)) {
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    message = (String)message + "\n";
                }
                message = (String)message + StringUtils.trim((String)stackFrame);
            }
        }
        this.logger.error((String)message);
        if (showDialog) {
            Window owner = this.getWindowForComponent(parentComponent);
            if (owner instanceof java.awt.Frame) {
                new ErrorDialog((java.awt.Frame)owner, (String)message);
            } else {
                new ErrorDialog((Dialog)owner, (String)message);
            }
        }
    }

    private Component getVisibleComponent(Component component) {
        if (component != null && component.isVisible()) {
            return component;
        }
        if (this.isVisible()) {
            return this;
        }
        return null;
    }

    private Window getWindowForComponent(Component parentComponent) {
        Object owner = null;
        if (parentComponent == null) {
            owner = this;
        } else if (parentComponent instanceof java.awt.Frame || parentComponent instanceof Dialog) {
            owner = (Window)parentComponent;
        } else {
            owner = SwingUtilities.windowForComponent(parentComponent);
            if (owner == null) {
                owner = this;
            }
        }
        return owner;
    }

    public void setBold(JXTaskPane pane, int index) {
        for (int i = 0; i < pane.getContentPane().getComponentCount(); ++i) {
            pane.getContentPane().getComponent(i).setFont(UIConstants.TEXTFIELD_PLAIN_FONT);
        }
        if (index != -1) {
            pane.getContentPane().getComponent(index).setFont(UIConstants.TEXTFIELD_BOLD_FONT);
        }
    }

    public void setFocus(JXTaskPane pane) {
        this.setFocus(new JXTaskPane[]{pane}, true, true);
    }

    public void setFocus(JXTaskPane[] panes, boolean mirthPane, boolean otherPane) {
        this.taskPaneContainer.getComponent(0).setVisible(mirthPane);
        for (int i = 1; i < this.taskPaneContainer.getComponentCount() - 1; ++i) {
            this.taskPaneContainer.getComponent(i).setVisible(false);
        }
        this.taskPaneContainer.getComponent(this.taskPaneContainer.getComponentCount() - 1).setVisible(otherPane);
        if (panes != null) {
            for (JXTaskPane pane : panes) {
                if (pane == null) continue;
                pane.setVisible(true);
            }
        }
    }

    public void setNonFocusable(JXTaskPane pane) {
        for (int i = 0; i < pane.getContentPane().getComponentCount(); ++i) {
            pane.getContentPane().getComponent(i).setFocusable(false);
        }
    }

    public void setVisibleTasks(JXTaskPane pane, JPopupMenu menu, int startIndex, int endIndex, boolean visible) {
        for (int i = startIndex; (endIndex == -1 || i <= endIndex) && i < pane.getContentPane().getComponentCount(); ++i) {
            boolean componentVisible = visible;
            String componentTask = this.getComponentTaskMap().get(pane.getContentPane().getComponent(i));
            if (componentTask != null && !AuthorizationControllerFactory.getAuthorizationController().checkTask(pane.getName(), componentTask)) {
                componentVisible = false;
            }
            pane.getContentPane().getComponent(i).setVisible(componentVisible);
            if (menu == null) continue;
            menu.getComponent(i).setVisible(componentVisible);
        }
    }

    public boolean confirmLeave() {
        int option;
        if (this.dashboardPanel != null) {
            this.dashboardPanel.closePopupWindow();
        }
        if (this.channelPanel != null) {
            this.channelPanel.closePopupWindow();
        }
        if (this.channelEditPanel != null) {
            this.channelEditPanel.closePopupWindow();
        }
        if (this.currentContentPage == this.channelPanel && this.isSaveEnabled() ? !this.channelPanel.confirmLeave() : ((this.currentContentPage == this.channelEditPanel || this.currentContentPage == this.channelEditPanel.transformerPane || this.currentContentPage == this.channelEditPanel.filterPane) && this.isSaveEnabled() ? ((option = JOptionPane.showConfirmDialog((Component)((Object)this), "Would you like to save the channel changes?")) == 0 ? !this.channelEditPanel.saveChanges() : option == 2 || option == -1) : (this.currentContentPage == this.settingsPane && this.isSaveEnabled() ? ((option = JOptionPane.showConfirmDialog((Component)((Object)this), "Would you like to save the " + this.settingsPane.getCurrentSettingsPanel().getTabName() + " settings changes?")) == 0 ? !this.settingsPane.getCurrentSettingsPanel().doSave() : option == 2 || option == -1) : (this.currentContentPage == this.alertEditPanel && this.isSaveEnabled() ? ((option = JOptionPane.showConfirmDialog((Component)((Object)this), "Would you like to save the alerts?")) == 0 ? !this.alertEditPanel.saveAlert() : option == 2 || option == -1) : (this.currentContentPage == this.globalScriptsPanel && this.isSaveEnabled() ? ((option = JOptionPane.showConfirmDialog((Component)((Object)this), "Would you like to save the scripts?")) == 0 ? !this.doSaveGlobalScripts() : option == 2 || option == -1) : this.currentContentPage == this.codeTemplatePanel && this.isSaveEnabled() && !this.codeTemplatePanel.confirmLeave()))))) {
            return false;
        }
        this.setSaveEnabled(false);
        return true;
    }

    public boolean updateChannel(Channel curr, boolean overwriting, Integer userId, Calendar dateStartEdit) throws ClientException {
        if (overwriting ? !this.mirthClient.updateChannel(curr, false, dateStartEdit) : !this.mirthClient.createChannel(curr)) {
            if (this.mirthClient.getCurrentUser().getId().equals(userId)) {
                this.mirthClient.updateChannel(curr, true, dateStartEdit);
            } else {
                String otherUsername = "unknown";
                if (userId != null && userId != 0) {
                    otherUsername = this.mirthClient.getUser(userId).getUsername();
                }
                if (this.alertOption((Component)((Object)this), "Another user (" + otherUsername + ") has made changes to this channel since you started editing and\nyour changes will overwrite theirs. Are you sure you want to save your changes?")) {
                    this.mirthClient.updateChannel(curr, true, dateStartEdit);
                } else {
                    return false;
                }
            }
        }
        this.channelPanel.retrieveChannels();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUser(Component parentComponent, User updateUser, String newPassword) {
        String workingId = this.startWorking("Saving user...");
        try {
            if (StringUtils.isNotEmpty((CharSequence)newPassword) && !this.checkOrUpdateUserPassword(parentComponent, updateUser, newPassword)) {
                boolean bl = false;
                return bl;
            }
            try {
                if (updateUser.getId() == null) {
                    this.mirthClient.createUser(updateUser);
                } else {
                    this.mirthClient.updateUser(updateUser);
                }
            }
            catch (ClientException e) {
                if (e.getMessage() != null && e.getMessage().contains("username must be unique")) {
                    this.alertWarning(parentComponent, "This username already exists. Please choose another one.");
                } else {
                    this.alertThrowable(parentComponent, e);
                }
                boolean bl = false;
                this.stopWorking(workingId);
                return bl;
            }
            try {
                this.retrieveUsers();
                if (updateUser.getId() == null) {
                    User newUser = null;
                    for (User user : this.users) {
                        if (!user.getUsername().equals(updateUser.getUsername())) continue;
                        newUser = user;
                    }
                    this.checkOrUpdateUserPassword(parentComponent, newUser, newPassword);
                }
            }
            catch (ClientException e) {
                this.alertThrowable(parentComponent, e);
            }
            finally {
                if (this.userPanel != null) {
                    this.userPanel.updateUserTable();
                }
            }
        }
        finally {
            this.stopWorking(workingId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCurrentUser(Component parentComponent, User currentUser, String newPassword) {
        boolean changingUsername = !currentUser.getUsername().equals(PlatformUI.USER_NAME);
        String workingId = this.startWorking("Saving user...");
        try {
            if (StringUtils.isNotEmpty((CharSequence)newPassword)) {
                if (!this.checkOrUpdateUserPassword(parentComponent, currentUser, newPassword)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (changingUsername) {
                this.alertWarning(parentComponent, "If you are changing your username, you must also update your password.");
                boolean bl = false;
                return bl;
            }
            try {
                this.mirthClient.updateUser(currentUser);
            }
            catch (ClientException e) {
                if (e.getMessage() != null && e.getMessage().contains("username must be unique")) {
                    this.alertWarning(parentComponent, "This username already exists. Please choose another one.");
                } else {
                    this.alertThrowable(parentComponent, e);
                }
                boolean bl = false;
                this.stopWorking(workingId);
                return bl;
            }
            try {
                this.retrieveUsers();
            }
            catch (ClientException e) {
                this.alertThrowable(parentComponent, e);
            }
            finally {
                if (this.userPanel != null) {
                    this.userPanel.updateUserTable();
                }
            }
        }
        finally {
            this.stopWorking(workingId);
        }
        if (changingUsername) {
            String workingId2 = this.startWorking("Switching User...");
            try {
                LoadedExtensions.getInstance().resetPlugins();
                this.mirthClient.logout();
                this.mirthClient.login(currentUser.getUsername(), newPassword);
                PlatformUI.USER_NAME = currentUser.getUsername();
            }
            catch (ClientException e) {
                this.alertThrowable(parentComponent, e);
            }
            finally {
                this.stopWorking(workingId2);
            }
        }
        return true;
    }

    public boolean checkOrUpdateUserPassword(Component parentComponent, User currentUser, String newPassword) {
        try {
            List responses = currentUser.getId() == null ? this.mirthClient.checkUserPassword(newPassword) : this.mirthClient.updateUserPassword(currentUser.getId(), newPassword);
            if (CollectionUtils.isNotEmpty((Collection)responses)) {
                Object responseString = "Your password is not valid. Please fix the following:\n";
                for (String response : responses) {
                    responseString = (String)responseString + " - " + response + "\n";
                }
                this.alertError((Component)((Object)this), (String)responseString);
                return false;
            }
        }
        catch (ClientException e) {
            this.alertThrowable((Component)((Object)this), e);
            return false;
        }
        return true;
    }

    public User getCurrentUser(Component parentComponent) {
        return this.getCurrentUser(parentComponent, true);
    }

    public User getCurrentUser(Component parentComponent, boolean alertOnFailure) {
        User currentUser;
        block3: {
            currentUser = null;
            try {
                this.retrieveUsers();
                for (User user : this.users) {
                    if (!user.getUsername().equals(PlatformUI.USER_NAME)) continue;
                    currentUser = user;
                }
            }
            catch (ClientException e) {
                if (!alertOnFailure) break block3;
                this.alertThrowable(parentComponent, e);
            }
        }
        return currentUser;
    }

    public void registerUser(final User user) {
        final String workingId = this.startWorking("Registering user...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    ConnectServiceUtil.registerUser((String)PlatformUI.SERVER_ID, (String)PlatformUI.SERVER_VERSION, (User)user, (String[])PlatformUI.HTTPS_PROTOCOLS, (String[])PlatformUI.HTTPS_CIPHER_SUITES);
                }
                catch (ClientException clientException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void sendUsageStatistics() {
        UpdateSettings updateSettings = null;
        try {
            updateSettings = this.mirthClient.getUpdateSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (updateSettings != null && updateSettings.getStatsEnabled().booleanValue()) {
            final String workingId = this.startWorking("Sending usage statistics...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        boolean isSent;
                        String usageData = Frame.this.mirthClient.getUsageData(Frame.this.getClientStats());
                        if (usageData != null && (isSent = ConnectServiceUtil.sendStatistics((String)PlatformUI.SERVER_ID, (String)PlatformUI.SERVER_VERSION, (boolean)false, (String)usageData, (String[])PlatformUI.HTTPS_PROTOCOLS, (String[])PlatformUI.HTTPS_CIPHER_SUITES))) {
                            UpdateSettings settings = new UpdateSettings();
                            settings.setLastStatsTime(Long.valueOf(System.currentTimeMillis()));
                            Frame.this.mirthClient.setUpdateSettings(settings);
                        }
                    }
                    catch (ClientException clientException) {
                        // empty catch block
                    }
                    return null;
                }

                @Override
                public void done() {
                    Frame.this.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }

    private Map<String, Object> getClientStats() {
        HashMap<String, Object> clientStats = new HashMap<String, Object>();
        clientStats.put("javaVersion", System.getProperty("java.version"));
        return clientStats;
    }

    public void setSaveEnabled(boolean enabled) {
        if (this.currentContentPage == this.channelPanel) {
            this.channelPanel.setSaveEnabled(enabled);
        } else if (this.currentContentPage == this.channelEditPanel) {
            this.setVisibleTasks(this.channelEditTasks, this.channelEditPopupMenu, 0, 0, enabled);
        } else if (this.currentContentPage == this.settingsPane) {
            this.settingsPane.getCurrentSettingsPanel().setSaveEnabled(enabled);
        } else if (this.alertEditPanel != null && this.currentContentPage == this.alertEditPanel) {
            this.setVisibleTasks(this.alertEditTasks, this.alertEditPopupMenu, 0, 0, enabled);
        } else if (this.globalScriptsPanel != null && this.currentContentPage == this.globalScriptsPanel) {
            this.setVisibleTasks(this.globalScriptsTasks, this.globalScriptsPopupMenu, 0, 0, enabled);
        } else if (this.currentContentPage == this.codeTemplatePanel) {
            this.codeTemplatePanel.setSaveEnabled(enabled);
        }
    }

    public boolean isSaveEnabled() {
        boolean enabled = false;
        if (this.currentContentPage != null) {
            if (this.currentContentPage == this.channelPanel) {
                enabled = this.channelPanel.isSaveEnabled();
            } else if (this.currentContentPage == this.channelEditPanel) {
                enabled = this.channelEditTasks.getContentPane().getComponent(0).isVisible();
            } else if (this.channelEditPanel != null && this.currentContentPage == this.channelEditPanel.transformerPane) {
                enabled = this.channelEditTasks.getContentPane().getComponent(0).isVisible() || this.channelEditPanel.transformerPane.isModified();
            } else if (this.channelEditPanel != null && this.currentContentPage == this.channelEditPanel.filterPane) {
                enabled = this.channelEditTasks.getContentPane().getComponent(0).isVisible() || this.channelEditPanel.filterPane.isModified();
            } else if (this.currentContentPage == this.settingsPane) {
                enabled = this.settingsPane.getCurrentSettingsPanel().isSaveEnabled();
            } else if (this.alertEditPanel != null && this.currentContentPage == this.alertEditPanel) {
                enabled = this.alertEditTasks.getContentPane().getComponent(0).isVisible();
            } else if (this.globalScriptsPanel != null && this.currentContentPage == this.globalScriptsPanel) {
                enabled = this.globalScriptsTasks.getContentPane().getComponent(0).isVisible();
            } else if (this.currentContentPage == this.codeTemplatePanel) {
                enabled = this.codeTemplatePanel.isSaveEnabled();
            }
        }
        return enabled;
    }

    public void goToMirth() {
        BareBonesBrowserLaunch.openURL("https://www.innovarhealthcare.com");
    }

    public void goToUserAPI() {
        BareBonesBrowserLaunch.openURL(PlatformUI.SERVER_URL + UIConstants.USER_API_LOCATION);
    }

    public void goToClientAPI() {
        BareBonesBrowserLaunch.openURL(PlatformUI.SERVER_URL + UIConstants.CLIENT_API_LOCATION);
    }

    public void goToAbout() {
        new AboutMirth();
    }

    public void doReportIssue() {
        BareBonesBrowserLaunch.openURL("https://github.com/Innovar-Healthcare/BridgeLink/issues");
    }

    public void doShowDashboard() {
        if (this.dashboardPanel == null) {
            this.dashboardPanel = new DashboardPanel();
        }
        if (!this.confirmLeave()) {
            return;
        }
        this.dashboardPanel.switchPanel();
        this.setBold(this.viewPane, 0);
        this.setPanelName("Dashboard");
        this.setCurrentContentPage(this.dashboardPanel);
        this.setFocus(this.dashboardTasks);
        this.doRefreshStatuses(true);
    }

    public void doShowChannel() {
        if (!this.confirmLeave()) {
            return;
        }
        this.channelPanel.switchPanel();
    }

    public void doShowUsers() {
        if (this.userPanel == null) {
            this.userPanel = new UserPanel();
        }
        if (!this.confirmLeave()) {
            return;
        }
        final String workingId = this.startWorking("Loading users...");
        this.setBold(this.viewPane, 2);
        this.setPanelName("Users");
        this.setCurrentContentPage(this.userPanel);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Frame.this.refreshUser();
                return null;
            }

            @Override
            public void done() {
                Frame.this.setFocus(Frame.this.userTasks);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doShowSettings() {
        if (this.settingsPane == null) {
            this.settingsPane = new SettingsPane();
        }
        if (!this.confirmLeave()) {
            return;
        }
        final String workingId = this.startWorking("Loading settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Frame.this.settingsPane.setSelectedSettingsPanel(0);
                return null;
            }

            @Override
            public void done() {
                Frame.this.setBold(Frame.this.viewPane, 3);
                Frame.this.setPanelName("Settings");
                Frame.this.setCurrentContentPage(Frame.this.settingsPane);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doShowAlerts() {
        if (this.alertPanel == null) {
            this.alertPanel = new DefaultAlertPanel();
        }
        if (!this.confirmLeave()) {
            return;
        }
        this.setBold(this.viewPane, 4);
        this.setPanelName("Alerts");
        this.setCurrentContentPage(this.alertPanel);
        this.setFocus(this.alertTasks);
        this.setSaveEnabled(false);
        this.doRefreshAlerts(true);
    }

    public void doShowExtensions() {
        if (this.extensionsPanel == null) {
            this.extensionsPanel = new ExtensionManagerPanel();
        }
        String workingId = this.startWorking("Loading extensions...");
        if (this.confirmLeave()) {
            this.setBold(this.viewPane, 6);
            this.setPanelName("Extensions");
            this.setCurrentContentPage(this.extensionsPanel);
            this.setFocus(this.extensionsTasks);
            this.refreshExtensions();
            this.stopWorking(workingId);
        }
    }

    public void doLogout() {
        this.logout(false);
    }

    public boolean logout(boolean quit) {
        return this.logout(quit, true);
    }

    public boolean logout(boolean quit, boolean confirmFirst) {
        Boolean inactivity;
        block13: {
            if (confirmFirst && !this.confirmLeave()) {
                return false;
            }
            inactivity = false;
            if (!quit && !confirmFirst) {
                inactivity = true;
            }
            LicenseClient.stop();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
            this.statusUpdaterExecutor.shutdownNow();
            if (this.currentContentPage == this.activeBrowser) {
                this.mirthClient.getServerConnection().abort(this.activeBrowser.getAbortOperations());
            }
            userPreferences = Preferences.userNodeForPackage(Mirth.class);
            userPreferences.putInt("maximizedState", this.getExtendedState());
            userPreferences.putInt("width", this.getWidth());
            userPreferences.putInt("height", this.getHeight());
            LoadedExtensions.getInstance().stopPlugins();
            Properties tagUserProperties = new Properties();
            tagUserProperties.put("initialTagsDashboard", this.dashboardPanel.getUserTags());
            tagUserProperties.put("initialTagsChannels", this.channelPanel.getUserTags());
            try {
                User currentUser = this.getCurrentUser((Component)((Object)this), inactivity == false);
                if (currentUser != null) {
                    this.mirthClient.setUserPreferences(currentUser.getId(), tagUserProperties);
                }
            }
            catch (ClientException e) {
                if (inactivity.booleanValue()) break block13;
                this.alertThrowable((Component)((Object)this), e);
            }
        }
        if (inactivity.booleanValue()) {
            try {
                this.mirthClient.inactivityLogout();
            }
            catch (ClientException e) {}
        } else {
            try {
                this.mirthClient.logout();
            }
            catch (ClientException e) {
                this.alertThrowable((Component)((Object)this), e);
            }
        }
        this.mirthClient.close();
        this.dispose();
        if (!quit) {
            LoginPanel.getInstance().initialize(PlatformUI.SERVER_URL, PlatformUI.CLIENT_VERSION, "", "");
        }
        return true;
    }

    public void doMoveDestinationDown() {
        this.channelEditPanel.moveDestinationDown();
    }

    public void doMoveDestinationUp() {
        this.channelEditPanel.moveDestinationUp();
    }

    public void doEditGlobalScripts() {
        if (this.globalScriptsPanel == null) {
            this.globalScriptsPanel = new GlobalScriptsPanel();
        }
        final String workingId = this.startWorking("Loading global scripts...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Frame.this.globalScriptsPanel.edit();
                return null;
            }

            @Override
            public void done() {
                Frame.this.editGlobalScripts();
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doEditCodeTemplates() {
        this.codeTemplatePanel.switchPanel();
    }

    public void doValidateCurrentGlobalScript() {
        this.globalScriptsPanel.validateCurrentScript();
    }

    public void doImportGlobalScripts() {
        String content = this.browseForFileString("XML");
        if (content != null) {
            try {
                ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
                Map importScripts = (Map)serializer.deserialize(content, Map.class);
                for (Map.Entry globalScriptEntry : importScripts.entrySet()) {
                    importScripts.put((String)globalScriptEntry.getKey(), ((String)globalScriptEntry.getValue()).replaceAll("com.webreach.mirth", "com.mirth.connect"));
                }
                if (importScripts.containsKey("Shutdown") && !importScripts.containsKey("Undeploy")) {
                    importScripts.put("Undeploy", (String)importScripts.get("Shutdown"));
                    importScripts.remove("Shutdown");
                }
                this.globalScriptsPanel.importAllScripts(importScripts);
            }
            catch (Exception e) {
                this.alertThrowable((Component)((Object)this), (Throwable)e, "Invalid scripts file. " + e.getMessage());
            }
        }
    }

    public void doExportGlobalScripts() {
        if (this.changesHaveBeenMade()) {
            if (this.alertOption((Component)((Object)this), "You must save your global scripts before exporting.  Would you like to save them now?")) {
                String validationMessage = this.globalScriptsPanel.validateAllScripts();
                if (validationMessage != null) {
                    this.alertCustomError((Component)((Object)this), validationMessage, "There was an error in the validation of your global scripts.  Please fix the following error(s):");
                    return;
                }
                this.globalScriptsPanel.save();
                this.setSaveEnabled(false);
            } else {
                return;
            }
        }
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        String globalScriptsXML = serializer.serialize(this.globalScriptsPanel.exportAllScripts());
        this.exportFile(globalScriptsXML, null, "XML", "Global Scripts export");
    }

    public void doValidateChannelScripts() {
        this.channelEditPanel.validateScripts();
    }

    public boolean doSaveGlobalScripts() {
        String validationMessage = this.globalScriptsPanel.validateAllScripts();
        if (validationMessage != null) {
            this.alertCustomError((Component)((Object)this), validationMessage, "There was an error in the validation of your global scripts.  Please fix the following error(s):");
            return false;
        }
        final String workingId = this.startWorking("Saving global scripts...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Frame.this.globalScriptsPanel.save();
                return null;
            }

            @Override
            public void done() {
                Frame.this.setSaveEnabled(false);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
        return true;
    }

    public synchronized void increaseSafeErrorFailCount(String safeErrorKey) {
        int safeErrorFailCount = this.getSafeErrorFailCount(safeErrorKey) + 1;
        this.safeErrorFailCountMap.put(safeErrorKey, safeErrorFailCount);
    }

    public synchronized void resetSafeErrorFailCount(String safeErrorKey) {
        this.safeErrorFailCountMap.put(safeErrorKey, 0);
    }

    public synchronized int getSafeErrorFailCount(String safeErrorKey) {
        if (this.safeErrorFailCountMap.containsKey(safeErrorKey)) {
            return this.safeErrorFailCountMap.get(safeErrorKey);
        }
        return 0;
    }

    public void doRefreshStatuses() {
        this.doRefreshStatuses(true);
    }

    public void doRefreshStatuses(boolean queue) {
        QueuingSwingWorkerTask<Void, DashboardStatus> task = new QueuingSwingWorkerTask<Void, DashboardStatus>("doRefreshStatuses", "Loading statistics..."){

            @Override
            public Void doInBackground() {
                try {
                    Frame.this.channelPanel.retrieveGroups();
                    Frame.this.channelPanel.retrieveDependencies();
                    SettingsPanelTags tagsPanel = Frame.this.getTagsPanel();
                    if (tagsPanel != null) {
                        tagsPanel.refresh();
                    }
                    for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
                        plugin.tableUpdate(Frame.this.status);
                    }
                    String filter = Frame.this.dashboardPanel.getUserTags();
                    DashboardChannelInfo dashboardStatusList = Frame.this.mirthClient.getDashboardChannelInfo(100, filter);
                    Frame.this.status = dashboardStatusList.getDashboardStatuses();
                    Set remainingIds = dashboardStatusList.getRemainingChannelIds();
                    Frame.this.deployedChannelCount = dashboardStatusList.getDeployedChannelCount();
                    if (Frame.this.status != null) {
                        this.publish(Frame.this.status.toArray(new DashboardStatus[Frame.this.status.size()]));
                        if (CollectionUtils.isNotEmpty((Collection)remainingIds)) {
                            HashSet<String> statusChannelIds = new HashSet<String>(Math.min(remainingIds.size(), 100));
                            Iterator it = remainingIds.iterator();
                            while (it.hasNext()) {
                                statusChannelIds.add((String)it.next());
                                if (it.hasNext() && statusChannelIds.size() != 100) continue;
                                List intermediateStatusList = Frame.this.mirthClient.getChannelStatusList(statusChannelIds, filter);
                                this.publish(intermediateStatusList.toArray(new DashboardStatus[intermediateStatusList.size()]));
                                Frame.this.status.addAll(intermediateStatusList);
                                statusChannelIds.clear();
                            }
                        }
                    }
                }
                catch (ClientException e) {
                    Frame.this.status = null;
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e, e.getMessage(), false, "doRefreshStatuses"));
                }
                return null;
            }

            @Override
            public void process(List<DashboardStatus> chunks) {
                Frame.this.logger.debug("Processing chunk: " + String.valueOf(chunks != null ? Integer.valueOf(chunks.size()) : "null"));
                if (chunks != null) {
                    DashboardPanel.TableState tableState = Frame.this.dashboardPanel.getCurrentTableState();
                    Frame.this.dashboardPanel.updateTableChannelNodes(chunks);
                    Frame.this.dashboardPanel.updateTableState(tableState);
                }
            }

            @Override
            public void done() {
                if (Frame.this.status != null) {
                    DashboardPanel.TableState tableState = Frame.this.dashboardPanel.getCurrentTableState();
                    Frame.this.channelPanel.updateDefaultChannelGroup(Frame.this.status);
                    Frame.this.dashboardPanel.finishUpdatingTable(Frame.this.status, Frame.this.channelPanel.getCachedGroupStatuses().values(), Frame.this.deployedChannelCount);
                    Frame.this.dashboardPanel.updateTableState(tableState);
                }
            }
        };
        new QueuingSwingWorker<Void, DashboardStatus>(task, queue).executeDelegate();
    }

    public int getDeployedChannelCount() {
        return this.deployedChannelCount;
    }

    public void doStart() {
        final Set<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedChannelStatuses();
        if (selectedStatuses.size() == 0) {
            return;
        }
        if (!this.getStatusesWithDependencies(selectedStatuses, ChannelTask.START_RESUME)) {
            return;
        }
        final String workingId = this.startWorking("Starting or resuming channels...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashSet<String> startChannelIds = new HashSet<String>();
                HashSet<String> resumeChannelIds = new HashSet<String>();
                for (DashboardStatus dashboardStatus : selectedStatuses) {
                    if (dashboardStatus.getState() == DeployedState.PAUSED) {
                        resumeChannelIds.add(dashboardStatus.getChannelId());
                        continue;
                    }
                    startChannelIds.add(dashboardStatus.getChannelId());
                }
                try {
                    if (!startChannelIds.isEmpty()) {
                        Frame.this.mirthClient.startChannels(startChannelIds);
                    }
                    if (!resumeChannelIds.isEmpty()) {
                        Frame.this.mirthClient.resumeChannels(resumeChannelIds);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doStop() {
        final Set<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedChannelStatuses();
        if (selectedStatuses.size() == 0) {
            return;
        }
        if (!this.getStatusesWithDependencies(selectedStatuses, ChannelTask.STOP)) {
            return;
        }
        final String workingId = this.startWorking("Stopping channel...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashSet<String> channelIds = new HashSet<String>();
                for (DashboardStatus dashboardStatus : selectedStatuses) {
                    channelIds.add(dashboardStatus.getChannelId());
                }
                try {
                    if (!channelIds.isEmpty()) {
                        Frame.this.mirthClient.stopChannels(channelIds);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doHalt() {
        final Set<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedChannelStatuses();
        int size = selectedStatuses.size();
        if (size == 0 || !this.alertOption((Component)((Object)this), "Are you sure you want to halt " + (size == 1 ? "this channel" : "these channels") + "?")) {
            return;
        }
        final String workingId = this.startWorking("Halting channels...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashSet<String> channelIds = new HashSet<String>();
                for (DashboardStatus dashboardStatus : selectedStatuses) {
                    channelIds.add(dashboardStatus.getChannelId());
                }
                try {
                    if (!channelIds.isEmpty()) {
                        Frame.this.mirthClient.haltChannels(channelIds);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doPause() {
        final Set<DashboardStatus> selectedChannelStatuses = this.dashboardPanel.getSelectedChannelStatuses();
        if (selectedChannelStatuses.size() == 0) {
            return;
        }
        if (!this.getStatusesWithDependencies(selectedChannelStatuses, ChannelTask.PAUSE)) {
            return;
        }
        final String workingId = this.startWorking("Pausing channels...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashSet<String> channelIds = new HashSet<String>();
                for (DashboardStatus dashboardStatus : selectedChannelStatuses) {
                    channelIds.add(dashboardStatus.getChannelId());
                }
                try {
                    if (!channelIds.isEmpty()) {
                        Frame.this.mirthClient.pauseChannels(channelIds);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doStartConnector() {
        final List<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedStatuses();
        if (selectedStatuses.size() == 0) {
            return;
        }
        final String workingId = this.startWorking("Starting connectors...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashMap connectorInfo = new HashMap();
                for (DashboardStatus dashboardStatus : selectedStatuses) {
                    String channelId = dashboardStatus.getChannelId();
                    Integer metaDataId = dashboardStatus.getMetaDataId();
                    if (metaDataId == null) continue;
                    if (!connectorInfo.containsKey(channelId)) {
                        connectorInfo.put(channelId, new ArrayList());
                    }
                    ((List)connectorInfo.get(channelId)).add(metaDataId);
                }
                try {
                    if (!connectorInfo.isEmpty()) {
                        Frame.this.mirthClient.startConnectors(connectorInfo);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doStopConnector() {
        final List<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedStatuses();
        if (selectedStatuses.size() == 0) {
            return;
        }
        boolean warnQueueDisabled = false;
        Iterator<DashboardStatus> it = selectedStatuses.iterator();
        while (it.hasNext()) {
            DashboardStatus dashboardStatus = it.next();
            if (dashboardStatus.getMetaDataId() == 0 || dashboardStatus.isQueueEnabled()) continue;
            warnQueueDisabled = true;
            it.remove();
        }
        final String workingId = this.startWorking("Stopping connectors...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashMap connectorInfo = new HashMap();
                for (DashboardStatus dashboardStatus : selectedStatuses) {
                    String channelId = dashboardStatus.getChannelId();
                    Integer metaDataId = dashboardStatus.getMetaDataId();
                    if (metaDataId == null) continue;
                    if (!connectorInfo.containsKey(channelId)) {
                        connectorInfo.put(channelId, new ArrayList());
                    }
                    ((List)connectorInfo.get(channelId)).add(metaDataId);
                }
                try {
                    if (!connectorInfo.isEmpty()) {
                        Frame.this.mirthClient.stopConnectors(connectorInfo);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
        if (warnQueueDisabled) {
            this.alertWarning((Component)((Object)this), "<html>One or more destination connectors were not stopped because queueing was not enabled.<br>Queueing must be enabled for a destination connector to be stopped individually.</html>");
        }
    }

    public void doNewDestination() {
        this.channelEditPanel.addNewDestination();
    }

    public void doDeleteDestination() {
        if (!this.alertOption((Component)((Object)this), "Are you sure you want to delete this destination?")) {
            return;
        }
        this.channelEditPanel.deleteDestination();
    }

    public void doCloneDestination() {
        this.channelEditPanel.cloneDestination();
    }

    public void doEnableDestination() {
        this.channelEditPanel.enableDestination();
    }

    public void doDisableDestination() {
        this.channelEditPanel.disableDestination();
    }

    public void doNewUser() {
        new UserDialog(null);
    }

    public void doEditUser() {
        int index = this.userPanel.getUserIndex();
        if (index == -1) {
            this.alertWarning((Component)((Object)this), "User no longer exists.");
        } else {
            new UserDialog(this.users.get(index));
        }
    }

    public void doDeleteUser() {
        if (!this.alertOption((Component)((Object)this), "Are you sure you want to delete this user?")) {
            return;
        }
        final String workingId = this.startWorking("Deleting user...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                if (Frame.this.users.size() == 1) {
                    Frame.this.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), "You must have at least one user account.");
                    return null;
                }
                int userToDelete = Frame.this.userPanel.getUserIndex();
                try {
                    if (userToDelete != -1) {
                        Frame.this.mirthClient.removeUser(Frame.this.users.get(userToDelete).getId());
                        Frame.this.retrieveUsers();
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.userPanel.updateUserTable();
                Frame.this.userPanel.deselectRows();
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doRefreshUser() {
        final String workingId = this.startWorking("Loading users...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Frame.this.refreshUser();
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void refreshUser() {
        User user = null;
        String userName = null;
        int index = this.userPanel.getUserIndex();
        if (index != -1) {
            user = this.users.get(index);
        }
        try {
            this.retrieveUsers();
            this.userPanel.updateUserTable();
            if (user != null) {
                for (int i = 0; i < this.users.size(); ++i) {
                    if (!user.equals((Object)this.users.get(i))) continue;
                    userName = this.users.get(i).getUsername();
                }
            }
        }
        catch (ClientException e) {
            this.alertThrowable((Component)((Object)this), e);
        }
        if (userName != null) {
            this.userPanel.setSelectedUser(userName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doDebugDeployFromChannelView() {
        String channelId = this.channelEditPanel.currentChannel.getId();
        if (this.isSaveEnabled()) {
            if (!this.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "<html>This channel will be saved before it is deployed in debug mode.<br/>Are you sure you want to save and debug this channel?</html>")) return;
            if (!this.channelEditPanel.saveChanges()) return;
            this.setSaveEnabled(false);
        } else if (!this.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "Are you sure you want to debug this channel?")) {
            return;
        }
        ChannelStatus channelStatus = this.channelPanel.getCachedChannelStatuses().get(channelId);
        if (channelStatus == null) {
            this.alertWarning((Component)((Object)this), "The channel cannot be found and will not be deployed.");
            return;
        }
        if (!channelStatus.getChannel().getExportData().getMetadata().isEnabled()) {
            this.alertWarning((Component)((Object)this), "The channel is disabled and will not be deployed.");
            return;
        }
        DeployInDebugModeDialog deployInDebugMode = new DeployInDebugModeDialog();
        this.debugOptions = deployInDebugMode.getDebugOptions();
        if (!deployInDebugMode.getIsDebugChannel()) return;
        this.deployChannel(Collections.singleton(channelId), this.debugOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doDeployFromChannelView() {
        String channelId = this.channelEditPanel.currentChannel.getId();
        if (this.isSaveEnabled()) {
            if (!this.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "<html>This channel will be saved before it is deployed.<br/>Are you sure you want to save and deploy this channel?</html>")) return;
            if (!this.channelEditPanel.saveChanges()) return;
            this.setSaveEnabled(false);
        } else if (!this.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "Are you sure you want to deploy this channel?")) {
            return;
        }
        ChannelStatus channelStatus = this.channelPanel.getCachedChannelStatuses().get(channelId);
        if (channelStatus == null) {
            this.alertWarning((Component)((Object)this), "The channel cannot be found and will not be deployed.");
            return;
        }
        if (!channelStatus.getChannel().getExportData().getMetadata().isEnabled()) {
            boolean channelErrorsExist;
            boolean bl = channelErrorsExist = this.channelEditPanel.checkAllForms(this.channelEditPanel.currentChannel) != null;
            if (!channelErrorsExist && this.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "The channel is disabled. Are you sure you want to enable and deploy the channel?")) {
                this.channelEditPanel.setChannelEnabledField(true);
                this.channelEditPanel.saveChanges();
            } else {
                if (channelErrorsExist) {
                    this.alertWarning((Component)((Object)this), "There are errors in the channel that prevent it from being enabled and deployed.");
                    return;
                }
                this.alertWarning((Component)((Object)this), "The channel is disabled and will not be deployed.");
                return;
            }
        }
        this.deployChannel(Collections.singleton(channelId), null);
    }

    private void addChannelToDeploySet(String channelId, ChannelDependencyGraph channelDependencyGraph, Set<String> deployedChannelIds, Set<String> channelIdsToDeploy) {
        if (!channelIdsToDeploy.add(channelId)) {
            return;
        }
        DirectedAcyclicGraphNode node = channelDependencyGraph.getNode((Object)channelId);
        if (node != null) {
            ChannelStatus channelStatus;
            for (String dependentChannelId : node.getDirectDependentElements()) {
                channelStatus = this.channelPanel.getCachedChannelStatuses().get(dependentChannelId);
                if (channelStatus == null || !channelStatus.getChannel().getExportData().getMetadata().isEnabled() || !deployedChannelIds.contains(dependentChannelId)) continue;
                this.addChannelToDeploySet(dependentChannelId, channelDependencyGraph, deployedChannelIds, channelIdsToDeploy);
            }
            for (String dependencyChannelId : node.getDirectDependencyElements()) {
                channelStatus = this.channelPanel.getCachedChannelStatuses().get(dependencyChannelId);
                if (channelStatus == null || !channelStatus.getChannel().getExportData().getMetadata().isEnabled()) continue;
                this.addChannelToDeploySet(dependencyChannelId, channelDependencyGraph, deployedChannelIds, channelIdsToDeploy);
            }
        }
    }

    public Set<ChannelDependency> retrieveDependencies() {
        try {
            return this.mirthClient.getChannelDependencies();
        }
        catch (ClientException e) {
            SwingUtilities.invokeLater(() -> this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
            return null;
        }
    }

    public void deployChannel(Set<String> selectedChannelIds, final DebugOptions debugOptions) {
        if (CollectionUtils.isNotEmpty(selectedChannelIds)) {
            LinkedHashSet<String> selectedEnabledChannelIds;
            block9: {
                selectedEnabledChannelIds = new LinkedHashSet<String>(selectedChannelIds);
                if (debugOptions == null) {
                    try {
                        Set<ChannelDependency> channelDependencies = this.retrieveDependencies();
                        ChannelDependencyGraph channelDependencyGraph = new ChannelDependencyGraph(channelDependencies);
                        HashSet<String> deployedChannelIds = new HashSet<String>();
                        if (this.status != null) {
                            for (DashboardStatus dashboardStatus : this.status) {
                                deployedChannelIds.add(dashboardStatus.getChannelId());
                            }
                        }
                        HashSet<String> channelIdsToDeploy = new HashSet<String>();
                        for (String channelEnabledId : selectedEnabledChannelIds) {
                            this.addChannelToDeploySet(channelEnabledId, channelDependencyGraph, deployedChannelIds, channelIdsToDeploy);
                        }
                        if (CollectionUtils.subtract(channelIdsToDeploy, selectedEnabledChannelIds).isEmpty()) break block9;
                        ChannelDependenciesWarningDialog dialog = new ChannelDependenciesWarningDialog(ChannelTask.DEPLOY, channelDependencies, selectedEnabledChannelIds, channelIdsToDeploy);
                        if (dialog.getResult() == 0) {
                            if (dialog.isIncludeOtherChannels()) {
                                selectedEnabledChannelIds.addAll(channelIdsToDeploy);
                            }
                            break block9;
                        }
                        return;
                    }
                    catch (ChannelDependencyException e) {
                        e.printStackTrace();
                    }
                }
            }
            String plural = selectedEnabledChannelIds.size() > 1 ? "s" : "";
            final String workingId = this.startWorking("Deploying channel" + plural + "...");
            this.dashboardPanel.deselectRows(false);
            this.doShowDashboard();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        if (debugOptions != null) {
                            Frame.this.mirthClient.deployChannel((String)selectedEnabledChannelIds.iterator().next(), false, debugOptions);
                        } else {
                            Frame.this.mirthClient.deployChannels(selectedEnabledChannelIds);
                        }
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                    }
                    return null;
                }

                @Override
                public void done() {
                    Frame.this.stopWorking(workingId);
                    Frame.this.doRefreshStatuses(true);
                }
            };
            worker.execute();
        }
    }

    private boolean getStatusesWithDependencies(Set<DashboardStatus> selectedDashboardStatuses, ChannelTask task) {
        block7: {
            try {
                ChannelDependencyGraph channelDependencyGraph = new ChannelDependencyGraph(this.channelPanel.getCachedChannelDependencies());
                HashSet<String> selectedChannelIds = new HashSet<String>();
                HashSet<String> channelIdsToHandle = new HashSet<String>();
                HashMap<String, DashboardStatus> statusMap = new HashMap<String, DashboardStatus>();
                for (DashboardStatus dashboardStatus : this.status) {
                    statusMap.put(dashboardStatus.getChannelId(), dashboardStatus);
                }
                for (DashboardStatus dashboardStatus : selectedDashboardStatuses) {
                    selectedChannelIds.add(dashboardStatus.getChannelId());
                    this.addChannelToTaskSet(dashboardStatus.getChannelId(), channelDependencyGraph, statusMap, channelIdsToHandle, task);
                }
                if (CollectionUtils.subtract(channelIdsToHandle, selectedChannelIds).isEmpty()) break block7;
                ChannelDependenciesWarningDialog dialog = new ChannelDependenciesWarningDialog(task, this.channelPanel.getCachedChannelDependencies(), selectedChannelIds, channelIdsToHandle);
                if (dialog.getResult() == 0) {
                    if (dialog.isIncludeOtherChannels()) {
                        for (String channelId : channelIdsToHandle) {
                            selectedDashboardStatuses.add((DashboardStatus)statusMap.get(channelId));
                        }
                    }
                    break block7;
                }
                return false;
            }
            catch (ChannelDependencyException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void addChannelToTaskSet(String channelId, ChannelDependencyGraph channelDependencyGraph, Map<String, DashboardStatus> statusMap, Set<String> channelIdsToHandle, ChannelTask task) {
        block5: {
            if (!channelIdsToHandle.add(channelId)) {
                return;
            }
            DirectedAcyclicGraphNode node = channelDependencyGraph.getNode((Object)channelId);
            if (node == null) break block5;
            if (task.isForwardOrder()) {
                for (String dependencyChannelId : node.getDirectDependencyElements()) {
                    DashboardStatus dashboardStatus;
                    if (!statusMap.containsKey(dependencyChannelId) || (dashboardStatus = statusMap.get(dependencyChannelId)).getState() == DeployedState.STARTED) continue;
                    this.addChannelToTaskSet(dependencyChannelId, channelDependencyGraph, statusMap, channelIdsToHandle, task);
                }
            } else {
                for (String dependentChannelId : node.getDirectDependentElements()) {
                    if (!statusMap.containsKey(dependentChannelId)) continue;
                    DashboardStatus dashboardStatus = statusMap.get(dependentChannelId);
                    if (task != ChannelTask.UNDEPLOY && (task != ChannelTask.STOP || dashboardStatus.getState() == DeployedState.STOPPED) && (task != ChannelTask.PAUSE || dashboardStatus.getState() == DeployedState.PAUSED || dashboardStatus.getState() == DeployedState.STOPPED)) continue;
                    this.addChannelToTaskSet(dependentChannelId, channelDependencyGraph, statusMap, channelIdsToHandle, task);
                }
            }
        }
    }

    public void doUndeployChannel() {
        final Set<DashboardStatus> selectedChannelStatuses = this.dashboardPanel.getSelectedChannelStatuses();
        if (selectedChannelStatuses.size() == 0) {
            return;
        }
        if (!this.getStatusesWithDependencies(selectedChannelStatuses, ChannelTask.UNDEPLOY)) {
            return;
        }
        this.dashboardPanel.deselectRows(false);
        String plural = selectedChannelStatuses.size() > 1 ? "s" : "";
        final String workingId = this.startWorking("Undeploying channel" + plural + "...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    LinkedHashSet<String> channelIds = new LinkedHashSet<String>();
                    for (DashboardStatus channelStatus : selectedChannelStatuses) {
                        channelIds.add(channelStatus.getChannelId());
                    }
                    Frame.this.mirthClient.undeployChannels(channelIds);
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
                Frame.this.doRefreshStatuses(true);
            }
        };
        worker.execute();
    }

    public void doSaveChannel() {
        final String workingId = this.startWorking("Saving channel...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                if (Frame.this.changesHaveBeenMade() || Frame.this.currentContentPage == Frame.this.channelEditPanel.transformerPane || Frame.this.currentContentPage == Frame.this.channelEditPanel.filterPane) {
                    if (Frame.this.channelEditPanel.saveChanges()) {
                        Frame.this.setSaveEnabled(false);
                    }
                    return null;
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public boolean changesHaveBeenMade() {
        if (this.currentContentPage == this.channelPanel) {
            return this.channelPanel.changesHaveBeenMade();
        }
        if (this.channelEditPanel != null && this.currentContentPage == this.channelEditPanel) {
            return this.channelEditTasks.getContentPane().getComponent(0).isVisible();
        }
        if (this.channelEditPanel != null && this.currentContentPage == this.channelEditPanel.transformerPane) {
            return this.channelEditPanel.transformerPane.isModified();
        }
        if (this.channelEditPanel != null && this.currentContentPage == this.channelEditPanel.filterPane) {
            return this.channelEditPanel.filterPane.isModified();
        }
        if (this.settingsPane != null && this.currentContentPage == this.settingsPane) {
            return this.settingsPane.getCurrentSettingsPanel().isSaveEnabled();
        }
        if (this.alertEditPanel != null && this.currentContentPage == this.alertEditPanel) {
            return this.alertEditTasks.getContentPane().getComponent(0).isVisible();
        }
        if (this.globalScriptsPanel != null && this.currentContentPage == this.globalScriptsPanel) {
            return this.globalScriptsTasks.getContentPane().getComponent(0).isVisible();
        }
        if (this.currentContentPage == this.codeTemplatePanel) {
            return this.codeTemplatePanel.changesHaveBeenMade();
        }
        return false;
    }

    public void doShowMessages() {
        final HashMap<String, MessageBrowserChannelModel> selectedChannelModels = new HashMap<String, MessageBrowserChannelModel>();
        String panelName = "";
        if (this.currentContentPage == this.dashboardPanel) {
            MessageBrowserChannelModel channelModel;
            List<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedStatuses();
            Set<DashboardStatus> selectedChannelStatuses = this.dashboardPanel.getSelectedChannelStatuses();
            if (selectedStatuses.size() == 0) {
                return;
            }
            if (!this.multiChannelMessageBrowsingEnabled && selectedChannelStatuses.size() > 1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "This operation can only be performed on a single channel.");
                return;
            }
            for (DashboardStatus status : selectedStatuses) {
                channelModel = (MessageBrowserChannelModel)selectedChannelModels.get(status.getChannelId());
                if (channelModel == null) {
                    channelModel = new MessageBrowserChannelModel(status.getChannelId());
                    selectedChannelModels.put(status.getChannelId(), channelModel);
                    channelModel.setChannelDeployed(true);
                }
                channelModel.getSelectedMetaDataIds().add(status.getMetaDataId());
            }
            Iterator<Object> iterator = selectedChannelStatuses.iterator();
            while (iterator.hasNext()) {
                DashboardStatus status;
                status = (DashboardStatus)iterator.next();
                channelModel = (MessageBrowserChannelModel)selectedChannelModels.get(status.getChannelId());
                if (channelModel == null) {
                    channelModel = new MessageBrowserChannelModel(status.getChannelId());
                    selectedChannelModels.put(status.getChannelId(), channelModel);
                    channelModel.setChannelDeployed(true);
                }
                channelModel.setChannelName(status.getName());
            }
        } else if (this.currentContentPage == this.channelPanel) {
            List<Channel> selectedChannels = this.channelPanel.getSelectedChannels();
            for (Channel selectedChannel : selectedChannels) {
                MessageBrowserChannelModel channelModel = (MessageBrowserChannelModel)selectedChannelModels.get(selectedChannel.getId());
                if (channelModel == null) {
                    channelModel = new MessageBrowserChannelModel(selectedChannel.getId());
                    selectedChannelModels.put(selectedChannel.getId(), channelModel);
                }
                channelModel.setChannelName(selectedChannel.getName());
                channelModel.getSelectedMetaDataIds().add(null);
                boolean channelDeployed = false;
                for (DashboardStatus dashStatus : this.status) {
                    if (!dashStatus.getChannelId().equals(selectedChannel.getId())) continue;
                    channelDeployed = true;
                }
                channelModel.setChannelDeployed(channelDeployed);
            }
        }
        if (selectedChannelModels.size() > 1) {
            if (Preferences.userNodeForPackage(Mirth.class).getBoolean("multiChannelSearchWarning", true)) {
                String searchWarning = "<html>Viewing messages for multiple channels may take a long time, depending on the number of channels and messages being searched.<br/>Are you sure you want to proceed?</html>";
                Object[] params = new Object[]{searchWarning};
                int result = JOptionPane.showConfirmDialog((Component)((Object)this), params, "Select an Option", 0, 3);
                if (result != 0) {
                    return;
                }
                if (this.enhancedMessageBrowser == null) {
                    this.logger.error("enhancedMessageBrowser is null");
                }
            }
            this.activeBrowser = this.enhancedMessageBrowser;
            panelName = "Multi-Channel Messages";
        } else {
            if (this.messageBrowser == null) {
                this.messageBrowser = new MessageBrowser();
            }
            this.activeBrowser = this.messageBrowser;
            Iterator selectedChannelModelsIter = selectedChannelModels.values().iterator();
            StringBuilder panelNameBuilder = new StringBuilder("Channel Messages - " + ((MessageBrowserChannelModel)selectedChannelModelsIter.next()).getChannelName());
            panelName = panelNameBuilder.toString();
        }
        this.setBold(this.viewPane, -1);
        this.setPanelName(panelName);
        this.setCurrentContentPage(this.activeBrowser);
        this.setFocus(this.messageTasks);
        final String workingId = this.startWorking("Retrieving channel metadata...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    for (MessageBrowserChannelModel selectedChannelModel : selectedChannelModels.values()) {
                        selectedChannelModel.setConnectors(Frame.this.mirthClient.getConnectorNames(selectedChannelModel.getChannelId()));
                        selectedChannelModel.setMetaDataColumns(Frame.this.mirthClient.getMetaDataColumns(selectedChannelModel.getChannelId()));
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
                boolean retrievedMetadata = true;
                for (MessageBrowserChannelModel selectedChannelModel : selectedChannelModels.values()) {
                    if (selectedChannelModel.getConnectors() != null && selectedChannelModel.getMetaDataColumns() != null) continue;
                    retrievedMetadata = false;
                    break;
                }
                if (!retrievedMetadata) {
                    Frame.this.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Could not retrieve metadata for channel.");
                } else {
                    Frame.this.activeBrowser.loadChannels(new ArrayList<MessageBrowserChannelModel>(selectedChannelModels.values()));
                }
            }
        };
        worker.execute();
    }

    public void doShowEvents() {
        this.doShowEvents(null);
    }

    public void doShowEvents(String eventNameFilter) {
        if (!this.confirmLeave()) {
            return;
        }
        if (this.eventBrowser == null) {
            this.eventBrowser = new EventBrowser();
        }
        this.setBold(this.viewPane, 5);
        this.setPanelName("Events");
        this.setCurrentContentPage(this.eventBrowser);
        this.setFocus(this.eventTasks);
        this.eventBrowser.loadNew(eventNameFilter);
    }

    public void doEditTransformer() {
        this.channelEditPanel.transformerPane.resizePanes();
        String name = this.channelEditPanel.editTransformer();
        this.setPanelName("Edit Channel - " + this.channelEditPanel.currentChannel.getName() + " - " + name + " Transformer");
    }

    public void doEditResponseTransformer() {
        this.channelEditPanel.transformerPane.resizePanes();
        String name = this.channelEditPanel.editResponseTransformer();
        this.setPanelName("Edit Channel - " + this.channelEditPanel.currentChannel.getName() + " - " + name + " Response Transformer");
    }

    public void doEditFilter() {
        this.channelEditPanel.filterPane.resizePanes();
        String name = this.channelEditPanel.editFilter();
        this.setPanelName("Edit Channel - " + this.channelEditPanel.currentChannel.getName() + " - " + name + " Filter");
    }

    public void updateFilterTaskName(int rules) {
        this.updateFilterOrTransformerTaskName("Edit Filter", 9, rules, false);
    }

    public void updateTransformerTaskName(int steps, boolean outboundTemplate) {
        this.updateFilterOrTransformerTaskName("Edit Transformer", 10, steps, outboundTemplate);
    }

    public void updateResponseTransformerTaskName(int steps, boolean outboundTemplate) {
        this.updateFilterOrTransformerTaskName("Edit Response", 11, steps, outboundTemplate);
    }

    private void updateFilterOrTransformerTaskName(String taskName, int componentIndex, int rulesOrSteps, boolean outboundTemplate) {
        if (rulesOrSteps > 0) {
            taskName = (String)taskName + " (" + rulesOrSteps + ")";
        } else if (outboundTemplate) {
            taskName = (String)taskName + " (0)";
        }
        ((JXHyperlink)this.channelEditTasks.getContentPane().getComponent(componentIndex)).setText((String)taskName);
        ((JMenuItem)this.channelEditPopupMenu.getComponent(componentIndex)).setText((String)taskName);
    }

    public void doValidate() {
        this.channelEditPanel.doValidate();
    }

    public boolean doExportChannel() {
        return this.channelPanel.doExportChannel();
    }

    public List<String> browseForMultipleFileStrings(String fileExtension) {
        File[] files;
        ArrayList<String> fileStrings = new ArrayList<String>();
        for (File file : files = this.browseForFiles(fileExtension)) {
            if (file == null) continue;
            fileStrings.add(this.readFileToString(file));
        }
        return fileStrings;
    }

    public List<byte[]> browseForMultipleFileBytes(String fileExtension) {
        ArrayList<byte[]> fileBytes = new ArrayList<byte[]>();
        File[] files = this.browseForFiles(fileExtension);
        String fileName = "";
        if (files != null) {
            try {
                for (File file : files) {
                    fileName = file.getName();
                    byte[] bytes = FileUtils.readFileToByteArray((File)file);
                    fileBytes.add(bytes);
                }
                return fileBytes;
            }
            catch (IOException e) {
                this.alertError((Component)((Object)this), "Unable to read file: " + fileName);
            }
        }
        return null;
    }

    public String browseForFileString(String fileExtension) {
        File file = this.browseForFile(fileExtension);
        if (file != null) {
            return this.readFileToString(file);
        }
        return null;
    }

    public byte[] browseForFileBytes(String fileExtension) {
        File file = this.browseForFile(fileExtension);
        if (file != null) {
            try {
                return FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                this.alertError((Component)((Object)this), "Unable to read file.");
            }
        }
        return null;
    }

    public String readFileToString(File file) {
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (StringUtils.startsWith((CharSequence)content, (CharSequence)"{enc}")) {
                return this.mirthClient.getEncryptor().decrypt(StringUtils.removeStart((String)content, (String)"{enc}"));
            }
            return content;
        }
        catch (IOException e) {
            this.alertError((Component)((Object)this), "Unable to read file.");
            return null;
        }
    }

    public File browseForFile(String fileExtension) {
        File currentDir;
        JFileChooser importFileChooser = new JFileChooser();
        if (fileExtension != null) {
            importFileChooser.setFileFilter(new MirthFileFilter(fileExtension));
        }
        if ((currentDir = new File(userPreferences.get("currentDirectory", ""))).exists()) {
            importFileChooser.setCurrentDirectory(currentDir);
        }
        if (importFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            userPreferences.put("currentDirectory", importFileChooser.getCurrentDirectory().getPath());
            return importFileChooser.getSelectedFile();
        }
        return null;
    }

    public File[] browseForFiles(String fileExtension) {
        File currentDir;
        JFileChooser importFileChooser = new JFileChooser();
        importFileChooser.setMultiSelectionEnabled(true);
        if (fileExtension != null) {
            importFileChooser.setFileFilter(new MirthFileFilter(fileExtension));
        }
        if ((currentDir = new File(userPreferences.get("currentDirectory", ""))).exists()) {
            importFileChooser.setCurrentDirectory(currentDir);
        }
        if (importFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            userPreferences.put("currentDirectory", importFileChooser.getCurrentDirectory().getPath());
            return importFileChooser.getSelectedFiles();
        }
        return null;
    }

    public File createFileForExport(String defaultFileName, String fileExtension) {
        File currentDir;
        JFileChooser exportFileChooser = new JFileChooser();
        if (defaultFileName != null) {
            exportFileChooser.setSelectedFile(new File(defaultFileName));
        }
        if (fileExtension != null) {
            exportFileChooser.setFileFilter(new MirthFileFilter(fileExtension));
        }
        if ((currentDir = new File(userPreferences.get("currentDirectory", ""))).exists()) {
            exportFileChooser.setCurrentDirectory(currentDir);
        }
        if (exportFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            userPreferences.put("currentDirectory", exportFileChooser.getCurrentDirectory().getPath());
            File exportFile = exportFileChooser.getSelectedFile();
            if (exportFile.getName().length() < 4 || !FilenameUtils.getExtension((String)exportFile.getName()).equalsIgnoreCase(fileExtension)) {
                exportFile = new File(exportFile.getAbsolutePath() + "." + fileExtension.toLowerCase());
            }
            if (exportFile.exists() && !this.alertOption((Component)((Object)this), "This file already exists.  Would you like to overwrite it?")) {
                return null;
            }
            return exportFile;
        }
        return null;
    }

    public boolean exportFile(String fileContents, String defaultFileName, String fileExtension, String name) {
        return this.exportFile(fileContents, this.createFileForExport(defaultFileName, fileExtension), name);
    }

    public boolean exportFile(String fileContents, File exportFile, String name) {
        if (exportFile != null) {
            try {
                Object contentToWrite = null;
                contentToWrite = this.mirthClient.isEncryptExport() ? "{enc}" + this.mirthClient.getEncryptor().encrypt(fileContents) : fileContents;
                FileUtils.writeStringToFile((File)exportFile, (String)contentToWrite, (String)"UTF-8");
                this.alertInformation((Component)((Object)this), name + " was written to " + exportFile.getPath() + ".");
            }
            catch (IOException ex) {
                this.alertError((Component)((Object)this), "File could not be written.");
                return false;
            }
            return true;
        }
        return false;
    }

    public void doImportConnector() {
        String content = this.browseForFileString("XML");
        if (content != null) {
            try {
                this.channelEditPanel.importConnector((Connector)ObjectXMLSerializer.getInstance().deserialize(content, Connector.class));
            }
            catch (Exception e) {
                this.alertThrowable((Component)((Object)this), e);
            }
        }
    }

    public void doExportConnector() {
        if (this.changesHaveBeenMade()) {
            if (this.alertOption((Component)((Object)this), "This channel has been modified. You must save the channel changes before you can export. Would you like to save them now?")) {
                if (!this.channelEditPanel.saveChanges()) {
                    return;
                }
            } else {
                return;
            }
            this.setSaveEnabled(false);
        }
        Connector connector = this.channelEditPanel.exportSelectedConnector();
        this.updateResourceNames(connector);
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        String connectorXML = serializer.serialize((Object)connector);
        Object fileName = this.channelEditPanel.currentChannel.getName();
        fileName = connector.getMode().equals((Object)Connector.Mode.SOURCE) ? (String)fileName + " Source" : (String)fileName + " " + connector.getName();
        this.exportFile(connectorXML, (String)fileName, "XML", "Connector");
    }

    public void doRefreshMessages() {
        this.activeBrowser.refresh(null, true);
    }

    public void doSendMessage() {
        String channelId = null;
        ArrayList<Integer> selectedMetaDataIds = null;
        if (this.currentContentPage == this.dashboardPanel) {
            List<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedStatuses();
            channelId = selectedStatuses.get(0).getChannelId();
            selectedMetaDataIds = new ArrayList<Integer>();
            for (DashboardStatus status : selectedStatuses) {
                Integer metaDataId;
                if (status.getChannelId() != channelId) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "This operation can only be performed on a single channel.");
                    return;
                }
                if (status.getStatusType() == DashboardStatus.StatusType.CHANNEL) {
                    selectedMetaDataIds = null;
                    continue;
                }
                if (selectedMetaDataIds == null || (metaDataId = status.getMetaDataId()) == null) continue;
                selectedMetaDataIds.add(metaDataId);
            }
        } else if (this.currentContentPage == this.activeBrowser) {
            channelId = this.activeBrowser.getChannelId();
        }
        if (channelId == null) {
            this.alertError((Component)((Object)this), "Could not find channel ID!");
            return;
        }
        String dataType = "RAW";
        if (AuthorizationControllerFactory.getAuthorizationController().checkTask("view", "doShowChannel")) {
            ChannelStatus channelStatus = this.channelPanel.getCachedChannelStatuses().get(channelId);
            if (channelStatus == null) {
                try {
                    HashMap<String, ChannelHeader> channelHeaders = new HashMap<String, ChannelHeader>();
                    channelHeaders.put(channelId, new ChannelHeader(0, null, true));
                    this.channelPanel.updateChannelStatuses(this.mirthClient.getChannelSummary(channelHeaders, true));
                    channelStatus = this.channelPanel.getCachedChannelStatuses().get(channelId);
                }
                catch (ClientException e) {
                    this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e);
                }
            }
            if (channelStatus == null) {
                this.alertError((Component)((Object)this), "Channel no longer exists!");
                return;
            }
            dataType = channelStatus.getChannel().getSourceConnector().getTransformer().getInboundDataType();
        }
        this.editMessageDialog.setPropertiesAndShow("", dataType, channelId, this.dashboardPanel.getDestinationConnectorNames(channelId), selectedMetaDataIds, new HashMap<String, Object>());
    }

    public void doExportMessages() {
        if (this.activeBrowser == this.enhancedMessageBrowser) {
            this.enhancedMessageExportDialog.setEncryptor(this.mirthClient.getEncryptor());
            this.enhancedMessageExportDialog.setMessageFilter(this.activeBrowser.getMessageFilter());
            this.enhancedMessageExportDialog.setPageSize(this.activeBrowser.getPageSize());
            this.enhancedMessageExportDialog.setChannelIds(this.activeBrowser.getChannelIds());
            this.enhancedMessageExportDialog.setMessages(this.activeBrowser.getMessages());
            this.enhancedMessageExportDialog.setIsChannelMessagesPanelFirstLoadSearch(this.activeBrowser.getIsChannelMessagesPanelFirstLoadSearch());
            this.enhancedMessageExportDialog.setLocationRelativeTo((Component)((Object)this));
            this.enhancedMessageExportDialog.setVisible(true);
        } else {
            if (this.messageExportDialog == null) {
                this.messageExportDialog = new MessageExportDialog();
            }
            this.messageExportDialog.setEncryptor(this.mirthClient.getEncryptor());
            this.messageExportDialog.setMessageFilter(this.activeBrowser.getMessageFilter());
            this.messageExportDialog.setPageSize(this.activeBrowser.getPageSize());
            this.messageExportDialog.setChannelId(this.activeBrowser.getChannelId());
            this.messageExportDialog.setMessages(this.activeBrowser.getMessages());
            this.messageExportDialog.setIsChannelMessagesPanelFirstLoadSearch(this.activeBrowser.getIsChannelMessagesPanelFirstLoadSearch());
            this.messageExportDialog.setLocationRelativeTo((Component)((Object)this));
            this.messageExportDialog.setVisible(true);
        }
    }

    public void doImportMessages() {
        if (this.messageImportDialog == null) {
            this.messageImportDialog = new MessageImportDialog();
        }
        this.messageImportDialog.setChannelId(this.activeBrowser.getChannelId());
        this.messageImportDialog.setMessageBrowser(this.activeBrowser);
        this.messageImportDialog.setLocationRelativeTo((Component)((Object)this));
        this.messageImportDialog.setVisible(true);
    }

    public void doRemoveAllMessages() {
        if (this.removeMessagesDialog == null) {
            this.removeMessagesDialog = new RemoveMessagesDialog(this, true);
        }
        HashSet<String> channelIds = new HashSet<String>();
        boolean restartCheckboxEnabled = false;
        if (this.currentContentPage instanceof MessageBrowser) {
            String channelId = ((MessageBrowser)this.currentContentPage).getChannelId();
            channelIds.add(channelId);
            for (DashboardStatus channelStatus : this.status) {
                if (!channelStatus.getChannelId().equals(channelId) || channelStatus.getState().equals((Object)DeployedState.STOPPED) || restartCheckboxEnabled) continue;
                restartCheckboxEnabled = true;
            }
        } else {
            for (DashboardStatus channelStatus : this.dashboardPanel.getSelectedChannelStatuses()) {
                channelIds.add(channelStatus.getChannelId());
                if (channelStatus.getState().equals((Object)DeployedState.STOPPED) || restartCheckboxEnabled) continue;
                restartCheckboxEnabled = true;
            }
        }
        this.removeMessagesDialog.init(channelIds, restartCheckboxEnabled);
        this.removeMessagesDialog.setLocationRelativeTo((Component)((Object)this));
        this.removeMessagesDialog.setVisible(true);
    }

    public void doClearStats() {
        List<DashboardStatus> channelStatuses = this.dashboardPanel.getSelectedStatusesRecursive();
        if (channelStatuses.size() != 0) {
            new DeleteStatisticsDialog(channelStatuses);
        } else {
            this.dashboardPanel.deselectRows(false);
        }
    }

    public void clearStats(List<DashboardStatus> statusesToClear, final boolean deleteReceived, final boolean deleteFiltered, final boolean deleteSent, final boolean deleteErrored) {
        final String workingId = this.startWorking("Clearing statistics...");
        HashMap<String, ArrayList<Integer>> channelConnectorMap = new HashMap<String, ArrayList<Integer>>();
        for (DashboardStatus status : statusesToClear) {
            String channelId = status.getChannelId();
            Integer metaDataId = status.getMetaDataId();
            ArrayList<Integer> metaDataIds = (ArrayList<Integer>)channelConnectorMap.get(channelId);
            if (metaDataIds == null) {
                metaDataIds = new ArrayList<Integer>();
                channelConnectorMap.put(channelId, metaDataIds);
            }
            metaDataIds.add(metaDataId);
        }
        final HashMap<String, ArrayList<Integer>> channelConnectorMapFinal = channelConnectorMap;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    Frame.this.mirthClient.clearStatistics(channelConnectorMapFinal, deleteReceived, deleteFiltered, deleteSent, deleteErrored);
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshStatuses(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doRemoveFilteredMessages() {
        if (this.alertOption((Component)((Object)this), "<html><font color=\"red\"><b>Warning:</b></font> This will remove <b>all</b> results for the current search criteria,<br/>including those not listed on the current page. To see how many messages will<br/>be removed, close this dialog and click the Count button in the upper-right.<br/><font size='1'><br/></font><font color=\"red\"><b>Warning:</b></font> Removing a Source message will remove all of its destinations.<br/><font size='1'><br/></font>Are you sure you would like to remove all messages that match<br/>the current search criteria (including QUEUED) in this channel?<br/>Channel must be stopped for unfinished messages to be removed.</html>")) {
            String result;
            if (userPreferences.getBoolean("showReprocessRemoveMessagesWarning", true) && !StringUtils.equals((CharSequence)(result = DisplayUtil.showInputDialog((Component)((Object)this), "<html>This will remove all messages that match the current search criteria.<br/>To see how many messages will be removed, close this dialog and<br/>click the Count button in the upper-right.<br><font size='1'><br></font>Type REMOVEALL and click the OK button to continue.</html>", "Remove Results", 2)), (CharSequence)"REMOVEALL")) {
                this.alertWarning((Component)((Object)this), "You must type REMOVEALL to remove results.");
                return;
            }
            final String workingId = this.startWorking("Removing messages...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    block2: {
                        try {
                            Frame.this.mirthClient.removeMessages(Frame.this.activeBrowser.getChannelId(), Frame.this.activeBrowser.getMessageFilter());
                        }
                        catch (ClientException e) {
                            if (e instanceof RequestAbortedException) break block2;
                            SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                        }
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (Frame.this.currentContentPage == Frame.this.dashboardPanel) {
                        Frame.this.doRefreshStatuses(true);
                    } else if (Frame.this.currentContentPage == Frame.this.activeBrowser) {
                        Frame.this.activeBrowser.refresh(1, true);
                    }
                    Frame.this.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }

    public void doRemoveMessage() {
        ArrayList<Integer> selectedMetaDataIds = new ArrayList<Integer>();
        final Integer metaDataId = this.activeBrowser.getSelectedMetaDataId();
        final Long messageId = this.activeBrowser.getSelectedMessageId();
        final String channelId = this.activeBrowser.getChannelId();
        selectedMetaDataIds.add(metaDataId);
        final String patientId = this.activeBrowser.getPatientId(messageId, metaDataId, selectedMetaDataIds);
        if (this.alertOption((Component)((Object)this), "<html>Are you sure you would like to remove the selected message?<br>Channel must be stopped for an unfinished message to be removed.<br><font size='1'><br></font>WARNING: Removing a Source message will remove all of its destinations.</html>")) {
            final String workingId = this.startWorking("Removing message...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        Frame.this.mirthClient.removeMessage(channelId, messageId, metaDataId, patientId);
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (Frame.this.currentContentPage == Frame.this.dashboardPanel) {
                        Frame.this.doRefreshStatuses(true);
                    } else if (Frame.this.currentContentPage == Frame.this.activeBrowser) {
                        Frame.this.activeBrowser.refresh(null, false);
                    }
                    Frame.this.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }

    public void doReprocessFilteredMessages() {
        this.doReprocess(this.activeBrowser.getMessageFilter(), null, null, true);
    }

    public void doReprocessMessage() {
        Long messageId = this.activeBrowser.getSelectedMessageId();
        if (this.activeBrowser.canReprocessMessage(messageId)) {
            this.doReprocess(null, messageId, this.activeBrowser.getSelectedMetaDataId(), false);
        } else {
            this.alertError((Component)((Object)this), "Message " + messageId + " cannot be reprocessed because no source raw content was found.");
        }
    }

    private void doReprocess(final MessageFilter filter, final Long messageId, final Integer selectedMetaDataId, final boolean showWarning) {
        final String workingId = this.startWorking("Retrieving Channels...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                if (Frame.this.channelPanel.getCachedChannelStatuses() == null || Frame.this.channelPanel.getCachedChannelStatuses().values().size() == 0) {
                    Frame.this.channelPanel.retrieveChannels();
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
                LinkedHashMap<Integer, String> destinationConnectors = new LinkedHashMap<Integer, String>();
                destinationConnectors.putAll(Frame.this.dashboardPanel.getDestinationConnectorNames(Frame.this.activeBrowser.getChannelId()));
                new ReprocessMessagesDialog(Frame.this.activeBrowser.getChannelId(), filter, messageId, destinationConnectors, selectedMetaDataId, showWarning);
            }
        };
        worker.execute();
    }

    public void reprocessMessage(final String channelId, final MessageFilter filter, final Long messageId, final boolean replace, final Collection<Integer> reprocessMetaDataIds) {
        final String workingId = this.startWorking("Reprocessing messages...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    if (filter != null) {
                        Frame.this.mirthClient.reprocessMessages(channelId, filter, replace, reprocessMetaDataIds);
                    } else if (messageId != null) {
                        Frame.this.mirthClient.reprocessMessage(channelId, messageId, replace, reprocessMetaDataIds);
                    }
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.activeBrowser.updateFilterButtonFont(1);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void viewImage() {
        final String workingId = this.startWorking("Opening attachment...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Frame.this.activeBrowser.viewAttachment();
                Frame.this.stopWorking(workingId);
                return null;
            }

            @Override
            public void done() {
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doExportAttachment() {
        if (this.attachmentExportDialog == null) {
            this.attachmentExportDialog = new AttachmentExportDialog();
        }
        this.attachmentExportDialog.setLocationRelativeTo((Component)((Object)this));
        this.attachmentExportDialog.setVisible(true);
    }

    public void processMessage(final String channelId, final RawMessage rawMessage) {
        final String workingId = this.startWorking("Processing message...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    Frame.this.mirthClient.processMessage(channelId, rawMessage);
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                if (Frame.this.currentContentPage == Frame.this.activeBrowser) {
                    Frame.this.activeBrowser.updateFilterButtonFont(1);
                }
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doRefreshEvents() {
        this.eventBrowser.refresh(null);
    }

    public void doExportAllEvents() {
        if (this.alertOption((Component)((Object)this), "Are you sure you would like to export all events? An export\nfile will be placed in the exports directory on the server.")) {
            final String workingId = this.startWorking("Exporting events...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                private String exportPath = null;

                @Override
                public Void doInBackground() {
                    try {
                        this.exportPath = Frame.this.mirthClient.exportAllEvents();
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (this.exportPath != null) {
                        Frame.this.alertInformation((Component)((Object)PlatformUI.MIRTH_FRAME), "Events have been exported to the following server path:\n" + this.exportPath);
                    }
                    Frame.this.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }

    public void doRefreshAlerts() {
        this.doRefreshAlerts(true);
    }

    public void doRefreshAlerts(boolean queue) {
        final List<String> selectedAlertIds = this.alertPanel.getSelectedAlertIds();
        QueuingSwingWorkerTask<Void, Void> task = new QueuingSwingWorkerTask<Void, Void>("doRefreshAlerts", "Loading alerts..."){
            private List<AlertStatus> alertStatusList;

            @Override
            public Void doInBackground() {
                try {
                    this.alertStatusList = Frame.this.mirthClient.getAlertStatusList();
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.alertPanel.updateAlertTable(this.alertStatusList);
                Frame.this.alertPanel.setSelectedAlertIds(selectedAlertIds);
            }
        };
        new QueuingSwingWorker<Void, Void>(task, queue).executeDelegate();
    }

    public void doSaveAlerts() {
        if (this.changesHaveBeenMade()) {
            try {
                ServerSettings serverSettings = this.mirthClient.getServerSettings();
                if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpHost()) || StringUtils.isBlank((CharSequence)serverSettings.getSmtpPort())) {
                    this.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), "The SMTP server on the settings page is not specified or is incomplete.  An SMTP server is required to send email alerts.");
                }
            }
            catch (ClientException e) {
                this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, false);
            }
            final String workingId = this.startWorking("Saving alerts...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    if (Frame.this.alertEditPanel.saveAlert()) {
                        Frame.this.setSaveEnabled(false);
                    }
                    return null;
                }

                @Override
                public void done() {
                    Frame.this.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }

    public void doDeleteAlert() {
        if (!this.alertOption((Component)((Object)this), "Are you sure you want to delete the selected alert(s)?")) {
            return;
        }
        final String workingId = this.startWorking("Deleting alert...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                List<String> selectedAlertIds = Frame.this.alertPanel.getSelectedAlertIds();
                for (String alertId : selectedAlertIds) {
                    try {
                        Frame.this.mirthClient.removeAlert(alertId);
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                        return null;
                    }
                }
                Frame.this.alertPanel.updateAlertDetails(new HashSet<String>(selectedAlertIds));
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshAlerts(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doNewAlert() throws ClientException {
        AlertInfo alertInfo = this.mirthClient.getAlertInfo(this.channelPanel.getChannelHeaders());
        this.channelPanel.updateChannelStatuses(alertInfo.getChangedChannels());
        this.setupAlert(alertInfo.getProtocolOptions());
    }

    public void doEditAlert() {
        if (this.isEditingAlert) {
            return;
        }
        this.isEditingAlert = true;
        List<String> selectedAlertIds = this.alertPanel.getSelectedAlertIds();
        if (selectedAlertIds.size() > 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This operation can only be performed on a single alert.");
        } else if (selectedAlertIds.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Alert no longer exists.");
        } else {
            try {
                AlertInfo alertInfo = this.mirthClient.getAlertInfo(selectedAlertIds.get(0), this.channelPanel.getChannelHeaders());
                if (alertInfo.getModel() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Alert no longer exists.");
                    this.doRefreshAlerts(true);
                } else {
                    this.channelPanel.updateChannelStatuses(alertInfo.getChangedChannels());
                    this.editAlert(alertInfo.getModel(), alertInfo.getProtocolOptions());
                }
            }
            catch (ClientException e) {
                this.alertThrowable((Component)((Object)this), e);
            }
        }
        this.isEditingAlert = false;
    }

    public void doEnableAlert() {
        final String workingId = this.startWorking("Enabling alert...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                List<String> selectedAlertIds = Frame.this.alertPanel.getSelectedAlertIds();
                for (String alertId : selectedAlertIds) {
                    try {
                        Frame.this.mirthClient.enableAlert(alertId);
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                        return null;
                    }
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshAlerts(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doDisableAlert() {
        final String workingId = this.startWorking("Enabling alert...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                List<String> selectedAlertIds = Frame.this.alertPanel.getSelectedAlertIds();
                for (String alertId : selectedAlertIds) {
                    try {
                        Frame.this.mirthClient.disableAlert(alertId);
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                        return null;
                    }
                }
                return null;
            }

            @Override
            public void done() {
                Frame.this.doRefreshAlerts(true);
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doExportAlert() {
        AlertModel alert;
        List<Object> selectedAlertIds;
        if (this.changesHaveBeenMade()) {
            if (this.alertOption((Component)((Object)this), "This alert has been modified. You must save the alert changes before you can export. Would you like to save them now?")) {
                if (!this.alertEditPanel.saveAlert()) {
                    return;
                }
            } else {
                return;
            }
            this.setSaveEnabled(false);
        }
        if (this.currentContentPage == this.alertEditPanel) {
            selectedAlertIds = new ArrayList();
            String alertId = this.alertEditPanel.getAlertId();
            if (alertId != null) {
                selectedAlertIds.add(alertId);
            }
        } else {
            selectedAlertIds = this.alertPanel.getSelectedAlertIds();
        }
        if (CollectionUtils.isEmpty(selectedAlertIds)) {
            return;
        }
        try {
            alert = this.mirthClient.getAlert((String)selectedAlertIds.get(0));
        }
        catch (ClientException e) {
            this.alertThrowable((Component)((Object)this), e);
            return;
        }
        if (alert == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Alert no longer exists.");
            this.doRefreshAlerts(true);
        } else {
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            String alertXML = serializer.serialize((Object)alert);
            this.exportFile(alertXML, alert.getName(), "XML", "Alert");
        }
    }

    public void doExportAlerts() {
        JFileChooser exportFileChooser = new JFileChooser();
        exportFileChooser.setFileSelectionMode(1);
        File currentDir = new File(userPreferences.get("currentDirectory", ""));
        if (currentDir.exists()) {
            exportFileChooser.setCurrentDirectory(currentDir);
        }
        int returnVal = exportFileChooser.showSaveDialog((Component)((Object)this));
        File exportFile = null;
        File exportDirectory = null;
        if (returnVal == 0) {
            userPreferences.put("currentDirectory", exportFileChooser.getCurrentDirectory().getPath());
            try {
                List alerts;
                exportDirectory = exportFileChooser.getSelectedFile();
                try {
                    alerts = this.mirthClient.getAllAlerts();
                }
                catch (ClientException e) {
                    this.alertThrowable((Component)((Object)this), e);
                    return;
                }
                for (AlertModel alert : alerts) {
                    ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
                    String channelXML = serializer.serialize((Object)alert);
                    exportFile = new File(exportDirectory.getAbsolutePath() + "/" + alert.getName() + ".xml");
                    if (exportFile.exists() && !this.alertOption((Component)((Object)this), "The file " + alert.getName() + ".xml already exists.  Would you like to overwrite it?")) continue;
                    FileUtils.writeStringToFile((File)exportFile, (String)channelXML, (String)"UTF-8");
                }
                this.alertInformation((Component)((Object)this), "All files were written successfully to " + exportDirectory.getPath() + ".");
            }
            catch (IOException ex) {
                this.alertError((Component)((Object)this), "File could not be written.");
            }
        }
    }

    public void doImportAlert() {
        String content = this.browseForFileString("XML");
        if (content != null) {
            this.importAlert(content, true);
        }
    }

    public void importAlert(String alertXML, boolean showAlerts) {
        List alertList;
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        try {
            alertList = serializer.deserializeList(alertXML.replaceAll("\\&\\#x0D;\\n", "\n").replaceAll("\\&\\#x0D;", "\n"), AlertModel.class);
        }
        catch (Exception e) {
            if (showAlerts) {
                this.alertThrowable((Component)((Object)this), (Throwable)e, "Invalid alert file:\n" + e.getMessage());
            }
            return;
        }
        this.removeInvalidItems(alertList, AlertModel.class);
        for (AlertModel importAlert : alertList) {
            try {
                String alertName = importAlert.getName();
                String tempId = this.mirthClient.getGuid();
                if (!this.checkAlertName(alertName)) {
                    if (!this.alertOption((Component)((Object)this), "Would you like to overwrite the existing alert?  Choose 'No' to create a new alert.")) {
                        do {
                            if ((alertName = DisplayUtil.showInputDialog((Component)((Object)this), "Please enter a new name for the channel.", alertName)) != null) continue;
                            return;
                        } while (!this.checkAlertName(alertName));
                        importAlert.setName(alertName);
                        importAlert.setId(tempId);
                    } else {
                        for (Map.Entry<String, String> entry : this.alertPanel.getAlertNames().entrySet()) {
                            String id = entry.getKey();
                            String name = entry.getValue();
                            if (!name.equalsIgnoreCase(alertName)) continue;
                            importAlert.setId(id);
                        }
                    }
                }
                this.mirthClient.updateAlert(importAlert);
            }
            catch (Exception e) {
                this.alertThrowable((Component)((Object)this), (Throwable)e, "Error importing alert:\n" + e.getMessage());
            }
        }
        this.doRefreshAlerts(true);
    }

    public boolean checkAlertName(String name) {
        if (name.equals("")) {
            this.alertWarning((Component)((Object)this), "Alert name cannot be empty.");
            return false;
        }
        Pattern alphaNumericPattern = Pattern.compile("^[a-zA-Z_0-9\\-\\s]*$");
        Matcher matcher = alphaNumericPattern.matcher(name);
        if (!matcher.find()) {
            this.alertWarning((Component)((Object)this), "Alert name cannot have special characters besides hyphen, underscore, and space.");
            return false;
        }
        for (String alertName : this.alertPanel.getAlertNames().values()) {
            if (!alertName.equalsIgnoreCase(name)) continue;
            this.alertWarning((Component)((Object)this), "Alert \"" + name + "\" already exists.");
            return false;
        }
        return true;
    }

    public void doRefreshExtensions() {
        String workingId = this.startWorking("Loading extension settings...");
        if (this.confirmLeave()) {
            this.refreshExtensions();
        }
        this.stopWorking(workingId);
    }

    public void refreshExtensions() {
        this.extensionsPanel.setPluginData(this.getPluginMetaData());
        this.extensionsPanel.setConnectorData(this.getConnectorMetaData());
    }

    public void doEnableExtension() {
        final String workingId = this.startWorking("Enabling extension...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private boolean success = true;

            @Override
            public Void doInBackground() {
                try {
                    Frame.this.mirthClient.setExtensionEnabled(Frame.this.extensionsPanel.getSelectedExtension().getName(), true);
                }
                catch (ClientException e) {
                    this.success = false;
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                if (this.success) {
                    Frame.this.extensionsPanel.setSelectedExtensionEnabled(true);
                    Frame.this.extensionsPanel.setRestartRequired(true);
                }
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doDisableExtension() {
        final String workingId = this.startWorking("Disabling extension...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private boolean success = true;

            @Override
            public Void doInBackground() {
                try {
                    Frame.this.mirthClient.setExtensionEnabled(Frame.this.extensionsPanel.getSelectedExtension().getName(), false);
                }
                catch (ClientException e) {
                    this.success = false;
                    SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                }
                return null;
            }

            @Override
            public void done() {
                if (this.success) {
                    Frame.this.extensionsPanel.setSelectedExtensionEnabled(false);
                    Frame.this.extensionsPanel.setRestartRequired(true);
                }
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doShowExtensionProperties() {
        this.extensionsPanel.showExtensionProperties();
    }

    public void doUninstallExtension() {
        final String workingId = this.startWorking("Uninstalling extension...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private boolean success = true;

            @Override
            public Void doInBackground() {
                String packageName = Frame.this.extensionsPanel.getSelectedExtension().getPath();
                if (Frame.this.alertOkCancel((Component)((Object)PlatformUI.MIRTH_FRAME), "Uninstalling this extension will remove all plugins and/or connectors\nin the following extension folder: " + packageName)) {
                    try {
                        Frame.this.mirthClient.uninstallExtension(packageName);
                    }
                    catch (ClientException e) {
                        this.success = false;
                        SwingUtilities.invokeLater(() -> Frame.this.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e));
                    }
                }
                return null;
            }

            @Override
            public void done() {
                if (this.success) {
                    Frame.this.extensionsPanel.setRestartRequired(true);
                }
                Frame.this.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public boolean installExtension(File file) {
        try {
            if (!file.exists()) {
                this.alertError((Component)((Object)this), "Invalid extension file.");
                return false;
            }
            this.mirthClient.installExtension(file);
        }
        catch (ClientException e) {
            if (e.getCause() != null && e.getCause() instanceof VersionMismatchException) {
                this.alertError((Component)((Object)this), e.getCause().getMessage());
            } else {
                this.alertThrowable((Component)((Object)this), (Throwable)e, "Unable to install extension: " + e.getMessage());
            }
            return false;
        }
        return true;
    }

    public boolean exportChannelOnError() {
        if (this.isSaveEnabled()) {
            int option = JOptionPane.showConfirmDialog((Component)((Object)this), "Would you like to save the channel changes locally to your computer?");
            if (option == 0) {
                if (!this.channelEditPanel.saveChanges()) {
                    return false;
                }
                boolean enabled = this.isSaveEnabled();
                this.setSaveEnabled(false);
                if (!this.doExportChannel()) {
                    this.setSaveEnabled(enabled);
                    return false;
                }
            } else {
                if (option == 2 || option == -1) {
                    return false;
                }
                this.setSaveEnabled(false);
            }
        }
        return true;
    }

    public void setCanSave(boolean canSave) {
        this.canSave = canSave;
    }

    public void doContextSensitiveSave() {
        if (this.canSave) {
            if (this.currentContentPage == this.channelPanel) {
                this.channelPanel.doContextSensitiveSave();
            } else if (this.currentContentPage == this.channelEditPanel) {
                this.doSaveChannel();
            } else if (this.currentContentPage == this.channelEditPanel.filterPane) {
                this.doSaveChannel();
            } else if (this.currentContentPage == this.channelEditPanel.transformerPane) {
                this.doSaveChannel();
            } else if (this.currentContentPage == this.globalScriptsPanel) {
                this.doSaveGlobalScripts();
            } else if (this.currentContentPage == this.codeTemplatePanel) {
                this.codeTemplatePanel.doContextSensitiveSave();
            } else if (this.currentContentPage == this.settingsPane) {
                this.settingsPane.getCurrentSettingsPanel().doSave();
            } else if (this.currentContentPage == this.alertEditPanel) {
                this.doSaveAlerts();
            }
        }
    }

    public void doFind(JEditTextArea text) {
        Window owner = this.getWindowForComponent(text);
        FindRplDialog find2 = owner instanceof java.awt.Frame ? new FindRplDialog((java.awt.Frame)owner, true, text) : new FindRplDialog((Dialog)owner, true, text);
        find2.setVisible(true);
    }

    public void doHelp() {
        BareBonesBrowserLaunch.openURL(UIConstants.HELP_URL_LOCATION);
    }

    public void goToNotifications() {
    }

    public Map<String, PluginMetaData> getPluginMetaData() {
        return this.loadedPlugins;
    }

    public Map<String, ConnectorMetaData> getConnectorMetaData() {
        return this.loadedConnectors;
    }

    public String getSelectedChannelIdFromDashboard() {
        return this.dashboardPanel.getSelectedStatuses().get(0).getChannelId();
    }

    public List<Integer> getSelectedMetaDataIdsFromDashboard(String channelId) {
        List<DashboardStatus> selectedStatuses = this.dashboardPanel.getSelectedStatuses();
        ArrayList<Integer> metaDataIds = new ArrayList<Integer>();
        if (selectedStatuses.size() == 0) {
            return metaDataIds;
        }
        for (DashboardStatus status : selectedStatuses) {
            Integer metaDataId;
            if (status.getChannelId() != channelId || (metaDataId = status.getMetaDataId()) == null) continue;
            metaDataIds.add(metaDataId);
        }
        return metaDataIds;
    }

    public void retrieveUsers() throws ClientException {
        this.users = this.mirthClient.getAllUsers();
    }

    public synchronized void updateAcceleratorKeyPressed(InputEvent e) {
        this.acceleratorKeyPressed = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 || (e.getModifiers() & 2) > 0 || (e.getModifiers() & 8) > 0;
    }

    public synchronized boolean isAcceleratorKeyPressed() {
        return this.acceleratorKeyPressed;
    }

    public boolean checkChannelName(String name, String id) {
        if (name.equals("")) {
            this.alertWarning((Component)((Object)this), "Channel name cannot be empty.");
            return false;
        }
        if (name.length() > 40) {
            this.alertWarning((Component)((Object)this), "Channel name cannot be longer than 40 characters.");
            return false;
        }
        Pattern alphaNumericPattern = Pattern.compile("^[a-zA-Z_0-9\\-\\s]*$");
        Matcher matcher = alphaNumericPattern.matcher(name);
        if (!matcher.find()) {
            this.alertWarning((Component)((Object)this), "Channel name cannot have special characters besides hyphen, underscore, and space.");
            return false;
        }
        for (ChannelStatus channelStatus : this.channelPanel.getCachedChannelStatuses().values()) {
            if (!channelStatus.getChannel().getName().equalsIgnoreCase(name) || channelStatus.getChannel().getId().equals(id)) continue;
            this.alertWarning((Component)((Object)this), "Channel \"" + name + "\" already exists.");
            return false;
        }
        return true;
    }

    public SettingsPanelTags getTagsPanel() {
        if (this.settingsPane != null) {
            return (SettingsPanelTags)this.settingsPane.getSettingsPanel("Tags");
        }
        return null;
    }

    public Set<ChannelTag> getCachedChannelTags() {
        SettingsPanelTags tagsPanel = this.getTagsPanel();
        if (tagsPanel != null) {
            return tagsPanel.getCachedChannelTags();
        }
        return new HashSet<ChannelTag>();
    }

    public boolean promptObjectMigration(String content, String objectName) {
        String version = null;
        try {
            version = MigrationUtil.normalizeVersion((String)MigrationUtil.getSerializedObjectVersion((String)content), (int)3);
        }
        catch (Exception e) {
            this.logger.error("Failed to read version information", (Throwable)e);
        }
        StringBuilder message = new StringBuilder();
        if (version == null) {
            message.append("The " + objectName + " being imported is from an older or unknown version of BridgeLink.\n");
        } else {
            int comparison = MigrationUtil.compareVersions((String)version, (String)PlatformUI.SERVER_VERSION);
            if (comparison == 0) {
                return true;
            }
            if (comparison > 0) {
                this.alertInformation((Component)((Object)this), "The " + objectName + " being imported originated from BridgeLink version " + version + ".\nYou are using BridgeLink version " + PlatformUI.SERVER_VERSION + ".\nThe " + objectName + " cannot be imported, because it originated from a newer version of BridgeLink.");
                return false;
            }
            if (comparison < 0) {
                message.append("The " + objectName + " being imported originated from BridgeLink version " + version + ".\n");
            }
        }
        message.append("You are using BridgeLink version " + PlatformUI.SERVER_VERSION + ".\nWould you like to automatically convert the " + objectName + " to the " + PlatformUI.SERVER_VERSION + " format?");
        return 0 == JOptionPane.showConfirmDialog((Component)((Object)this), message.toString(), "Select an Option", 0);
    }

    public void removeInvalidItems(List<?> list, Class<?> expectedClass) {
        if (list == null) {
            return;
        }
        int originalSize = list.size();
        for (int i = 0; i < list.size(); ++i) {
            if (expectedClass.isInstance(list.get(i))) continue;
            list.remove(i--);
        }
        if (list.size() < originalSize) {
            if (list.size() == 0) {
                this.alertError((Component)((Object)this), "The imported object(s) are not of the expected class: " + expectedClass.getSimpleName());
            } else {
                this.alertError((Component)((Object)this), "One or more imported objects were skipped, because they are not of the expected class: " + expectedClass.getSimpleName());
            }
        }
    }

    public List<ResourceProperties> getResources() {
        if (this.settingsPane == null) {
            this.settingsPane = new SettingsPane();
        }
        List<ResourceProperties> resourceProperties = null;
        SettingsPanelResources resourcesPanel = (SettingsPanelResources)this.settingsPane.getSettingsPanel("Resources");
        if (resourcesPanel != null && (resourceProperties = resourcesPanel.getCachedResources()) == null) {
            resourcesPanel.refresh();
            resourceProperties = resourcesPanel.getCachedResources();
        }
        return resourceProperties;
    }

    public void updateResourceNames(Channel channel) {
        this.updateResourceNames(channel, this.getResources());
    }

    public void updateResourceNames(Channel channel, List<ResourceProperties> resourceProperties) {
        if (!(channel instanceof InvalidChannel)) {
            this.updateResourceNames(channel.getProperties().getResourceIds(), resourceProperties);
            this.updateResourceNames(channel.getSourceConnector(), resourceProperties);
            for (Connector destinationConnector : channel.getDestinationConnectors()) {
                this.updateResourceNames(destinationConnector, resourceProperties);
            }
        }
    }

    public void updateResourceNames(Connector connector) {
        this.updateResourceNames(connector, this.getResources());
    }

    private void updateResourceNames(Connector connector, List<ResourceProperties> resourceProperties) {
        if (connector.getProperties() instanceof SourceConnectorPropertiesInterface) {
            this.updateResourceNames(((SourceConnectorPropertiesInterface)connector.getProperties()).getSourceConnectorProperties().getResourceIds(), resourceProperties);
        } else {
            this.updateResourceNames(((DestinationConnectorPropertiesInterface)connector.getProperties()).getDestinationConnectorProperties().getResourceIds(), resourceProperties);
        }
    }

    private void updateResourceNames(Map<String, String> resourceIds, List<ResourceProperties> resourceProperties) {
        if (resourceProperties != null) {
            HashSet<String> invalidIds = new HashSet<String>(resourceIds.keySet());
            for (ResourceProperties resource : resourceProperties) {
                if (!resourceIds.containsKey(resource.getId())) continue;
                resourceIds.put(resource.getId(), resource.getName());
                invalidIds.remove(resource.getId());
            }
            for (String invalidId : invalidIds) {
                String resourceName = resourceIds.get(invalidId);
                if (!StringUtils.isNotBlank((CharSequence)resourceName)) continue;
                for (ResourceProperties resource : resourceProperties) {
                    if (!resource.getName().equals(resourceName) || resourceIds.containsKey(resource.getId())) continue;
                    resourceIds.put(resource.getId(), resourceName);
                    resourceIds.remove(invalidId);
                }
            }
        }
    }

    public void updatePadlockWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StringUtils.isBlank((CharSequence)message)) {
                    Frame.this.padlockWarning.setText("     ");
                    Frame.this.updateBackgroundColor(Frame.this.getCurrentUser((Component)((Object)PlatformUI.MIRTH_FRAME)));
                } else {
                    Frame.this.padlockWarning.setText(message);
                    Color backgroundColor = PlatformUI.BOLD_RED_BACKGROUND_COLOR;
                    Frame.this.setupBackgroundPainters(backgroundColor);
                    Frame.this.padlockWarning.repaint();
                }
            }
        });
    }

    public String getPadlockWarning() {
        return this.padlockWarning.getText();
    }

    public void updateBackgroundColor(User currentUser) {
        Color backgroundColor = PlatformUI.DEFAULT_BACKGROUND_COLOR;
        try {
            Color backgroundColorPreference;
            String backgroundColorStr;
            if (currentUser != null && StringUtils.isNotBlank((CharSequence)(backgroundColorStr = this.mirthClient.getUserPreference(currentUser.getId(), "backgroundColor"))) && (backgroundColorPreference = (Color)ObjectXMLSerializer.getInstance().deserialize(backgroundColorStr, Color.class)) != null) {
                backgroundColor = backgroundColorPreference;
            }
        }
        catch (Exception e) {
            this.alertThrowable((Component)((Object)this), e);
        }
        this.setupBackgroundPainters(backgroundColor);
    }

    class InactivityListener
    implements ActionListener,
    AWTEventListener {
        public static final long KEY_EVENTS = 8L;
        public static final long MOUSE_EVENTS = 48L;
        public static final long USER_EVENTS = 56L;
        private Window window;
        private Action action;
        private int interval;
        private long eventMask;
        private Timer timer = new Timer(0, this);

        public InactivityListener(Window window, Action action) {
            this(window, action, 1);
        }

        public InactivityListener(Window window, Action action, int interval) {
            this(window, action, interval, 56L);
        }

        public InactivityListener(Window window, Action action, int minutes, long eventMask) {
            this.window = window;
            this.setAction(action);
            this.setInterval(minutes);
            this.setEventMask(eventMask);
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public void setInterval(int minutes) {
            this.setIntervalInMillis(minutes * 60000);
        }

        public void setIntervalInMillis(int interval) {
            this.interval = interval;
            this.timer.setInitialDelay(interval);
        }

        public void setEventMask(long eventMask) {
            this.eventMask = eventMask;
        }

        public void start() {
            this.timer.setInitialDelay(this.interval);
            this.timer.setRepeats(false);
            this.timer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, this.eventMask);
        }

        public void stop() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionEvent ae = new ActionEvent(this.window, 1001, "");
            this.action.actionPerformed(ae);
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (this.timer.isRunning()) {
                this.timer.restart();
            }
        }
    }

    public static enum ConflictOption {
        YES,
        YES_APPLY_ALL,
        NO,
        NO_APPLY_ALL;

    }

    public static enum ChannelTask {
        DEPLOY("deploy", "(re)deployed", true),
        UNDEPLOY("undeploy", "undeployed", false),
        START_RESUME("start/resume", "started or resumed", true),
        STOP("stop", "stopped", false),
        PAUSE("pause", "paused", false);

        private String value;
        private String futurePassive;
        private boolean forwardOrder;

        private ChannelTask(String value, String futurePassive, boolean forwardOrder) {
            this.value = value;
            this.futurePassive = futurePassive;
            this.forwardOrder = forwardOrder;
        }

        public String getFuturePassive() {
            return this.futurePassive;
        }

        public boolean isForwardOrder() {
            return this.forwardOrder;
        }

        public String toString() {
            return this.value;
        }
    }
}

