/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.panels.reference.ReferenceListPanel;
import com.mirth.connect.client.ui.reference.Category;
import com.mirth.connect.client.ui.reference.ReferenceListFactory;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.ContextType;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.collections4.CollectionUtils;

public class FunctionList
extends JPanel {
    private LinkedHashMap<String, JPanel> panels;
    private ContextType contextType;
    private boolean enableFilter;
    private JLabel categoryLabel;
    private JTextField filterField;
    private JLabel filterLabel;
    private JComboBox variableReferenceDropDown;
    private JScrollPane variableScrollPane;

    public FunctionList(ContextType contextType) {
        this(contextType, true);
    }

    public FunctionList(ContextType contextType, boolean enableFilter) {
        this.contextType = contextType;
        this.enableFilter = enableFilter;
        this.initComponents();
        this.panels = new LinkedHashMap();
        this.setup();
        this.enableFilter(enableFilter);
    }

    private void enableFilter(boolean enable) {
        this.enableFilter = enable;
        this.filterLabel.setVisible(enable);
        this.filterField.setVisible(enable);
        this.filterField.setEnabled(enable);
    }

    private void setup() {
        ReferenceListFactory factory = ReferenceListFactory.getInstance();
        this.addPanel(new ReferenceListPanel("All", factory.getCodeTemplates(null, this.contextType)), "All");
        for (String category : factory.getCodeTemplateMap().keySet()) {
            List<CodeTemplate> items = factory.getCodeTemplates(category, this.contextType);
            if (!CollectionUtils.isNotEmpty(items)) continue;
            this.addPanel(new ReferenceListPanel(category.toString(), items), category.toString());
        }
        this.updateUserTemplates();
        this.setDefaultDropDownValue();
    }

    public void updateUserTemplates() {
        ReferenceListFactory factory = ReferenceListFactory.getInstance();
        this.addPanel(new ReferenceListPanel("All", factory.getCodeTemplates(null, this.contextType)), "All");
        List<CodeTemplate> codeListItems = factory.getCodeTemplates(Category.USER_CODE.toString(), this.contextType);
        if (codeListItems.size() > 0) {
            this.addPanel(new ReferenceListPanel(Category.USER_CODE.toString(), codeListItems), Category.USER_CODE.toString());
        } else if (this.panels.get(Category.USER_CODE.toString()) != null) {
            this.panels.remove(Category.USER_CODE.toString());
        }
        List<CodeTemplate> functionListItems = factory.getCodeTemplates(Category.USER_FUNCTIONS.toString(), this.contextType);
        if (functionListItems.size() > 0) {
            this.addPanel(new ReferenceListPanel(Category.USER_FUNCTIONS.toString(), functionListItems), Category.USER_FUNCTIONS.toString());
        } else if (this.panels.get(Category.USER_FUNCTIONS.toString()) != null) {
            this.panels.remove(Category.USER_FUNCTIONS.toString());
        }
        this.updateDropDown();
    }

    public void setDefaultDropDownValue() {
        this.variableReferenceDropDownActionPerformed(null);
        this.variableReferenceDropDown.setSelectedItem("All");
    }

    public void addPanel(JPanel panel, String name) {
        this.panels.put(name, panel);
    }

    public void updateDropDown() {
        String[] items = new String[this.panels.keySet().size()];
        int i = 0;
        Iterator<String> iterator = this.panels.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            items[i] = s = iterator.next();
            ++i;
        }
        Object selectedItem = this.variableReferenceDropDown.getSelectedItem();
        this.variableReferenceDropDown.setModel(new DefaultComboBoxModel<String>(items));
        if (selectedItem != null) {
            this.variableReferenceDropDown.setSelectedItem(selectedItem);
        }
    }

    private void refreshTableList() {
        if (this.enableFilter) {
            JPanel panel = this.panels.get(this.variableReferenceDropDown.getSelectedItem());
            if (panel instanceof ReferenceListPanel) {
                ReferenceListPanel refListPanel = (ReferenceListPanel)panel;
                refListPanel.refreshTableList(this.filterField.getText());
            }
            this.variableScrollPane.setViewportView(panel);
        }
    }

    private void initComponents() {
        this.variableReferenceDropDown = new JComboBox();
        this.categoryLabel = new JLabel();
        this.variableScrollPane = new JScrollPane();
        this.filterLabel = new JLabel();
        this.filterField = new JTextField();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.variableReferenceDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunctionList.this.variableReferenceDropDownActionPerformed(evt);
            }
        });
        this.categoryLabel.setText("Category:");
        this.filterLabel.setText("Filter:");
        this.filterField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FunctionList.this.filterFieldKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                FunctionList.this.filterFieldKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                FunctionList.this.filterFieldKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterLabel, GroupLayout.Alignment.TRAILING).addComponent(this.categoryLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.variableReferenceDropDown, 0, 70, Short.MAX_VALUE).addComponent(this.filterField, -1, 70, Short.MAX_VALUE)).addContainerGap()).addComponent(this.variableScrollPane, -1, 143, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryLabel).addComponent(this.variableReferenceDropDown, -2, 22, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.filterField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.variableScrollPane, -1, 115, Short.MAX_VALUE)));
    }

    private void filterFieldKeyPressed(KeyEvent evt) {
        this.refreshTableList();
    }

    private void filterFieldKeyTyped(KeyEvent evt) {
        this.refreshTableList();
    }

    private void filterFieldKeyReleased(KeyEvent evt) {
        this.refreshTableList();
    }

    private void variableReferenceDropDownActionPerformed(ActionEvent evt) {
        this.filterField.setText("");
        this.refreshTableList();
        this.updateUserTemplates();
        this.variableScrollPane.setViewportView(this.panels.get(this.variableReferenceDropDown.getSelectedItem()));
    }
}

