/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ChannelDependenciesDialog;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.MirthTriStateCheckBox;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.LibraryProperties;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.plugins.LibraryClientPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class LibraryResourcesPanel
extends JPanel
implements ListSelectionListener,
TreeSelectionListener {
    private static final int SELECTED_COLUMN = 0;
    private static final int PROPERTIES_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private ChannelDependenciesDialog parent;
    private Map<Integer, Map<String, String>> selectedResourceIds;
    private MirthTreeTable treeTable;
    private JScrollPane treeTableScrollPane;
    private MirthTable resourceTable;
    private JScrollPane resourceTableScrollPane;

    public LibraryResourcesPanel(ChannelDependenciesDialog parent, Channel channel) {
        this.parent = parent;
        this.selectedResourceIds = new HashMap<Integer, Map<String, String>>();
        LinkedHashMap channelResourceIds = channel.getProperties().getResourceIds();
        if (channelResourceIds == null) {
            channelResourceIds = new LinkedHashMap();
        }
        this.selectedResourceIds.put(null, new LinkedHashMap(channelResourceIds));
        LinkedHashMap sourceResourceIds = ((SourceConnectorPropertiesInterface)channel.getSourceConnector().getProperties()).getSourceConnectorProperties().getResourceIds();
        if (sourceResourceIds == null) {
            sourceResourceIds = new LinkedHashMap();
        }
        this.selectedResourceIds.put(channel.getSourceConnector().getMetaDataId(), new LinkedHashMap(sourceResourceIds));
        for (Connector destinationConnector : channel.getDestinationConnectors()) {
            LinkedHashMap destinationResourceIds = ((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().getResourceIds();
            if (destinationResourceIds == null) {
                destinationResourceIds = new LinkedHashMap();
            }
            this.selectedResourceIds.put(destinationConnector.getMetaDataId(), new LinkedHashMap(destinationResourceIds));
        }
        this.initComponents(channel);
        this.initLayout();
    }

    public void initialize() {
        final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Loading library resources...");
        SwingWorker<List<LibraryProperties>, Void> worker = new SwingWorker<List<LibraryProperties>, Void>(){

            @Override
            public List<LibraryProperties> doInBackground() throws ClientException {
                List resourceProperties = PlatformUI.MIRTH_FRAME.mirthClient.getResources();
                ArrayList<LibraryProperties> libraryProperties = new ArrayList<LibraryProperties>();
                for (ResourceProperties resource : resourceProperties) {
                    if (!(resource instanceof LibraryProperties)) continue;
                    libraryProperties.add((LibraryProperties)resource);
                }
                return libraryProperties;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                try {
                    ArrayList resources = (ArrayList)this.get();
                    if (resources == null) {
                        resources = new ArrayList();
                    }
                    Object[][] data = new Object[resources.size()][3];
                    int i = 0;
                    for (LibraryProperties properties : resources) {
                        data[i][0] = null;
                        data[i][1] = properties;
                        data[i][2] = properties.getType();
                        ++i;
                        for (Map<String, String> resourceIds : LibraryResourcesPanel.this.selectedResourceIds.values()) {
                            if (!resourceIds.containsKey(properties.getId())) continue;
                            resourceIds.put(properties.getId(), properties.getName());
                        }
                    }
                    ((RefreshTableModel)LibraryResourcesPanel.this.resourceTable.getModel()).refreshDataVector(data);
                    LibraryResourcesPanel.this.treeTable.getSelectionModel().setSelectionInterval(0, 0);
                    LibraryResourcesPanel.this.treeTable.getTreeSelectionModel().setSelectionPath(LibraryResourcesPanel.this.treeTable.getPathForRow(0));
                    LibraryResourcesPanel.this.parent.resourcesReady();
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), t, "Error loading library resources: " + t.toString());
                }
                finally {
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                }
            }
        };
        worker.execute();
    }

    public Map<Integer, Map<String, String>> getSelectedResourceIds() {
        return this.selectedResourceIds;
    }

    private void initComponents(Channel channel) {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        DefaultMutableTreeTableNode channelNode = new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Channel", -1, null));
        DefaultMutableTreeTableNode channelScriptsNode = new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Channel Scripts", null, null));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Deploy Script", null, null, false)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Undeploy Script", null, null, false)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Preprocessor Script", null, null, false)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Postprocessor Script", null, null, false)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Attachment Script", null, null, false)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Batch Script", null, null, false)));
        channelNode.add((MutableTreeTableNode)channelScriptsNode);
        DefaultMutableTreeTableNode sourceConnectorNode = new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Source Connector", 0, channel.getSourceConnector().getTransportName()));
        sourceConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Receiver", channel.getSourceConnector().getMetaDataId(), channel.getSourceConnector().getTransportName(), false)));
        sourceConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Filter / Transformer Script", channel.getSourceConnector().getMetaDataId(), channel.getSourceConnector().getTransportName(), false)));
        channelNode.add((MutableTreeTableNode)sourceConnectorNode);
        for (Connector destinationConnector : channel.getDestinationConnectors()) {
            DefaultMutableTreeTableNode destinationConnectorNode = new DefaultMutableTreeTableNode((Object)new ConnectorEntry(destinationConnector.getName(), destinationConnector.getMetaDataId(), destinationConnector.getTransportName()));
            destinationConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Filter / Transformer Script", destinationConnector.getMetaDataId(), destinationConnector.getTransportName(), false)));
            destinationConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Dispatcher", destinationConnector.getMetaDataId(), destinationConnector.getTransportName(), false)));
            destinationConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ConnectorEntry("Response Transformer Script", destinationConnector.getMetaDataId(), destinationConnector.getTransportName(), false)));
            channelNode.add((MutableTreeTableNode)destinationConnectorNode);
        }
        this.treeTable = new MirthTreeTable();
        SortableTreeTableModel model = new SortableTreeTableModel((TreeTableNode)channelNode);
        model.setColumnIdentifiers(Arrays.asList("Library Context"));
        this.treeTable.setTreeTableModel((TreeTableModel)model);
        this.treeTable.setRootVisible(true);
        this.treeTable.setDragEnabled(false);
        this.treeTable.getSelectionModel().setSelectionMode(0);
        this.treeTable.getTreeSelectionModel().setSelectionMode(1);
        this.treeTable.setRowHeight(20);
        this.treeTable.setFocusable(true);
        this.treeTable.setOpaque(true);
        this.treeTable.getTableHeader().setReorderingAllowed(false);
        this.treeTable.setEditable(false);
        this.treeTable.setSortable(false);
        this.treeTable.addTreeSelectionListener(this);
        this.treeTable.getSelectionModel().addListSelectionListener(this);
        this.treeTable.putClientProperty("JTree.lineStyle", "Horizontal");
        this.treeTable.setShowGrid(true, true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.treeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        String toolTipText = "<html>Select which context(s) to include library resources in.<br/>Libraries can be included everywhere (the Channel node),<br/>on channel-level scripts (the Channel Scripts node), and<br/>on specific source or destination connectors.</html>";
        this.treeTable.setTreeCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                this.setToolTipText("<html>Select which context(s) to include library resources in.<br/>Libraries can be included everywhere (the Channel node),<br/>on channel-level scripts (the Channel Scripts node), and<br/>on specific source or destination connectors.</html>");
                this.setEnabled(((ConnectorEntry)((AbstractMutableTreeTableNode)value).getUserObject()).enabled);
                return this;
            }
        });
        this.treeTable.setOpenIcon(null);
        this.treeTable.setClosedIcon(null);
        this.treeTable.setLeafIcon(null);
        this.treeTable.getColumnExt(0).setToolTipText("<html>Select which context(s) to include library resources in.<br/>Libraries can be included everywhere (the Channel node),<br/>on channel-level scripts (the Channel Scripts node), and<br/>on specific source or destination connectors.</html>");
        this.treeTableScrollPane = new JScrollPane((Component)((Object)this.treeTable));
        this.resourceTable = new MirthTable();
        this.resourceTable.setModel(new RefreshTableModel(new Object[]{"", "Name", "Type"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        });
        this.resourceTable.setDragEnabled(false);
        this.resourceTable.setRowSelectionAllowed(false);
        this.resourceTable.setRowHeight(20);
        this.resourceTable.setFocusable(false);
        this.resourceTable.setOpaque(true);
        this.resourceTable.getTableHeader().setReorderingAllowed(false);
        this.resourceTable.setEditable(true);
        this.resourceTable.setSortable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.resourceTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.resourceTable.getColumnModel().getColumn(0).setMinWidth(20);
        this.resourceTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.resourceTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxRenderer());
        this.resourceTable.getColumnModel().getColumn(0).setCellEditor(new CheckBoxEditor());
        this.resourceTable.getColumnModel().getColumn(2).setMinWidth(75);
        this.resourceTable.getColumnModel().getColumn(2).setMaxWidth(200);
        this.resourceTableScrollPane = new JScrollPane((Component)((Object)this.resourceTable));
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.add((Component)this.treeTableScrollPane, "grow, h 60%");
        this.add((Component)this.resourceTableScrollPane, "newline, grow, h 40%");
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        ((AbstractTableModel)this.resourceTable.getModel()).fireTableDataChanged();
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        MutableTreeTableNode node = (MutableTreeTableNode)evt.getPath().getLastPathComponent();
        ConnectorEntry entry = (ConnectorEntry)node.getUserObject();
        if (node.equals(this.treeTable.getTreeTableModel().getRoot())) {
            this.resourceTable.setEnabled(true);
            for (int row = 0; row < this.resourceTable.getRowCount(); ++row) {
                LibraryProperties properties = (LibraryProperties)this.resourceTable.getModel().getValueAt(row, 1);
                boolean allChildrenChecked = true;
                boolean allChildrenUnchecked = true;
                Enumeration en = node.children();
                while (en.hasMoreElements()) {
                    if (this.selectedResourceIds.get(((ConnectorEntry)((MutableTreeTableNode)en.nextElement()).getUserObject()).metaDataId).containsKey(properties.getId())) {
                        allChildrenUnchecked = false;
                        continue;
                    }
                    allChildrenChecked = false;
                }
                Boolean value = null;
                if (allChildrenChecked) {
                    value = true;
                } else if (allChildrenUnchecked) {
                    value = false;
                }
                this.resourceTable.getModel().setValueAt(value, row, 0);
            }
        } else {
            this.resourceTable.setEnabled(node.getParent().equals(this.treeTable.getTreeTableModel().getRoot()));
            for (int row = 0; row < this.resourceTable.getRowCount(); ++row) {
                LibraryProperties properties = (LibraryProperties)this.resourceTable.getModel().getValueAt(row, 1);
                this.resourceTable.getModel().setValueAt(this.selectedResourceIds.get(entry.metaDataId).containsKey(properties.getId()), row, 0);
            }
        }
    }

    private class ConnectorEntry {
        public String name;
        public Integer metaDataId;
        public String transportName;
        public boolean enabled;

        public ConnectorEntry(String name, Integer metaDataId, String transportName) {
            this(name, metaDataId, transportName, true);
        }

        public ConnectorEntry(String name, Integer metaDataId, String transportName, boolean enabled) {
            this.name = name;
            this.metaDataId = metaDataId;
            this.transportName = transportName;
            this.enabled = enabled;
        }

        public String toString() {
            return this.name + (String)(this.enabled && this.transportName != null ? " (" + this.transportName + ")" : "");
        }
    }

    private class CheckBoxRenderer
    extends JPanel
    implements TableCellRenderer {
        private MirthTriStateCheckBox checkBox;

        public CheckBoxRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = new MirthTriStateCheckBox();
            this.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
                this.checkBox.setBackground(this.getBackground());
            }
            boolean enabled = table.isEnabled();
            if (LibraryResourcesPanel.this.treeTable.getSelectedRow() >= 0) {
                LibraryProperties properties = (LibraryProperties)LibraryResourcesPanel.this.resourceTable.getModel().getValueAt(row, 1);
                LibraryClientPlugin plugin = LoadedExtensions.getInstance().getLibraryClientPlugins().get(properties.getPluginPointName());
                if (plugin != null) {
                    ConnectorEntry entry = (ConnectorEntry)LibraryResourcesPanel.this.treeTable.getValueAt(LibraryResourcesPanel.this.treeTable.getSelectedRow(), 0);
                    if (entry.transportName != null && ArrayUtils.contains((Object[])plugin.getUnselectableTransportNames(), (Object)entry.transportName)) {
                        enabled = false;
                    }
                }
            }
            this.checkBox.setEnabled(enabled);
            this.checkBox.setState(value == null ? 2 : ((Boolean)value != false ? 0 : 1));
            return this;
        }
    }

    private class CheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        private MirthTriStateCheckBox checkBox = new MirthTriStateCheckBox();

        public CheckBoxEditor() {
            this.checkBox.addActionListener(this);
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (LibraryResourcesPanel.this.treeTable.getSelectedRow() >= 0 && evt instanceof MouseEvent) {
                LibraryProperties properties = (LibraryProperties)LibraryResourcesPanel.this.resourceTable.getModel().getValueAt(LibraryResourcesPanel.this.resourceTable.rowAtPoint(((MouseEvent)evt).getPoint()), 1);
                LibraryClientPlugin plugin = LoadedExtensions.getInstance().getLibraryClientPlugins().get(properties.getPluginPointName());
                if (plugin != null) {
                    ConnectorEntry entry = (ConnectorEntry)LibraryResourcesPanel.this.treeTable.getValueAt(LibraryResourcesPanel.this.treeTable.getSelectedRow(), 0);
                    if (entry.transportName != null && ArrayUtils.contains((Object[])plugin.getUnselectableTransportNames(), (Object)entry.transportName)) {
                        return false;
                    }
                }
            }
            return super.isCellEditable(evt);
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkBox.getState() == 2 ? null : Boolean.valueOf(this.checkBox.getState() == 0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
                this.panel.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
                this.checkBox.setBackground(this.panel.getBackground());
            }
            this.checkBox.setState(value == null ? 2 : ((Boolean)value != false ? 0 : 1));
            return this.panel;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryProperties props;
            MutableTreeTableNode node = (MutableTreeTableNode)LibraryResourcesPanel.this.treeTable.getTreeSelectionModel().getSelectionPath().getLastPathComponent();
            ConnectorEntry entry = (ConnectorEntry)node.getUserObject();
            LibraryProperties properties = (LibraryProperties)LibraryResourcesPanel.this.resourceTable.getModel().getValueAt(LibraryResourcesPanel.this.resourceTable.getEditingRow(), 1);
            LibraryClientPlugin plugin = LoadedExtensions.getInstance().getLibraryClientPlugins().get(properties.getPluginPointName());
            boolean selected = ((JCheckBox)evt.getSource()).isSelected();
            if (node.equals(LibraryResourcesPanel.this.treeTable.getTreeTableModel().getRoot())) {
                Enumeration en = node.children();
                while (en.hasMoreElements()) {
                    ConnectorEntry child = (ConnectorEntry)((MutableTreeTableNode)en.nextElement()).getUserObject();
                    if (plugin != null && child.transportName != null && ArrayUtils.contains((Object[])plugin.getUnselectableTransportNames(), (Object)child.transportName)) continue;
                    if (selected) {
                        LibraryResourcesPanel.this.selectedResourceIds.get(child.metaDataId).put(properties.getId(), properties.getName());
                        continue;
                    }
                    LibraryResourcesPanel.this.selectedResourceIds.get(child.metaDataId).remove(properties.getId());
                }
            } else if (selected) {
                LibraryResourcesPanel.this.selectedResourceIds.get(entry.metaDataId).put(properties.getId(), properties.getName());
            } else {
                LibraryResourcesPanel.this.selectedResourceIds.get(entry.metaDataId).remove(properties.getId());
            }
            if (plugin != null && plugin.singleSelectionOnly()) {
                for (int row = 0; row < LibraryResourcesPanel.this.resourceTable.getRowCount(); ++row) {
                    props = (LibraryProperties)LibraryResourcesPanel.this.resourceTable.getModel().getValueAt(row, 1);
                    if (row == LibraryResourcesPanel.this.resourceTable.getEditingRow() || !props.getType().equals(properties.getType())) continue;
                    if (node.equals(LibraryResourcesPanel.this.treeTable.getTreeTableModel().getRoot())) {
                        Enumeration en = node.children();
                        while (en.hasMoreElements()) {
                            ConnectorEntry child = (ConnectorEntry)((MutableTreeTableNode)en.nextElement()).getUserObject();
                            if (child.transportName != null && ArrayUtils.contains((Object[])plugin.getUnselectableTransportNames(), (Object)child.transportName)) continue;
                            LibraryResourcesPanel.this.selectedResourceIds.get(child.metaDataId).remove(props.getId());
                        }
                        continue;
                    }
                    LibraryResourcesPanel.this.selectedResourceIds.get(entry.metaDataId).remove(props.getId());
                }
            }
            for (int row = 0; row < LibraryResourcesPanel.this.resourceTable.getRowCount(); ++row) {
                Boolean newValue;
                props = (LibraryProperties)LibraryResourcesPanel.this.resourceTable.getModel().getValueAt(row, 1);
                if (node.equals(LibraryResourcesPanel.this.treeTable.getTreeTableModel().getRoot())) {
                    boolean allChecked = true;
                    boolean allUnchecked = true;
                    Enumeration en = node.children();
                    while (en.hasMoreElements()) {
                        if (LibraryResourcesPanel.this.selectedResourceIds.get(((ConnectorEntry)((MutableTreeTableNode)en.nextElement()).getUserObject()).metaDataId).containsKey(props.getId())) {
                            allUnchecked = false;
                            continue;
                        }
                        allChecked = false;
                    }
                    newValue = allChecked ? Boolean.valueOf(true) : (allUnchecked ? Boolean.valueOf(false) : null);
                } else {
                    newValue = LibraryResourcesPanel.this.selectedResourceIds.get(entry.metaDataId).containsKey(props.getId());
                }
                LibraryResourcesPanel.this.resourceTable.getModel().setValueAt(newValue, row, 0);
            }
            ((AbstractTableModel)LibraryResourcesPanel.this.resourceTable.getModel()).fireTableDataChanged();
            this.cancelCellEditing();
        }
    }
}

