/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.api.InvocationHandlerRecorder;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.reference.ReferenceListFactory;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.plugins.AttachmentViewer;
import com.mirth.connect.plugins.ChannelColumnPlugin;
import com.mirth.connect.plugins.ChannelPanelPlugin;
import com.mirth.connect.plugins.ChannelTabPlugin;
import com.mirth.connect.plugins.ChannelWizardPlugin;
import com.mirth.connect.plugins.ClientPlugin;
import com.mirth.connect.plugins.CodeTemplatePlugin;
import com.mirth.connect.plugins.CodeTemplateTypePlugin;
import com.mirth.connect.plugins.ConnectorPropertiesPlugin;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import com.mirth.connect.plugins.DashboardTabPlugin;
import com.mirth.connect.plugins.DashboardTablePlugin;
import com.mirth.connect.plugins.DataTypeClientPlugin;
import com.mirth.connect.plugins.FilterRulePlugin;
import com.mirth.connect.plugins.LibraryClientPlugin;
import com.mirth.connect.plugins.ResourceClientPlugin;
import com.mirth.connect.plugins.SettingsPanelPlugin;
import com.mirth.connect.plugins.TaskPlugin;
import com.mirth.connect.plugins.TransformerStepPlugin;
import com.mirth.connect.plugins.TransmissionModePlugin;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadedExtensions {
    private Map<String, String> extensionVersions = new HashMap<String, String>();
    private List<ClientPlugin> clientPlugins = new ArrayList<ClientPlugin>();
    private Set<String> userutilPackages = new HashSet<String>();
    private Map<String, SettingsPanelPlugin> settingsPanelPlugins = new LinkedHashMap<String, SettingsPanelPlugin>();
    private Map<String, ChannelPanelPlugin> channelPanelPlugins = new LinkedHashMap<String, ChannelPanelPlugin>();
    private Map<String, DashboardTabPlugin> dashboardTabPlugins = new LinkedHashMap<String, DashboardTabPlugin>();
    private Map<String, DashboardTablePlugin> dashboardTablePlugins = new LinkedHashMap<String, DashboardTablePlugin>();
    private Map<String, ChannelWizardPlugin> channelWizardPlugins = new LinkedHashMap<String, ChannelWizardPlugin>();
    private Map<String, ChannelColumnPlugin> channelColumnPlugins = new LinkedHashMap<String, ChannelColumnPlugin>();
    private Map<String, DashboardColumnPlugin> dashboardColumnPlugins = new LinkedHashMap<String, DashboardColumnPlugin>();
    private Map<String, AttachmentViewer> attachmentViewerPlugins = new LinkedHashMap<String, AttachmentViewer>();
    private Map<String, FilterRulePlugin> filterRulePlugins = new LinkedHashMap<String, FilterRulePlugin>();
    private Map<String, TransformerStepPlugin> transformerStepPlugins = new LinkedHashMap<String, TransformerStepPlugin>();
    private Map<String, CodeTemplatePlugin> codeTemplatePlugins = new LinkedHashMap<String, CodeTemplatePlugin>();
    private Map<String, CodeTemplateTypePlugin> codeTemplateTypePlugins = new LinkedHashMap<String, CodeTemplateTypePlugin>();
    private Map<String, DataTypeClientPlugin> dataTypePlugins = new TreeMap<String, DataTypeClientPlugin>();
    private Map<String, TransmissionModePlugin> transmissionModePlugins = new TreeMap<String, TransmissionModePlugin>();
    private Map<String, ResourceClientPlugin> resourceClientPlugins = new LinkedHashMap<String, ResourceClientPlugin>();
    private Map<String, LibraryClientPlugin> libraryClientPlugins = new LinkedHashMap<String, LibraryClientPlugin>();
    private Map<String, ConnectorPropertiesPlugin> connectorPropertiesPlugins = new LinkedHashMap<String, ConnectorPropertiesPlugin>();
    private Map<String, ChannelTabPlugin> channelTabPlugins = new LinkedHashMap<String, ChannelTabPlugin>();
    private Map<String, TaskPlugin> taskPlugins = new LinkedHashMap<String, TaskPlugin>();
    private Map<String, ConnectorSettingsPanel> connectors = new TreeMap<String, ConnectorSettingsPanel>();
    private Map<String, ConnectorSettingsPanel> sourceConnectors = new TreeMap<String, ConnectorSettingsPanel>();
    private Map<String, ConnectorSettingsPanel> destinationConnectors = new TreeMap<String, ConnectorSettingsPanel>();
    private InvocationHandlerRecorder recorder;
    private static LoadedExtensions instance = null;
    private Logger logger = LogManager.getLogger(this.getClass());

    private LoadedExtensions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadedExtensions getInstance() {
        Class<LoadedExtensions> clazz = LoadedExtensions.class;
        synchronized (LoadedExtensions.class) {
            if (instance == null) {
                instance = new LoadedExtensions();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
        CodeTemplatePlugin codeTemplatePlugin;
        Class<?> clazz;
        this.clearExtensionMaps();
        HashMap<String, String> pluginNameMap = new HashMap<String, String>();
        TreeMap<Integer, ArrayList<String>> weightedPlugins = new TreeMap<Integer, ArrayList<String>>();
        for (PluginMetaData pluginMetaData : PlatformUI.MIRTH_FRAME.getPluginMetaData().values()) {
            try {
                if (!PlatformUI.MIRTH_FRAME.mirthClient.isExtensionEnabled(pluginMetaData.getName())) continue;
                this.extensionVersions.put(pluginMetaData.getName(), pluginMetaData.getPluginVersion());
                if (pluginMetaData.getClientClasses() != null) {
                    for (Constructor<?>[] pluginClass : pluginMetaData.getClientClasses()) {
                        String clazzName = pluginClass.getName();
                        int weight = pluginClass.getWeight();
                        pluginNameMap.put(clazzName, pluginMetaData.getName());
                        ArrayList<String> classList = (ArrayList<String>)weightedPlugins.get(weight);
                        if (classList == null) {
                            classList = new ArrayList<String>();
                            weightedPlugins.put(weight, classList);
                        }
                        classList.add(clazzName);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)pluginMetaData.getTemplateClassName())) {
                    clazz = Class.forName(pluginMetaData.getTemplateClassName());
                    for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                        if (constructor.getParameterTypes().length != 1) continue;
                        codeTemplatePlugin = (CodeTemplatePlugin)constructor.newInstance(pluginMetaData.getName());
                        this.addPluginPoints(codeTemplatePlugin);
                        break;
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)pluginMetaData.getUserutilPackages())) continue;
                this.userutilPackages.addAll(pluginMetaData.getUserutilPackages());
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e);
            }
        }
        for (ConnectorMetaData connectorMetaData : PlatformUI.MIRTH_FRAME.getConnectorMetaData().values()) {
            try {
                if (!PlatformUI.MIRTH_FRAME.mirthClient.isExtensionEnabled(connectorMetaData.getName())) continue;
                this.extensionVersions.put(connectorMetaData.getName(), connectorMetaData.getPluginVersion());
                if (StringUtils.isNotEmpty((CharSequence)connectorMetaData.getTemplateClassName())) {
                    clazz = Class.forName(connectorMetaData.getTemplateClassName());
                    for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                        if (constructor.getParameterTypes().length != 1) continue;
                        codeTemplatePlugin = (CodeTemplatePlugin)constructor.newInstance(connectorMetaData.getName());
                        this.addPluginPoints(codeTemplatePlugin);
                        break;
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)connectorMetaData.getUserutilPackages())) continue;
                this.userutilPackages.addAll(connectorMetaData.getUserutilPackages());
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, "Could not load code template plugin: " + connectorMetaData.getTemplateClassName());
            }
        }
        ReferenceListFactory.getInstance().loadPluginReferences();
        for (List list : weightedPlugins.descendingMap().values()) {
            for (String clazzName : list) {
                try {
                    String pluginName = (String)pluginNameMap.get(clazzName);
                    Class<?> clazz2 = Class.forName(clazzName);
                    Constructor<?>[] constructors = clazz2.getDeclaredConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Class<?>[] parameters = constructors[i].getParameterTypes();
                        if (parameters.length != 1) continue;
                        ClientPlugin clientPlugin = (ClientPlugin)constructors[i].newInstance(pluginName);
                        this.addPluginPoints(clientPlugin);
                        i = constructors.length;
                    }
                }
                catch (Exception e) {
                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, "Could not load plugin class: " + clazzName);
                }
            }
        }
        for (ConnectorMetaData connectorMetaData : PlatformUI.MIRTH_FRAME.getConnectorMetaData().values()) {
            try {
                if (!PlatformUI.MIRTH_FRAME.mirthClient.isExtensionEnabled(connectorMetaData.getName())) continue;
                String connectorName = connectorMetaData.getName();
                ConnectorSettingsPanel connectorSettingsPanel = (ConnectorSettingsPanel)Class.forName(connectorMetaData.getClientClassName()).newInstance();
                if (connectorMetaData.getType() == ConnectorMetaData.Type.SOURCE) {
                    this.connectors.put(connectorName, connectorSettingsPanel);
                    this.sourceConnectors.put(connectorName, connectorSettingsPanel);
                    continue;
                }
                if (connectorMetaData.getType() == ConnectorMetaData.Type.DESTINATION) {
                    this.connectors.put(connectorName, connectorSettingsPanel);
                    this.destinationConnectors.put(connectorName, connectorSettingsPanel);
                    continue;
                }
                throw new Exception();
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, "Could not load connector class: " + connectorMetaData.getClientClassName());
            }
        }
        ReferenceListFactory.getInstance().loadReferencesAfterPlugins();
    }

    public void startPlugins() {
        for (ClientPlugin clientPlugin : this.clientPlugins) {
            try {
                clientPlugin.start();
            }
            catch (Exception e) {
                this.logger.error("Could not start plugin: " + clientPlugin.getPluginName());
                PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, "Could not start plugin: " + clientPlugin.getPluginName());
            }
        }
    }

    public void stopPlugins() {
        for (ClientPlugin clientPlugin : this.clientPlugins) {
            clientPlugin.stop();
        }
    }

    public void resetPlugins() {
        for (ClientPlugin clientPlugin : this.clientPlugins) {
            clientPlugin.reset();
        }
    }

    private void addPluginPoints(ClientPlugin plugin) {
        this.clientPlugins.add(plugin);
        if (plugin instanceof SettingsPanelPlugin) {
            this.settingsPanelPlugins.put(plugin.getPluginPointName(), (SettingsPanelPlugin)plugin);
        }
        if (plugin instanceof DashboardTabPlugin) {
            this.dashboardTabPlugins.put(plugin.getPluginPointName(), (DashboardTabPlugin)plugin);
        }
        if (plugin instanceof DashboardTablePlugin) {
            this.dashboardTablePlugins.put(plugin.getPluginPointName(), (DashboardTablePlugin)plugin);
        }
        if (plugin instanceof ChannelPanelPlugin) {
            this.channelPanelPlugins.put(plugin.getPluginPointName(), (ChannelPanelPlugin)plugin);
        }
        if (plugin instanceof ChannelWizardPlugin) {
            this.channelWizardPlugins.put(plugin.getPluginPointName(), (ChannelWizardPlugin)plugin);
        }
        if (plugin instanceof DashboardColumnPlugin) {
            this.dashboardColumnPlugins.put(plugin.getPluginPointName(), (DashboardColumnPlugin)plugin);
        }
        if (plugin instanceof ChannelColumnPlugin) {
            this.channelColumnPlugins.put(plugin.getPluginPointName(), (ChannelColumnPlugin)plugin);
        }
        if (plugin instanceof AttachmentViewer) {
            this.attachmentViewerPlugins.put(plugin.getPluginPointName(), (AttachmentViewer)plugin);
        }
        if (plugin instanceof FilterRulePlugin) {
            this.filterRulePlugins.put(plugin.getPluginPointName(), (FilterRulePlugin)plugin);
        }
        if (plugin instanceof TransformerStepPlugin) {
            this.transformerStepPlugins.put(plugin.getPluginPointName(), (TransformerStepPlugin)plugin);
        }
        if (plugin instanceof CodeTemplatePlugin) {
            this.codeTemplatePlugins.put(plugin.getPluginPointName(), (CodeTemplatePlugin)plugin);
        }
        if (plugin instanceof CodeTemplateTypePlugin) {
            this.codeTemplateTypePlugins.put(plugin.getPluginPointName(), (CodeTemplateTypePlugin)plugin);
        }
        if (plugin instanceof DataTypeClientPlugin) {
            this.dataTypePlugins.put(plugin.getPluginPointName(), (DataTypeClientPlugin)plugin);
        }
        if (plugin instanceof TransmissionModePlugin) {
            this.transmissionModePlugins.put(plugin.getPluginPointName(), (TransmissionModePlugin)plugin);
        }
        if (plugin instanceof ConnectorPropertiesPlugin) {
            this.connectorPropertiesPlugins.put(plugin.getPluginPointName(), (ConnectorPropertiesPlugin)plugin);
        }
        if (plugin instanceof ResourceClientPlugin) {
            this.resourceClientPlugins.put(plugin.getPluginPointName(), (ResourceClientPlugin)plugin);
        }
        if (plugin instanceof LibraryClientPlugin) {
            this.libraryClientPlugins.put(plugin.getPluginPointName(), (LibraryClientPlugin)plugin);
        }
        if (plugin instanceof ChannelTabPlugin) {
            this.channelTabPlugins.put(plugin.getPluginPointName(), (ChannelTabPlugin)plugin);
        }
        if (plugin instanceof TaskPlugin) {
            this.taskPlugins.put(plugin.getPluginPointName(), (TaskPlugin)plugin);
        }
        if (plugin instanceof InvocationHandlerRecorder) {
            this.recorder = (InvocationHandlerRecorder)plugin;
        }
    }

    private void clearExtensionMaps() {
        this.clientPlugins.clear();
        this.userutilPackages.clear();
        this.settingsPanelPlugins.clear();
        this.dashboardTabPlugins.clear();
        this.dashboardTablePlugins.clear();
        this.channelPanelPlugins.clear();
        this.channelWizardPlugins.clear();
        this.dashboardColumnPlugins.clear();
        this.channelColumnPlugins.clear();
        this.attachmentViewerPlugins.clear();
        this.filterRulePlugins.clear();
        this.transformerStepPlugins.clear();
        this.codeTemplatePlugins.clear();
        this.dataTypePlugins.clear();
        this.transmissionModePlugins.clear();
        this.connectorPropertiesPlugins.clear();
        this.resourceClientPlugins.clear();
        this.libraryClientPlugins.clear();
        this.channelTabPlugins.clear();
        this.taskPlugins.clear();
        this.connectors.clear();
        this.sourceConnectors.clear();
        this.destinationConnectors.clear();
    }

    public List<ClientPlugin> getClientPlugins() {
        return this.clientPlugins;
    }

    public Set<String> getUserutilPackages() {
        return this.userutilPackages;
    }

    public Map<String, SettingsPanelPlugin> getSettingsPanelPlugins() {
        return this.settingsPanelPlugins;
    }

    public Map<String, DashboardTabPlugin> getDashboardTabPlugins() {
        return this.dashboardTabPlugins;
    }

    public Map<String, DashboardTablePlugin> getDashboardTablePlugins() {
        return this.dashboardTablePlugins;
    }

    public Map<String, ChannelPanelPlugin> getChannelPanelPlugins() {
        return this.channelPanelPlugins;
    }

    public Map<String, ChannelWizardPlugin> getChannelWizardPlugins() {
        return this.channelWizardPlugins;
    }

    public Map<String, DashboardColumnPlugin> getDashboardColumnPlugins() {
        return this.dashboardColumnPlugins;
    }

    public Map<String, ChannelColumnPlugin> getChannelColumnPlugins() {
        return this.channelColumnPlugins;
    }

    public Map<String, AttachmentViewer> getAttachmentViewerPlugins() {
        return this.attachmentViewerPlugins;
    }

    public Map<String, FilterRulePlugin> getFilterRulePlugins() {
        return this.filterRulePlugins;
    }

    public Map<String, TransformerStepPlugin> getTransformerStepPlugins() {
        return this.transformerStepPlugins;
    }

    public Map<String, CodeTemplatePlugin> getCodeTemplatePlugins() {
        return this.codeTemplatePlugins;
    }

    public Map<String, CodeTemplateTypePlugin> getCodeTemplateTypePlugins() {
        return this.codeTemplateTypePlugins;
    }

    public Map<String, DataTypeClientPlugin> getDataTypePlugins() {
        return this.dataTypePlugins;
    }

    public Map<String, TransmissionModePlugin> getTransmissionModePlugins() {
        return this.transmissionModePlugins;
    }

    public Map<String, ConnectorPropertiesPlugin> getConnectorPropertiesPlugins() {
        return this.connectorPropertiesPlugins;
    }

    public Map<String, ResourceClientPlugin> getResourceClientPlugins() {
        return this.resourceClientPlugins;
    }

    public Map<String, LibraryClientPlugin> getLibraryClientPlugins() {
        return this.libraryClientPlugins;
    }

    public Map<String, ChannelTabPlugin> getChannelTabPlugins() {
        return this.channelTabPlugins;
    }

    public Map<String, TaskPlugin> getTaskPlugins() {
        return this.taskPlugins;
    }

    public InvocationHandlerRecorder getRecorder() {
        return this.recorder;
    }

    public Map<String, ConnectorSettingsPanel> getConnectors() {
        return this.connectors;
    }

    public Map<String, ConnectorSettingsPanel> getSourceConnectors() {
        return this.sourceConnectors;
    }

    public Map<String, ConnectorSettingsPanel> getDestinationConnectors() {
        return this.destinationConnectors;
    }

    public Map<String, String> getExtensionVersions() {
        return this.extensionVersions;
    }
}

