/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ConnectServiceUtil;
import com.mirth.connect.client.core.UnauthorizedException;
import com.mirth.connect.client.core.api.servlets.UserServletInterface;
import com.mirth.connect.client.ui.BareBonesBrowserLaunch;
import com.mirth.connect.client.ui.ChangePasswordDialog;
import com.mirth.connect.client.ui.CustomBannerPanelDialog;
import com.mirth.connect.client.ui.FirstLoginDialog;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthHeadingPanel;
import com.mirth.connect.client.ui.NotificationDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.ExtendedLoginStatus;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.MultiFactorAuthenticationClientPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class LoginPanel
extends JFrame {
    private Client client;
    private static final String ERROR_MESSAGE = "There was an error connecting to the server at the specified address. Please verify that the server is up and running.";
    private static LoginPanel instance = null;
    private JButton closeButton;
    private JScrollPane errorPane;
    private JTextArea errorTextArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel loggingIn;
    private JButton loginButton;
    private JPanel loginMain;
    private JProgressBar loginProgress;
    private JLabel mirthCorpImage;
    private JLabel mirthCorpImage1;
    private MirthHeadingPanel mirthHeadingPanel1;
    private MirthHeadingPanel mirthHeadingPanel2;
    private JPasswordField password;
    private JButton placeholderButton;
    private JTextField serverName;
    private JLabel status;
    private JTextField username;

    private LoginPanel() {
        this.initComponents();
        DisplayUtil.setResizable(this, false);
        this.jLabel2.setForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.jLabel5.setForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.setDefaultCloseOperation(3);
        this.setIconImage(UIConstants.MIRTH_FAVICON.getImage());
        ImageIcon imageIcon = UIConstants.MIRTHCORP_LOGO;
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(175, 30, 4);
        imageIcon = new ImageIcon(newimg);
        this.mirthCorpImage.setIcon(imageIcon);
        this.mirthCorpImage.setText("");
        this.mirthCorpImage.setToolTipText("Innovar Healthcare");
        this.mirthCorpImage.setCursor(new Cursor(12));
        this.mirthCorpImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BareBonesBrowserLaunch.openURL("https://www.innovarhealthcare.com");
            }
        });
        this.mirthCorpImage1.setIcon(imageIcon);
        this.mirthCorpImage1.setText("");
        this.mirthCorpImage1.setToolTipText("Innovar Healthcare");
        this.mirthCorpImage1.setCursor(new Cursor(12));
        this.mirthCorpImage1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BareBonesBrowserLaunch.openURL("https://www.innovarhealthcare.com");
            }
        });
        this.placeholderButton.setVisible(false);
        this.errorTextArea.setBackground(Color.WHITE);
        this.errorTextArea.setDisabledTextColor(Color.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginPanel getInstance() {
        Class<LoginPanel> clazz = LoginPanel.class;
        synchronized (LoginPanel.class) {
            if (instance == null) {
                instance = new LoginPanel();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String mirthServer, String version, String user, String pass) {
        LoginPanel loginPanel = this;
        synchronized (loginPanel) {
            if (this.isVisible()) {
                return;
            }
            PlatformUI.CLIENT_VERSION = version;
            this.setTitle("BridgeLink " + version + " - Login");
            this.setIconImage(UIConstants.MIRTH_FAVICON.getImage());
            this.serverName.setText(mirthServer);
            this.setLocationRelativeTo(null);
            this.setState(0);
            this.errorPane.setVisible(false);
            this.loggingIn.setVisible(false);
            this.loginMain.setVisible(true);
            this.loginProgress.setIndeterminate(false);
            this.setStatus("Logging in...");
            this.username.setText(user);
            this.password.setText(pass);
            this.username.grabFocus();
            this.setVisible(true);
        }
        if (user.length() > 0 && pass.length() > 0) {
            this.loginButtonActionPerformed(null);
        }
    }

    private void initComponents() {
        this.loginMain = new JPanel();
        this.closeButton = new JButton();
        this.loginButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.serverName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.mirthHeadingPanel2 = new MirthHeadingPanel();
        this.jLabel2 = new JLabel();
        this.username = new JTextField();
        this.jLabel6 = new JLabel();
        this.password = new JPasswordField();
        this.mirthCorpImage = new JLabel();
        this.errorPane = new JScrollPane();
        this.errorTextArea = new JTextArea();
        this.loggingIn = new JPanel();
        this.mirthHeadingPanel1 = new MirthHeadingPanel();
        this.jLabel5 = new JLabel();
        this.loginProgress = new JProgressBar();
        this.status = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.mirthCorpImage1 = new JLabel();
        this.placeholderButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("BridgeLink - Login");
        this.setIconImage(UIConstants.MIRTH_FAVICON.getImage());
        this.loginMain.setBackground(new Color(255, 255, 255));
        this.loginMain.setName("");
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.closeButtonActionPerformed(evt);
            }
        });
        this.loginButton.setText("Login");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.loginButtonActionPerformed(evt);
            }
        });
        this.serverName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.serverNameActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Server:");
        this.jLabel3.setText("Username:");
        this.jLabel2.setFont(new Font("Tahoma", 1, 18));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("BridgeLink Login");
        GroupLayout mirthHeadingPanel2Layout = new GroupLayout(this.mirthHeadingPanel2);
        this.mirthHeadingPanel2.setLayout(mirthHeadingPanel2Layout);
        mirthHeadingPanel2Layout.setHorizontalGroup(mirthHeadingPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 358, Short.MAX_VALUE).addContainerGap()));
        mirthHeadingPanel2Layout.setVerticalGroup(mirthHeadingPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 27, Short.MAX_VALUE).addContainerGap()));
        this.username.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.usernameActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Password:");
        this.password.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.passwordActionPerformed(evt);
            }
        });
        this.mirthCorpImage.setText(" ");
        this.errorPane.setBorder(null);
        this.errorPane.setHorizontalScrollBarPolicy(31);
        this.errorPane.setVerticalScrollBarPolicy(21);
        this.errorTextArea.setColumns(20);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setFont(new Font("Tahoma", 0, 11));
        this.errorTextArea.setLineWrap(true);
        this.errorTextArea.setText(ERROR_MESSAGE);
        this.errorTextArea.setWrapStyleWord(true);
        this.errorTextArea.setEnabled(false);
        this.errorPane.setViewportView(this.errorTextArea);
        GroupLayout loginMainLayout = new GroupLayout(this.loginMain);
        this.loginMain.setLayout(loginMainLayout);
        loginMainLayout.setHorizontalGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 358, Short.MAX_VALUE).addContainerGap()).addComponent(this.mirthHeadingPanel2, -1, 378, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, loginMainLayout.createSequentialGroup().addContainerGap().addComponent(this.mirthCorpImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 235, Short.MAX_VALUE).addComponent(this.loginButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, loginMainLayout.createSequentialGroup().addGap(51, 51, 51).addGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.serverName, GroupLayout.Alignment.LEADING, -2, 220, -2).addComponent(this.password, GroupLayout.Alignment.LEADING, -2, 220, -2).addComponent(this.username, GroupLayout.Alignment.LEADING, -2, 220, -2)).addGap(51, 51, 51)).addGroup(GroupLayout.Alignment.TRAILING, loginMainLayout.createSequentialGroup().addContainerGap(57, Short.MAX_VALUE).addComponent(this.errorPane, -2, 264, -2).addGap(57, 57, 57)));
        loginMainLayout.linkSize(0, this.closeButton, this.loginButton);
        loginMainLayout.setVerticalGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, loginMainLayout.createSequentialGroup().addComponent(this.mirthHeadingPanel2, -2, 49, -2).addGap(22, 22, 22).addGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.serverName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.username, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.password, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(loginMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.loginButton).addComponent(this.mirthCorpImage)).addContainerGap()));
        this.loggingIn.setBackground(new Color(255, 255, 255));
        this.jLabel5.setFont(new Font("Tahoma", 1, 18));
        this.jLabel5.setForeground(new Color(255, 255, 255));
        this.jLabel5.setText("BridgeLink Login");
        GroupLayout mirthHeadingPanel1Layout = new GroupLayout(this.mirthHeadingPanel1);
        this.mirthHeadingPanel1.setLayout(mirthHeadingPanel1Layout);
        mirthHeadingPanel1Layout.setHorizontalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5, -2, 326, -2).addContainerGap(42, Short.MAX_VALUE)));
        mirthHeadingPanel1Layout.setVerticalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5, -1, 27, Short.MAX_VALUE).addContainerGap()));
        this.loginProgress.setDoubleBuffered(true);
        this.status.setText("Please wait: Logging in...");
        this.mirthCorpImage1.setText(" ");
        this.placeholderButton.setText("Placeholder");
        GroupLayout loggingInLayout = new GroupLayout(this.loggingIn);
        this.loggingIn.setLayout(loggingInLayout);
        loggingInLayout.setHorizontalGroup(loggingInLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mirthHeadingPanel1, -1, 378, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, loggingInLayout.createSequentialGroup().addContainerGap().addComponent(this.loginProgress, -1, 358, Short.MAX_VALUE).addContainerGap()).addGroup(loggingInLayout.createSequentialGroup().addContainerGap().addComponent(this.status).addContainerGap(247, Short.MAX_VALUE)).addGroup(loggingInLayout.createSequentialGroup().addContainerGap().addComponent(this.mirthCorpImage1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 268, Short.MAX_VALUE).addComponent(this.placeholderButton).addContainerGap()).addGroup(loggingInLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator2, -1, 358, Short.MAX_VALUE).addContainerGap()));
        loggingInLayout.setVerticalGroup(loggingInLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loggingInLayout.createSequentialGroup().addComponent(this.mirthHeadingPanel1, -2, 49, -2).addGap(45, 45, 45).addComponent(this.status).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loginProgress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 82, Short.MAX_VALUE).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(loggingInLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mirthCorpImage1).addComponent(this.placeholderButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginMain, -1, -1, Short.MAX_VALUE).addComponent(this.loggingIn, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginMain, -1, -1, Short.MAX_VALUE).addComponent(this.loggingIn, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void usernameActionPerformed(ActionEvent evt) {
        this.loginButtonActionPerformed(null);
    }

    private void serverNameActionPerformed(ActionEvent evt) {
        this.loginButtonActionPerformed(null);
    }

    private void passwordActionPerformed(ActionEvent evt) {
        this.loginButtonActionPerformed(null);
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        this.errorPane.setVisible(false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                boolean errorOccurred = false;
                try {
                    LoginStatus loginStatus;
                    block14: {
                        String server = LoginPanel.this.serverName.getText();
                        LoginPanel.this.client = new Client(server, PlatformUI.HTTPS_PROTOCOLS, PlatformUI.HTTPS_CIPHER_SUITES);
                        PlatformUI.SERVER_URL = server;
                        loginStatus = null;
                        try {
                            HashMap<String, List<String>> customHeaders = new HashMap<String, List<String>>();
                            customHeaders.put("X-Mirth-Server-Url", Collections.singletonList(PlatformUI.SERVER_URL));
                            loginStatus = ((UserServletInterface)LoginPanel.this.client.getServlet(UserServletInterface.class, null, customHeaders)).login(LoginPanel.this.username.getText(), String.valueOf(LoginPanel.this.password.getPassword()));
                        }
                        catch (ClientException ex) {
                            UnauthorizedException e2;
                            ex.printStackTrace();
                            if (!(ex instanceof UnauthorizedException) || (e2 = (UnauthorizedException)ex).getResponse() == null || !(e2.getResponse() instanceof LoginStatus)) break block14;
                            loginStatus = (LoginStatus)e2.getResponse();
                        }
                    }
                    if (loginStatus != null && (loginStatus.getStatus() == LoginStatus.Status.SUCCESS || loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD)) {
                        if (!this.handleSuccess(loginStatus)) {
                            LoginPanel.getInstance().setVisible(false);
                            LoginPanel.getInstance().initialize(PlatformUI.SERVER_URL, PlatformUI.CLIENT_VERSION, "", "");
                        }
                    } else {
                        ExtendedLoginStatus extendedLoginStatus;
                        errorOccurred = true;
                        if (loginStatus instanceof ExtendedLoginStatus && StringUtils.isNotBlank((CharSequence)(extendedLoginStatus = (ExtendedLoginStatus)loginStatus).getClientPluginClass())) {
                            String updatedUsername = StringUtils.defaultString((String)loginStatus.getUpdatedUsername(), (String)LoginPanel.this.username.getText());
                            MultiFactorAuthenticationClientPlugin plugin = (MultiFactorAuthenticationClientPlugin)Class.forName(extendedLoginStatus.getClientPluginClass()).newInstance();
                            loginStatus = plugin.authenticate(LoginPanel.this, LoginPanel.this.client, updatedUsername, loginStatus);
                            if (loginStatus != null && (loginStatus.getStatus() == LoginStatus.Status.SUCCESS || loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD)) {
                                errorOccurred = false;
                                if (!this.handleSuccess(loginStatus)) {
                                    LoginPanel.getInstance().setVisible(false);
                                    LoginPanel.getInstance().initialize(PlatformUI.SERVER_URL, PlatformUI.CLIENT_VERSION, "", "");
                                }
                            }
                        }
                    }
                    if (errorOccurred) {
                        if (loginStatus != null) {
                            LoginPanel.this.errorTextArea.setText(loginStatus.getMessage());
                        } else {
                            LoginPanel.this.errorTextArea.setText(LoginPanel.ERROR_MESSAGE);
                        }
                    }
                }
                catch (Throwable t) {
                    errorOccurred = true;
                    LoginPanel.this.errorTextArea.setText(LoginPanel.ERROR_MESSAGE);
                    t.printStackTrace();
                }
                if (errorOccurred) {
                    LoginPanel.this.errorPane.setVisible(true);
                    LoginPanel.this.loggingIn.setVisible(false);
                    LoginPanel.this.loginMain.setVisible(true);
                    LoginPanel.this.loginProgress.setIndeterminate(false);
                    LoginPanel.this.password.grabFocus();
                }
                return null;
            }

            private boolean handleSuccess(LoginStatus loginStatus) throws ClientException {
                try {
                    String serverName;
                    String environmentName;
                    PublicServerSettings publicServerSettings = LoginPanel.this.client.getPublicServerSettings();
                    if (publicServerSettings.getLoginNotificationEnabled().booleanValue()) {
                        CustomBannerPanelDialog customBannerPanelDialog = new CustomBannerPanelDialog(LoginPanel.getInstance(), "Login Notification", publicServerSettings.getLoginNotificationMessage());
                        boolean isAccepted = customBannerPanelDialog.isAccepted();
                        if (isAccepted) {
                            LoginPanel.this.client.setUserNotificationAcknowledged(LoginPanel.this.client.getCurrentUser().getId());
                        } else {
                            return false;
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)(environmentName = publicServerSettings.getEnvironmentName()))) {
                        PlatformUI.ENVIRONMENT_NAME = environmentName;
                    }
                    PlatformUI.SERVER_NAME = !StringUtils.isBlank((CharSequence)(serverName = publicServerSettings.getServerName())) ? serverName : null;
                    Color defaultBackgroundColor = publicServerSettings.getDefaultAdministratorBackgroundColor();
                    if (defaultBackgroundColor != null) {
                        PlatformUI.DEFAULT_BACKGROUND_COLOR = defaultBackgroundColor;
                    }
                }
                catch (ClientException e) {
                    PlatformUI.SERVER_NAME = null;
                }
                try {
                    String database = (String)LoginPanel.this.client.getAbout().get("database");
                    PlatformUI.SERVER_DATABASE = !StringUtils.isBlank((CharSequence)database) ? database : null;
                }
                catch (ClientException e) {
                    PlatformUI.SERVER_DATABASE = null;
                }
                try {
                    Map map = LoginPanel.this.client.getProtocolsAndCipherSuites();
                    PlatformUI.SERVER_HTTPS_SUPPORTED_PROTOCOLS = (String[])map.get("supportedProtocols");
                    PlatformUI.SERVER_HTTPS_ENABLED_CLIENT_PROTOCOLS = (String[])map.get("enabledClientProtocols");
                    PlatformUI.SERVER_HTTPS_ENABLED_SERVER_PROTOCOLS = (String[])map.get("enabledServerProtocols");
                    PlatformUI.SERVER_HTTPS_SUPPORTED_CIPHER_SUITES = (String[])map.get("supportedCipherSuites");
                    PlatformUI.SERVER_HTTPS_ENABLED_CIPHER_SUITES = (String[])map.get("enabledCipherSuites");
                }
                catch (ClientException map) {
                    // empty catch block
                }
                PlatformUI.USER_NAME = StringUtils.defaultString((String)loginStatus.getUpdatedUsername(), (String)LoginPanel.this.username.getText());
                LoginPanel.this.setStatus("Authenticated...");
                new Mirth(LoginPanel.this.client);
                LoginPanel.getInstance().setVisible(false);
                User currentUser = PlatformUI.MIRTH_FRAME.getCurrentUser((Component)((Object)PlatformUI.MIRTH_FRAME));
                Properties userPreferences = new Properties();
                HashSet<String> preferenceNames = new HashSet<String>();
                preferenceNames.add("firstlogin");
                preferenceNames.add("checkForNotifications");
                preferenceNames.add("showNotificationPopup");
                preferenceNames.add("archivedNotifications");
                try {
                    String checkForNotifications;
                    userPreferences = LoginPanel.this.client.getUserPreferences(currentUser.getId(), preferenceNames);
                    String firstlogin = userPreferences.getProperty("firstlogin");
                    if (firstlogin == null || BooleanUtils.toBoolean((String)firstlogin)) {
                        FirstLoginDialog firstLoginDialog;
                        Preferences preferences;
                        String systemUserInfo;
                        if (Integer.valueOf(currentUser.getId()) == 1 && (systemUserInfo = (preferences = Preferences.userNodeForPackage(Mirth.class)).get("userLoginInfo", null)) != null) {
                            String[] info = systemUserInfo.split(",", 0);
                            currentUser.setUsername(info[0]);
                            currentUser.setFirstName(info[1]);
                            currentUser.setLastName(info[2]);
                            currentUser.setEmail(info[3]);
                            currentUser.setCountry(info[4]);
                            currentUser.setStateTerritory(info[5]);
                            currentUser.setPhoneNumber(info[6]);
                            currentUser.setOrganization(info[7]);
                            currentUser.setRole(info[8]);
                            currentUser.setIndustry(info[9]);
                            currentUser.setDescription(info[10]);
                        }
                        if (!(firstLoginDialog = new FirstLoginDialog(currentUser)).getResult()) {
                            return false;
                        }
                    } else if (loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD) {
                        new ChangePasswordDialog(currentUser, loginStatus.getMessage());
                    }
                    if ((checkForNotifications = userPreferences.getProperty("checkForNotifications")) == null || BooleanUtils.toBoolean((String)checkForNotifications)) {
                        Set archivedNotifications = new HashSet();
                        String archivedNotificationString = userPreferences.getProperty("archivedNotifications");
                        if (archivedNotificationString != null) {
                            archivedNotifications = (Set)ObjectXMLSerializer.getInstance().deserialize(archivedNotificationString, Set.class);
                        }
                        int unarchivedNotifications = ConnectServiceUtil.getNotificationCount((String)PlatformUI.SERVER_ID, (String)PlatformUI.SERVER_VERSION, LoadedExtensions.getInstance().getExtensionVersions(), archivedNotifications, (String[])PlatformUI.HTTPS_PROTOCOLS, (String[])PlatformUI.HTTPS_CIPHER_SUITES);
                        PlatformUI.MIRTH_FRAME.updateNotificationTaskName(unarchivedNotifications);
                        String showNotificationPopup = userPreferences.getProperty("showNotificationPopup");
                        if ((showNotificationPopup == null || BooleanUtils.toBoolean((String)showNotificationPopup)) && unarchivedNotifications > 0) {
                            new NotificationDialog();
                        }
                    }
                }
                catch (ClientException e) {
                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e);
                }
                PlatformUI.MIRTH_FRAME.sendUsageStatistics();
                return true;
            }

            @Override
            public void done() {
            }
        };
        worker.execute();
        this.loggingIn.setVisible(true);
        this.loginMain.setVisible(false);
        this.loginProgress.setIndeterminate(true);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    public void setStatus(String status) {
        this.status.setText("Please wait: " + status);
    }
}

