/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.PaginatedMessageList;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.panels.export.MessageExportPanel;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.util.MessageExporter;
import com.mirth.connect.util.PaginatedList;
import com.mirth.connect.util.messagewriter.AttachmentSource;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterFactory;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class MessageExportDialog
extends MirthDialog {
    protected Frame parent = PlatformUI.MIRTH_FRAME;
    private String channelId;
    protected List<String> channelIds;
    protected MessageFilter messageFilter;
    protected int pageSize;
    private Encryptor encryptor;
    private PaginatedMessageList messages;
    private boolean isChannelMessagesPanelFirstLoadSearch;
    protected MessageExportPanel messageExportPanel;
    private JButton exportButton;
    private JButton cancelButton;

    public MessageExportDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.setTitle("Export Results");
        this.setPreferredSize(new Dimension(800, 300));
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.initComponents();
        this.initLayout();
        this.pack();
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setChannelIds(List<String> channelIds) {
        this.channelIds = channelIds;
    }

    public void setMessageFilter(MessageFilter messageFilter) {
        this.messageFilter = messageFilter;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setMessages(PaginatedMessageList messages) {
        if (messages != null) {
            PaginatedMessageList clonedMessages = (PaginatedMessageList)messages.clone();
            clonedMessages.setIncludeContent(true);
            this.messages = clonedMessages;
        }
    }

    public void setIsChannelMessagesPanelFirstLoadSearch(boolean isChannelMessagesPanelFirstLoadSearch) {
        this.isChannelMessagesPanelFirstLoadSearch = isChannelMessagesPanelFirstLoadSearch;
    }

    private void initComponents() {
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.messageExportPanel = new MessageExportPanel(Frame.userPreferences, false, true);
        this.messageExportPanel.setExportLocal(true);
        this.messageExportPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportDialog.this.export();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportDialog.this.setVisible(false);
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, wrap", "[]", "[fill][]"));
        this.add((Component)this.messageExportPanel, "grow,push");
        this.add((Component)new JSeparator(), "grow, gaptop 4, span");
        this.add((Component)this.exportButton, "split 2, gaptop 4, alignx right, width 60");
        this.add((Component)this.cancelButton, "width 60");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        String errorMessage = this.messageExportPanel.validate(true);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            this.parent.alertError(this, errorMessage);
            return;
        }
        int exportCount = 0;
        MessageWriterOptions writerOptions = this.messageExportPanel.getMessageWriterOptions();
        if (StringUtils.isBlank((CharSequence)writerOptions.getRootFolder())) {
            this.parent.alertError((Component)((Object)this.parent), "Please enter a valid root path to store exported files.");
            this.setVisible(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LinkedHashMap<String, String> auditMessageAttributesMap;
            if (!this.isChannelMessagesPanelFirstLoadSearch) {
                auditMessageAttributesMap = new LinkedHashMap<String, String>();
                this.parent.mirthClient.auditExportMessages(auditMessageAttributesMap);
                if (this.messageExportPanel.isExportLocal()) {
                    PaginatedMessageList messageList = this.messages;
                    writerOptions.setBaseFolder(SystemUtils.getUserHome().getAbsolutePath());
                    MessageWriter messageWriter = MessageWriterFactory.getInstance().getMessageWriter(writerOptions, this.encryptor);
                    AttachmentSource attachmentSource = null;
                    if (writerOptions.includeAttachments()) {
                        attachmentSource = new AttachmentSource(){

                            public List<Attachment> getMessageAttachments(Message message) throws ClientException {
                                return PlatformUI.MIRTH_FRAME.mirthClient.getAttachmentsByMessageId(message.getChannelId(), message.getMessageId());
                            }
                        };
                    }
                    try {
                        exportCount = new MessageExporter().exportMessages((PaginatedList)messageList, messageWriter, attachmentSource, writerOptions);
                        messageWriter.finishWrite();
                    }
                    finally {
                        messageWriter.close();
                    }
                } else {
                    exportCount = this.exportToServer(writerOptions);
                }
            }
            this.setVisible(false);
            this.setCursor(Cursor.getDefaultCursor());
            if (this.isChannelMessagesPanelFirstLoadSearch) {
                this.parent.alertInformation((Component)((Object)this.parent), "There are no messages to export. Please perform a search before exporting.");
            } else if (exportCount == 0) {
                this.parent.alertInformation((Component)((Object)this.parent), "There are no messages to export.");
            } else {
                auditMessageAttributesMap = new LinkedHashMap();
                auditMessageAttributesMap.put("rootPath", writerOptions.getRootFolder());
                auditMessageAttributesMap.put("filePattern", writerOptions.getFilePattern());
                auditMessageAttributesMap.put("exportCount", String.valueOf(exportCount));
                auditMessageAttributesMap.put("contentType", writerOptions.getContentType() != null ? writerOptions.getContentType().toString() : "");
                auditMessageAttributesMap.put("encrypted", String.valueOf(writerOptions.isEncrypt()));
                auditMessageAttributesMap.put("includeAttachments", String.valueOf(writerOptions.includeAttachments()));
                auditMessageAttributesMap.put("compressionFormat", writerOptions.getArchiveFormat() != null ? this.getArchiveExtension(writerOptions.getArchiveFormat(), writerOptions.getCompressFormat()) : "");
                auditMessageAttributesMap.put("passwordProtected", String.valueOf(writerOptions.isPasswordEnabled()));
                this.parent.mirthClient.auditExportMessagesSuccess(auditMessageAttributesMap);
                this.parent.alertInformation((Component)((Object)this.parent), exportCount + " message" + (exportCount == 1 ? " has" : "s have") + " been successfully exported to: " + writerOptions.getRootFolder());
            }
        }
        catch (Exception e) {
            this.setCursor(Cursor.getDefaultCursor());
            Throwable cause = e.getCause() == null ? e : e.getCause();
            this.parent.alertThrowable((Component)((Object)this.parent), cause);
        }
    }

    protected int exportToServer(MessageWriterOptions writerOptions) throws ClientException {
        writerOptions.setIncludeAttachments(this.messageExportPanel.isIncludeAttachments());
        return this.parent.mirthClient.exportMessagesServer(this.channelId, this.messageFilter, this.pageSize, writerOptions);
    }

    private String getArchiveExtension(String archiver, String compressor) {
        if (compressor == null) {
            return archiver;
        }
        if (compressor.equals("bzip2")) {
            compressor = "bz2";
        }
        return archiver + "." + compressor;
    }
}

