/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AboutMirth;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoginPanel;
import com.mirth.connect.client.ui.MirthTheme;
import com.mirth.connect.client.ui.OSXAdapter;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthTextArea;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTextPane;
import java.awt.Color;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;

public class Mirth {
    private static Preferences userPreferences;

    public Mirth(Client mirthClient) throws ClientException {
        int height;
        int width;
        boolean maximized;
        PlatformUI.MIRTH_FRAME = new Frame();
        UIManager.put("Tree.leafIcon", UIConstants.LEAF_ICON);
        UIManager.put("Tree.openIcon", UIConstants.OPEN_ICON);
        UIManager.put("Tree.closedIcon", UIConstants.CLOSED_ICON);
        userPreferences = Preferences.userNodeForPackage(Mirth.class);
        LoginPanel.getInstance().setStatus("Loading components...");
        PlatformUI.MIRTH_FRAME.setupFrame(mirthClient);
        if (SystemUtils.IS_OS_MAC) {
            maximized = userPreferences.get("width", null) == null || userPreferences.get("height", null) == null || userPreferences.getInt("maximizedState", 6) == 6;
            width = userPreferences.getInt("width", 950);
            height = userPreferences.getInt("height", 950);
        } else {
            boolean bl = maximized = userPreferences.getInt("maximizedState", 6) == 6;
            if (maximized) {
                width = 950;
                height = 650;
            } else {
                width = userPreferences.getInt("width", 950);
                height = userPreferences.getInt("height", 650);
            }
        }
        PlatformUI.MIRTH_FRAME.setSize(width, height);
        PlatformUI.MIRTH_FRAME.setLocationRelativeTo(null);
        if (maximized) {
            PlatformUI.MIRTH_FRAME.setExtendedState(6);
        }
        PlatformUI.MIRTH_FRAME.setVisible(true);
    }

    public static void aboutMac() {
        new AboutMirth();
    }

    public static boolean quitMac() {
        return LoginPanel.getInstance().isVisible() || PlatformUI.MIRTH_FRAME != null && PlatformUI.MIRTH_FRAME.logout(true);
    }

    private static void createAlternateKeyBindings() {
        int acceleratorKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, acceleratorKey), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, acceleratorKey), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(88, acceleratorKey), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, acceleratorKey), "select-all"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, acceleratorKey), "delete-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(8, acceleratorKey), "delete-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, acceleratorKey), "caret-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(227, acceleratorKey), "caret-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, acceleratorKey), "caret-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(226, acceleratorKey), "caret-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, acceleratorKey | 1), "selection-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(227, acceleratorKey | 1), "selection-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, acceleratorKey | 1), "selection-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(226, acceleratorKey | 1), "selection-previous-word")};
        Mirth.keyMapBindings(new JTextField(), defaultBindings);
        Mirth.keyMapBindings(new JPasswordField(), defaultBindings);
        Mirth.keyMapBindings(new JTextPane(), defaultBindings);
        Mirth.keyMapBindings(new JTextArea(), defaultBindings);
        Mirth.keyMapBindings(new MirthTextField(), defaultBindings);
        Mirth.keyMapBindings(new MirthPasswordField(), defaultBindings);
        Mirth.keyMapBindings(new MirthTextPane(), defaultBindings);
        Mirth.keyMapBindings(new MirthTextArea(), defaultBindings);
    }

    private static void keyMapBindings(JTextComponent comp, JTextComponent.KeyBinding[] bindings) {
        JTextComponent.loadKeymap(comp.getKeymap(), bindings, comp.getActions());
    }

    public static void initUIManager() {
        try {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new MirthTheme());
            PlasticXPLookAndFeel look = new PlasticXPLookAndFeel();
            UIManager.setLookAndFeel((LookAndFeel)look);
            UIManager.put("win.xpstyle.name", "metallic");
            LookAndFeelAddons.setAddon(WindowsLookAndFeelAddons.class);
            if (2 != Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                Mirth.createAlternateKeyBindings();
            }
            if (SystemUtils.IS_OS_MAC) {
                OSXAdapter.setAboutHandler(Mirth.class, Mirth.class.getDeclaredMethod("aboutMac", null));
                OSXAdapter.setQuitHandler(Mirth.class, Mirth.class.getDeclaredMethod("quitMac", null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ToolTipManager.sharedInstance().setDismissDelay(3600000);
        UIManager.put("TabbedPane.highlight", new Color(225, 225, 225));
        UIManager.put("TabbedPane.selectHighlight", new Color(0xC3C3C3));
        UIManager.put("TabbedPane.contentBorderInsets", new InsetsUIResource(0, 0, 0, 0));
        UIManager.put("TaskPane.titleBackgroundGradientStart", new Color(0xFFFFFF));
        UIManager.put("TaskPane.titleBackgroundGradientEnd", new Color(0xFFFFFF));
        UIManager.put("TextPane.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ToggleButton.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("Panel.font", UIConstants.DIALOG_FONT);
        UIManager.put("PopupMenu.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("OptionPane.font", UIConstants.DIALOG_FONT);
        UIManager.put("Label.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("Tree.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ScrollPane.font", UIConstants.DIALOG_FONT);
        UIManager.put("TextField.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("Viewport.font", UIConstants.DIALOG_FONT);
        UIManager.put("MenuBar.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("FormattedTextField.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("DesktopIcon.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("TableHeader.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ToolTip.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("PasswordField.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("TaskPane.font", UIConstants.TEXTFIELD_BOLD_FONT);
        UIManager.put("Table.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("TabbedPane.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ProgressBar.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("CheckBoxMenuItem.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ColorChooser.font", UIConstants.DIALOG_FONT);
        UIManager.put("Button.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("TextArea.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("Spinner.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("RadioButton.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("TitledBorder.font", UIConstants.TEXTFIELD_BOLD_FONT);
        UIManager.put("EditorPane.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("RadioButtonMenuItem.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ToolBar.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("MenuItem.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("CheckBox.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("JXTitledPanel.title.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("Menu.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("ComboBox.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        UIManager.put("JXLoginPanel.banner.font", UIConstants.BANNER_FONT);
        UIManager.put("List.font", UIConstants.TEXTFIELD_PLAIN_FONT);
        InputMap im = (InputMap)UIManager.get("Button.focusInputMap");
        im.put(KeyStroke.getKeyStroke("pressed ENTER"), "pressed");
        im.put(KeyStroke.getKeyStroke("released ENTER"), "released");
        try {
            UIManager.put("wizard.sidebar.image", ImageIO.read(Frame.class.getResource("images/wizardsidebar.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String server = "https://localhost:8443";
        String version = "";
        String username = "";
        String password = "";
        String protocols = "";
        String cipherSuites = "";
        if (args.length > 0) {
            server = args[0];
        }
        if (args.length > 1) {
            version = args[1];
        }
        if (args.length > 2) {
            if (StringUtils.equalsIgnoreCase((CharSequence)args[2], (CharSequence)"-ssl")) {
                if (args.length > 3) {
                    protocols = args[3];
                }
                if (args.length > 4) {
                    cipherSuites = args[4];
                }
                if (args.length > 5) {
                    username = args[5];
                }
                if (args.length > 6) {
                    password = args[6];
                }
            } else {
                username = args[2];
                if (args.length > 3) {
                    password = args[3];
                }
                if (args.length > 4 && StringUtils.equalsIgnoreCase((CharSequence)args[4], (CharSequence)"-ssl")) {
                    if (args.length > 5) {
                        protocols = args[5];
                    }
                    if (args.length > 6) {
                        cipherSuites = args[6];
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)protocols)) {
            PlatformUI.HTTPS_PROTOCOLS = StringUtils.split((String)protocols, (char)',');
        }
        if (StringUtils.isNotBlank((CharSequence)cipherSuites)) {
            PlatformUI.HTTPS_CIPHER_SUITES = StringUtils.split((String)cipherSuites, (char)',');
        }
        Mirth.start(server, version, username, password);
    }

    private static void start(final String server, final String version, final String username, final String password) {
        Logger velocityLogger = LogManager.getLogger((String)"org.apache.velocity");
        if (velocityLogger != null && velocityLogger.getLevel() == null) {
            Configurator.setLevel((String)velocityLogger.getName(), (Level)Level.OFF);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Mirth.initUIManager();
                PlatformUI.BACKGROUND_IMAGE = new ImageIcon(Frame.class.getResource("images/header_nologo.png"));
                LoginPanel.getInstance().initialize(server, version, username, password);
            }
        });
    }
}

