/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class MirthFileFilter
extends FileFilter {
    private String fileExtension;

    public MirthFileFilter(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() || FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase(this.fileExtension);
    }

    @Override
    public String getDescription() {
        if (this.fileExtension.equalsIgnoreCase("xml")) {
            return "XML files";
        }
        if (this.fileExtension.equalsIgnoreCase("html")) {
            return "HTML files";
        }
        if (this.fileExtension.equalsIgnoreCase("txt")) {
            return "Text files";
        }
        if (this.fileExtension.equalsIgnoreCase("zip")) {
            return "ZIP files";
        }
        if (this.fileExtension.equalsIgnoreCase("wsdl")) {
            return "WSDL files";
        }
        if (this.fileExtension.equalsIgnoreCase("properties")) {
            return "Properties files";
        }
        return "ERROR";
    }
}

