/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public class OSXAdapter
implements InvocationHandler {
    protected Object targetObject;
    protected Method targetMethod;
    protected String proxySignature;
    static Object macOSXApplication;

    public static void setQuitHandler(final Object target, final Method quitHandler) {
        try {
            if (OSXAdapter.isJava9OrGreater()) {
                InvocationHandler invocationHandler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("handleQuitRequestWith")) {
                            boolean quit = (Boolean)quitHandler.invoke(target, new Object[0]);
                            Object quitResponse = args[1];
                            quitResponse.getClass().getMethod(quit ? "performQuit" : "cancelQuit", new Class[0]).invoke(quitResponse, new Object[0]);
                        }
                        return null;
                    }
                };
                OSXAdapter.setHandler(invocationHandler, "java.awt.desktop.QuitHandler", "setQuitHandler");
            } else {
                OSXAdapter.setHandler(new OSXAdapter("handleQuit", target, quitHandler));
            }
        }
        catch (Exception ex) {
            System.err.println("OSXAdapter could not set quit handler");
            ex.printStackTrace();
        }
    }

    public static void setAboutHandler(Object target, Method aboutHandler) {
        boolean enableAboutMenu = target != null && aboutHandler != null;
        try {
            if (OSXAdapter.isJava9OrGreater()) {
                if (enableAboutMenu) {
                    OSXAdapter.setHandler(new OSXAdapter("handleAbout", target, aboutHandler), "java.awt.desktop.AboutHandler", "setAboutHandler");
                }
            } else {
                if (enableAboutMenu) {
                    OSXAdapter.setHandler(new OSXAdapter("handleAbout", target, aboutHandler));
                }
                Method enableAboutMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
                enableAboutMethod.invoke(macOSXApplication, enableAboutMenu);
            }
        }
        catch (Exception ex) {
            System.err.println("OSXAdapter could not access the About Menu");
            ex.printStackTrace();
        }
    }

    public static void setPreferencesHandler(Object target, Method prefsHandler) {
        boolean enablePrefsMenu = target != null && prefsHandler != null;
        try {
            if (OSXAdapter.isJava9OrGreater()) {
                if (enablePrefsMenu) {
                    OSXAdapter.setHandler(new OSXAdapter("handlePreferences", target, prefsHandler), "java.awt.desktop.PreferencesHandler", "setPreferencesHandler");
                }
            } else {
                if (enablePrefsMenu) {
                    OSXAdapter.setHandler(new OSXAdapter("handlePreferences", target, prefsHandler));
                }
                Method enablePrefsMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
                enablePrefsMethod.invoke(macOSXApplication, enablePrefsMenu);
            }
        }
        catch (Exception ex) {
            System.err.println("OSXAdapter could not set preferences handler");
            ex.printStackTrace();
        }
    }

    public static void setFileHandler(final Object target, final Method fileHandler) {
        try {
            if (OSXAdapter.isJava9OrGreater()) {
                InvocationHandler invocationHandler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("openFiles")) {
                            Object event = args[0];
                            List files = (List)event.getClass().getMethod("getFiles", new Class[0]).invoke(event, new Object[0]);
                            String searchTerm = (String)event.getClass().getMethod("getSearchTerm", new Class[0]).invoke(event, new Object[0]);
                            fileHandler.invoke(target, files, searchTerm);
                        }
                        return null;
                    }
                };
                OSXAdapter.setHandler(invocationHandler, "java.awt.desktop.OpenFilesHandler", "setOpenFileHandler");
            } else {
                OSXAdapter.setHandler(new OSXAdapter("handleOpenFile", target, fileHandler){

                    @Override
                    public boolean callTarget(Object appleEvent) {
                        if (appleEvent != null) {
                            try {
                                Method getFilenameMethod = appleEvent.getClass().getDeclaredMethod("getFilename", null);
                                String filename = (String)getFilenameMethod.invoke(appleEvent, (Object[])null);
                                this.targetMethod.invoke(this.targetObject, filename);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return true;
                    }
                });
            }
        }
        catch (Exception ex) {
            System.err.println("OSXAdapter could not set open files handler");
            ex.printStackTrace();
        }
    }

    public static void setHandler(OSXAdapter adapter) {
        try {
            Object application = OSXAdapter.getApplication();
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Method addListenerMethod = application.getClass().getDeclaredMethod("addApplicationListener", applicationListenerClass);
            Object osxAdapterProxy = Proxy.newProxyInstance(OSXAdapter.class.getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)adapter);
            addListenerMethod.invoke(application, osxAdapterProxy);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  ApplicationEvent handling has been disabled (" + String.valueOf(cnfe) + ")");
        }
        catch (Exception ex) {
            System.err.println("Mac OS X Adapter could not talk to EAWT:");
            ex.printStackTrace();
        }
    }

    protected OSXAdapter(String proxySignature, Object target, Method handler) {
        this.proxySignature = proxySignature;
        this.targetObject = target;
        this.targetMethod = handler;
    }

    public boolean callTarget(Object appleEvent) throws InvocationTargetException, IllegalAccessException {
        Object result = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (result == null) {
            return true;
        }
        return Boolean.valueOf(result.toString());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isCorrectMethod(method, args)) {
            boolean handled = this.callTarget(args[0]);
            this.setApplicationEventHandled(args[0], handled);
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] args) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && args.length == 1;
    }

    protected void setApplicationEventHandled(Object event, boolean handled) {
        if (event != null && !OSXAdapter.isJava9OrGreater()) {
            try {
                Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                setHandledMethod.invoke(event, handled);
            }
            catch (Exception ex) {
                System.err.println("OSXAdapter was unable to handle an ApplicationEvent: " + String.valueOf(event));
                ex.printStackTrace();
            }
        }
    }

    protected static Object getApplication() throws Exception {
        if (macOSXApplication == null) {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            macOSXApplication = OSXAdapter.isJava9OrGreater() ? applicationClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]) : applicationClass.getConstructor(null).newInstance(null);
        }
        return macOSXApplication;
    }

    protected static void setHandler(InvocationHandler adapter, String interfaceName, String applicationSetter) throws Exception {
        Class<?> handlerInterface = Class.forName(interfaceName);
        Object handlerImpl = Proxy.newProxyInstance((ClassLoader)AccessController.doPrivileged(ReflectionHelper.getClassLoaderPA(handlerInterface)), new Class[]{handlerInterface}, adapter);
        Object application = OSXAdapter.getApplication();
        application.getClass().getMethod(applicationSetter, handlerInterface).invoke(application, handlerImpl);
    }

    protected static boolean isJava9OrGreater() {
        String version = System.getProperty("java.version");
        int index = version.indexOf(45);
        if (index > 0) {
            version = version.substring(0, index);
        }
        if ((index = version.indexOf(46)) > 0) {
            version = version.substring(0, index);
        }
        return NumberUtils.toDouble((String)version) >= 9.0;
    }
}

