/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.AuthorizationControllerFactory;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.SettingsPanelAdministrator;
import com.mirth.connect.client.ui.SettingsPanelDatabaseTasks;
import com.mirth.connect.client.ui.SettingsPanelMap;
import com.mirth.connect.client.ui.SettingsPanelResources;
import com.mirth.connect.client.ui.SettingsPanelServer;
import com.mirth.connect.client.ui.tag.SettingsPanelTags;
import com.mirth.connect.plugins.SettingsPanelPlugin;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SettingsPane
extends JPanel {
    private Frame parent;
    private AbstractSettingsPanel currentSettingsPanel = null;
    private Map<String, AbstractSettingsPanel> settingsPanelMap = new HashMap<String, AbstractSettingsPanel>();
    private JTabbedPane tabbedPane;

    public SettingsPane() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.loadPanel(new SettingsPanelServer("Server"));
        this.loadPanel(new SettingsPanelAdministrator("Administrator"));
        this.loadPanel(new SettingsPanelTags("Tags"));
        this.loadPanel(new SettingsPanelMap("Configuration Map"));
        this.loadPanel(new SettingsPanelDatabaseTasks("Database Tasks"));
        this.loadPanel(new SettingsPanelResources("Resources"));
        this.loadPluginPanels();
        DefaultSingleSelectionModel model = new DefaultSingleSelectionModel(){

            @Override
            public void setSelectedIndex(int index) {
                if (SettingsPane.this.parent.confirmLeave()) {
                    SettingsPane.this.setCurrentSettingsPanel(index);
                    super.setSelectedIndex(index);
                }
            }
        };
        this.tabbedPane.setModel(model);
    }

    public void loadPluginPanels() {
        for (SettingsPanelPlugin settingsPanelPlugin : LoadedExtensions.getInstance().getSettingsPanelPlugins().values()) {
            this.loadPanel(settingsPanelPlugin.getSettingsPanel());
        }
    }

    private void loadPanel(AbstractSettingsPanel settingsPanel) {
        if (AuthorizationControllerFactory.getAuthorizationController().checkTask(settingsPanel.getTaskPane().getName(), "doRefresh")) {
            this.parent.setNonFocusable(settingsPanel.getTaskPane());
            settingsPanel.getTaskPane().setVisible(false);
            this.parent.taskPaneContainer.add((Component)settingsPanel.getTaskPane(), this.parent.taskPaneContainer.getComponentCount() - 1);
            this.tabbedPane.addTab(settingsPanel.getTabName(), settingsPanel);
            this.settingsPanelMap.put(settingsPanel.getTabName(), settingsPanel);
        }
    }

    private void setCurrentSettingsPanel(int index) {
        String tabName = this.tabbedPane.getTitleAt(index);
        this.currentSettingsPanel = this.settingsPanelMap.get(tabName);
        this.parent.setFocus(this.currentSettingsPanel.getTaskPane());
        this.currentSettingsPanel.doRefresh();
    }

    public void setSelectedSettingsPanel(int index) {
        this.tabbedPane.setSelectedIndex(0);
    }

    public AbstractSettingsPanel getCurrentSettingsPanel() {
        return this.currentSettingsPanel;
    }

    public AbstractSettingsPanel getSettingsPanel(String tabName) {
        return this.settingsPanelMap.get(tabName);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 300, Short.MAX_VALUE));
    }
}

