/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.DateCellRenderer;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.model.DatabaseTask;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SettingsPanelDatabaseTasks
extends AbstractSettingsPanel
implements ListSelectionListener {
    public static final String TAB_NAME = "Database Tasks";
    private JXTable taskTable;
    private JXTable channelsTable;

    public SettingsPanelDatabaseTasks(String tabName) {
        super(tabName);
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.initComponents();
        this.addTask("doRunDatabaseTask", "Run Task", "Execute the selected database task.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")));
        this.addTask("doCancelDatabaseTask", "Cancel Task", "Cancel the selected database task.", "", new ImageIcon(Frame.class.getResource("images/stop.png")));
        this.setVisibleTasks(2, 3, false);
    }

    @Override
    public void doRefresh() {
        final String workingId = this.getFrame().startWorking("Loading database tasks...");
        final int selectedRow = this.taskTable.getSelectedRow();
        SwingWorker<Map<String, DatabaseTask>, Void> worker = new SwingWorker<Map<String, DatabaseTask>, Void>(){

            @Override
            public Map<String, DatabaseTask> doInBackground() throws ClientException {
                return SettingsPanelDatabaseTasks.this.getFrame().mirthClient.getDatabaseTasks();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                try {
                    HashMap databaseTasks = (HashMap)this.get();
                    if (databaseTasks == null) {
                        databaseTasks = new HashMap();
                    }
                    Object[][] data = new Object[databaseTasks.size()][4];
                    int i = 0;
                    for (DatabaseTask databaseTask : databaseTasks.values()) {
                        DatabaseTask.Status status = databaseTask.getStatus();
                        data[i][0] = new CellData(status == DatabaseTask.Status.IDLE ? UIConstants.ICON_BULLET_YELLOW : UIConstants.ICON_BULLET_GREEN, status.toString());
                        data[i][1] = databaseTask;
                        data[i][2] = databaseTask.getDescription();
                        data[i][3] = databaseTask.getStartDateTime();
                        ++i;
                    }
                    ((RefreshTableModel)SettingsPanelDatabaseTasks.this.taskTable.getModel()).refreshDataVector(data);
                    if (selectedRow > -1 && selectedRow < SettingsPanelDatabaseTasks.this.taskTable.getRowCount()) {
                        SettingsPanelDatabaseTasks.this.taskTable.setRowSelectionInterval(selectedRow, selectedRow);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelDatabaseTasks.this.getFrame().alertThrowable((Component)((Object)SettingsPanelDatabaseTasks.this.getFrame()), t, "Error loading database tasks: " + t.toString());
                }
                finally {
                    SettingsPanelDatabaseTasks.this.getFrame().stopWorking(workingId);
                }
            }
        };
        worker.execute();
    }

    @Override
    public boolean doSave() {
        return false;
    }

    public void doRunDatabaseTask() {
        DatabaseTask databaseTask = (DatabaseTask)this.taskTable.getValueAt(this.taskTable.getSelectedRow(), 1);
        if (databaseTask.getConfirmationMessage() != null && !this.getFrame().alertOption((Component)((Object)this.getFrame()), databaseTask.getConfirmationMessage())) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Running database task...");
        final String taskId = databaseTask.getId();
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            public String doInBackground() throws ClientException {
                return SettingsPanelDatabaseTasks.this.getFrame().mirthClient.runDatabaseTask(taskId);
            }

            @Override
            public void done() {
                try {
                    String result = (String)this.get();
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        SettingsPanelDatabaseTasks.this.getFrame().alertInformation((Component)((Object)SettingsPanelDatabaseTasks.this.getFrame()), result);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelDatabaseTasks.this.getFrame().alertThrowable((Component)((Object)SettingsPanelDatabaseTasks.this.getFrame()), t, "Error running database task: " + t.getMessage());
                }
                finally {
                    SettingsPanelDatabaseTasks.this.getFrame().stopWorking(workingId);
                    SettingsPanelDatabaseTasks.this.doRefresh();
                }
            }
        };
        worker.execute();
        this.doRefresh();
    }

    public void doCancelDatabaseTask() {
        DatabaseTask databaseTask = (DatabaseTask)this.taskTable.getValueAt(this.taskTable.getSelectedRow(), 1);
        if (databaseTask.getStatus() != DatabaseTask.Status.RUNNING) {
            this.getFrame().alertError((Component)((Object)this.getFrame()), "Task \"" + databaseTask.getName() + "\" is not currently running.");
            return;
        }
        if (!this.getFrame().alertOption((Component)((Object)this.getFrame()), "Are you sure you want to cancel the selected database task?")) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Cancelling database task...");
        final String taskId = databaseTask.getId();
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws ClientException {
                SettingsPanelDatabaseTasks.this.getFrame().mirthClient.cancelDatabaseTask(taskId);
                return null;
            }

            @Override
            public void done() {
                try {
                    this.get();
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelDatabaseTasks.this.getFrame().alertThrowable((Component)((Object)SettingsPanelDatabaseTasks.this.getFrame()), t, "Error cancelling database task: " + t.getMessage());
                }
                finally {
                    SettingsPanelDatabaseTasks.this.getFrame().stopWorking(workingId);
                    SettingsPanelDatabaseTasks.this.doRefresh();
                }
            }
        };
        worker.execute();
    }

    private void initComponents() {
        JPanel containerPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        containerPanel.setBackground(this.getBackground());
        containerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), TAB_NAME, 0, 0, new Font("Tahoma", 1, 11)));
        containerPanel.add((Component)new JLabel("Cleanup or optimization tasks for the internal database. If no tasks are present, no action is necessary."), "top, wrap");
        this.taskTable = new MirthTable();
        this.taskTable.setModel((TableModel)new RefreshTableModel(new Object[]{"Status", "Name", "Description", "Start Time"}, 0));
        this.taskTable.setDragEnabled(false);
        this.taskTable.setRowSelectionAllowed(true);
        this.taskTable.setSelectionMode(0);
        this.taskTable.setRowHeight(20);
        this.taskTable.setFocusable(false);
        this.taskTable.setOpaque(true);
        this.taskTable.getTableHeader().setReorderingAllowed(false);
        this.taskTable.setEditable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.taskTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.taskTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                if (SettingsPanelDatabaseTasks.this.taskTable.rowAtPoint(new Point(evt.getX(), evt.getY())) < 0) {
                    SettingsPanelDatabaseTasks.this.taskTable.clearSelection();
                    SettingsPanelDatabaseTasks.this.setVisibleTasks(2, 3, false);
                }
            }
        });
        this.taskTable.getColumnModel().getColumn(0).setMinWidth(75);
        this.taskTable.getColumnModel().getColumn(0).setMaxWidth(75);
        this.taskTable.getColumnModel().getColumn(0).setCellRenderer(new ImageCellRenderer());
        this.taskTable.getColumnModel().getColumn(1).setMinWidth(45);
        this.taskTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.taskTable.getColumnModel().getColumn(2).setMinWidth(75);
        this.taskTable.getColumnModel().getColumn(2).setPreferredWidth(475);
        this.taskTable.getColumnModel().getColumn(3).setMinWidth(95);
        this.taskTable.getColumnModel().getColumn(3).setMaxWidth(95);
        this.taskTable.getColumnModel().getColumn(3).setCellRenderer(new DateCellRenderer());
        this.taskTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane taskTableScrollPane = new JScrollPane((Component)this.taskTable);
        containerPanel.add((Component)taskTableScrollPane, "grow, push");
        this.add((Component)containerPanel, "grow, h 60%");
        JPanel channelsPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        channelsPanel.setBackground(this.getBackground());
        channelsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Affected Channels", 0, 0, new Font("Tahoma", 1, 11)));
        this.channelsTable = new MirthTable();
        this.channelsTable.setModel((TableModel)new RefreshTableModel(new Object[]{"Name", "Id"}, 0));
        this.channelsTable.setDragEnabled(false);
        this.channelsTable.setRowSelectionAllowed(false);
        this.channelsTable.setRowHeight(20);
        this.channelsTable.setFocusable(false);
        this.channelsTable.setOpaque(true);
        this.channelsTable.getTableHeader().setReorderingAllowed(false);
        this.channelsTable.setEditable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.channelsTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        channelsPanel.add((Component)new JScrollPane((Component)this.channelsTable), "grow");
        this.add((Component)channelsPanel, "newline, grow, h 40%");
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            int selectedRow = this.taskTable.getSelectedRow();
            boolean showRun = evt.getFirstIndex() > -1;
            boolean showCancel = false;
            if (showRun) {
                for (int row = 0; row < this.taskTable.getRowCount(); ++row) {
                    if (((DatabaseTask)this.taskTable.getValueAt(row, 1)).getStatus() != DatabaseTask.Status.RUNNING) continue;
                    showRun = false;
                    if (row != selectedRow) continue;
                    showCancel = true;
                }
            }
            this.setVisibleTasks(2, 2, showRun);
            this.setVisibleTasks(3, 3, showCancel);
            Map affectedChannels = new HashMap();
            if (selectedRow > -1) {
                affectedChannels = ((DatabaseTask)this.taskTable.getValueAt(selectedRow, 1)).getAffectedChannels();
            }
            Object[][] data = new Object[affectedChannels.size()][2];
            int i = 0;
            for (String channelId : affectedChannels.keySet()) {
                data[i][0] = affectedChannels.get(channelId);
                data[i][1] = channelId;
                ++i;
            }
            ((RefreshTableModel)this.channelsTable.getModel()).refreshDataVector(data);
        }
    }
}

