/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthDialogTableCellEditor;
import com.mirth.connect.client.ui.components.MirthPasswordTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.util.ConfigurationProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SettingsPanelMap
extends AbstractSettingsPanel {
    public static final String TAB_NAME = "Configuration Map";
    private static final String SHOW_VALUES_KEY = "showConfigMapValues";
    private static Preferences userPreferences = Preferences.userNodeForPackage(Mirth.class);
    private JLabel showValuesLabel;
    private JCheckBox showValuesCheckbox;
    private JPanel configurationMapPanel;
    private JScrollPane configurationMapScrollPane;
    private MirthTable configurationMapTable;
    private MirthButton addButton;
    private MirthButton removeButton;

    public SettingsPanelMap(String tabName) {
        super(tabName);
        this.initComponents();
        this.addTask("doImportMap", "Import Map", "Import a properties file into the configuration map. This will remove and replace any existing map values.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")));
        this.addTask("doExportMap", "Export Map", "Export the configuration map to a properties file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")));
        this.setVisibleTasks(2, 3, true);
    }

    @Override
    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        if (this.configurationMapTable.getCellEditor() != null) {
            this.configurationMapTable.getCellEditor().stopCellEditing();
        }
        final boolean showConfigMapValues = userPreferences.getBoolean(SHOW_VALUES_KEY, false);
        this.showValuesCheckbox.setSelected(showConfigMapValues);
        final String workingId = this.getFrame().startWorking("Loading " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            Map<String, ConfigurationProperty> configurationMap = null;

            @Override
            public Void doInBackground() {
                try {
                    this.configurationMap = SettingsPanelMap.this.getFrame().mirthClient.getConfigurationMap();
                }
                catch (ClientException e) {
                    SettingsPanelMap.this.getFrame().alertThrowable((Component)((Object)SettingsPanelMap.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                if (this.configurationMap != null) {
                    SettingsPanelMap.this.updateConfigurationTable(this.configurationMap, showConfigMapValues, true);
                }
                SettingsPanelMap.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
    }

    @Override
    public boolean doSave() {
        Map<String, ConfigurationProperty> configurationMap;
        if (this.configurationMapTable.getCellEditor() != null) {
            this.configurationMapTable.getCellEditor().stopCellEditing();
        }
        if ((configurationMap = this.getConfigurationMapFromTable()) == null) {
            return false;
        }
        final String workingId = this.getFrame().startWorking("Saving " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    SettingsPanelMap.this.getFrame().mirthClient.setConfigurationMap(configurationMap);
                }
                catch (ClientException e) {
                    SettingsPanelMap.this.getFrame().alertThrowable((Component)((Object)SettingsPanelMap.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                SettingsPanelMap.this.setSaveEnabled(false);
                SettingsPanelMap.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
        return true;
    }

    private Map<String, ConfigurationProperty> getConfigurationMapFromTable() {
        LinkedHashMap<String, ConfigurationProperty> configurationMap = new LinkedHashMap<String, ConfigurationProperty>();
        RefreshTableModel model = (RefreshTableModel)this.configurationMapTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String key = (String)model.getValueAt(i, 0);
            String value = (String)model.getValueAt(i, 1);
            String comment = (String)model.getValueAt(i, 2);
            if (StringUtils.isNotBlank((CharSequence)key)) {
                configurationMap.put(key, new ConfigurationProperty(value, comment));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)value) && !StringUtils.isNotBlank((CharSequence)comment)) continue;
            this.getFrame().alertWarning(this, "Blank keys are not allowed.");
            return null;
        }
        return configurationMap;
    }

    public void doImportMap() {
        File file;
        if (this.configurationMapTable.getCellEditor() != null) {
            this.configurationMapTable.getCellEditor().stopCellEditing();
        }
        if ((file = this.getFrame().browseForFile("PROPERTIES")) != null) {
            try {
                PropertiesConfiguration properties = PropertiesConfigurationUtil.create((File)file);
                HashMap<String, ConfigurationProperty> configurationMap = new HashMap<String, ConfigurationProperty>();
                Iterator iterator = properties.getKeys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = properties.getString(key);
                    String comment = properties.getLayout().getCanonicalComment(key, false);
                    configurationMap.put(key, new ConfigurationProperty(value, comment));
                }
                this.updateConfigurationTable(configurationMap, this.showValuesCheckbox.isSelected(), true);
                this.setSaveEnabled(true);
            }
            catch (Exception e) {
                this.getFrame().alertThrowable((Component)((Object)this.getFrame()), (Throwable)e, "Error importing configuration map");
            }
        }
    }

    public void doExportMap() {
        int option;
        if (this.configurationMapTable.getCellEditor() != null) {
            this.configurationMapTable.getCellEditor().stopCellEditing();
        }
        if (this.isSaveEnabled() && ((option = JOptionPane.showConfirmDialog(this, "Would you like to save the settings first?")) == 0 ? !this.doSave() : option == 2 || option == -1)) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Exporting " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private Map<String, ConfigurationProperty> configurationMap;

            @Override
            public Void doInBackground() {
                try {
                    File file = SettingsPanelMap.this.getFrame().createFileForExport(null, "PROPERTIES");
                    if (file != null) {
                        PropertiesConfiguration properties = PropertiesConfigurationUtil.create((File)file);
                        properties.clear();
                        PropertiesConfigurationLayout layout = properties.getLayout();
                        this.configurationMap = SettingsPanelMap.this.getFrame().mirthClient.getConfigurationMap();
                        TreeMap<String, ConfigurationProperty> sortedMap = new TreeMap<String, ConfigurationProperty>(String.CASE_INSENSITIVE_ORDER);
                        sortedMap.putAll(this.configurationMap);
                        for (Map.Entry entry : sortedMap.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = ((ConfigurationProperty)entry.getValue()).getValue();
                            String comment = ((ConfigurationProperty)entry.getValue()).getComment();
                            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                            properties.setProperty(key, (Object)value);
                            layout.setComment(key, StringUtils.isBlank((CharSequence)comment) ? null : comment);
                        }
                        PropertiesConfigurationUtil.saveTo((PropertiesConfiguration)properties, (File)file);
                    }
                }
                catch (Exception e) {
                    SettingsPanelMap.this.getFrame().alertThrowable((Component)((Object)SettingsPanelMap.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                SettingsPanelMap.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
    }

    private void updateConfigurationTable(Map<String, ConfigurationProperty> map, boolean show, boolean sort) {
        RefreshTableModel model = (RefreshTableModel)this.configurationMapTable.getModel();
        Object[][] data = new String[map.size()][3];
        Map<String, ConfigurationProperty> sortedMap = null;
        if (sort) {
            sortedMap = new TreeMap<String, ConfigurationProperty>(String.CASE_INSENSITIVE_ORDER);
            sortedMap.putAll(map);
        } else {
            sortedMap = map;
        }
        int index = 0;
        for (Map.Entry<String, ConfigurationProperty> entry : sortedMap.entrySet()) {
            data[index][0] = entry.getKey();
            data[index][1] = entry.getValue().getValue();
            data[index++][2] = entry.getValue().getComment();
        }
        this.updateCellRenderer(show);
        model.refreshDataVector(data);
    }

    private void updateCellRenderer(boolean show) {
        if (show) {
            this.configurationMapTable.getColumnExt("Value").setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer());
        } else {
            this.configurationMapTable.getColumnExt("Value").setCellRenderer((TableCellRenderer)new MirthPasswordTableCellRenderer());
        }
    }

    private void showValuesCheckboxActionPerformed(boolean show) {
        this.updateCellRenderer(show);
        ((RefreshTableModel)this.configurationMapTable.getModel()).fireTableDataChanged();
        userPreferences.putBoolean(SHOW_VALUES_KEY, show);
    }

    private void initComponents() {
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout((LayoutManager)new MigLayout("insets 12, fill"));
        this.showValuesLabel = new JLabel("Show values");
        this.showValuesCheckbox = new JCheckBox();
        String tooltip = "If enabled, values in the table will be shown.";
        this.showValuesCheckbox.setToolTipText(tooltip);
        this.showValuesCheckbox.setBackground(Color.WHITE);
        this.showValuesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanelMap.this.showValuesCheckboxActionPerformed(SettingsPanelMap.this.showValuesCheckbox.isSelected());
            }
        });
        this.configurationMapTable = new MirthTable();
        this.configurationMapTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.configurationMapTable.getTableHeader().setReorderingAllowed(false);
        this.configurationMapTable.setSortable(false);
        this.configurationMapTable.setSelectionMode(0);
        this.configurationMapTable.setModel(new RefreshTableModel(new String[0][], new String[]{"Key", "Value", "Comment"}));
        TextFieldCellEditor cellEditor = new TextFieldCellEditor(){

            @Override
            protected boolean valueChanged(String value) {
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                return true;
            }
        };
        this.configurationMapTable.getColumnExt("Key").setCellEditor((TableCellEditor)cellEditor);
        this.configurationMapTable.getColumnExt("Comment").setCellEditor((TableCellEditor)cellEditor);
        this.configurationMapTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                int selectedRow = SettingsPanelMap.this.configurationMapTable.isEditing() ? SettingsPanelMap.this.configurationMapTable.getEditingRow() : SettingsPanelMap.this.configurationMapTable.getSelectedRow();
                SettingsPanelMap.this.removeButton.setEnabled(selectedRow != -1);
            }
        });
        this.configurationMapTable.getColumnExt("Value").setCellEditor((TableCellEditor)new MirthDialogTableCellEditor((JTable)((Object)this.configurationMapTable)));
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.configurationMapTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.configurationMapScrollPane = new JScrollPane();
        this.configurationMapScrollPane.setViewportView((Component)((Object)this.configurationMapTable));
        this.addButton = new MirthButton("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RefreshTableModel)SettingsPanelMap.this.configurationMapTable.getModel()).addRow(new String[]{"", ""});
                if (SettingsPanelMap.this.configurationMapTable.getRowCount() == 1) {
                    SettingsPanelMap.this.configurationMapTable.setRowSelectionInterval(0, 0);
                }
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.removeButton = new MirthButton("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPanelMap.this.configurationMapTable.getSelectedModelIndex() != -1 && !SettingsPanelMap.this.configurationMapTable.isEditing()) {
                    Integer selectedModelIndex = SettingsPanelMap.this.configurationMapTable.getSelectedModelIndex();
                    RefreshTableModel model = (RefreshTableModel)SettingsPanelMap.this.configurationMapTable.getModel();
                    int newViewIndex = SettingsPanelMap.this.configurationMapTable.convertRowIndexToView(selectedModelIndex);
                    if (newViewIndex == model.getRowCount() - 1) {
                        --newViewIndex;
                    }
                    model.removeRow(selectedModelIndex);
                    if (model.getRowCount() != 0) {
                        SettingsPanelMap.this.configurationMapTable.setRowSelectionInterval(newViewIndex, newViewIndex);
                    }
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        });
        this.configurationMapPanel = new JPanel();
        this.configurationMapPanel.setBackground(Color.WHITE);
        this.configurationMapPanel.setLayout((LayoutManager)new MigLayout("fill, insets 0", "[grow]", "[][grow]"));
        this.configurationMapPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), TAB_NAME, 0, 0, new Font("Tahoma", 1, 11)));
        JPanel showValuesPanel = new JPanel();
        showValuesPanel.setBackground(Color.WHITE);
        showValuesPanel.add(this.showValuesCheckbox);
        showValuesPanel.add(this.showValuesLabel);
        this.configurationMapPanel.add((Component)showValuesPanel, "wrap");
        JPanel configurationMapSubPanel = new JPanel();
        configurationMapSubPanel.setBackground(Color.WHITE);
        configurationMapSubPanel.setLayout((LayoutManager)new MigLayout("fill, flowy, insets 0", "[grow][]", "[grow]"));
        configurationMapSubPanel.add((Component)this.configurationMapScrollPane, "grow, wrap");
        configurationMapSubPanel.add((Component)this.addButton, "growx, aligny top, split");
        configurationMapSubPanel.add((Component)this.removeButton, "growx, aligny top");
        this.configurationMapPanel.add((Component)configurationMapSubPanel, "grow, aligny top");
        this.add((Component)this.configurationMapPanel, "grow, height 100px:100%:100%, wrap");
    }
}

