/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.ResourcePropertiesPanel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.model.InvalidResourceProperties;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.plugins.ResourceClientPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SettingsPanelResources
extends AbstractSettingsPanel
implements ListSelectionListener {
    public static final String TAB_NAME = "Resources";
    private static final int PROPERTIES_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final int GLOBAL_SCRIPTS_COLUMN = 3;
    private static final int LOAD_PARENT_FIRST_COLUMN = 4;
    private MirthTable resourceTable;
    private Map<String, ResourcePropertiesPanel> propertiesPanelMap = new LinkedHashMap<String, ResourcePropertiesPanel>();
    private ResourcePropertiesPanel currentPropertiesPanel = null;
    private JPanel fillerPanel;
    private JLabel fillerLabel;
    private JScrollPane exceptionScrollPane;
    private JTextPane exceptionTextPane;
    private int selectedRow = -1;
    private int addResourceTaskIndex;
    private int removeResourceTaskIndex;
    private int reloadResourceTaskIndex;
    private List<ResourceProperties> cachedResources;

    public SettingsPanelResources(String tabName) {
        super(tabName);
        this.initComponents();
        this.addResourceTaskIndex = this.addTask("doAddResource", "Add Resource", "Add new resource.", "", new ImageIcon(Frame.class.getResource("images/add.png")));
        this.removeResourceTaskIndex = this.addTask("doRemoveResource", "Remove Resource", "Remove selected resource.", "", new ImageIcon(Frame.class.getResource("images/delete.png")));
        this.reloadResourceTaskIndex = this.addTask("doReloadResource", "Reload Resource", "Reloads the selected resource on the server.", "", new ImageIcon(Frame.class.getResource("images/arrow_rotate_clockwise.png")));
        this.setVisibleTasks(this.addResourceTaskIndex, this.reloadResourceTaskIndex, false);
        this.setVisibleTasks(this.addResourceTaskIndex, this.addResourceTaskIndex, true);
        this.setVisibleTasks(this.reloadResourceTaskIndex, this.reloadResourceTaskIndex, true);
    }

    public List<ResourceProperties> getCachedResources() {
        return this.cachedResources;
    }

    @Override
    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Loading resources...");
        final int selectedRow = this.resourceTable.getSelectedRow();
        SwingWorker<List<ResourceProperties>, Void> worker = new SwingWorker<List<ResourceProperties>, Void>(){

            @Override
            public List<ResourceProperties> doInBackground() throws ClientException {
                return SettingsPanelResources.this.getFrame().mirthClient.getResources();
            }

            @Override
            public void done() {
                try {
                    SettingsPanelResources.this.updateResourcesTable((List)this.get(), selectedRow, true);
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelResources.this.getFrame().alertThrowable((Component)((Object)SettingsPanelResources.this.getFrame()), t, "Error loading resources: " + t.toString());
                }
                finally {
                    SettingsPanelResources.this.getFrame().stopWorking(workingId);
                }
            }
        };
        worker.execute();
    }

    public void refresh() {
        try {
            this.updateResourcesTable(this.getFrame().mirthClient.getResources(), this.resourceTable.getSelectedRow(), false);
        }
        catch (Throwable t) {
            this.getFrame().alertThrowable((Component)((Object)this.getFrame()), t, "Error loading resources: " + t.toString(), false);
        }
    }

    private void updateResourcesTable(List<ResourceProperties> resources, int selectedRow, boolean clearSaveEnabled) {
        try {
            this.cachedResources = resources;
            String selectedResourceId = null;
            if (selectedRow > -1 && selectedRow < this.resourceTable.getRowCount()) {
                int modelRow = this.resourceTable.convertRowIndexToModel(selectedRow);
                ResourceProperties resourceProperties = (ResourceProperties)this.resourceTable.getModel().getValueAt(modelRow, 0);
                selectedResourceId = resourceProperties.getId();
            }
            for (ResourceClientPlugin resourceClientPlugin : LoadedExtensions.getInstance().getResourceClientPlugins().values()) {
                resourceClientPlugin.resourcesRefreshed(selectedResourceId);
            }
            ResourceProperties defaultResource = null;
            for (ResourceProperties properties : resources) {
                if (!properties.getId().equals("Default Resource")) continue;
                defaultResource = properties;
            }
            Object[][] objectArray = new Object[resources.size()][5];
            objectArray[0][0] = defaultResource;
            objectArray[0][1] = defaultResource.getName();
            objectArray[0][2] = defaultResource.getType();
            objectArray[0][3] = defaultResource.isIncludeWithGlobalScripts();
            objectArray[0][4] = defaultResource.isLoadParentFirst();
            int i = 1;
            for (ResourceProperties properties : resources) {
                if (properties.getId().equals("Default Resource")) continue;
                objectArray[i][0] = properties;
                objectArray[i][1] = properties.getName();
                objectArray[i][2] = properties.getType();
                objectArray[i][3] = properties.isIncludeWithGlobalScripts();
                objectArray[i][4] = properties.isLoadParentFirst();
                ++i;
            }
            this.selectedRow = -1;
            this.changePropertiesPanel(null);
            ((RefreshTableModel)this.resourceTable.getModel()).refreshDataVector(objectArray);
            if (selectedRow > -1 && selectedRow < this.resourceTable.getRowCount()) {
                this.resourceTable.setRowSelectionInterval(selectedRow, selectedRow);
            } else if (this.resourceTable.getRowCount() > 0) {
                this.resourceTable.setRowSelectionInterval(0, 0);
            }
            if (clearSaveEnabled) {
                this.getFrame().setSaveEnabled(false);
            }
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                t = t.getCause();
            }
            this.getFrame().alertThrowable((Component)((Object)this.getFrame()), t, "Error loading resources: " + t.toString());
        }
    }

    @Override
    public boolean doSave() {
        this.resetInvalidProperties();
        String errors = this.checkProperties().trim();
        if (StringUtils.isNotEmpty((CharSequence)errors)) {
            this.getFrame().alertError((Component)((Object)this.getFrame()), "Error validating resource settings:\n\n" + errors);
            return false;
        }
        if (!this.getFrame().alertOption((Component)((Object)this.getFrame()), "<html>Libraries associated with any changed resources will be reloaded.<br/>Any channels / connectors using those libraries will be affected.<br/>Also, a maximum of 1000 files may be loaded into a directory<br/>resource, with additional files being skipped.<br/>Are you sure you wish to continue?</html>")) {
            return false;
        }
        this.updateResource(this.resourceTable.getSelectedRow());
        final String workingId = this.getFrame().startWorking("Saving resources...");
        final ArrayList<ResourceProperties> resources = new ArrayList<ResourceProperties>();
        for (int row = 0; row < this.resourceTable.getRowCount(); ++row) {
            resources.add((ResourceProperties)this.resourceTable.getModel().getValueAt(row, 0));
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws ClientException {
                SettingsPanelResources.this.getFrame().mirthClient.setResources(resources);
                return null;
            }

            @Override
            public void done() {
                try {
                    this.get();
                    SettingsPanelResources.this.setSaveEnabled(false);
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelResources.this.getFrame().alertThrowable((Component)((Object)SettingsPanelResources.this.getFrame()), t, "Error saving resources: " + t.toString());
                }
                finally {
                    SettingsPanelResources.this.getFrame().stopWorking(workingId);
                }
            }
        };
        worker.execute();
        return true;
    }

    public void doAddResource() {
        int selectedRow = this.resourceTable.getSelectedRow();
        if (selectedRow >= 0) {
            this.resetInvalidProperties();
            String errors = StringUtils.defaultString((String)this.checkProperties()).trim();
            if (StringUtils.isNotEmpty((CharSequence)errors)) {
                this.getFrame().alertError((Component)((Object)this.getFrame()), "Error validating resource settings:\n\n" + errors);
                return;
            }
            this.updateResource(selectedRow);
        }
        if (this.propertiesPanelMap.size() > 0) {
            this.changePropertiesPanel(this.propertiesPanelMap.keySet().iterator().next());
            this.resetInvalidProperties();
            ResourceProperties properties = this.currentPropertiesPanel.getDefaults();
            int num = 1;
            do {
                properties.setName("Resource " + num++);
            } while (!this.checkUniqueName(properties.getName()));
            this.selectedRow = -1;
            ((RefreshTableModel)this.resourceTable.getModel()).addRow(new Object[]{properties, properties.getName(), properties.getType(), false, false});
            this.resourceTable.getSelectionModel().setSelectionInterval(this.resourceTable.getRowCount() - 1, this.resourceTable.getRowCount() - 1);
            this.getFrame().setSaveEnabled(true);
        }
    }

    private boolean checkUniqueName(String name) {
        for (int row = 0; row < this.resourceTable.getRowCount(); ++row) {
            if (!((String)this.resourceTable.getModel().getValueAt(row, 1)).equals(name)) continue;
            return false;
        }
        return true;
    }

    public void doRemoveResource() {
        int selectedRow = this.resourceTable.getSelectedRow();
        if (selectedRow > 0) {
            this.resetInvalidProperties();
            this.resourceTable.getSelectionModel().removeListSelectionListener(this);
            ((RefreshTableModel)this.resourceTable.getModel()).removeRow(selectedRow);
            this.resourceTable.getSelectionModel().addListSelectionListener(this);
            int previousSelectedRow = selectedRow;
            this.selectedRow = -1;
            this.changePropertiesPanel(null);
            if (previousSelectedRow < this.resourceTable.getRowCount()) {
                this.resourceTable.getSelectionModel().setSelectionInterval(previousSelectedRow, previousSelectedRow);
            } else if (this.resourceTable.getRowCount() > 0) {
                this.resourceTable.getSelectionModel().setSelectionInterval(this.resourceTable.getRowCount() - 1, this.resourceTable.getRowCount() - 1);
            } else {
                this.setVisibleTasks(this.removeResourceTaskIndex, this.removeResourceTaskIndex, false);
            }
            this.getFrame().setSaveEnabled(true);
        }
    }

    public void doReloadResource() {
        final int selectedRow = this.resourceTable.getSelectedRow();
        if (selectedRow >= 0) {
            if (this.getFrame().isSaveEnabled()) {
                this.getFrame().alertWarning((Component)((Object)this.getFrame()), "You must save before reloading any resources.");
                return;
            }
            if (!this.getFrame().alertOption((Component)((Object)this.getFrame()), "<html>Libraries associated with this resource will be reloaded.<br/>Any channels / connectors using those libraries will be<br/>affected. Also, a maximum of 1000 files may be loaded into<br/>a directory resource, with additional files being skipped.<br/>Are you sure you wish to continue?</html>")) {
                return;
            }
            final String workingId = this.getFrame().startWorking("Reloading resource...");
            final String resourceId = ((ResourceProperties)this.resourceTable.getModel().getValueAt(selectedRow, 0)).getId();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() throws ClientException {
                    SettingsPanelResources.this.getFrame().mirthClient.reloadResource(resourceId);
                    return null;
                }

                @Override
                public void done() {
                    try {
                        this.get();
                        if (SettingsPanelResources.this.resourceTable.getSelectedRow() == selectedRow && SettingsPanelResources.this.currentPropertiesPanel != null) {
                            ResourceProperties properties = (ResourceProperties)SettingsPanelResources.this.resourceTable.getModel().getValueAt(selectedRow, 0);
                            properties.setName((String)SettingsPanelResources.this.resourceTable.getModel().getValueAt(selectedRow, 1));
                            properties.setIncludeWithGlobalScripts(((Boolean)SettingsPanelResources.this.resourceTable.getModel().getValueAt(selectedRow, 3)).booleanValue());
                            properties.setLoadParentFirst(((Boolean)SettingsPanelResources.this.resourceTable.getModel().getValueAt(selectedRow, 4)).booleanValue());
                            SettingsPanelResources.this.currentPropertiesPanel.fillProperties(properties);
                            SettingsPanelResources.this.currentPropertiesPanel.setProperties(properties);
                        }
                        SettingsPanelResources.this.doRefresh();
                    }
                    catch (Throwable t) {
                        if (t instanceof ExecutionException) {
                            t = t.getCause();
                        }
                        SettingsPanelResources.this.getFrame().alertThrowable((Component)((Object)SettingsPanelResources.this.getFrame()), t, "Error reloading resource: " + t.toString());
                    }
                    finally {
                        SettingsPanelResources.this.getFrame().stopWorking(workingId);
                    }
                }
            };
            worker.execute();
        }
    }

    private void resetInvalidProperties() {
        if (this.currentPropertiesPanel != null) {
            this.currentPropertiesPanel.resetInvalidProperties();
        }
    }

    private String checkProperties() {
        if (this.currentPropertiesPanel != null) {
            return this.currentPropertiesPanel.checkProperties();
        }
        return "";
    }

    private void updateResource(int row) {
        ResourceProperties properties = (ResourceProperties)this.resourceTable.getModel().getValueAt(row, 0);
        properties.setName((String)this.resourceTable.getModel().getValueAt(row, 1));
        properties.setIncludeWithGlobalScripts(((Boolean)this.resourceTable.getModel().getValueAt(row, 3)).booleanValue());
        properties.setLoadParentFirst(((Boolean)this.resourceTable.getModel().getValueAt(row, 4)).booleanValue());
        if (this.currentPropertiesPanel != null) {
            this.currentPropertiesPanel.fillProperties(properties);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel resourceListPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        resourceListPanel.setBackground(this.getBackground());
        resourceListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), TAB_NAME, 0, 0, new Font("Tahoma", 1, 11)));
        this.resourceTable = new MirthTable();
        this.resourceTable.setModel(new RefreshTableModel(new Object[]{"Properties", "Name", "Type", "Global Scripts", "Load Parent-First"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (row == 0) {
                    return column == 3 || column == 4;
                }
                return column == 1 || column == 2 || column == 3 || column == 4;
            }
        });
        this.resourceTable.setDragEnabled(false);
        this.resourceTable.setRowSelectionAllowed(true);
        this.resourceTable.setSelectionMode(0);
        this.resourceTable.setRowHeight(20);
        this.resourceTable.setFocusable(true);
        this.resourceTable.setOpaque(true);
        this.resourceTable.getTableHeader().setReorderingAllowed(false);
        this.resourceTable.setEditable(true);
        this.resourceTable.setSortable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.resourceTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        for (ResourceClientPlugin plugin : LoadedExtensions.getInstance().getResourceClientPlugins().values()) {
            this.propertiesPanelMap.put(plugin.getType(), plugin.getPropertiesPanel());
        }
        this.resourceTable.getColumnModel().getColumn(1).setCellEditor(new NameEditor());
        this.resourceTable.getColumnExt(1).setToolTipText("The unique name of the resource.");
        this.resourceTable.getColumnModel().getColumn(2).setMinWidth(100);
        this.resourceTable.getColumnModel().getColumn(2).setMaxWidth(200);
        this.resourceTable.getColumnModel().getColumn(2).setCellRenderer(new ComboBoxRenderer(this.propertiesPanelMap.keySet().toArray()));
        this.resourceTable.getColumnModel().getColumn(2).setCellEditor(new ComboBoxEditor((JTable)((Object)this.resourceTable), this.propertiesPanelMap.keySet().toArray(), 1, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelResources.this.typeComboBoxActionPerformed(evt);
            }
        }));
        this.resourceTable.getColumnExt(2).setToolTipText("The type of resource.");
        this.resourceTable.getColumnModel().getColumn(3).setMinWidth(80);
        this.resourceTable.getColumnModel().getColumn(3).setMaxWidth(80);
        this.resourceTable.getColumnModel().getColumn(3).setCellRenderer(new CheckBoxRenderer());
        this.resourceTable.getColumnModel().getColumn(3).setCellEditor(new CheckBoxEditor());
        this.resourceTable.getColumnExt(3).setToolTipText("<html>If checked, libraries associated with the corresponding<br/>resource will be included in global script contexts.</html>");
        this.resourceTable.getColumnModel().getColumn(4).setMinWidth(100);
        this.resourceTable.getColumnModel().getColumn(4).setMaxWidth(100);
        this.resourceTable.getColumnModel().getColumn(4).setCellRenderer(new CheckBoxRenderer());
        this.resourceTable.getColumnModel().getColumn(4).setCellEditor(new CheckBoxEditor());
        this.resourceTable.getColumnExt(4).setToolTipText("<html>If checked, classes already included in the overall server<br/>classpath will not be able to be overwritten. Classes will<br/>attempt to be loaded from the parent ClassLoader first.<br/><br/>Also, if this resource is included on a channel with other<br/>resources that have this option disabled, you will still<br/>not be able to overwrite classes in the parent classpath.</html>");
        this.resourceTable.removeColumn(this.resourceTable.getColumnModel().getColumn(0));
        this.resourceTable.getSelectionModel().addListSelectionListener(this);
        this.resourceTable.setToolTipText("<html>Add or remove resources to use<br/>in specific channels/connectors.</html>");
        this.resourceTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextColumnCell");
        resourceListPanel.add((Component)new JScrollPane((Component)((Object)this.resourceTable)), "grow, push");
        this.add((Component)resourceListPanel, "grow, h 20%");
        for (ResourcePropertiesPanel panel : this.propertiesPanelMap.values()) {
            this.add((Component)panel, "newline, grow, h 80%");
        }
        this.fillerPanel = new JPanel((LayoutManager)new MigLayout("insets 5, novisualpadding, hidemode 3, fill", "", "[][grow]"));
        this.fillerPanel.setBackground(this.getBackground());
        this.fillerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Resource Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.fillerLabel = new JLabel("Select a resource from the table above.");
        this.fillerPanel.add(this.fillerLabel);
        this.exceptionTextPane = new JTextPane();
        this.exceptionTextPane.setBackground(new Color(224, 223, 227));
        this.exceptionTextPane.setEditable(false);
        this.exceptionScrollPane = new JScrollPane(this.exceptionTextPane);
        this.fillerPanel.add((Component)this.exceptionScrollPane, "newline, grow");
        this.add((Component)this.fillerPanel, "newline, grow, h 80%");
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        String type;
        int selectedRow;
        JComboBox comboBox = (JComboBox)evt.getSource();
        if (comboBox.isPopupVisible() && (selectedRow = this.resourceTable.getSelectedRow()) >= 0 && this.propertiesPanelMap.containsKey(type = (String)comboBox.getSelectedItem())) {
            this.changePropertiesPanel(type);
            ResourceProperties properties = this.currentPropertiesPanel.getDefaults();
            this.resourceTable.getModel().setValueAt(properties, selectedRow, 0);
            this.currentPropertiesPanel.setProperties(properties);
            this.getFrame().setSaveEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            int newSelectedRow;
            final int previousSelectedRow = this.selectedRow;
            if (previousSelectedRow >= 0) {
                this.resetInvalidProperties();
                final String errors = this.checkProperties().trim();
                if (StringUtils.isNotEmpty((CharSequence)errors)) {
                    this.resourceTable.getSelectionModel().removeListSelectionListener(this);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SettingsPanelResources.this.resourceTable.getSelectionModel().setSelectionInterval(previousSelectedRow, previousSelectedRow);
                            SettingsPanelResources.this.getFrame().alertError((Component)((Object)SettingsPanelResources.this.getFrame()), "Error validating resource settings:\n\n" + errors);
                            SettingsPanelResources.this.resourceTable.getSelectionModel().addListSelectionListener(SettingsPanelResources.this);
                        }
                    });
                    return;
                }
                this.updateResource(previousSelectedRow);
            }
            if ((newSelectedRow = this.resourceTable.getSelectedRow()) >= 0) {
                ResourceProperties properties = (ResourceProperties)this.resourceTable.getModel().getValueAt(newSelectedRow, 0);
                if (properties instanceof InvalidResourceProperties) {
                    this.currentPropertiesPanel = null;
                    for (Map.Entry<String, ResourcePropertiesPanel> entry : this.propertiesPanelMap.entrySet()) {
                        entry.getValue().setVisible(false);
                    }
                    this.fillerLabel.setText("The currently selected resource is invalid. Check to make sure all resource extensions are correctly loaded.");
                    this.fillerPanel.setVisible(true);
                    Throwable cause = ((InvalidResourceProperties)properties).getCause();
                    if (cause != null) {
                        this.exceptionScrollPane.setVisible(true);
                        this.exceptionTextPane.setText(ExceptionUtils.getStackTrace((Throwable)cause));
                        this.exceptionTextPane.setCaretPosition(0);
                    } else {
                        this.exceptionScrollPane.setVisible(false);
                    }
                } else {
                    boolean saveEnabled = this.getFrame().isSaveEnabled();
                    this.changePropertiesPanel(properties.getType());
                    this.resetInvalidProperties();
                    this.currentPropertiesPanel.setProperties(properties);
                    this.getFrame().setSaveEnabled(saveEnabled);
                }
            } else {
                this.changePropertiesPanel(null);
            }
            this.selectedRow = newSelectedRow;
            this.setVisibleTasks(this.removeResourceTaskIndex, this.removeResourceTaskIndex, this.selectedRow > 0);
        }
    }

    private void changePropertiesPanel(String type) {
        this.currentPropertiesPanel = this.propertiesPanelMap.get(type);
        for (Map.Entry<String, ResourcePropertiesPanel> entry : this.propertiesPanelMap.entrySet()) {
            entry.getValue().setVisible(entry.getKey().equals(type));
        }
        if (this.currentPropertiesPanel == null) {
            this.fillerLabel.setText("Select a resource from the table above.");
            this.fillerPanel.setVisible(true);
        } else {
            this.fillerPanel.setVisible(false);
        }
        this.exceptionScrollPane.setVisible(false);
    }

    private class NameEditor
    extends TextFieldCellEditor {
        private NameEditor() {
        }

        @Override
        protected boolean valueChanged(String value) {
            if (value.equals(this.getOriginalValue())) {
                return false;
            }
            for (int row = 0; row < SettingsPanelResources.this.resourceTable.getRowCount(); ++row) {
                if (!value.equals(SettingsPanelResources.this.resourceTable.getModel().getValueAt(row, 1))) continue;
                return false;
            }
            SettingsPanelResources.this.getFrame().setSaveEnabled(true);
            return true;
        }
    }

    private class ComboBoxRenderer
    extends MirthComboBoxTableCellRenderer {
        private Object[] items;
        private JPanel panel;
        private JLabel label;

        public ComboBoxRenderer(Object[] items) {
            super(items);
            this.items = items;
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0 3 0 0, novisualpadding, hidemode 3, fill"));
            this.label = new JLabel();
            this.panel.add((Component)this.label, "grow");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == 0) {
                if (isSelected) {
                    this.panel.setBackground(table.getSelectionBackground());
                } else {
                    this.panel.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
                }
                this.label.setBackground(this.panel.getBackground());
                this.label.setText((String)value);
                return this.panel;
            }
            JComboBox comboBox = (JComboBox)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ResourceProperties properties = (ResourceProperties)table.getModel().getValueAt(row, 0);
            if (properties instanceof InvalidResourceProperties && value != null) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.items));
                list.add(value);
                comboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            } else {
                comboBox.setModel(new DefaultComboBoxModel<Object>(this.items));
            }
            if (value != null) {
                comboBox.setSelectedItem(value);
            } else {
                comboBox.setSelectedIndex(-1);
            }
            return comboBox;
        }
    }

    private class ComboBoxEditor
    extends MirthComboBoxTableCellEditor {
        private Object[] items;

        public ComboBoxEditor(JTable table, Object[] items, int clickCount, boolean focusable, ActionListener actionListener) {
            super(table, items, clickCount, focusable, actionListener);
            this.items = items;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ResourceProperties properties = (ResourceProperties)table.getModel().getValueAt(row, 0);
            if (properties instanceof InvalidResourceProperties && value != null) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.items));
                list.add(value);
                comboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            } else {
                comboBox.setModel(new DefaultComboBoxModel<Object>(this.items));
            }
            comboBox.setSelectedItem(value);
            return comboBox;
        }
    }

    private class CheckBoxRenderer
    extends JPanel
    implements TableCellRenderer {
        private MirthCheckBox checkBox;

        public CheckBoxRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = new MirthCheckBox();
            this.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true) && row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            this.checkBox.setBackground(this.getBackground());
            if (value != null) {
                this.checkBox.setSelected((Boolean)value);
            }
            return this;
        }
    }

    private class CheckBoxEditor
    extends DefaultCellEditor {
        private JPanel panel;
        private JCheckBox checkBox;

        public CheckBoxEditor() {
            super(new MirthCheckBox());
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = (JCheckBox)this.editorComponent;
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.panel.setBackground(table.getSelectionBackground());
            component.setBackground(this.panel.getBackground());
            return this.panel;
        }
    }
}

