/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.BareBonesBrowserLaunch;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.alert.DefaultAlertPanel;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTextPane;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertStatus;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.DefaultMetaData;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SettingsPanelServer
extends AbstractSettingsPanel {
    public static final String TAB_NAME = "Server";
    private List<MetaDataColumn> defaultMetaDataColumns;
    private JPanel generalPanel;
    private JLabel environmentNameLabel;
    private MirthTextField environmentNameField;
    private JLabel serverNameLabel;
    private MirthTextField serverNameField;
    private JLabel defaultAdministratorColorLabel;
    private JButton defaultAdministratorColorButton;
    private JLabel provideUsageStatsLabel;
    private ButtonGroup provideUsageStatsButtonGroup;
    private MirthRadioButton provideUsageStatsYesRadio;
    private MirthRadioButton provideUsageStatsNoRadio;
    private JLabel provideUsageStatsMoreInfoLabel;
    private JLabel administratorAutoLogoutIntervalLabel;
    private ButtonGroup administratorAutoLogoutIntervalButtonGroup;
    private MirthRadioButton administratorAutoLogoutIntervalYesRadio;
    private MirthRadioButton administratorAutoLogoutIntervalNoRadio;
    private JLabel administratorAutoLogoutIntervalTimeLabel;
    private MirthTextField administratorAutoLogoutIntervalField;
    private JPanel channelPanel;
    private JLabel clearGlobalMapLabel;
    private ButtonGroup clearGlobalMapButtonGroup;
    private MirthRadioButton clearGlobalMapYesRadio;
    private MirthRadioButton clearGlobalMapNoRadio;
    private JLabel queueBufferSizeLabel;
    private MirthTextField queueBufferSizeField;
    private JLabel defaultMetaDataLabel;
    private MirthCheckBox defaultMetaDataSourceCheckBox;
    private MirthCheckBox defaultMetaDataTypeCheckBox;
    private MirthCheckBox defaultMetaDataVersionCheckBox;
    private JPanel emailPanel;
    private JLabel smtpHostLabel;
    private MirthTextField smtpHostField;
    private JButton testEmailButton;
    private JLabel smtpPortLabel;
    private MirthTextField smtpPortField;
    private JLabel smtpTimeoutLabel;
    private MirthTextField smtpTimeoutField;
    private JLabel defaultFromAddressLabel;
    private MirthTextField defaultFromAddressField;
    private JLabel secureConnectionLabel;
    private ButtonGroup secureConnectionButtonGroup;
    private MirthRadioButton secureConnectionNoneRadio;
    private MirthRadioButton secureConnectionSSLRadio;
    private MirthRadioButton secureConnectionTLSRadio;
    private JLabel requireAuthenticationLabel;
    private ButtonGroup requireAuthenticationButtonGroup;
    private MirthRadioButton requireAuthenticationYesRadio;
    private MirthRadioButton requireAuthenticationNoRadio;
    private JLabel usernameLabel;
    private MirthTextField usernameField;
    private JLabel passwordLabel;
    private MirthPasswordField passwordField;
    private JPanel notificationPanel;
    private JLabel requireNotificationLabel;
    private ButtonGroup requireNotificationButtonGroup;
    private MirthRadioButton requireNotificationYesRadio;
    private MirthRadioButton requireNotificationNoRadio;
    private JLabel notificationLabel;
    private MirthTextPane notificationTextPane;
    private JScrollPane notificationScrollPane;

    public SettingsPanelServer(String tabName) {
        super(tabName);
        this.initComponents();
        this.initLayout();
        this.addTask("doBackup", "Backup Config", "Backup your server configuration to an XML file. The backup includes channels, alerts, code templates, server properties, global scripts, and plugin properties.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")));
        this.addTask("doRestore", "Restore Config", "Restore your server configuration from a server configuration XML file. This will remove and restore your channels, alerts, code templates, server properties, global scripts, and plugin properties.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")));
        this.addTask("doClearAllStats", "Clear All Statistics", "Reset the current and lifetime statistics for all channels.", "", new ImageIcon(Frame.class.getResource("images/chart_bar_delete.png")));
        this.provideUsageStatsMoreInfoLabel.setToolTipText("Privacy Information");
        this.provideUsageStatsMoreInfoLabel.setCursor(new Cursor(12));
        this.queueBufferSizeField.setDocument(new MirthFieldConstraints(8, false, false, true));
        this.smtpTimeoutField.setDocument(new MirthFieldConstraints(0, false, false, false));
        this.administratorAutoLogoutIntervalField.setDocument(new MirthFieldConstraints(2, false, false, true));
        this.defaultMetaDataColumns = new ArrayList<MetaDataColumn>();
    }

    @Override
    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Loading " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            ServerSettings serverSettings = null;
            UpdateSettings updateSettings = null;

            @Override
            public Void doInBackground() {
                try {
                    this.serverSettings = SettingsPanelServer.this.getFrame().mirthClient.getServerSettings();
                    this.updateSettings = SettingsPanelServer.this.getFrame().mirthClient.getUpdateSettings();
                }
                catch (ClientException e) {
                    SettingsPanelServer.this.getFrame().alertThrowable((Component)((Object)SettingsPanelServer.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                if (this.serverSettings != null && this.updateSettings != null) {
                    SettingsPanelServer.this.setServerSettings(this.serverSettings);
                    SettingsPanelServer.this.setUpdateSettings(this.updateSettings);
                }
                SettingsPanelServer.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
    }

    @Override
    public boolean doSave() {
        final ServerSettings serverSettings = this.getServerSettings();
        final UpdateSettings updateSettings = this.getUpdateSettings();
        if (serverSettings.getAdministratorAutoLogoutIntervalEnabled().booleanValue()) {
            if (serverSettings.getAdministratorAutoLogoutIntervalField() == null) {
                this.getFrame().alertWarning(this, "Please enter a valid auto logout interval time.");
                return false;
            }
            int autoLogoutInterval = serverSettings.getAdministratorAutoLogoutIntervalField();
            if (autoLogoutInterval <= 0 || autoLogoutInterval >= 61) {
                this.getFrame().alertWarning(this, "Please enter an auto logout interval time that is between 1 and 60.");
                return false;
            }
            serverSettings.setAdministratorAutoLogoutIntervalField(Integer.valueOf(autoLogoutInterval));
        }
        this.queueBufferSizeField.setBackground(null);
        if (serverSettings.getQueueBufferSize() == null) {
            this.queueBufferSizeField.setBackground(UIConstants.INVALID_COLOR);
            this.getFrame().alertWarning(this, "Please enter a valid queue buffer size.");
            return false;
        }
        try {
            String emailAddress = serverSettings.getSmtpFrom();
            if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                new InternetAddress(emailAddress).validate();
            }
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), "The Default From Address is invalid: " + e.getMessage());
            return false;
        }
        final String workingId = this.getFrame().startWorking("Saving " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private boolean usingServerDefaultColor = true;

            @Override
            public Void doInBackground() {
                try {
                    SettingsPanelServer.this.getFrame().mirthClient.setServerSettings(serverSettings);
                    String environmentName = SettingsPanelServer.this.environmentNameField.getText();
                    String serverName = SettingsPanelServer.this.serverNameField.getText();
                    StringBuilder titleText = new StringBuilder();
                    StringBuilder statusBarText = new StringBuilder();
                    statusBarText.append("Connected to: ");
                    if (!StringUtils.isBlank((CharSequence)environmentName)) {
                        titleText.append(environmentName + " - ");
                        statusBarText.append(environmentName);
                        if (!StringUtils.isBlank((CharSequence)serverName)) {
                            statusBarText.append(" - ");
                        } else {
                            statusBarText.append(" | ");
                        }
                        PlatformUI.ENVIRONMENT_NAME = environmentName;
                    }
                    if (!StringUtils.isBlank((CharSequence)serverName)) {
                        titleText.append(serverName);
                        statusBarText.append(serverName + " | ");
                        PlatformUI.SERVER_NAME = serverName;
                    } else {
                        titleText.append(PlatformUI.SERVER_URL);
                    }
                    titleText.append(" - BridgeLink Administrator");
                    statusBarText.append(PlatformUI.SERVER_URL);
                    titleText.append(" - (" + PlatformUI.SERVER_VERSION + ")");
                    SettingsPanelServer.this.getFrame().setTitle(titleText.toString());
                    User currentUser = SettingsPanelServer.this.getFrame().mirthClient.getCurrentUser();
                    statusBarText.append(" as " + currentUser.getUsername());
                    if (!StringUtils.isBlank((CharSequence)currentUser.getFirstName()) || !StringUtils.isBlank((CharSequence)currentUser.getLastName())) {
                        if (!StringUtils.isBlank((CharSequence)currentUser.getFirstName())) {
                            statusBarText.append(" (" + currentUser.getFirstName());
                            if (!StringUtils.isBlank((CharSequence)currentUser.getLastName())) {
                                statusBarText.append(" " + currentUser.getLastName() + ")");
                            } else {
                                statusBarText.append(")");
                            }
                        } else {
                            statusBarText.append(" (" + currentUser.getLastName() + ")");
                        }
                    }
                    SettingsPanelServer.this.getFrame().statusBar.setServerText(statusBarText.toString());
                    SettingsPanelServer.this.getFrame().mirthClient.setUpdateSettings(updateSettings);
                }
                catch (Exception e) {
                    SettingsPanelServer.this.getFrame().alertThrowable((Component)((Object)SettingsPanelServer.this.getFrame()), e);
                }
                try {
                    Color backgroundColor;
                    String backgroundColorStr;
                    Color defaultBackgroundColor = serverSettings.getDefaultAdministratorBackgroundColor();
                    if (defaultBackgroundColor != null) {
                        PlatformUI.DEFAULT_BACKGROUND_COLOR = defaultBackgroundColor;
                    }
                    if (StringUtils.isNotBlank((CharSequence)(backgroundColorStr = SettingsPanelServer.this.getFrame().mirthClient.getUserPreference(SettingsPanelServer.this.getFrame().getCurrentUser((Component)((Object)SettingsPanelServer.this.getFrame())).getId(), "backgroundColor"))) && (backgroundColor = (Color)ObjectXMLSerializer.getInstance().deserialize(backgroundColorStr, Color.class)) != null) {
                        this.usingServerDefaultColor = false;
                    }
                }
                catch (Exception e) {
                    SettingsPanelServer.this.getFrame().alertThrowable((Component)((Object)SettingsPanelServer.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                if (this.usingServerDefaultColor) {
                    SettingsPanelServer.this.getFrame().setupBackgroundPainters(PlatformUI.DEFAULT_BACKGROUND_COLOR);
                }
                SettingsPanelServer.this.setSaveEnabled(false);
                SettingsPanelServer.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
        return true;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        if (serverSettings.getEnvironmentName() != null) {
            this.environmentNameField.setText(serverSettings.getEnvironmentName());
        } else {
            this.environmentNameField.setText("");
        }
        if (serverSettings.getServerName() != null) {
            this.serverNameField.setText(serverSettings.getServerName());
        } else {
            this.serverNameField.setText("");
        }
        if (serverSettings.getDefaultAdministratorBackgroundColor() != null) {
            this.defaultAdministratorColorButton.setBackground(serverSettings.getDefaultAdministratorBackgroundColor());
        } else {
            this.defaultAdministratorColorButton.setBackground(ServerSettings.DEFAULT_COLOR);
        }
        if (serverSettings.getSmtpHost() != null) {
            this.smtpHostField.setText(serverSettings.getSmtpHost());
        } else {
            this.smtpHostField.setText("");
        }
        if (serverSettings.getSmtpPort() != null) {
            this.smtpPortField.setText(serverSettings.getSmtpPort());
        } else {
            this.smtpPortField.setText("");
        }
        if (serverSettings.getSmtpTimeout() != null) {
            this.smtpTimeoutField.setText(serverSettings.getSmtpTimeout().toString());
        } else {
            this.smtpTimeoutField.setText("");
        }
        if (serverSettings.getSmtpFrom() != null) {
            this.defaultFromAddressField.setText(serverSettings.getSmtpFrom());
        } else {
            this.defaultFromAddressField.setText("");
        }
        String smtpSecure = serverSettings.getSmtpSecure();
        if (smtpSecure != null && smtpSecure.equalsIgnoreCase("tls")) {
            this.secureConnectionTLSRadio.setSelected(true);
        } else if (smtpSecure != null && smtpSecure.equalsIgnoreCase("ssl")) {
            this.secureConnectionSSLRadio.setSelected(true);
        } else {
            this.secureConnectionNoneRadio.setSelected(true);
        }
        if (serverSettings.getSmtpAuth() != null && serverSettings.getSmtpAuth().booleanValue()) {
            this.requireAuthenticationYesRadio.setSelected(true);
            this.requireAuthenticationYesRadioActionPerformed(null);
        } else {
            this.requireAuthenticationNoRadio.setSelected(true);
            this.requireAuthenticationNoRadioActionPerformed(null);
        }
        if (serverSettings.getClearGlobalMap() != null && !serverSettings.getClearGlobalMap().booleanValue()) {
            this.clearGlobalMapNoRadio.setSelected(true);
        } else {
            this.clearGlobalMapYesRadio.setSelected(true);
        }
        if (serverSettings.getQueueBufferSize() != null) {
            this.queueBufferSizeField.setText(serverSettings.getQueueBufferSize().toString());
        } else {
            this.queueBufferSizeField.setText("");
        }
        List defaultMetaDataColumns = serverSettings.getDefaultMetaDataColumns();
        this.defaultMetaDataColumns = defaultMetaDataColumns != null ? new ArrayList<MetaDataColumn>(defaultMetaDataColumns) : new ArrayList<MetaDataColumn>(DefaultMetaData.DEFAULT_COLUMNS);
        this.defaultMetaDataSourceCheckBox.setSelected(this.defaultMetaDataColumns.contains(DefaultMetaData.SOURCE_COLUMN));
        this.defaultMetaDataTypeCheckBox.setSelected(this.defaultMetaDataColumns.contains(DefaultMetaData.TYPE_COLUMN));
        this.defaultMetaDataVersionCheckBox.setSelected(this.defaultMetaDataColumns.contains(DefaultMetaData.VERSION_COLUMN));
        if (serverSettings.getSmtpUsername() != null) {
            this.usernameField.setText(serverSettings.getSmtpUsername());
        } else {
            this.usernameField.setText("");
        }
        if (serverSettings.getSmtpPassword() != null) {
            this.passwordField.setText(serverSettings.getSmtpPassword());
        } else {
            this.passwordField.setText("");
        }
        if (serverSettings.getLoginNotificationEnabled().booleanValue()) {
            this.requireNotificationYesRadio.setSelected(true);
            this.notificationLabel.setEnabled(true);
            this.notificationTextPane.setEnabled(true);
        } else {
            this.requireNotificationNoRadio.setSelected(true);
            this.notificationLabel.setEnabled(false);
            this.notificationTextPane.setEnabled(false);
        }
        if (serverSettings.getLoginNotificationMessage() != null) {
            this.notificationTextPane.setText(serverSettings.getLoginNotificationMessage());
        } else {
            this.notificationTextPane.setText("");
        }
        if (serverSettings.getAdministratorAutoLogoutIntervalEnabled().booleanValue()) {
            this.administratorAutoLogoutIntervalYesRadio.setSelected(true);
            this.administratorAutoLogoutIntervalTimeLabel.setEnabled(true);
            this.administratorAutoLogoutIntervalField.setEnabled(true);
        } else {
            this.administratorAutoLogoutIntervalNoRadio.setSelected(true);
            this.administratorAutoLogoutIntervalTimeLabel.setEnabled(false);
            this.administratorAutoLogoutIntervalField.setEnabled(false);
        }
        if (serverSettings.getAdministratorAutoLogoutIntervalField() != null) {
            this.administratorAutoLogoutIntervalField.setText(serverSettings.getAdministratorAutoLogoutIntervalField().toString());
        } else {
            this.administratorAutoLogoutIntervalField.setText("");
        }
        this.resetInvalidSettings();
    }

    public void setUpdateSettings(UpdateSettings updateSettings) {
        if (updateSettings.getStatsEnabled() != null && !updateSettings.getStatsEnabled().booleanValue()) {
            this.provideUsageStatsNoRadio.setSelected(true);
        } else {
            this.provideUsageStatsYesRadio.setSelected(false);
        }
    }

    public ServerSettings getServerSettings() {
        ServerSettings serverSettings = new ServerSettings();
        serverSettings.setEnvironmentName(this.environmentNameField.getText());
        serverSettings.setServerName(this.serverNameField.getText());
        serverSettings.setDefaultAdministratorBackgroundColor(this.defaultAdministratorColorButton.getBackground());
        serverSettings.setClearGlobalMap(Boolean.valueOf(this.clearGlobalMapYesRadio.isSelected()));
        int queueBufferSize = NumberUtils.toInt((String)this.queueBufferSizeField.getText(), (int)0);
        if (queueBufferSize == 0) {
            serverSettings.setQueueBufferSize(null);
        } else {
            serverSettings.setQueueBufferSize(Integer.valueOf(queueBufferSize));
        }
        ArrayList<MetaDataColumn> defaultMetaDataColumns = new ArrayList<MetaDataColumn>();
        if (this.defaultMetaDataSourceCheckBox.isSelected()) {
            defaultMetaDataColumns.add(DefaultMetaData.SOURCE_COLUMN);
        } else {
            this.defaultMetaDataColumns.remove(DefaultMetaData.SOURCE_COLUMN);
        }
        if (this.defaultMetaDataTypeCheckBox.isSelected()) {
            defaultMetaDataColumns.add(DefaultMetaData.TYPE_COLUMN);
        } else {
            this.defaultMetaDataColumns.remove(DefaultMetaData.TYPE_COLUMN);
        }
        if (this.defaultMetaDataVersionCheckBox.isSelected()) {
            defaultMetaDataColumns.add(DefaultMetaData.VERSION_COLUMN);
        } else {
            this.defaultMetaDataColumns.remove(DefaultMetaData.VERSION_COLUMN);
        }
        for (MetaDataColumn column : this.defaultMetaDataColumns) {
            if (defaultMetaDataColumns.contains(column)) continue;
            defaultMetaDataColumns.add(column);
        }
        this.defaultMetaDataColumns = defaultMetaDataColumns;
        serverSettings.setDefaultMetaDataColumns(this.defaultMetaDataColumns);
        serverSettings.setSmtpHost(this.smtpHostField.getText());
        serverSettings.setSmtpPort(this.smtpPortField.getText());
        serverSettings.setSmtpTimeout(this.smtpTimeoutField.getText());
        serverSettings.setSmtpFrom(this.defaultFromAddressField.getText());
        if (this.secureConnectionTLSRadio.isSelected()) {
            serverSettings.setSmtpSecure("tls");
        } else if (this.secureConnectionSSLRadio.isSelected()) {
            serverSettings.setSmtpSecure("ssl");
        } else {
            serverSettings.setSmtpSecure("none");
        }
        if (this.requireAuthenticationYesRadio.isSelected()) {
            serverSettings.setSmtpAuth(Boolean.valueOf(true));
            serverSettings.setSmtpUsername(this.usernameField.getText());
            serverSettings.setSmtpPassword(new String(this.passwordField.getPassword()));
        } else {
            serverSettings.setSmtpAuth(Boolean.valueOf(false));
            serverSettings.setSmtpUsername("");
            serverSettings.setSmtpPassword("");
        }
        if (this.requireNotificationYesRadio.isSelected()) {
            serverSettings.setLoginNotificationEnabled(Boolean.valueOf(true));
        } else {
            serverSettings.setLoginNotificationEnabled(Boolean.valueOf(false));
        }
        serverSettings.setLoginNotificationMessage(this.notificationTextPane.getText().toString());
        if (this.administratorAutoLogoutIntervalYesRadio.isSelected()) {
            serverSettings.setAdministratorAutoLogoutIntervalEnabled(Boolean.valueOf(true));
        } else {
            serverSettings.setAdministratorAutoLogoutIntervalEnabled(Boolean.valueOf(false));
        }
        try {
            serverSettings.setAdministratorAutoLogoutIntervalField(Integer.valueOf(Integer.parseInt(this.administratorAutoLogoutIntervalField.getText().toString())));
        }
        catch (NumberFormatException e) {
            serverSettings.setAdministratorAutoLogoutIntervalField(null);
        }
        return serverSettings;
    }

    public UpdateSettings getUpdateSettings() {
        UpdateSettings updateSettings = new UpdateSettings();
        updateSettings.setStatsEnabled(Boolean.valueOf(false));
        return updateSettings;
    }

    public void doBackup() {
        int option;
        if (this.isSaveEnabled() && ((option = JOptionPane.showConfirmDialog(this, "Would you like to save the settings first?")) == 0 ? !this.doSave() : option == 2 || option == -1)) {
            return;
        }
        final String backupDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        final File exportFile = this.getFrame().createFileForExport(backupDate.substring(0, 10) + " Mirth Backup.xml", "XML");
        if (exportFile != null) {
            final String workingId = this.getFrame().startWorking("Exporting server config...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    ServerConfiguration configuration = null;
                    try {
                        configuration = SettingsPanelServer.this.getFrame().mirthClient.getServerConfiguration();
                    }
                    catch (ClientException e) {
                        SettingsPanelServer.this.getFrame().alertThrowable(SettingsPanelServer.this, e);
                        return null;
                    }
                    for (Channel channel : configuration.getChannels()) {
                        SettingsPanelServer.this.getFrame().updateResourceNames(channel, (List<ResourceProperties>)configuration.getResourceProperties().getList());
                    }
                    configuration.setDate(backupDate);
                    String backupXML = ObjectXMLSerializer.getInstance().serialize((Object)configuration);
                    SettingsPanelServer.this.getFrame().exportFile(backupXML, exportFile, "Server Configuration");
                    return null;
                }

                @Override
                public void done() {
                    SettingsPanelServer.this.getFrame().stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }

    public void doRestore() {
        String content;
        if (this.getFrame().isSaveEnabled()) {
            if (!this.getFrame().alertOkCancel(this, "Your new settings will first be saved.  Continue?")) {
                return;
            }
            if (!this.doSave()) {
                return;
            }
        }
        if ((content = this.getFrame().browseForFileString("XML")) != null) {
            try {
                if (!this.getFrame().promptObjectMigration(content, "server configuration")) {
                    return;
                }
                final ServerConfiguration configuration = (ServerConfiguration)ObjectXMLSerializer.getInstance().deserialize(content, ServerConfiguration.class);
                final JCheckBox deployChannelsCheckBox = new JCheckBox("Deploy all channels after import");
                deployChannelsCheckBox.setSelected(true);
                final JCheckBox overwriteConfigMap = new JCheckBox("Overwrite Configuration Map");
                overwriteConfigMap.setSelected(false);
                String warningMessage = "Import configuration from " + configuration.getDate() + "?\nWARNING: This will overwrite all current channels,\nalerts, server properties, and plugin properties.\n";
                Object[] params = new Object[]{warningMessage, new JLabel(" "), deployChannelsCheckBox, overwriteConfigMap};
                int option = JOptionPane.showConfirmDialog(this, params, "Select an Option", 0);
                if (option == 0) {
                    final HashSet<String> alertIds = new HashSet<String>();
                    for (AlertStatus alertStatus : PlatformUI.MIRTH_FRAME.mirthClient.getAlertStatusList()) {
                        alertIds.add(alertStatus.getId());
                    }
                    final String workingId = this.getFrame().startWorking("Restoring server config...");
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                        private boolean updateAlerts = false;

                        @Override
                        public Void doInBackground() {
                            try {
                                SettingsPanelServer.this.getFrame().mirthClient.setServerConfiguration(configuration, deployChannelsCheckBox.isSelected(), overwriteConfigMap.isSelected());
                                SettingsPanelServer.this.getFrame().channelPanel.clearChannelCache();
                                SettingsPanelServer.this.doRefresh();
                                SettingsPanelServer.this.getFrame().alertInformation(SettingsPanelServer.this, "Your configuration was successfully restored.");
                                this.updateAlerts = true;
                            }
                            catch (ClientException e) {
                                SettingsPanelServer.this.getFrame().alertThrowable(SettingsPanelServer.this, e);
                            }
                            return null;
                        }

                        @Override
                        public void done() {
                            if (SettingsPanelServer.this.getFrame().alertPanel == null) {
                                SettingsPanelServer.this.getFrame().alertPanel = new DefaultAlertPanel();
                            }
                            if (this.updateAlerts) {
                                SettingsPanelServer.this.getFrame().alertPanel.updateAlertDetails(alertIds);
                            }
                            SettingsPanelServer.this.getFrame().stopWorking(workingId);
                        }
                    };
                    worker.execute();
                }
            }
            catch (Exception e) {
                this.getFrame().alertError(this, "Invalid server configuration file.");
            }
        }
    }

    public void doClearAllStats() {
        String result = DisplayUtil.showInputDialog(this, "<html>This will reset all channel statistics (including lifetime statistics) for<br>all channels (including undeployed channels).<br><font size='1'><br></font>Type CLEAR and click the OK button to continue.</html>", "Clear All Statistics", 2);
        if (result != null) {
            if (!result.equals("CLEAR")) {
                this.getFrame().alertWarning(this, "You must type CLEAR to clear all statistics.");
                return;
            }
            final String workingId = this.getFrame().startWorking("Clearing all statistics...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                private Exception exception = null;

                @Override
                public Void doInBackground() {
                    try {
                        SettingsPanelServer.this.getFrame().mirthClient.clearAllStatistics();
                    }
                    catch (ClientException e) {
                        this.exception = e;
                        SettingsPanelServer.this.getFrame().alertThrowable(SettingsPanelServer.this, e);
                    }
                    return null;
                }

                @Override
                public void done() {
                    SettingsPanelServer.this.getFrame().stopWorking(workingId);
                    if (this.exception == null) {
                        SettingsPanelServer.this.getFrame().alertInformation(SettingsPanelServer.this, "All current and lifetime statistics have been cleared for all channels.");
                    }
                }
            };
            worker.execute();
        }
    }

    private void resetInvalidSettings() {
        this.queueBufferSizeField.setBackground(null);
        this.smtpHostField.setBackground(null);
        this.smtpPortField.setBackground(null);
        this.smtpTimeoutField.setBackground(null);
        this.defaultFromAddressField.setBackground(null);
        this.usernameField.setBackground(null);
        this.passwordField.setBackground(null);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.generalPanel = new JPanel();
        this.generalPanel.setBackground(this.getBackground());
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "General", 0, 0, new Font("Tahoma", 1, 11)));
        this.environmentNameLabel = new JLabel("Environment name:");
        this.environmentNameField = new MirthTextField();
        this.environmentNameField.setToolTipText("<html>The name of this BridgeLink environment. There is one environment name per BridgeLink database.</html>");
        this.serverNameLabel = new JLabel("Server name:");
        this.serverNameField = new MirthTextField();
        this.serverNameField.setToolTipText("<html>The server name which will appear in the Administrator title, taskbar/dock<br>and desktop shortcut. This setting applies for all users on this server.</html>");
        this.defaultAdministratorColorLabel = new JLabel("Default Background Color:");
        this.defaultAdministratorColorButton = new JButton();
        this.defaultAdministratorColorButton.setBackground(ServerSettings.DEFAULT_COLOR);
        this.defaultAdministratorColorButton.setToolTipText("<html>The default Administrator GUI background color this server should use.<br/>Users can override this with their own custom background color.</html>");
        this.defaultAdministratorColorButton.setCursor(Cursor.getPredefinedCursor(12));
        this.defaultAdministratorColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color color = JColorChooser.showDialog((Component)((Object)PlatformUI.MIRTH_FRAME), "Edit Background Color", SettingsPanelServer.this.defaultAdministratorColorButton.getBackground());
                if (color != null) {
                    SettingsPanelServer.this.defaultAdministratorColorButton.setBackground(color);
                    SettingsPanelServer.this.getFrame().setSaveEnabled(true);
                }
            }
        });
        this.provideUsageStatsLabel = new JLabel("Provide usage statistics:");
        this.provideUsageStatsLabel.setVisible(false);
        this.provideUsageStatsButtonGroup = new ButtonGroup();
        this.provideUsageStatsYesRadio = new MirthRadioButton("Yes");
        this.provideUsageStatsYesRadio.setBackground(this.getBackground());
        this.provideUsageStatsYesRadio.setToolTipText("<html>Toggles was used to send usage statistics to NextGen Healthcare. Disabled it in BrdgeLink.</html>");
        this.provideUsageStatsButtonGroup.add(this.provideUsageStatsYesRadio);
        this.provideUsageStatsYesRadio.setVisible(false);
        this.provideUsageStatsNoRadio = new MirthRadioButton("No");
        this.provideUsageStatsNoRadio.setBackground(this.getBackground());
        this.provideUsageStatsNoRadio.setToolTipText("<html>Toggles was used to send usage statistics to NextGen Healthcare. Disabled it in BrdgeLink.</html>");
        this.provideUsageStatsButtonGroup.add(this.provideUsageStatsNoRadio);
        this.provideUsageStatsNoRadio.setVisible(false);
        this.provideUsageStatsMoreInfoLabel = new JLabel("<html><font color=blue><u>More Info</u></font></html>");
        this.provideUsageStatsMoreInfoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SettingsPanelServer.this.provideUsageStatsMoreInfoLabelMouseClicked(evt);
            }
        });
        this.provideUsageStatsMoreInfoLabel.setVisible(false);
        this.administratorAutoLogoutIntervalLabel = new JLabel("Enable Auto Logout:");
        this.administratorAutoLogoutIntervalButtonGroup = new ButtonGroup();
        this.administratorAutoLogoutIntervalYesRadio = new MirthRadioButton("Yes");
        this.administratorAutoLogoutIntervalYesRadio.setBackground(this.getBackground());
        this.administratorAutoLogoutIntervalYesRadio.setToolTipText("<html>Toggles automatically logging out the user due to inactivity.</html>");
        this.administratorAutoLogoutIntervalYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.requireAdministratorAutoLogoutIntervalYesRadioActionPerformed(evt);
            }
        });
        this.administratorAutoLogoutIntervalButtonGroup.add(this.administratorAutoLogoutIntervalYesRadio);
        this.administratorAutoLogoutIntervalNoRadio = new MirthRadioButton("No");
        this.administratorAutoLogoutIntervalNoRadio.setBackground(this.getBackground());
        this.administratorAutoLogoutIntervalNoRadio.setToolTipText("<html>Toggles automatically logging out the user due to inactivity.</html>");
        this.administratorAutoLogoutIntervalNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.requireAdministratorAutoLogoutIntervalNoRadioActionPerformed(evt);
            }
        });
        this.administratorAutoLogoutIntervalButtonGroup.add(this.administratorAutoLogoutIntervalNoRadio);
        this.administratorAutoLogoutIntervalTimeLabel = new JLabel("Auto Logout Interval (minutes):");
        this.administratorAutoLogoutIntervalField = new MirthTextField();
        this.administratorAutoLogoutIntervalField.setToolTipText("<html>Interval in minutes to automatically logout the user due to inactivity.</html>");
        this.channelPanel = new JPanel();
        this.channelPanel.setBackground(this.getBackground());
        this.channelPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Channel", 0, 0, new Font("Tahoma", 1, 11)));
        this.clearGlobalMapLabel = new JLabel("Clear global map on redeploy:");
        this.clearGlobalMapButtonGroup = new ButtonGroup();
        this.clearGlobalMapYesRadio = new MirthRadioButton("Yes");
        this.clearGlobalMapYesRadio.setBackground(this.getBackground());
        this.clearGlobalMapYesRadio.setSelected(true);
        this.clearGlobalMapYesRadio.setToolTipText("Toggles clearing the global map when redeploying all channels.");
        this.clearGlobalMapButtonGroup.add(this.clearGlobalMapYesRadio);
        this.clearGlobalMapNoRadio = new MirthRadioButton("No");
        this.clearGlobalMapNoRadio.setBackground(this.getBackground());
        this.clearGlobalMapNoRadio.setToolTipText("Toggles clearing the global map when redeploying all channels.");
        this.clearGlobalMapButtonGroup.add(this.clearGlobalMapNoRadio);
        this.queueBufferSizeLabel = new JLabel("Default Queue Buffer Size:");
        this.queueBufferSizeField = new MirthTextField();
        this.queueBufferSizeField.setToolTipText("The default source/destination queue buffer size to use for new channels.");
        this.defaultMetaDataLabel = new JLabel("Default Metadata Columns:");
        this.defaultMetaDataSourceCheckBox = new MirthCheckBox("Source");
        this.defaultMetaDataSourceCheckBox.setBackground(this.getBackground());
        this.defaultMetaDataSourceCheckBox.setToolTipText("<html>If checked, the Source metadata column will be added by<br/>default when a user creates a new channel. The user can<br/>choose to remove the column on the channel's Summary tab.</html>");
        this.defaultMetaDataTypeCheckBox = new MirthCheckBox("Type");
        this.defaultMetaDataTypeCheckBox.setBackground(this.getBackground());
        this.defaultMetaDataTypeCheckBox.setToolTipText("<html>If checked, the Type metadata column will be added by<br/>default when a user creates a new channel. The user can<br/>choose to remove the column on the channel's Summary tab.</html>");
        this.defaultMetaDataVersionCheckBox = new MirthCheckBox("Version");
        this.defaultMetaDataVersionCheckBox.setBackground(this.getBackground());
        this.defaultMetaDataVersionCheckBox.setToolTipText("<html>If checked, the Version metadata column will be added by<br/>default when a user creates a new channel. The user can<br/>choose to remove the column on the channel's Summary tab.</html>");
        this.emailPanel = new JPanel();
        this.emailPanel.setBackground(this.getBackground());
        this.emailPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Email", 0, 0, new Font("Tahoma", 1, 11)));
        this.smtpHostLabel = new JLabel("SMTP Host:");
        this.smtpHostField = new MirthTextField();
        this.smtpHostField.setToolTipText("SMTP host used for global SMTP settings.");
        this.testEmailButton = new JButton("Send Test Email");
        this.testEmailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.testEmailButtonActionPerformed(evt);
            }
        });
        this.smtpPortLabel = new JLabel("SMTP Port:");
        this.smtpPortField = new MirthTextField();
        this.smtpPortField.setToolTipText("SMTP port used for global SMTP settings.");
        this.smtpTimeoutLabel = new JLabel("Send Timeout (ms):");
        this.smtpTimeoutField = new MirthTextField();
        this.smtpTimeoutField.setToolTipText("SMTP socket connection timeout in milliseconds used for global SMTP settings.");
        this.defaultFromAddressLabel = new JLabel("Default From Address:");
        this.defaultFromAddressField = new MirthTextField();
        this.defaultFromAddressField.setToolTipText("Default \"from\" email address used for global SMTP settings.");
        this.secureConnectionLabel = new JLabel("Secure Connection:");
        this.secureConnectionButtonGroup = new ButtonGroup();
        this.secureConnectionNoneRadio = new MirthRadioButton("None");
        this.secureConnectionNoneRadio.setBackground(this.getBackground());
        this.secureConnectionNoneRadio.setSelected(true);
        this.secureConnectionNoneRadio.setToolTipText("Toggles STARTTLS and SSL connections for global SMTP settings.");
        this.secureConnectionButtonGroup.add(this.secureConnectionNoneRadio);
        this.secureConnectionTLSRadio = new MirthRadioButton("STARTTLS");
        this.secureConnectionTLSRadio.setBackground(this.getBackground());
        this.secureConnectionTLSRadio.setToolTipText("Toggles STARTTLS and SSL connections for global SMTP settings.");
        this.secureConnectionButtonGroup.add(this.secureConnectionTLSRadio);
        this.secureConnectionSSLRadio = new MirthRadioButton("SSL");
        this.secureConnectionSSLRadio.setBackground(this.getBackground());
        this.secureConnectionSSLRadio.setToolTipText("Toggles STARTTLS and SSL connections for global SMTP settings.");
        this.secureConnectionButtonGroup.add(this.secureConnectionSSLRadio);
        this.requireAuthenticationLabel = new JLabel("Require Authentication:");
        this.requireAuthenticationButtonGroup = new ButtonGroup();
        this.requireAuthenticationYesRadio = new MirthRadioButton("Yes");
        this.requireAuthenticationYesRadio.setBackground(this.getBackground());
        this.requireAuthenticationYesRadio.setSelected(true);
        this.requireAuthenticationYesRadio.setToolTipText("Toggles authentication for global SMTP settings.");
        this.requireAuthenticationYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.requireAuthenticationYesRadioActionPerformed(evt);
            }
        });
        this.requireAuthenticationButtonGroup.add(this.requireAuthenticationYesRadio);
        this.requireAuthenticationNoRadio = new MirthRadioButton("No");
        this.requireAuthenticationNoRadio.setBackground(this.getBackground());
        this.requireAuthenticationNoRadio.setToolTipText("Toggles authentication for global SMTP settings.");
        this.requireAuthenticationNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.requireAuthenticationNoRadioActionPerformed(evt);
            }
        });
        this.requireAuthenticationButtonGroup.add(this.requireAuthenticationNoRadio);
        this.usernameLabel = new JLabel("Username:");
        this.usernameField = new MirthTextField();
        this.usernameField.setToolTipText("Username for global SMTP settings.");
        this.passwordLabel = new JLabel("Password:");
        this.passwordField = new MirthPasswordField();
        this.passwordField.setToolTipText("Password for global SMTP settings.");
        this.notificationPanel = new JPanel();
        this.notificationPanel.setBackground(this.getBackground());
        this.notificationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Notification", 0, 0, new Font("Tahoma", 1, 11)));
        this.requireNotificationLabel = new JLabel("Require Login Notification and Consent:");
        this.requireNotificationButtonGroup = new ButtonGroup();
        this.requireNotificationYesRadio = new MirthRadioButton("Yes");
        this.requireNotificationYesRadio.setBackground(this.getBackground());
        this.requireNotificationYesRadio.setSelected(true);
        this.requireNotificationYesRadio.setToolTipText("Require login notification.");
        this.requireNotificationYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.requireNotificationYesRadioActionPerformed(evt);
            }
        });
        this.requireNotificationButtonGroup.add(this.requireNotificationYesRadio);
        this.requireNotificationNoRadio = new MirthRadioButton("No");
        this.requireNotificationNoRadio.setBackground(this.getBackground());
        this.requireNotificationNoRadio.setToolTipText("Do not require login notification.");
        this.requireNotificationNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelServer.this.requireNotificationNoRadioActionPerformed(evt);
            }
        });
        this.requireNotificationButtonGroup.add(this.requireNotificationNoRadio);
        this.notificationLabel = new JLabel("Login Notification:");
        this.notificationTextPane = new MirthTextPane();
        this.notificationScrollPane = new JScrollPane(this.notificationTextPane);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "", "[][][][grow]"));
        this.generalPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]12[][grow]", ""));
        this.generalPanel.add((Component)this.environmentNameLabel, "right");
        this.generalPanel.add((Component)this.environmentNameField, "w 168!");
        this.generalPanel.add((Component)this.serverNameLabel, "newline, right");
        this.generalPanel.add((Component)this.serverNameField, "w 168!");
        this.generalPanel.add((Component)this.defaultAdministratorColorLabel, "newline, right");
        this.generalPanel.add((Component)this.defaultAdministratorColorButton, "h 22!, w 22!");
        this.generalPanel.add((Component)this.provideUsageStatsLabel, "newline, right");
        this.generalPanel.add((Component)this.provideUsageStatsYesRadio, "split 3");
        this.generalPanel.add(this.provideUsageStatsNoRadio);
        this.generalPanel.add((Component)this.provideUsageStatsMoreInfoLabel, "gapbefore 12");
        this.generalPanel.add((Component)this.administratorAutoLogoutIntervalLabel, "newline, right");
        this.generalPanel.add((Component)this.administratorAutoLogoutIntervalYesRadio, "split 3");
        this.generalPanel.add(this.administratorAutoLogoutIntervalNoRadio);
        this.generalPanel.add((Component)this.administratorAutoLogoutIntervalTimeLabel, "newline, right");
        this.generalPanel.add((Component)this.administratorAutoLogoutIntervalField, "w 30!");
        this.add((Component)this.generalPanel, "growx");
        this.channelPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]12[][grow]", ""));
        this.channelPanel.add((Component)this.clearGlobalMapLabel, "right");
        this.channelPanel.add((Component)this.clearGlobalMapYesRadio, "split 2");
        this.channelPanel.add(this.clearGlobalMapNoRadio);
        this.channelPanel.add((Component)this.queueBufferSizeLabel, "newline, right");
        this.channelPanel.add((Component)this.queueBufferSizeField, "w 50!");
        this.channelPanel.add((Component)this.defaultMetaDataLabel, "newline, right");
        this.channelPanel.add((Component)this.defaultMetaDataSourceCheckBox, "split 3");
        this.channelPanel.add(this.defaultMetaDataTypeCheckBox);
        this.channelPanel.add(this.defaultMetaDataVersionCheckBox);
        this.add((Component)this.channelPanel, "newline, growx");
        this.emailPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]12[][grow]", "[][][][][][][][][grow]"));
        this.emailPanel.add((Component)this.smtpHostLabel, "right");
        this.emailPanel.add((Component)this.smtpHostField, "w 117!, split 2");
        this.emailPanel.add(this.testEmailButton);
        this.emailPanel.add((Component)this.smtpPortLabel, "newline, right");
        this.emailPanel.add((Component)this.smtpPortField, "w 50!");
        this.emailPanel.add((Component)this.smtpTimeoutLabel, "newline, right");
        this.emailPanel.add((Component)this.smtpTimeoutField, "w 75!");
        this.emailPanel.add((Component)this.defaultFromAddressLabel, "newline, right");
        this.emailPanel.add((Component)this.defaultFromAddressField, "w 117!");
        this.emailPanel.add((Component)this.secureConnectionLabel, "newline, right");
        this.emailPanel.add((Component)this.secureConnectionNoneRadio, "split 3");
        this.emailPanel.add(this.secureConnectionTLSRadio);
        this.emailPanel.add(this.secureConnectionSSLRadio);
        this.emailPanel.add((Component)this.requireAuthenticationLabel, "newline, right");
        this.emailPanel.add((Component)this.requireAuthenticationYesRadio, "split 2");
        this.emailPanel.add(this.requireAuthenticationNoRadio);
        this.emailPanel.add((Component)this.usernameLabel, "newline, right");
        this.emailPanel.add((Component)this.usernameField, "w 117!");
        this.emailPanel.add((Component)this.passwordLabel, "newline, right");
        this.emailPanel.add((Component)this.passwordField, "w 117!");
        this.add((Component)this.emailPanel, "newline, growx");
        this.notificationPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]12[][grow]", ""));
        this.notificationPanel.add((Component)this.requireNotificationLabel, "right");
        this.notificationPanel.add((Component)this.requireNotificationYesRadio, "split 2");
        this.notificationPanel.add(this.requireNotificationNoRadio);
        this.notificationPanel.add((Component)this.notificationLabel, "newline, top, right");
        this.notificationPanel.add((Component)this.notificationScrollPane, "grow, sx, push, h 100%");
        this.add((Component)this.notificationPanel, "newline, growx");
    }

    private void provideUsageStatsMoreInfoLabelMouseClicked(MouseEvent evt) {
        BareBonesBrowserLaunch.openURL("https://www.innovarhealthcare.com");
    }

    private void requireAuthenticationNoRadioActionPerformed(ActionEvent evt) {
        this.usernameField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.usernameLabel.setEnabled(false);
        this.passwordLabel.setEnabled(false);
    }

    private void requireAuthenticationYesRadioActionPerformed(ActionEvent evt) {
        this.usernameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.usernameLabel.setEnabled(true);
        this.passwordLabel.setEnabled(true);
    }

    private void requireNotificationNoRadioActionPerformed(ActionEvent evt) {
        this.notificationLabel.setEnabled(false);
        this.notificationTextPane.setEnabled(false);
    }

    private void requireNotificationYesRadioActionPerformed(ActionEvent evt) {
        this.notificationLabel.setEnabled(true);
        this.notificationTextPane.setEnabled(true);
    }

    private void requireAdministratorAutoLogoutIntervalNoRadioActionPerformed(ActionEvent evt) {
        this.administratorAutoLogoutIntervalTimeLabel.setEnabled(false);
        this.administratorAutoLogoutIntervalField.setEnabled(false);
    }

    private void requireAdministratorAutoLogoutIntervalYesRadioActionPerformed(ActionEvent evt) {
        this.administratorAutoLogoutIntervalTimeLabel.setEnabled(true);
        this.administratorAutoLogoutIntervalField.setEnabled(true);
    }

    private void testEmailButtonActionPerformed(ActionEvent evt) {
        String errors;
        this.resetInvalidSettings();
        ServerSettings serverSettings = this.getServerSettings();
        StringBuilder invalidFields = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpHost())) {
            this.smtpHostField.setBackground(UIConstants.INVALID_COLOR);
            invalidFields.append("\"SMTP Host\" is required\n");
        }
        if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpPort())) {
            this.smtpPortField.setBackground(UIConstants.INVALID_COLOR);
            invalidFields.append("\"SMTP Port\" is required\n");
        }
        if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpTimeout())) {
            this.smtpTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            invalidFields.append("\"Send Timeout\" is required\n");
        }
        if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpFrom())) {
            this.defaultFromAddressField.setBackground(UIConstants.INVALID_COLOR);
            invalidFields.append("\"Default From Address\" is required\n");
        }
        if (serverSettings.getSmtpAuth().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpUsername())) {
                this.usernameField.setBackground(UIConstants.INVALID_COLOR);
                invalidFields.append("\"Username\" is required\n");
            }
            if (StringUtils.isBlank((CharSequence)serverSettings.getSmtpPassword())) {
                this.passwordField.setBackground(UIConstants.INVALID_COLOR);
                invalidFields.append("\"Password\" is required\n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(errors = invalidFields.toString()))) {
            PlatformUI.MIRTH_FRAME.alertCustomError((Component)((Object)PlatformUI.MIRTH_FRAME), errors, "Please fix the following errors before sending a test email:");
            return;
        }
        String sendToEmail = DisplayUtil.showInputDialog((Component)((Object)PlatformUI.MIRTH_FRAME), "Send test email to:", "Send Test Email", 1, null, null, serverSettings.getSmtpFrom());
        if (StringUtils.isNotBlank((CharSequence)sendToEmail)) {
            try {
                new InternetAddress(sendToEmail).validate();
            }
            catch (Exception error) {
                PlatformUI.MIRTH_FRAME.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), "The Send To Address is invalid: " + error.getMessage());
                return;
            }
            final Properties properties = new Properties();
            properties.put("port", serverSettings.getSmtpPort());
            properties.put("encryption", serverSettings.getSmtpSecure());
            properties.put("host", serverSettings.getSmtpHost());
            properties.put("timeout", serverSettings.getSmtpTimeout());
            properties.put("authentication", String.valueOf(serverSettings.getSmtpAuth()));
            properties.put("username", serverSettings.getSmtpUsername());
            properties.put("password", serverSettings.getSmtpPassword());
            properties.put("toAddress", sendToEmail);
            properties.put("fromAddress", serverSettings.getSmtpFrom());
            final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Sending test email...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        ConnectionTestResponse response = PlatformUI.MIRTH_FRAME.mirthClient.sendTestEmail(properties);
                        if (response == null) {
                            PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Failed to send email.");
                        } else if (response.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                            PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)PlatformUI.MIRTH_FRAME), response.getMessage());
                        } else {
                            PlatformUI.MIRTH_FRAME.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), response.getMessage());
                        }
                        return null;
                    }
                    catch (Exception e) {
                        PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e);
                        return null;
                    }
                }

                @Override
                public void done() {
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }
}

