/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TransformerType;
import com.mirth.connect.client.ui.TreePanel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.editors.DataTypePropertiesDialog;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.plugins.DataTypeClientPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.HL7TokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class TemplatePanel
extends JPanel
implements DropTargetListener {
    public final String DEFAULT_TEXT = "Paste a sample message here.";
    private static final String MESSAGE_TEMPLATES_BOLD = "<html><b>Message Templates</b></html>";
    private static final String MESSAGE_TEMPLATES = "Message Templates";
    private ActionListener templateTitleListener;
    private SyntaxDocument hl7Document;
    private TreePanel treePanel;
    private String currentMessage = "";
    private String currentDataType;
    private DataTypeProperties dataProperties;
    private Timer timer;
    private String lastWorkingId = null;
    private boolean inbound = false;
    private TransformerType transformerType;
    private JComboBox dataTypeComboBox;
    private JLabel jLabel5;
    private JButton openFileButton;
    private MirthSyntaxTextArea pasteBox;
    private JButton properties;

    public TemplatePanel() {
        this.initComponents();
    }

    public TemplatePanel(ActionListener templateTitleListener) {
        this.templateTitleListener = templateTitleListener;
        this.initComponents();
        this.openFileButton.setIcon(UIConstants.ICON_FILE_PICKER);
        if (PlatformUI.MIRTH_FRAME != null) {
            this.dataTypeComboBox.setModel(new DefaultComboBoxModel<Object>(PlatformUI.MIRTH_FRAME.dataTypeToDisplayName.values().toArray()));
        }
        this.hl7Document = new SyntaxDocument();
        this.hl7Document.setTokenMarker(new HL7TokenMarker());
        this.pasteBox.setDocument(this.hl7Document);
        this.pasteBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TemplatePanel.this.updateText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TemplatePanel.this.updateText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TemplatePanel.this.updateText();
            }
        });
        this.pasteBox.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 2 && TemplatePanel.this.pasteBox.getText().equals("Paste a sample message here.")) {
                    TemplatePanel.this.pasteBox.setText("");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2 && TemplatePanel.this.pasteBox.getText().length() == 0) {
                    TemplatePanel.this.pasteBox.setText("Paste a sample message here.");
                }
            }
        });
        new DropTarget(this.pasteBox, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                dtde.rejectDrag();
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                File file = (File)((List)tr.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                String dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(this.getDataType());
                DataTypeClientPlugin dataTypePlugin = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType);
                if (dataTypePlugin.isBinary()) {
                    byte[] content = FileUtils.readFileToByteArray((File)file);
                    this.pasteBox.setText(dataTypePlugin.getTemplateString(content));
                } else {
                    this.pasteBox.setText(FileUtils.readFileToString((File)file, (String)"UTF-8"));
                }
            }
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    public void setDataTypeEnabled(boolean dataTypeEnabled, boolean propertiesEnabled, TransformerType transformerType) {
        this.dataTypeComboBox.setEnabled(dataTypeEnabled);
        this.properties.setEnabled(propertiesEnabled);
        this.transformerType = transformerType;
    }

    public void setInbound(boolean inbound) {
        this.inbound = inbound;
    }

    public void setTreePanel(TreePanel tree) {
        this.treePanel = tree;
    }

    private void updateText() {
        class UpdateTimer
        extends TimerTask {
            UpdateTimer() {
            }

            @Override
            public void run() {
                if (TemplatePanel.this.dataProperties == null || TemplatePanel.this.currentMessage.equals("") && TemplatePanel.this.currentMessage.equals(TemplatePanel.this.pasteBox.getText())) {
                    TemplatePanel.this.treePanel.clearMessage();
                } else if (!TemplatePanel.this.currentMessage.equals(TemplatePanel.this.pasteBox.getText())) {
                    String message;
                    String workingId;
                    TemplatePanel.this.lastWorkingId = workingId = PlatformUI.MIRTH_FRAME.startWorking("Parsing...");
                    TemplatePanel.this.currentMessage = message = TemplatePanel.this.pasteBox.getText();
                    try {
                        TemplatePanel.this.treePanel.setMessage(TemplatePanel.this.dataProperties, (String)TemplatePanel.this.dataTypeComboBox.getSelectedItem(), message, "Paste a sample message here.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                }
            }
        }
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new UpdateTimer(), 1000L);
        } else {
            this.timer.cancel();
            PlatformUI.MIRTH_FRAME.stopWorking(this.lastWorkingId);
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new UpdateTimer(), 1000L);
        }
        if (!this.inbound && this.templateTitleListener != null) {
            String title = StringUtils.isBlank((CharSequence)this.pasteBox.getText()) ? MESSAGE_TEMPLATES : MESSAGE_TEMPLATES_BOLD;
            this.templateTitleListener.actionPerformed(new ActionEvent(this, 1001, title));
        }
    }

    public String getMessage() {
        if (this.pasteBox.getText().equals("Paste a sample message here.")) {
            return "";
        }
        return this.pasteBox.getText();
    }

    public void setMessage(String msg) {
        this.pasteBox.setText(msg);
        this.pasteBoxFocusLost(null);
        this.updateText();
    }

    public void clearMessage() {
        this.treePanel.clearMessage();
        this.pasteBoxFocusLost(null);
        this.updateText();
    }

    public void setDataType(String dataType) {
        this.currentDataType = dataType;
        this.dataTypeComboBox.setSelectedItem(dataType);
        this.setDocType(dataType);
    }

    private void setDocType(String dataType) {
        TokenMarker tokenMarker = LoadedExtensions.getInstance().getDataTypePlugins().get(PlatformUI.MIRTH_FRAME.displayNameToDataType.get(dataType)).getTokenMarker(this.getDataProperties());
        if (tokenMarker != null) {
            this.hl7Document.setTokenMarker(tokenMarker);
        }
        this.pasteBox.setDocument(this.hl7Document);
    }

    public String getDataType() {
        return (String)this.dataTypeComboBox.getSelectedItem();
    }

    public DataTypeProperties getDataProperties() {
        return this.dataProperties;
    }

    public void setDataProperties(DataTypeProperties p) {
        this.dataProperties = p != null ? p : null;
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.dataTypeComboBox = new JComboBox();
        this.properties = new JButton();
        this.pasteBox = new MirthSyntaxTextArea();
        this.openFileButton = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 1, 1, 1), "Message Template", 0, 0, new Font("Tahoma", 1, 11), new Color(0, 51, 51)));
        this.jLabel5.setText("Data Type:");
        this.dataTypeComboBox.setMaximumRowCount(20);
        this.dataTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dataTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatePanel.this.dataTypeComboBoxActionPerformed(evt);
            }
        });
        this.properties.setText("Properties");
        this.properties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatePanel.this.propertiesActionPerformed(evt);
            }
        });
        this.pasteBox.setBorder(BorderFactory.createEtchedBorder());
        this.pasteBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TemplatePanel.this.pasteBoxFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TemplatePanel.this.pasteBoxFocusLost(evt);
            }
        });
        this.openFileButton.setToolTipText("Open File...");
        this.openFileButton.setMargin(new Insets(0, 1, 0, 1));
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatePanel.this.openFileButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pasteBox, -1, 231, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.properties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openFileButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.properties, GroupLayout.Alignment.TRAILING).addComponent(this.dataTypeComboBox, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.openFileButton, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pasteBox, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jLabel5).addGap(207, 207, 207)));
        layout.linkSize(1, this.dataTypeComboBox, this.openFileButton, this.properties);
    }

    private void openFileButtonActionPerformed(ActionEvent evt) {
        try {
            String dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(this.getDataType());
            DataTypeClientPlugin dataTypePropertiesPlugin = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType);
            if (dataTypePropertiesPlugin.isBinary()) {
                byte[] content = PlatformUI.MIRTH_FRAME.browseForFileBytes(null);
                if (content != null) {
                    this.pasteBox.setText(dataTypePropertiesPlugin.getTemplateString(content));
                }
            } else {
                String content = PlatformUI.MIRTH_FRAME.browseForFileString(null);
                if (content != null) {
                    this.pasteBox.setText(content);
                }
            }
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)this, (Throwable)e, "Invalid template file. " + e.getMessage());
        }
    }

    private void pasteBoxFocusLost(FocusEvent evt) {
    }

    private void pasteBoxFocusGained(FocusEvent evt) {
        if (this.pasteBox.getText().equals("Paste a sample message here.")) {
            this.pasteBox.setText("");
        }
    }

    private void propertiesActionPerformed(ActionEvent evt) {
        this.currentMessage = "";
        String displayName = (String)this.dataTypeComboBox.getSelectedItem();
        if (this.dataProperties != null) {
            DataTypeProperties lastDataTypeProperties = this.dataProperties.clone();
            DataTypePropertiesDialog dialog = new DataTypePropertiesDialog(this.inbound, displayName, this.dataProperties, this.transformerType);
            if (dialog.isRevert()) {
                this.dataProperties = lastDataTypeProperties;
            } else {
                this.dataProperties = dialog.getDataTypeProperties();
                if (!this.dataProperties.equals((Object)lastDataTypeProperties)) {
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        }
        this.setDocType(this.currentDataType);
        this.updateText();
    }

    private void dataTypeComboBoxActionPerformed(ActionEvent evt) {
        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        this.currentMessage = "";
        if (!this.currentDataType.equals(this.dataTypeComboBox.getSelectedItem())) {
            this.currentDataType = (String)this.dataTypeComboBox.getSelectedItem();
            String dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(this.currentDataType);
            this.dataProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
        }
        this.setDocType(this.currentDataType);
        this.updateText();
    }
}

