/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.MirthHeadingPanel;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.UserDialogInterface;
import com.mirth.connect.client.ui.UserEditPanel;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.User;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;

public class UserDialog
extends MirthDialog
implements UserDialogInterface {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private boolean editingLoggedInUser = false;
    private JButton cancelButton;
    private JPanel channelOverview;
    private JButton finishButton;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private MirthHeadingPanel mirthHeadingPanel1;
    private UserEditPanel userEditPanel;

    public UserDialog(User currentUser) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.initComponents();
        DisplayUtil.setResizable(this, false);
        this.finishButton.setEnabled(false);
        boolean passwordRequired = false;
        if (currentUser != null) {
            this.editingLoggedInUser = currentUser.getUsername().equals(PlatformUI.USER_NAME);
            this.jLabel2.setText("Edit User");
        } else {
            currentUser = new User();
            passwordRequired = true;
            this.jLabel2.setText("New User");
        }
        this.userEditPanel.setUser(this, currentUser);
        this.userEditPanel.setRequiredFields(false, passwordRequired);
        this.jLabel2.setForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.setModal(true);
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void setFinishButtonEnabled(boolean enabled) {
        this.finishButton.setEnabled(enabled);
    }

    @Override
    public void triggerFinishButton() {
        this.finishButtonActionPerformed(null);
    }

    private void initComponents() {
        this.channelOverview = new JPanel();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.mirthHeadingPanel1 = new MirthHeadingPanel();
        this.jLabel2 = new JLabel();
        this.userEditPanel = new UserEditPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("User");
        this.channelOverview.setBackground(new Color(255, 255, 255));
        this.channelOverview.setName("");
        this.finishButton.setText("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDialog.this.finishButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 18));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("User");
        GroupLayout mirthHeadingPanel1Layout = new GroupLayout(this.mirthHeadingPanel1);
        this.mirthHeadingPanel1.setLayout(mirthHeadingPanel1Layout);
        mirthHeadingPanel1Layout.setHorizontalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 353, Short.MAX_VALUE).addContainerGap()));
        mirthHeadingPanel1Layout.setVerticalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 29, Short.MAX_VALUE).addContainerGap()));
        GroupLayout channelOverviewLayout = new GroupLayout(this.channelOverview);
        this.channelOverview.setLayout(channelOverviewLayout);
        channelOverviewLayout.setHorizontalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap(228, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishButton).addGap(9, 9, 9)).addComponent(this.mirthHeadingPanel1, -1, 373, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 353, Short.MAX_VALUE).addContainerGap()).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap().addComponent(this.userEditPanel, -2, -1, -2).addContainerGap(31, Short.MAX_VALUE)));
        channelOverviewLayout.linkSize(0, this.cancelButton, this.finishButton);
        channelOverviewLayout.setVerticalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addComponent(this.mirthHeadingPanel1, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userEditPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.finishButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        this.finishButton.requestFocus();
        String validateUserMessage = this.userEditPanel.validateUser();
        if (validateUserMessage != null) {
            this.parent.alertWarning(this, validateUserMessage);
        } else {
            User user = this.userEditPanel.getUser();
            boolean success = false;
            success = this.editingLoggedInUser ? this.parent.updateCurrentUser(this, user, this.userEditPanel.getPassword()) : this.parent.updateUser(this, user, this.userEditPanel.getPassword());
            if (success) {
                this.dispose();
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

