/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.UserDialogInterface;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.model.User;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.internet.InternetAddress;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class UserEditPanel
extends JPanel {
    private static List<String> STATE_TERRITORY_CODES = Arrays.asList("AL", "AK", "AS", "AZ", "AR", "CA", "CO", "CT", "DE", "DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MD", "MA", "MI", "MN", "MP", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VT", "VA", "VI", "WA", "WV", "WI", "WY");
    private static List<String> INDUSTRIES = Arrays.asList("ACO", "CHC/FQHC", "Clinic", "HIE", "HIT Consulting", "HIT Software", "Hospital", "Lab", "Network", "Other", "Payer", "Physicians Group", "Private Practice", "Public Health Agency", "Radiology Center", "University");
    private static List<String> ROLES = Arrays.asList("Primary Role*", "C-Suite", "Consultant - Advisor", "Consultant - Engineer", "Consultant - Implementer", "Employee - Engineer", "Employee - Manager", "Employee - Director", "Employee - VP", "Independent Contractor", "Other");
    private User user;
    private UserDialogInterface dialog;
    private Frame parent;
    private final String DEFAULT_OPTION = "--Select an option--";
    Map<String, String> countryMap = new HashMap<String, String>();
    private List<String> countryNames;
    private JPasswordField confirmPassword;
    private JLabel confirmPasswordAsteriskLabel;
    private Boolean confirmPasswordIsRequired = false;
    private JLabel confirmPasswordLabel;
    private JComboBox<String> country;
    private JLabel countryAsteriskLabel;
    private Boolean countryIsRequired = false;
    private JLabel countryLabel;
    private JTextArea description;
    private JLabel descriptionLabel;
    private MirthTextField email;
    private JLabel emailAsteriskLabel;
    private Boolean emailIsRequired = false;
    private JLabel emailLabel;
    private MirthTextField firstName;
    private JLabel firstNameAsteriskLabel;
    private Boolean firstNameIsRequired = false;
    private JLabel firstNameLabel;
    private JComboBox<String> industry;
    private JLabel industryLabel;
    private JScrollPane jScrollPane1;
    private MirthTextField lastName;
    private JLabel lastNameAsteriskLabel;
    private Boolean lastNameIsRequired = false;
    private JLabel lastNameLabel;
    private MirthTextField organization;
    private JLabel organizationAsteriskLabel;
    private Boolean organizationIsRequired = false;
    private JLabel organizationLabel;
    private JPasswordField password;
    private JLabel passwordAsteriskLabel;
    private Boolean passwordIsRequired = false;
    private JLabel passwordLabel;
    private MirthTextField phone;
    private JLabel phoneLabel;
    private JComboBox<String> role;
    private JLabel roleLabel;
    private JComboBox<String> stateTerritory;
    private JLabel stateTerritoryLabel;
    private JTextField username;
    private JLabel usernameAsteriskLabel;
    private JLabel usernameLabel;

    public UserEditPanel() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initializeCountryCodes();
        this.initComponents();
        this.initLayout();
    }

    private void initializeCountryCodes() {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        Set countryCodeSet = phoneUtil.getSupportedRegions();
        for (String item : countryCodeSet) {
            Locale obj = new Locale("", item);
            String countryName = obj.getDisplayCountry();
            this.countryMap.put(item, countryName);
        }
        this.countryNames = this.countryMap.values().stream().collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(this.countryNames);
    }

    protected List<String> getCountryNames() {
        return this.countryNames;
    }

    public void setUser(UserDialogInterface dialog, User user) {
        this.dialog = dialog;
        this.user = user;
        this.username.setText(user.getUsername());
        this.password.setText("");
        this.confirmPassword.setText("");
        this.firstName.setText(user.getFirstName());
        this.lastName.setText(user.getLastName());
        this.organization.setText(user.getOrganization());
        this.email.setText(user.getEmail());
        this.phone.setText(user.getPhoneNumber());
        this.description.setText(user.getDescription());
        if (!StringUtils.isBlank((CharSequence)user.getIndustry())) {
            this.industry.setSelectedItem(user.getIndustry());
        }
        if (!StringUtils.isBlank((CharSequence)user.getCountry())) {
            this.country.setSelectedItem(user.getCountry());
        }
        if (!StringUtils.isBlank((CharSequence)user.getStateTerritory())) {
            this.stateTerritory.setSelectedItem(user.getStateTerritory());
        }
        if (!StringUtils.isBlank((CharSequence)user.getRole())) {
            this.role.setSelectedItem(user.getRole());
        }
    }

    public User getUser() {
        this.user.setUsername(this.username.getText());
        this.user.setFirstName(this.firstName.getText());
        this.user.setLastName(this.lastName.getText());
        this.user.setOrganization(this.organization.getText());
        this.user.setEmail(this.email.getText());
        this.user.setPhoneNumber(this.phone.getText());
        this.user.setDescription(this.description.getText());
        if (!this.country.getSelectedItem().equals("--Select an option--")) {
            this.user.setCountry((String)this.country.getSelectedItem());
        }
        if (!this.industry.getSelectedItem().equals("--Select an option--")) {
            this.user.setIndustry((String)this.industry.getSelectedItem());
        }
        if (!this.role.getSelectedItem().equals("--Select an option--")) {
            this.user.setRole((String)this.role.getSelectedItem());
        }
        if (!this.stateTerritory.getSelectedItem().equals("--Select an option--")) {
            this.user.setStateTerritory((String)this.stateTerritory.getSelectedItem());
        } else {
            this.user.setStateTerritory(null);
        }
        return this.user;
    }

    public String getPassword() {
        return String.valueOf(this.password.getPassword());
    }

    public boolean checkIfAbleToFinish() {
        boolean finishEnabled = true;
        if (StringUtils.isBlank((CharSequence)this.username.getText()) || this.passwordIsRequired != false && StringUtils.isBlank((CharSequence)String.valueOf(this.password.getPassword())) || this.confirmPasswordIsRequired != false && StringUtils.isBlank((CharSequence)String.valueOf(this.confirmPassword.getPassword())) || this.firstNameIsRequired != false && StringUtils.isBlank((CharSequence)this.firstName.getText()) || this.lastNameIsRequired != false && StringUtils.isBlank((CharSequence)this.lastName.getText()) || this.emailIsRequired != false && StringUtils.isBlank((CharSequence)this.email.getText()) || this.countryIsRequired != false && this.country.getSelectedItem().equals("--Select an option--") || this.organizationIsRequired.booleanValue() && StringUtils.isBlank((CharSequence)this.organization.getText())) {
            finishEnabled = false;
        }
        this.dialog.setFinishButtonEnabled(finishEnabled);
        return finishEnabled;
    }

    public void setRequiredFields(boolean allRequired, boolean passwordRequired) {
        this.confirmPasswordIsRequired = passwordRequired;
        this.countryIsRequired = allRequired;
        this.emailIsRequired = allRequired;
        this.firstNameIsRequired = allRequired;
        this.lastNameIsRequired = allRequired;
        this.organizationIsRequired = allRequired;
        this.passwordIsRequired = passwordRequired;
        if (allRequired) {
            this.passwordAsteriskLabel.setVisible(true);
            this.confirmPasswordAsteriskLabel.setVisible(true);
            this.firstNameAsteriskLabel.setVisible(true);
            this.lastNameAsteriskLabel.setVisible(true);
            this.emailAsteriskLabel.setVisible(true);
            this.countryAsteriskLabel.setVisible(true);
            this.organizationAsteriskLabel.setVisible(true);
        } else {
            this.passwordAsteriskLabel.setVisible(passwordRequired);
            this.confirmPasswordAsteriskLabel.setVisible(passwordRequired);
            this.firstNameAsteriskLabel.setVisible(false);
            this.lastNameAsteriskLabel.setVisible(false);
            this.emailAsteriskLabel.setVisible(false);
            this.countryAsteriskLabel.setVisible(false);
            this.organizationAsteriskLabel.setVisible(false);
        }
        this.checkIfAbleToFinish();
    }

    public String validateUser() {
        if (!this.checkIfAbleToFinish()) {
            return "Please fill in all required information.";
        }
        if (this.user.getId() == null || !this.user.getUsername().equals(this.username.getText())) {
            for (int i = 0; i < this.parent.users.size(); ++i) {
                if (!this.parent.users.get(i).getUsername().equals(this.username.getText())) continue;
                return "This username already exists. Please choose another one.";
            }
        }
        if (!String.valueOf(this.password.getPassword()).equals(String.valueOf(this.confirmPassword.getPassword()))) {
            return "Passwords must be the same.";
        }
        try {
            String emailAddress = this.email.getText();
            if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                new InternetAddress(emailAddress).validate();
            }
        }
        catch (Exception e) {
            return "The email address is invalid: " + e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)this.phone.getText())) {
            if (this.country.getSelectedItem().equals("--Select an option--")) {
                return "Country field is required to validate phone number.";
            }
            if (!UserEditPanel.validatePhoneNumber(this.phone.getText(), this.getKeyFromValue(this.countryMap, this.country.getSelectedItem()).toString())) {
                return "The phone number is invalid for the given Country and/or State/Territory.";
            }
        }
        return null;
    }

    private void checkAndTriggerFinishButton(KeyEvent evt) {
        if (this.checkIfAbleToFinish() && evt.getKeyCode() == 10) {
            this.dialog.triggerFinishButton();
        }
    }

    public static boolean validatePhoneNumber(String phoneNumber, String countryCode) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber parsedPhoneNumber = phoneUtil.parse((CharSequence)phoneNumber, countryCode);
            return phoneUtil.isValidNumber(parsedPhoneNumber);
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    protected String formatPhoneNumber(String phoneNumber, String countryCode) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            String originalPhoneNumber = Long.toString(phoneUtil.parse((CharSequence)phoneNumber, countryCode).getNationalNumber());
            Phonenumber.PhoneNumber parsedPhoneNumber = phoneUtil.parse((CharSequence)originalPhoneNumber, countryCode);
            return phoneUtil.format(parsedPhoneNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }
        catch (NumberParseException e) {
            return phoneNumber;
        }
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.usernameAsteriskLabel = new JLabel();
        this.usernameAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.usernameAsteriskLabel.setText("*");
        this.usernameAsteriskLabel.setVisible(true);
        this.passwordAsteriskLabel = new JLabel();
        this.passwordAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.passwordAsteriskLabel.setText("*");
        this.passwordAsteriskLabel.setVisible(false);
        this.confirmPasswordAsteriskLabel = new JLabel();
        this.confirmPasswordAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.confirmPasswordAsteriskLabel.setText("*");
        this.confirmPasswordAsteriskLabel.setVisible(false);
        this.firstNameAsteriskLabel = new JLabel();
        this.firstNameAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.firstNameAsteriskLabel.setText("*");
        this.firstNameAsteriskLabel.setVisible(false);
        this.lastNameAsteriskLabel = new JLabel();
        this.lastNameAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.lastNameAsteriskLabel.setText("*");
        this.lastNameAsteriskLabel.setVisible(false);
        this.emailAsteriskLabel = new JLabel();
        this.emailAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.emailAsteriskLabel.setText("*");
        this.emailAsteriskLabel.setVisible(false);
        this.countryAsteriskLabel = new JLabel();
        this.countryAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.countryAsteriskLabel.setText("*");
        this.countryAsteriskLabel.setVisible(false);
        this.organizationAsteriskLabel = new JLabel();
        this.organizationAsteriskLabel.setForeground(new Color(255, 0, 0));
        this.organizationAsteriskLabel.setText("*");
        this.organizationAsteriskLabel.setVisible(false);
        this.usernameLabel = new JLabel("Username:");
        this.username = new JTextField();
        this.username.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.usernameKeyReleased(evt);
            }
        });
        this.passwordLabel = new JLabel("New Password:");
        this.password = new JPasswordField();
        this.password.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.passwordKeyReleased(evt);
            }
        });
        this.confirmPasswordLabel = new JLabel("Confirm New Password:");
        this.confirmPassword = new JPasswordField();
        this.confirmPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.confirmPasswordKeyReleased(evt);
            }
        });
        this.firstNameLabel = new JLabel("First Name:");
        this.firstName = new MirthTextField();
        this.firstName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.firstNameKeyReleased(evt);
            }
        });
        this.lastNameLabel = new JLabel("Last Name:");
        this.lastName = new MirthTextField();
        this.lastName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.lastNameKeyReleased(evt);
            }
        });
        this.emailLabel = new JLabel("Email:");
        this.email = new MirthTextField();
        this.email.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.emailKeyReleased(evt);
            }
        });
        this.countryLabel = new JLabel("Country:");
        this.country = new JComboBox();
        for (String item : this.getCountryNames()) {
            this.country.addItem(item);
        }
        this.country.getModel().setSelectedItem("United States");
        this.country.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserEditPanel.this.countryActionPerformed(evt);
            }
        });
        this.stateTerritoryLabel = new JLabel("State/Territory:");
        this.stateTerritory = new JComboBox();
        for (String item : STATE_TERRITORY_CODES) {
            this.stateTerritory.addItem(item);
        }
        this.stateTerritory.getModel().setSelectedItem("--Select an option--");
        this.stateTerritory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserEditPanel.this.stateTerritoryActionPerformed(evt);
            }
        });
        this.phoneLabel = new JLabel("Phone:");
        this.phone = new MirthTextField();
        this.phone.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.phoneKeyReleased(evt);
            }
        });
        this.organizationLabel = new JLabel("Organization:");
        this.organization = new MirthTextField();
        this.organization.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserEditPanel.this.organizationKeyReleased(evt);
            }
        });
        this.roleLabel = new JLabel("Role:");
        this.role = new JComboBox();
        for (String item : ROLES) {
            this.role.addItem(item);
        }
        this.role.getModel().setSelectedItem("--Select an option--");
        this.role.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserEditPanel.this.roleActionPerformed(evt);
            }
        });
        this.industryLabel = new JLabel("Business:");
        this.industry = new JComboBox();
        for (String item : INDUSTRIES) {
            this.industry.addItem(item);
        }
        this.industry.getModel().setSelectedItem("--Select an option--");
        this.industry.setMaximumRowCount(this.industry.getModel().getSize());
        this.industry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserEditPanel.this.industryActionPerformed(evt);
            }
        });
        this.descriptionLabel = new JLabel("Description:");
        this.description = new JTextArea();
        this.description.setColumns(20);
        this.description.setFont(new Font("Tahoma", 0, 11));
        this.description.setLineWrap(true);
        this.description.setRows(4);
        this.description.setWrapStyleWord(true);
        this.description.setAutoscrolls(false);
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setViewportView(this.description);
    }

    private void initLayout() {
        JPanel editUserPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][fill][125]"));
        editUserPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        editUserPanel.setBorder(BorderFactory.createEmptyBorder());
        editUserPanel.setMinimumSize(this.getMinimumSize());
        editUserPanel.setMaximumSize(this.getMaximumSize());
        editUserPanel.add(this.usernameLabel);
        editUserPanel.add(this.username);
        editUserPanel.add((Component)this.usernameAsteriskLabel, "wrap");
        editUserPanel.add(this.passwordLabel);
        editUserPanel.add(this.password);
        editUserPanel.add((Component)this.passwordAsteriskLabel, "wrap");
        editUserPanel.add(this.confirmPasswordLabel);
        editUserPanel.add(this.confirmPassword);
        editUserPanel.add((Component)this.confirmPasswordAsteriskLabel, "wrap");
        editUserPanel.add(this.firstNameLabel);
        editUserPanel.add(this.firstName);
        editUserPanel.add((Component)this.firstNameAsteriskLabel, "wrap");
        editUserPanel.add(this.lastNameLabel);
        editUserPanel.add(this.lastName);
        editUserPanel.add((Component)this.lastNameAsteriskLabel, "wrap");
        editUserPanel.add(this.emailLabel);
        editUserPanel.add(this.email);
        editUserPanel.add((Component)this.emailAsteriskLabel, "wrap");
        editUserPanel.add(this.countryLabel);
        editUserPanel.add(this.country);
        editUserPanel.add((Component)this.countryAsteriskLabel, "wrap");
        editUserPanel.add(this.stateTerritoryLabel);
        editUserPanel.add(this.stateTerritory, "wrap");
        editUserPanel.add(this.phoneLabel);
        editUserPanel.add((Component)this.phone, "wrap");
        editUserPanel.add(this.organizationLabel);
        editUserPanel.add(this.organization);
        editUserPanel.add((Component)this.organizationAsteriskLabel, "wrap");
        editUserPanel.add(this.roleLabel);
        editUserPanel.add(this.role, "wrap");
        editUserPanel.add(this.industryLabel);
        editUserPanel.add(this.industry, "wrap");
        editUserPanel.add(this.descriptionLabel);
        editUserPanel.add((Component)this.jScrollPane1, "wrap");
        this.add(editUserPanel);
    }

    private void usernameKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void passwordKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void confirmPasswordKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void firstNameKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void lastNameKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void organizationKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void emailKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void phoneKeyReleased(KeyEvent evt) {
        this.phone.setText(this.formatPhoneNumber(this.phone.getText(), this.getKeyFromValue(this.countryMap, this.country.getSelectedItem()).toString()));
        this.checkAndTriggerFinishButton(evt);
    }

    private void countryActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            if (this.country.getSelectedItem() == "United States") {
                this.stateTerritory.setEnabled(true);
            } else {
                this.stateTerritory.getModel().setSelectedItem("--Select an option--");
                this.stateTerritory.setEnabled(false);
            }
            this.phone.setText(this.formatPhoneNumber(this.phone.getText(), this.getKeyFromValue(this.countryMap, this.country.getSelectedItem()).toString()));
            this.checkIfAbleToFinish();
        }
    }

    private void stateTerritoryActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.checkIfAbleToFinish();
        }
    }

    private void roleActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.checkIfAbleToFinish();
        }
    }

    private void industryActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.checkIfAbleToFinish();
        }
    }

    public Object getKeyFromValue(Map map, Object value) {
        for (Object item : map.keySet()) {
            if (!map.get(item).equals(value)) continue;
            return item;
        }
        return null;
    }
}

