/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTableTransferHandler;
import com.mirth.connect.model.User;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class UserPanel
extends JPanel {
    private final String USER_EMAIL_COLUMN_NAME = "Email";
    private final String USERNAME_COLUMN_NAME = "Username";
    private final String USERFIRSTNAME_COLUMN_NAME = "First Name";
    private final String USERLASTNAME_COLUMN_NAME = "Last Name";
    private final String USERORGANIZATION_COLUMN_NAME = "Organization";
    private final String USERINDUSTRY_COLUMN_NAME = "Business";
    private final String USERPHONENUMBER_COLUMN_NAME = "Phone Number";
    private final String USERDESCRIPTION_COLUMN_NAME = "Description";
    private final String USERLASTLOGIN_COLUMN_NAME = "Last Login";
    private final String USER_COUNTRY_COLUMN_NAME = "Country";
    private final String USER_STATETERRITORY_COLUMN_NAME = "State/Territory";
    private final String USER_ROLE_COLUMN_NAME = "Role";
    private final int USERNAME_COLUMN_NUMBER = 0;
    private final int USER_EMAIL_COLUMN_NUMBER = 4;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private int lastRow = -1;
    private JScrollPane usersPane;
    public MirthTable usersTable;

    public UserPanel() {
        this.initComponents();
        this.makeUsersTable();
        this.usersTable.setBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setVisible(true);
    }

    public void makeUsersTable() {
        this.updateUserTable();
        this.usersTable.setSelectionMode(0);
        this.usersTable.getColumnExt("Username").setCellRenderer((TableCellRenderer)new ImageCellRenderer());
        this.usersTable.getColumnExt("Username").setMaxWidth(200);
        this.usersTable.getColumnExt("First Name").setMaxWidth(200);
        this.usersTable.getColumnExt("Last Name").setMaxWidth(200);
        this.usersTable.getColumnExt("Business").setMinWidth(125);
        this.usersTable.getColumnExt("Business").setMaxWidth(200);
        this.usersTable.getColumnExt("Organization").setMinWidth(125);
        this.usersTable.getColumnExt("Organization").setMaxWidth(200);
        this.usersTable.getColumnExt("Email").setMinWidth(150);
        this.usersTable.getColumnExt("Email").setMaxWidth(200);
        this.usersTable.getColumnExt("Phone Number").setMaxWidth(200);
        this.usersTable.getColumnExt("Last Login").setMinWidth(125);
        this.usersTable.getColumnExt("Last Login").setMaxWidth(200);
        this.usersTable.getColumnExt("Country").setMinWidth(125);
        this.usersTable.getColumnExt("Country").setMaxWidth(200);
        this.usersTable.getColumnExt("State/Territory").setMinWidth(125);
        this.usersTable.getColumnExt("State/Territory").setMaxWidth(200);
        this.usersTable.getColumnExt("Role").setMinWidth(125);
        this.usersTable.getColumnExt("Role").setMaxWidth(200);
        this.usersTable.packTable(10);
        this.usersTable.setRowHeight(20);
        this.usersTable.setOpaque(true);
        this.usersTable.setCellSelectionEnabled(false);
        this.usersTable.setRowSelectionAllowed(true);
        this.usersPane.setViewportView((Component)((Object)this.usersTable));
        this.usersTable.setDragEnabled(true);
        this.usersTable.setDropMode(DropMode.ON);
        this.usersTable.setTransferHandler(new MirthTableTransferHandler(0, 4){

            @Override
            public void importFile(File file, boolean showAlerts) {
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return false;
            }
        });
        this.usersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                UserPanel.this.UsersListSelected(evt);
            }
        });
        this.usersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                UserPanel.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                UserPanel.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (UserPanel.this.usersTable.rowAtPoint(new Point(evt.getX(), evt.getY())) == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2) {
                    UserPanel.this.parent.doEditUser();
                }
            }
        });
        this.usersTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    UserPanel.this.parent.doDeleteUser();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void updateUserTable() {
        Object[][] tableData = null;
        if (this.parent.users != null) {
            tableData = new Object[this.parent.users.size()][12];
            for (int i = 0; i < this.parent.users.size(); ++i) {
                User temp = this.parent.users.get(i);
                tableData[i][0] = new CellData(new ImageIcon(Frame.class.getResource("images/user.png")), temp.getUsername());
                tableData[i][1] = temp.getFirstName();
                tableData[i][2] = temp.getLastName();
                tableData[i][3] = temp.getEmail();
                tableData[i][4] = temp.getCountry();
                tableData[i][5] = temp.getStateTerritory();
                tableData[i][6] = temp.getPhoneNumber();
                tableData[i][7] = temp.getOrganization();
                tableData[i][8] = temp.getRole();
                tableData[i][9] = temp.getIndustry();
                if (temp.getLastLogin() != null) {
                    tableData[i][10] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(temp.getLastLogin().getTime());
                }
                tableData[i][11] = temp.getDescription();
            }
        }
        if (this.usersTable != null) {
            this.lastRow = this.usersTable.getSelectedRow();
            RefreshTableModel model = (RefreshTableModel)this.usersTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.usersTable = new MirthTable();
            this.usersTable.setModel(new RefreshTableModel(tableData, new String[]{"Username", "First Name", "Last Name", "Email", "Country", "State/Territory", "Phone Number", "Organization", "Role", "Business", "Last Login", "Description"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (this.lastRow >= 0 && this.lastRow < this.usersTable.getRowCount()) {
            this.usersTable.setRowSelectionInterval(this.lastRow, this.lastRow);
        } else {
            this.lastRow = -1;
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.usersTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    private void checkSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.usersTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.usersTable.setRowSelectionInterval(row, row);
            }
            this.parent.userPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void UsersListSelected(ListSelectionEvent evt) {
        int row = this.usersTable.getSelectedRow();
        if (row >= 0 && row < this.usersTable.getRowCount()) {
            this.parent.setVisibleTasks(this.parent.userTasks, this.parent.userPopupMenu, 2, -1, true);
        }
    }

    public int getSelectedRow() {
        return this.usersTable.getSelectedRow();
    }

    public boolean setSelectedUser(String userName) {
        int columnNumber = this.usersTable.getColumnViewIndex("Username");
        for (int i = 0; i < this.parent.users.size(); ++i) {
            if (!userName.equals(((CellData)this.usersTable.getValueAt(i, columnNumber)).getText())) continue;
            this.usersTable.setRowSelectionInterval(i, i);
            return true;
        }
        return false;
    }

    public int getUserIndex() {
        int columnNumber = this.usersTable.getColumnViewIndex("Username");
        if (this.usersTable.getSelectedRow() != -1) {
            String userName = ((CellData)this.usersTable.getValueAt(this.getSelectedRow(), columnNumber)).getText();
            for (int i = 0; i < this.parent.users.size(); ++i) {
                if (!this.parent.users.get(i).getUsername().equals(userName)) continue;
                return i;
            }
        }
        return -1;
    }

    public void deselectRows() {
        this.usersTable.clearSelection();
        this.parent.setVisibleTasks(this.parent.userTasks, this.parent.userPopupMenu, 2, -1, false);
    }

    private void initComponents() {
        this.usersPane = new JScrollPane();
        this.usersTable = null;
        this.usersPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.usersPane.setViewportView((Component)((Object)this.usersTable));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usersPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usersPane, -1, 300, Short.MAX_VALUE));
    }
}

