/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.components.MirthVariableList;
import com.mirth.connect.model.Connector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VariableList
extends JPanel {
    private String borderTitle = "Variables";
    private JScrollPane jScrollPane1;
    private MirthVariableList mirthVariableList;

    public VariableList() {
        this.initComponents();
    }

    public MirthVariableList getMirthVariableList() {
        return this.mirthVariableList;
    }

    public void setTransferMode(VariableListHandler.TransferMode transferMode) {
        this.mirthVariableList.setTransferMode(transferMode);
    }

    public void populateConnectors(List<Connector> connectors) {
        this.mirthVariableList.populateConnectors(connectors);
    }

    public void setVariableListInbound(Set<String> additionalVariables) {
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        variables.add("Channel ID");
        variables.add("Channel Name");
        variables.add("Message ID");
        variables.add("Raw Data");
        variables.add("Transformed Data");
        variables.add("Encoded Data");
        variables.add("Message Source");
        variables.add("Message Type");
        variables.add("Message Version");
        variables.add("Message Hash");
        variables.add("Date");
        variables.add("Formatted Date");
        variables.add("Timestamp");
        variables.add("Unique ID");
        variables.add("Original File Name");
        if (this.mirthVariableList.getTransferMode() == VariableListHandler.TransferMode.VELOCITY) {
            variables.add("Count");
        }
        variables.add("XML Entity Encoder");
        variables.add("XML Pretty Printer");
        variables.add("Escape JSON String");
        variables.add("JSON Pretty Printer");
        variables.add("CDATA Tag");
        variables.add("DICOM Message Raw Data");
        variables.addAll(additionalVariables);
        this.mirthVariableList.removeAll();
        this.mirthVariableList.setListData(variables.toArray());
        this.jScrollPane1.setViewportView((Component)((Object)this.mirthVariableList));
    }

    public void setVariableListOutbound() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("Raw Data");
        variables.add("Transformed Data");
        variables.add("Encoded Data");
        this.mirthVariableList.removeAll();
        this.mirthVariableList.setListData(variables.toArray());
        this.jScrollPane1.setViewportView((Component)((Object)this.mirthVariableList));
    }

    public void setBorder(String title, Color color) {
        this.borderTitle = title;
        this.setBorder(BorderFactory.createTitledBorder(null, title, 0, 0, new Font("Tahoma", 0, 11), color));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBorder(this.borderTitle, new Color(0, 0, 0));
        } else {
            this.setBorder(this.borderTitle, new Color(160, 160, 160));
        }
        this.jScrollPane1.setEnabled(enabled);
        this.mirthVariableList.setEnabled(enabled);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mirthVariableList = new MirthVariableList();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mirthVariableList.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mirthVariableList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView((Component)((Object)this.mirthVariableList));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 170, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 495, Short.MAX_VALUE));
    }
}

