/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.VariableListHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Map;
import java.util.regex.Pattern;

public class VariableTransferable
implements Transferable {
    private static DataFlavor[] flavors = null;
    private static final Pattern VALID_VELOCITY_VARIABLE_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private String data = null;
    private VariableListHandler.TransferMode transferMode;
    private Map<String, Integer> metaDataMap;

    public VariableTransferable(String data, VariableListHandler.TransferMode transferMode) {
        this(data, transferMode, null);
    }

    public VariableTransferable(String data, VariableListHandler.TransferMode transferMode, Map<String, Integer> metaDataMap) {
        this.transferMode = transferMode;
        this.metaDataMap = metaDataMap;
        if (data.equals("CDATA Tag")) {
            this.data = "<![CDATA[]]>";
            this.transferMode = VariableListHandler.TransferMode.RAW;
        } else {
            this.data = data;
        }
        this.init();
    }

    private void init() {
        try {
            flavors = new DataFlavor[1];
            VariableTransferable.flavors[0] = DataFlavor.stringFlavor;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getTransferData(DataFlavor df) {
        if (df == null) {
            return null;
        }
        if (this.data != null) {
            Object replacedData = this.data;
            Object prefix = this.transferMode.getPrefix();
            Object suffix = this.transferMode.getSuffix();
            if (this.transferMode != VariableListHandler.TransferMode.RAW) {
                if (this.metaDataMap != null && this.metaDataMap.containsKey(this.data)) {
                    replacedData = "d" + String.valueOf(this.metaDataMap.get(this.data));
                    if (this.transferMode == VariableListHandler.TransferMode.VELOCITY) {
                        suffix = ".message" + (String)suffix;
                    }
                }
                if (this.transferMode == VariableListHandler.TransferMode.VELOCITY && !VALID_VELOCITY_VARIABLE_PATTERN.matcher((CharSequence)replacedData).matches()) {
                    prefix = (String)prefix + "maps.get('";
                    suffix = "')" + (String)suffix;
                }
                if (((String)replacedData).contains("'")) {
                    prefix = ((String)prefix).replaceAll("'", "\"");
                    suffix = ((String)suffix).replaceAll("'", "\"");
                }
            }
            return (String)prefix + (String)replacedData + (String)suffix;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        if (df == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!df.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

