/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.alert;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextArea;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthVariableList;
import com.mirth.connect.model.alert.AlertAction;
import com.mirth.connect.model.alert.AlertActionGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class AlertActionPane
extends JPanel {
    private static final int PROTOCOL_COLUMN_INDEX = 0;
    private static final int RECIPIENT_COLUMN_INDEX = 1;
    private static final String PROTOCOL_COLUMN_NAME = "Protocol";
    private static final String RECIPIENT_COLUMN_NAME = "Recipient";
    private static final String DEFAULT_PROTOCOL = "Email";
    private static int PROTOCOL_COLUMN_WIDTH = 65;
    private volatile Map<String, Protocol> protocols = new LinkedHashMap<String, Protocol>();
    private AlertActionGroup actionGroup;
    private JPanel actionPane;
    private JScrollPane actionScrollPane;
    private MirthTable actionTable;
    private MirthButton addActionButton;
    private MirthButton removeActionButton;
    private JPanel subjectPane;
    private MirthTextField subjectTextField;
    private JPanel templatePane;
    private JScrollPane templateScrollPane;
    private MirthTextArea templateTextArea;
    private JPanel variablePane;
    private JScrollPane variableScrollPane;
    private MirthVariableList variableList;

    public AlertActionPane() {
        this.initComponents();
        try {
            this.updateProtocols(PlatformUI.MIRTH_FRAME.mirthClient.getAlertProtocolOptions());
        }
        catch (ClientException e) {
            this.updateProtocols(new HashMap<String, Map<String, String>>());
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, "An error occurred while attempting to initialize the alert editor.", false);
        }
        this.makeActionTable();
    }

    private void makeActionTable() {
        this.actionTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.actionTable.setSelectionMode(0);
        this.actionTable.getColumnExt(PROTOCOL_COLUMN_NAME).setCellEditor((TableCellEditor)new MirthComboBoxTableCellEditor((JTable)((Object)this.actionTable), this.protocols.keySet().toArray(), 1, false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                if (comboBox.isPopupVisible()) {
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        }));
        this.actionTable.getColumnExt(PROTOCOL_COLUMN_NAME).setCellRenderer((TableCellRenderer)new MirthComboBoxTableCellRenderer(this.protocols.keySet().toArray()));
        this.actionTable.getColumnExt(1).setCellRenderer((TableCellRenderer)new RecipientCellRenderer());
        this.actionTable.getColumnExt(RECIPIENT_COLUMN_NAME).setCellEditor((TableCellEditor)new RecipientCellEditor());
        this.actionTable.setRowHeight(20);
        this.actionTable.setSortable(false);
        this.actionTable.setOpaque(true);
        this.actionTable.setDragEnabled(false);
        this.actionTable.getTableHeader().setReorderingAllowed(false);
        this.actionTable.setShowGrid(true, true);
        this.actionTable.setAutoCreateColumnsFromModel(false);
        this.actionTable.getColumnExt(PROTOCOL_COLUMN_NAME).setMaxWidth(PROTOCOL_COLUMN_WIDTH);
        this.actionTable.getColumnExt(PROTOCOL_COLUMN_NAME).setMinWidth(PROTOCOL_COLUMN_WIDTH);
        this.actionTable.getColumnExt(PROTOCOL_COLUMN_NAME).setResizable(false);
        this.actionTable.getColumnExt(RECIPIENT_COLUMN_NAME).setMinWidth(75);
        this.actionTable.getColumnExt(RECIPIENT_COLUMN_NAME).setResizable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.actionTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    private void updateActionTable(List<AlertAction> alertActions) {
        TableCellEditor cellEditor = this.actionTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        for (Protocol protocol : this.protocols.values()) {
            if (!protocol.hasOptions()) continue;
            MirthComboBoxTableCellEditor editor = new MirthComboBoxTableCellEditor((JTable)((Object)this.actionTable), protocol.getRecipientNames().toArray(), 1, true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox comboBox = (JComboBox)e.getSource();
                    if (comboBox.isPopupVisible() && AlertActionPane.this.actionTable.getCellEditor() != null) {
                        AlertActionPane.this.actionTable.getCellEditor().stopCellEditing();
                    }
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            });
            editor.setEditable(true);
            editor.getComboBox().setCanEnableSave(false);
            editor.getComboBox().setAutoResizeDropdown(true);
            MirthComboBoxTableCellRenderer renderer = new MirthComboBoxTableCellRenderer(protocol.getRecipientNames().toArray());
            renderer.setEditable(true);
            ((RecipientCellRenderer)this.actionTable.getColumnExt(1).getCellRenderer()).setCellRenderer(protocol.getProtocolName(), renderer);
            ((RecipientCellEditor)this.actionTable.getColumnExt(RECIPIENT_COLUMN_NAME).getCellEditor()).setCellEditor(protocol.getProtocolName(), editor);
        }
        ActionTableModel model = (ActionTableModel)this.actionTable.getModel();
        model.refreshData(alertActions);
        if (model.getRowCount() == 0) {
            this.actionTable.clearSelection();
            this.removeActionButton.setEnabled(false);
        } else {
            this.actionTable.getSelectionModel().setSelectionInterval(0, 0);
            this.removeActionButton.setEnabled(true);
        }
    }

    public AlertActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public void setActionGroup(AlertActionGroup actionGroup, Map<String, Map<String, String>> protocolOptions) {
        this.actionGroup = actionGroup;
        this.updateProtocols(protocolOptions);
        this.subjectTextField.setText(this.actionGroup.getSubject());
        this.templateTextArea.setText(this.actionGroup.getTemplate());
        this.updateActionTable(this.actionGroup.getActions());
    }

    public void setVariableList(List<String> variables) {
        this.variableList.removeAll();
        this.variableList.setListData(variables.toArray());
        this.variableScrollPane.setViewportView((Component)((Object)this.variableList));
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setLayout((LayoutManager)new MigLayout("insets 0, flowy", "[][grow][]", "grow"));
        this.actionTable = new MirthTable();
        this.actionTable.setModel(new ActionTableModel());
        this.actionScrollPane = new JScrollPane((Component)((Object)this.actionTable));
        this.actionScrollPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.addActionButton = new MirthButton("Add");
        this.addActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ActionTableModel)AlertActionPane.this.actionTable.getModel()).addRow(new AlertAction(AlertActionPane.DEFAULT_PROTOCOL, ""));
                if (AlertActionPane.this.actionTable.getRowCount() == 1) {
                    AlertActionPane.this.actionTable.setRowSelectionInterval(0, 0);
                }
                AlertActionPane.this.removeActionButton.setEnabled(true);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.removeActionButton = new MirthButton("Remove");
        this.removeActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlertActionPane.this.actionTable.getSelectedModelIndex() != -1) {
                    if (AlertActionPane.this.actionTable.isEditing()) {
                        AlertActionPane.this.actionTable.getCellEditor().stopCellEditing();
                    }
                    ActionTableModel model = (ActionTableModel)AlertActionPane.this.actionTable.getModel();
                    int selectedModelIndex = AlertActionPane.this.actionTable.getSelectedModelIndex();
                    int newViewIndex = AlertActionPane.this.actionTable.convertRowIndexToView(selectedModelIndex);
                    if (newViewIndex == model.getRowCount() - 1) {
                        --newViewIndex;
                    }
                    model.removeRow(selectedModelIndex);
                    if (AlertActionPane.this.actionTable.getModel().getRowCount() != 0) {
                        AlertActionPane.this.actionTable.setRowSelectionInterval(newViewIndex, newViewIndex);
                    } else {
                        AlertActionPane.this.removeActionButton.setEnabled(false);
                    }
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        });
        this.actionPane = new JPanel();
        this.actionPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.actionPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Actions"));
        this.actionPane.setLayout((LayoutManager)new MigLayout("insets 0, flowy", "[grow][]", "grow"));
        this.actionPane.add((Component)this.actionScrollPane, "grow, wrap");
        this.actionPane.add((Component)this.addActionButton, "aligny top, growx, split");
        this.actionPane.add((Component)this.removeActionButton, "growx");
        this.subjectTextField = new MirthTextField();
        this.subjectTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AlertActionPane.this.actionGroup.setSubject(AlertActionPane.this.subjectTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AlertActionPane.this.actionGroup.setSubject(AlertActionPane.this.subjectTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.subjectPane = new JPanel();
        this.subjectPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.subjectPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Subject (only used for email messages)"));
        this.subjectPane.setLayout(new BorderLayout());
        this.subjectPane.add(this.subjectTextField);
        this.templateTextArea = new MirthTextArea();
        this.templateTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AlertActionPane.this.actionGroup.setTemplate(AlertActionPane.this.templateTextArea.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AlertActionPane.this.actionGroup.setTemplate(AlertActionPane.this.templateTextArea.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.templateScrollPane = new JScrollPane(this.templateTextArea);
        this.templateScrollPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.templatePane = new JPanel();
        this.templatePane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.templatePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Template"));
        this.templatePane.setLayout(new BorderLayout());
        this.templatePane.add(this.templateScrollPane);
        this.variableList = new MirthVariableList();
        this.variableScrollPane = new JScrollPane((Component)((Object)this.variableList));
        this.variableScrollPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.variablePane = new JPanel();
        this.variablePane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.variablePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Alert Variables"));
        this.variablePane.setLayout(new BorderLayout());
        this.variablePane.add(this.variableScrollPane);
        this.add((Component)this.actionPane, "width 280:280:280, growy, wrap");
        this.add((Component)this.subjectPane, "split, growx");
        this.add((Component)this.templatePane, "grow, wrap");
        this.add((Component)this.variablePane, "width 140:140:140, growy");
    }

    private void updateProtocols(Map<String, Map<String, String>> protocolOptions) {
        this.protocols = new LinkedHashMap<String, Protocol>();
        for (Map.Entry<String, Map<String, String>> entry : protocolOptions.entrySet()) {
            this.protocols.put(entry.getKey(), new Protocol(entry.getKey(), entry.getValue()));
        }
    }

    private class RecipientCellRenderer
    implements TableCellRenderer {
        private Map<String, TableCellRenderer> cellRenderers = new HashMap<String, TableCellRenderer>();
        private String protocol;

        public RecipientCellRenderer() {
            for (Protocol protocol : AlertActionPane.this.protocols.values()) {
                if (protocol.hasOptions()) {
                    MirthComboBoxTableCellRenderer renderer = new MirthComboBoxTableCellRenderer(new Object[0]);
                    renderer.setEditable(true);
                    this.cellRenderers.put(protocol.getProtocolName(), renderer);
                    continue;
                }
                this.cellRenderers.put(protocol.getProtocolName(), new DefaultTableCellRenderer());
            }
        }

        public void setCellRenderer(String protocol, TableCellRenderer cellRenderer) {
            this.cellRenderers.put(protocol, cellRenderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.protocol = (String)table.getValueAt(row, 0);
            return this.cellRenderers.get(this.protocol).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class RecipientCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Map<String, TableCellEditor> cellEditors = new HashMap<String, TableCellEditor>();
        private String protocol;

        public RecipientCellEditor() {
            for (Protocol protocol : AlertActionPane.this.protocols.values()) {
                if (protocol.hasOptions()) {
                    MirthComboBoxTableCellEditor editor = new MirthComboBoxTableCellEditor((JTable)((Object)AlertActionPane.this.actionTable), new Object[0], 1, false, null);
                    editor.setEditable(true);
                    this.cellEditors.put(protocol.getProtocolName(), editor);
                    continue;
                }
                this.cellEditors.put(protocol.getProtocolName(), new TextFieldCellEditor(){

                    @Override
                    protected boolean valueChanged(String value) {
                        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                        return true;
                    }
                });
            }
        }

        public void setCellEditor(String protocol, TableCellEditor cellEditor) {
            this.cellEditors.put(protocol, cellEditor);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.protocol = (String)table.getValueAt(row, 0);
            return this.cellEditors.get(this.protocol).getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellEditors.get(this.protocol).getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            this.cellEditors.get(this.protocol).stopCellEditing();
            return super.stopCellEditing();
        }
    }

    private class Protocol {
        private String protocolName;
        private Map<String, String> options;
        private Map<String, String> ids;

        public Protocol(String protocolName, Map<String, String> options) {
            this.protocolName = protocolName;
            if (options != null) {
                this.options = options;
                this.ids = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    this.ids.put(entry.getValue(), entry.getKey());
                }
            }
        }

        String getProtocolName() {
            return this.protocolName;
        }

        boolean hasOptions() {
            return this.options != null;
        }

        Set<String> getRecipientNames() {
            if (this.options == null) {
                return null;
            }
            TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            names.addAll(this.options.values());
            return names;
        }

        String getRecipientIdFromName(String name) {
            if (name == null) {
                return null;
            }
            if (this.options == null) {
                return name;
            }
            return this.ids.get(name);
        }

        String getRecipientNameFromId(String id) {
            if (this.options == null || !this.options.containsKey(id)) {
                return id;
            }
            return this.options.get(id);
        }
    }

    private class ActionTableModel
    extends AbstractTableModel {
        private List<AlertAction> actions = new ArrayList<AlertAction>();
        private String[] columns = new String[]{"Protocol", "Recipient"};

        public void refreshData(List<AlertAction> actions) {
            Iterator<AlertAction> iterator = actions.iterator();
            while (iterator.hasNext()) {
                if (AlertActionPane.this.protocols.containsKey(iterator.next().getProtocol())) continue;
                iterator.remove();
            }
            this.actions = actions;
            this.fireTableDataChanged();
        }

        public void addRow(AlertAction action) {
            if (AlertActionPane.this.protocols.containsKey(action.getProtocol())) {
                int row = this.actions.size();
                this.actions.add(action);
                this.fireTableRowsInserted(row, row);
            }
        }

        public void removeRow(int rowIndex) {
            this.actions.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.actions.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AlertAction action = this.actions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return action.getProtocol();
                }
                case 1: {
                    return AlertActionPane.this.protocols.get(action.getProtocol()).getRecipientNameFromId(action.getRecipient());
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AlertAction action = this.actions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    action.setProtocol((String)aValue);
                    action.setRecipient(null);
                    break;
                }
                case 1: {
                    String recipient = AlertActionPane.this.protocols.get(action.getProtocol()).getRecipientIdFromName((String)aValue);
                    if (StringUtils.isBlank((CharSequence)recipient)) {
                        recipient = (String)aValue;
                    }
                    action.setRecipient(recipient);
                    break;
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }
}

