/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.alert;

import com.mirth.connect.client.ui.AbstractSortableTreeTableNode;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.alert.AlertChannels;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class AlertChannelPane
extends JPanel {
    private JLabel filterLabel;
    private JTextField filterTextField;
    private JLabel expandLabel;
    private JLabel collapseLabel;
    private JButton enableButton;
    private JButton disableButton;
    private JScrollPane channelScrollPane;
    private MirthTreeTable channelTreeTable;

    public AlertChannelPane() {
        this.initComponents();
        this.makeChannelTable();
    }

    private void makeChannelTable() {
        ChannelTreeTableModel model = new ChannelTreeTableModel();
        model.setColumnIdentifiers(Arrays.asList("test"));
        this.channelTreeTable.setTreeTableModel((TreeTableModel)model);
        this.channelTreeTable.setDoubleBuffered(true);
        this.channelTreeTable.setSelectionMode(2);
        this.channelTreeTable.setHorizontalScrollEnabled(true);
        this.channelTreeTable.packTable(10);
        this.channelTreeTable.setRowHeight(20);
        this.channelTreeTable.setOpaque(true);
        this.channelTreeTable.setRowSelectionAllowed(true);
        this.channelTreeTable.putClientProperty("JTree.lineStyle", "Horizontal");
        this.channelTreeTable.setAutoCreateColumnsFromModel(false);
        this.channelTreeTable.setShowGrid(true, true);
        this.channelTreeTable.setTableHeader(null);
        this.channelTreeTable.setDragEnabled(false);
        this.channelTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean enabled = AlertChannelPane.this.channelTreeTable.getSelectedRowCount() > 0;
                    AlertChannelPane.this.enableButton.setEnabled(enabled);
                    AlertChannelPane.this.disableButton.setEnabled(enabled);
                }
            }
        });
        this.channelTreeTable.setTreeCellRenderer(new TreeCellRenderer(){
            private JLabel label = new JLabel();

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value != null) {
                    if (value instanceof ChannelTreeTableNode) {
                        ImageIcon icon;
                        ChannelTreeTableNode channelNode = (ChannelTreeTableNode)((Object)value);
                        if (channelNode.getChildCount() == 0) {
                            icon = channelNode.isEnabled() ? UIConstants.ICON_BULLET_GREEN : UIConstants.ICON_BULLET_RED;
                        } else {
                            boolean hasDisabled = false;
                            boolean hasEnabled = false;
                            for (int i = 0; i < channelNode.getChildCount(); ++i) {
                                ConnectorTreeTableNode connectorNode = (ConnectorTreeTableNode)channelNode.getChildAt(i);
                                if (connectorNode.isEnabled()) {
                                    hasEnabled = true;
                                    continue;
                                }
                                hasDisabled = true;
                            }
                            icon = hasEnabled && hasDisabled ? UIConstants.ICON_BULLET_YELLOW : (hasDisabled ? UIConstants.ICON_BULLET_RED : (hasEnabled ? UIConstants.ICON_BULLET_GREEN : UIConstants.ICON_BULLET_RED));
                        }
                        this.label.setText(channelNode.getChannelName());
                        this.label.setIcon(icon);
                    } else if (value instanceof ConnectorTreeTableNode) {
                        ConnectorTreeTableNode connectorNode = (ConnectorTreeTableNode)((Object)value);
                        ImageIcon icon = connectorNode.isEnabled() ? UIConstants.ICON_BULLET_GREEN : UIConstants.ICON_BULLET_RED;
                        this.label.setText(connectorNode.getConnectorName());
                        this.label.setIcon(icon);
                    }
                }
                return this.label;
            }
        });
        this.channelTreeTable.expandAll();
    }

    private void toggleSelectedRows(boolean enabled) {
        int[] selectedRows = this.channelTreeTable.getSelectedModelRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            TreePath path = this.channelTreeTable.getPathForRow(selectedRows[i]);
            AbstractChannelTreeTableNode node = (AbstractChannelTreeTableNode)((Object)path.getLastPathComponent());
            node.setEnabled(enabled);
            for (int j = 0; j < node.getChildCount(); ++j) {
                ((AbstractChannelTreeTableNode)node.getChildAt(j)).setEnabled(enabled);
            }
        }
        this.channelTreeTable.repaint();
    }

    public AlertChannels getChannels() {
        return ((ChannelTreeTableModel)this.channelTreeTable.getTreeTableModel()).getAlertChannels();
    }

    public void setChannels(AlertChannels alertChannels, boolean includeConnectors) {
        if (PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelStatuses() != null) {
            TreeMap<String, Channel> channelMap = new TreeMap<String, Channel>(String.CASE_INSENSITIVE_ORDER);
            for (ChannelStatus channelStatus : PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelStatuses().values()) {
                Channel channel = channelStatus.getChannel();
                channelMap.put(channel.getName(), channel);
            }
            ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTreeTable.getTreeTableModel();
            model.addChannels(channelMap.values(), alertChannels, includeConnectors);
        }
        this.enableButton.setEnabled(false);
        this.disableButton.setEnabled(false);
    }

    private void updateFilter(String filterString) {
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTreeTable.getTreeTableModel();
        model.setFilter(filterString);
        this.channelTreeTable.expandAll();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Channels"));
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[grow][grow]", "[][][grow]"));
        this.filterLabel = new JLabel("Filter: ");
        this.filterTextField = new JTextField();
        this.filterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AlertChannelPane.this.updateFilter(AlertChannelPane.this.filterTextField.getText());
            }
        });
        this.expandLabel = new JLabel("<html><u>Expand All</u></html>");
        this.expandLabel.setForeground(Color.blue);
        this.expandLabel.setToolTipText("Expand all nodes below.");
        this.expandLabel.setCursor(new Cursor(12));
        this.expandLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AlertChannelPane.this.channelTreeTable.expandAll();
            }
        });
        this.collapseLabel = new JLabel("<html><u>Collapse All</u></html>");
        this.collapseLabel.setForeground(Color.blue);
        this.collapseLabel.setToolTipText("Collapse all nodes below.");
        this.collapseLabel.setCursor(new Cursor(12));
        this.collapseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AlertChannelPane.this.channelTreeTable.collapseAll();
            }
        });
        this.enableButton = new JButton("Enable");
        this.enableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertChannelPane.this.toggleSelectedRows(true);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.disableButton = new JButton("Disable");
        this.disableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertChannelPane.this.toggleSelectedRows(false);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.channelTreeTable = new MirthTreeTable();
        this.channelScrollPane = new JScrollPane((Component)((Object)this.channelTreeTable));
        this.add((Component)this.filterLabel, "span 2, split");
        this.add((Component)this.filterTextField, "growx, span, wrap");
        this.add((Component)this.enableButton, "split 2, alignx left, width 50");
        this.add((Component)this.disableButton, "alignx left, width 50");
        this.add((Component)this.expandLabel, "split 2, alignx right");
        this.add((Component)this.collapseLabel, "alignx right, wrap");
        this.add((Component)this.channelScrollPane, "height 100:100:, width 100:100:, grow, span");
    }

    private class ChannelTreeTableModel
    extends SortableTreeTableModel {
        private AbstractChannelTreeTableNode modelRoot;
        private AbstractChannelTreeTableNode viewRoot;

        public ChannelTreeTableModel() {
            this.modelRoot = new AbstractChannelTreeTableNode(false){

                public Object getValueAt(int column) {
                    return null;
                }

                @Override
                public int getColumnCount() {
                    return 0;
                }
            };
            this.viewRoot = new AbstractChannelTreeTableNode(false){

                public Object getValueAt(int column) {
                    return null;
                }

                @Override
                public int getColumnCount() {
                    return 0;
                }
            };
            this.setRoot((TreeTableNode)this.viewRoot);
        }

        public int getHierarchicalColumn() {
            return 0;
        }

        public AlertChannels getAlertChannels() {
            AlertChannels channels = new AlertChannels();
            ChannelTreeTableNode channelNode = (ChannelTreeTableNode)this.modelRoot.getModelChildAt(0);
            channels.setNewChannel(((ConnectorTreeTableNode)channelNode.getModelChildAt(0)).isEnabled(), ((ConnectorTreeTableNode)channelNode.getModelChildAt(1)).isEnabled());
            for (int i = 1; i < this.modelRoot.getModelChildCount(); ++i) {
                channelNode = (ChannelTreeTableNode)this.modelRoot.getModelChildAt(i);
                String channelId = channelNode.getChannelId();
                HashMap<Integer, Boolean> connectors = new HashMap<Integer, Boolean>();
                for (int j = 0; j < channelNode.getModelChildCount(); ++j) {
                    ConnectorTreeTableNode connectorNode = (ConnectorTreeTableNode)channelNode.getModelChildAt(j);
                    connectors.put(connectorNode.getMetaDataId(), connectorNode.isEnabled());
                }
                channels.addChannel(channelId, connectors);
            }
            return channels;
        }

        public void setFilter(String filter) {
            filter = filter.toLowerCase();
            this.clearView();
            for (int i = 0; i < this.modelRoot.getModelChildCount(); ++i) {
                int j;
                boolean matchesFilter = false;
                ChannelTreeTableNode channelNode = (ChannelTreeTableNode)this.modelRoot.getModelChildAt(i);
                if (StringUtils.isBlank((CharSequence)filter) || channelNode.getChannelName().toLowerCase().contains(filter)) {
                    matchesFilter = true;
                } else {
                    for (j = 0; j < channelNode.getModelChildCount(); ++j) {
                        ConnectorTreeTableNode connectorNode = (ConnectorTreeTableNode)channelNode.getModelChildAt(j);
                        if (!connectorNode.getConnectorName().toLowerCase().contains(filter)) continue;
                        matchesFilter = true;
                        break;
                    }
                }
                if (!matchesFilter) continue;
                this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)this.viewRoot);
                for (j = 0; j < channelNode.getModelChildCount(); ++j) {
                    this.insertNodeInto((MutableTreeTableNode)channelNode.getModelChildAt(j), (MutableTreeTableNode)channelNode);
                }
            }
        }

        public void addChannels(Collection<Channel> channels, AlertChannels alertChannels, boolean includeConnectors) {
            this.clearView();
            this.modelRoot.removeAllModelChildren();
            ChannelTreeTableNode channelNode = new ChannelTreeTableNode("[New Channels]", null, alertChannels.isChannelEnabled(null));
            this.modelRoot.addModelChild(channelNode);
            if (includeConnectors) {
                channelNode.addModelChild(new ConnectorTreeTableNode("Source", 0, alertChannels.isConnectorEnabled(null, Integer.valueOf(0))));
                channelNode.addModelChild(new ConnectorTreeTableNode("[New Destinations]", null, alertChannels.isConnectorEnabled(null, null)));
            }
            for (Channel channel : channels) {
                String channelId = channel.getId();
                channelNode = new ChannelTreeTableNode(channel.getName(), channelId, alertChannels.isChannelEnabled(channelId));
                this.modelRoot.addModelChild(channelNode);
                if (!includeConnectors) continue;
                channelNode.addModelChild(new ConnectorTreeTableNode("Source", 0, alertChannels.isConnectorEnabled(channelId, Integer.valueOf(0))));
                for (Connector destinationConnector : channel.getDestinationConnectors()) {
                    Integer metaDataId = destinationConnector.getMetaDataId();
                    channelNode.addModelChild(new ConnectorTreeTableNode(destinationConnector.getName(), metaDataId, alertChannels.isConnectorEnabled(channelId, metaDataId)));
                }
                channelNode.addModelChild(new ConnectorTreeTableNode("[New Destinations]", null, alertChannels.isConnectorEnabled(channelId, null)));
            }
            this.setFilter("");
        }

        private void clearView() {
            int childCount = this.viewRoot.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.removeNodeFromParent((MutableTreeTableNode)this.viewRoot.getChildAt(0));
            }
        }
    }

    private abstract class AbstractChannelTreeTableNode
    extends AbstractSortableTreeTableNode {
        private boolean enabled;
        private List<AbstractChannelTreeTableNode> modelChildren = new ArrayList<AbstractChannelTreeTableNode>();

        public AbstractChannelTreeTableNode(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void addModelChild(AbstractChannelTreeTableNode child) {
            this.modelChildren.add(child);
        }

        public int getModelChildCount() {
            return this.modelChildren.size();
        }

        public AbstractChannelTreeTableNode getModelChildAt(int index) {
            return this.modelChildren.get(index);
        }

        public void removeAllModelChildren() {
            this.modelChildren.clear();
        }

        public int getColumnCount() {
            return 1;
        }
    }

    private class ConnectorTreeTableNode
    extends AbstractChannelTreeTableNode {
        private String connectorName;
        private Integer metaDataId;

        public ConnectorTreeTableNode(String connectorName, Integer metaDataId, boolean enabled) {
            super(enabled);
            this.connectorName = connectorName;
            this.metaDataId = metaDataId;
        }

        public String getConnectorName() {
            return this.connectorName;
        }

        public Integer getMetaDataId() {
            return this.metaDataId;
        }

        public Object getValueAt(int column) {
            return this.connectorName;
        }
    }

    private class ChannelTreeTableNode
    extends AbstractChannelTreeTableNode {
        private String channelName;
        private String channelId;

        public ChannelTreeTableNode(String channelName, String channelId, boolean enabled) {
            super(enabled);
            this.channelName = channelName;
            this.channelId = channelId;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public Object getValueAt(int column) {
            return this.channelName;
        }
    }
}

