/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.alert;

import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.NumberCellComparator;
import com.mirth.connect.client.ui.NumberCellRenderer;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.alert.AlertPanel;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTableTransferHandler;
import com.mirth.connect.model.alert.AlertStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DefaultAlertPanel
extends AlertPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private static final String STATUS_COLUMN_NAME = "Status";
    private static final String NAME_COLUMN_NAME = "Name";
    private static final String ID_COLUMN_NAME = "Id";
    private static final String ALERTED_COLUMN_NAME = "Alerted";
    private static final String ENABLED_STATUS = "Enabled";
    private static final int NAME_COLUMN_NUMBER = 1;
    private static final int ID_COLUMN_NUMBER = 2;
    private JScrollPane alertPane;
    private MirthTable alertTable;

    public DefaultAlertPanel() {
        this.initComponents();
        this.makeAlertTable();
    }

    private void makeAlertTable() {
        this.alertTable.setModel(new RefreshTableModel(null, new String[]{STATUS_COLUMN_NAME, NAME_COLUMN_NAME, ID_COLUMN_NAME, ALERTED_COLUMN_NAME}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.alertTable.setSelectionMode(2);
        this.alertTable.setHorizontalScrollEnabled(true);
        this.alertTable.getColumnExt(STATUS_COLUMN_NAME).setMaxWidth(75);
        this.alertTable.getColumnExt(STATUS_COLUMN_NAME).setMinWidth(75);
        this.alertTable.getColumnExt(STATUS_COLUMN_NAME).setCellRenderer((TableCellRenderer)new ImageCellRenderer());
        this.alertTable.getColumnExt(STATUS_COLUMN_NAME).setToolTipText("<html><body>The status of this alert. Possible values are enabled and disabled.</body></html>");
        this.alertTable.getColumnExt(NAME_COLUMN_NAME).setMinWidth(150);
        this.alertTable.getColumnExt(NAME_COLUMN_NAME).setToolTipText("<html><body>The name of this alert.</body></html>");
        this.alertTable.getColumnExt(ID_COLUMN_NAME).setMinWidth(215);
        this.alertTable.getColumnExt(ID_COLUMN_NAME).setMaxWidth(215);
        this.alertTable.getColumnExt(ID_COLUMN_NAME).setToolTipText("<html><body>The unique id of this alert.</body></html>");
        this.alertTable.getColumnExt(ALERTED_COLUMN_NAME).setCellRenderer((TableCellRenderer)new NumberCellRenderer());
        this.alertTable.getColumnExt(ALERTED_COLUMN_NAME).setComparator((Comparator)new NumberCellComparator());
        this.alertTable.getColumnExt(ALERTED_COLUMN_NAME).setMaxWidth(75);
        this.alertTable.getColumnExt(ALERTED_COLUMN_NAME).setMinWidth(75);
        this.alertTable.getColumnExt(ALERTED_COLUMN_NAME).setToolTipText("<html><body>The number of times alerts have been sent.</body></html>");
        this.alertTable.packTable(10);
        this.alertTable.setRowHeight(20);
        this.alertTable.setOpaque(true);
        this.alertTable.setRowSelectionAllowed(true);
        this.alertTable.setSortable(true);
        this.alertTable.getRowSorter().toggleSortOrder(this.alertTable.getColumnModelIndex(NAME_COLUMN_NAME));
        this.alertTable.setDragEnabled(true);
        this.alertTable.setDropMode(DropMode.ON);
        this.alertTable.setTransferHandler(new MirthTableTransferHandler(1, 2){

            @Override
            public void importFile(File file, boolean showAlerts) {
                DefaultAlertPanel.this.parent.importAlert(DefaultAlertPanel.this.parent.readFileToString(file), showAlerts);
            }
        });
        this.alertTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DefaultAlertPanel.this.AlertListSelected(evt);
            }
        });
        this.alertTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DefaultAlertPanel.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DefaultAlertPanel.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (DefaultAlertPanel.this.alertTable.rowAtPoint(new Point(evt.getX(), evt.getY())) == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2) {
                    DefaultAlertPanel.this.parent.doEditAlert();
                }
            }
        });
        this.alertTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    DefaultAlertPanel.this.parent.doDeleteAlert();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.alertTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    @Override
    public void updateAlertTable(List<AlertStatus> alertStatusList) {
        Object[][] tableData = null;
        if (alertStatusList != null) {
            tableData = new Object[alertStatusList.size()][4];
            for (int i = 0; i < alertStatusList.size(); ++i) {
                AlertStatus alertStatus = alertStatusList.get(i);
                tableData[i][0] = alertStatus.isEnabled() ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), ENABLED_STATUS) : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
                tableData[i][1] = alertStatus.getName();
                tableData[i][2] = alertStatus.getId();
                if (alertStatus.getAlertedCount() == null) continue;
                tableData[i][3] = alertStatus.getAlertedCount();
            }
        }
        RefreshTableModel model = (RefreshTableModel)this.alertTable.getModel();
        model.refreshDataVector(tableData);
        if (tableData.length == 0) {
            this.alertTable.clearSelection();
        }
    }

    private void AlertListSelected(ListSelectionEvent evt) {
        int[] rows = this.alertTable.getSelectedModelRows();
        int column = this.alertTable.getColumnModelIndex(STATUS_COLUMN_NAME);
        if (rows.length > 0) {
            this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 3, -1, true);
            if (rows.length > 1) {
                this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 4, 4, false);
                this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 6, 8, false);
            } else {
                this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 7, 8, false);
            }
            for (int i = 0; i < rows.length; ++i) {
                if (((CellData)this.alertTable.getModel().getValueAt(rows[i], column)).getText().equals(ENABLED_STATUS)) {
                    this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 8, 8, true);
                    continue;
                }
                this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 7, 7, true);
            }
        }
    }

    private void checkSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.alertTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1 && !this.alertTable.isRowSelected(row)) {
                this.alertTable.setRowSelectionInterval(row, row);
            }
            this.parent.alertPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void deselectRows() {
        this.alertTable.clearSelection();
        this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 0, -1, true);
        this.parent.setVisibleTasks(this.parent.alertTasks, this.parent.alertPopupMenu, 4, -1, false);
    }

    @Override
    public Map<String, String> getAlertNames() {
        HashMap<String, String> alertNames = new HashMap<String, String>();
        for (int i = 0; i < this.alertTable.getRowCount(); ++i) {
            String alertId = (String)this.alertTable.getModel().getValueAt(i, this.alertTable.getColumnModelIndex(ID_COLUMN_NAME));
            String alertName = (String)this.alertTable.getModel().getValueAt(i, this.alertTable.getColumnModelIndex(NAME_COLUMN_NAME));
            alertNames.put(alertId, alertName);
        }
        return alertNames;
    }

    @Override
    public List<String> getSelectedAlertIds() {
        int[] selectedRows = this.alertTable.getSelectedModelRows();
        ArrayList<String> selectedAlertIds = new ArrayList<String>();
        for (int i = 0; i < selectedRows.length; ++i) {
            String alertId = (String)this.alertTable.getModel().getValueAt(selectedRows[i], this.alertTable.getColumnModelIndex(ID_COLUMN_NAME));
            selectedAlertIds.add(alertId);
        }
        return selectedAlertIds;
    }

    @Override
    public void setSelectedAlertIds(List<String> alertIds) {
        TableModel model = this.alertTable.getModel();
        int rowCount = model.getRowCount();
        int idColumn = this.alertTable.getColumnModelIndex(ID_COLUMN_NAME);
        for (String alertId : alertIds) {
            for (int i = 0; i < rowCount; ++i) {
                if (!alertId.equals(model.getValueAt(i, idColumn))) continue;
                int row = this.alertTable.convertRowIndexToView(i);
                this.alertTable.addRowSelectionInterval(row, row);
            }
        }
    }

    @Override
    public void updateAlertDetails(Set<String> alertIds) {
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout((LayoutManager)new MigLayout("fill, insets 0"));
        this.alertTable = new MirthTable();
        this.alertPane = new JScrollPane((Component)((Object)this.alertTable));
        this.alertPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.alertPane, "grow");
    }
}

