/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.attachments;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class CustomAttachmentDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private boolean initialFocus = true;
    private final String PROPERTY_NAME_COLUMN_NAME = "Name";
    private final String PROPERTY_VALUE_COLUMN_NAME = "Value";
    private AttachmentHandlerProperties attachmentHandlerProperties;
    public static final int DATA_TYPE_COLUMN_NUMBER = 1;
    private JButton addPropertyButton;
    private MirthTextField classNameField;
    private JButton closeButton;
    private JButton deletePropertyButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JScrollPane propertiesPane;
    private MirthTable propertiesTable;

    public CustomAttachmentDialog(AttachmentHandlerProperties properties) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.initComponents();
        this.initPropertiesTable();
        this.attachmentHandlerProperties = properties;
        this.classNameField.setText(this.attachmentHandlerProperties.getClassName());
        this.classNameField.requestFocus();
        this.classNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CustomAttachmentDialog.this.initialFocus) {
                    CustomAttachmentDialog.this.classNameField.setCaretPosition(0);
                    CustomAttachmentDialog.this.initialFocus = false;
                }
            }
        });
        this.updatePropertiesTable(this.attachmentHandlerProperties.getProperties());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
    }

    private void initPropertiesTable() {
        this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                if (!value.equals(this.getValueAt(row, column))) {
                    CustomAttachmentDialog.this.parent.setSaveEnabled(true);
                }
                super.setValueAt(value, row, column);
            }
        };
        this.propertiesTable.setSortable(false);
        this.propertiesTable.getTableHeader().setReorderingAllowed(false);
        this.propertiesTable.setModel(model);
        this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomAttachmentDialog.this.deletePropertyButton.setEnabled(CustomAttachmentDialog.this.propertiesTable.getSelectedRow() != -1);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.propertiesTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.deletePropertyButton.setEnabled(false);
    }

    private void updatePropertiesTable(Map<String, String> properties) {
        DefaultTableModel model = (DefaultTableModel)this.propertiesTable.getModel();
        model.setNumRows(0);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            model.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.closeButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.propertiesPane = new JScrollPane();
        this.propertiesTable = new MirthTable();
        this.addPropertyButton = new JButton();
        this.deletePropertyButton = new JButton();
        this.jPanel3 = new JPanel();
        this.classNameField = new MirthTextField();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Set Attachment Properties");
        this.setPreferredSize(new Dimension(627, 370));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomAttachmentDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.propertiesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.propertiesPane.setViewportView((Component)((Object)this.propertiesTable));
        this.addPropertyButton.setText("New");
        this.addPropertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomAttachmentDialog.this.addPropertyButtonActionPerformed(evt);
            }
        });
        this.deletePropertyButton.setText("Delete");
        this.deletePropertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomAttachmentDialog.this.deletePropertyButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.propertiesPane, -1, 536, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.deletePropertyButton, -1, -1, Short.MAX_VALUE).addComponent(this.addPropertyButton, -2, 49, -2))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.addPropertyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deletePropertyButton).addContainerGap(162, Short.MAX_VALUE)).addComponent(this.propertiesPane, -2, 0, Short.MAX_VALUE));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Fully Qualified Java Class Name"));
        this.jLabel1.setText("The specified class must extend MirthAttachmentHandler.");
        this.jLabel1.setToolTipText("com.mirth.connect.server.util.MirthAttachmentHandler");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameField, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classNameField, -2, -1, -2)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()));
        this.jPanel2.getAccessibleContext().setAccessibleName("Properties Pane");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.attachmentHandlerProperties.setClassName(this.classNameField.getText());
        this.attachmentHandlerProperties.getProperties().clear();
        DefaultTableModel model = (DefaultTableModel)this.propertiesTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            this.attachmentHandlerProperties.getProperties().put((String)model.getValueAt(i, 0), (String)model.getValueAt(i, 1));
        }
        this.attachmentHandlerProperties = null;
        this.dispose();
    }

    private void addPropertyButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.propertiesTable.getModel();
        int row = model.getRowCount();
        model.addRow(new Object[]{"", ""});
        this.propertiesTable.setRowSelectionInterval(row, row);
        this.parent.setSaveEnabled(true);
    }

    private void deletePropertyButtonActionPerformed(ActionEvent evt) {
        int rowCount;
        int selectedRow = this.propertiesTable.getSelectedRow();
        if (selectedRow != -1 && !this.propertiesTable.isEditing()) {
            ((DefaultTableModel)this.propertiesTable.getModel()).removeRow(selectedRow);
        }
        if ((rowCount = this.propertiesTable.getRowCount()) > 0) {
            if (selectedRow >= rowCount) {
                --selectedRow;
            }
            this.propertiesTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.parent.setSaveEnabled(true);
    }
}

