/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.attachments;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class IdentityAttachmentDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private AttachmentHandlerProperties attachmentHandlerProperties;
    private JPanel propertiesPanel;
    private JLabel mimeTypeLabel;
    private JTextField mimeTypeField;
    private JSeparator separator;
    private JButton closeButton;

    public IdentityAttachmentDialog(AttachmentHandlerProperties attachmentHandlerProperties) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.setProperties(attachmentHandlerProperties);
        this.setTitle("Set Attachment Properties");
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(309, 130));
        this.pack();
        this.setLocationRelativeTo((Component)((Object)this.parent));
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setBackground(this.getBackground());
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.mimeTypeLabel = new JLabel("MIME Type:");
        this.mimeTypeField = new JTextField();
        this.separator = new JSeparator(0);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentityAttachmentDialog.this.close();
            }
        });
    }

    private void initToolTips() {
        this.mimeTypeField.setToolTipText("The MIME type of the message. Source map variables may be used here.");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 10, novisualpadding, hidemode 3, fill"));
        this.propertiesPanel.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3", "[]13[]"));
        this.propertiesPanel.add((Component)this.mimeTypeLabel, "right");
        this.propertiesPanel.add((Component)this.mimeTypeField, "growx, pushx");
        this.add((Component)this.propertiesPanel, "grow, push");
        this.add((Component)this.separator, "newline, growx, pushx");
        this.add((Component)this.closeButton, "newline, right");
    }

    private void setProperties(AttachmentHandlerProperties attachmentHandlerProperties) {
        this.attachmentHandlerProperties = attachmentHandlerProperties;
        this.mimeTypeField.setText(StringUtils.defaultString((String)((String)attachmentHandlerProperties.getProperties().get("identity.mimetype"))));
    }

    private void close() {
        this.attachmentHandlerProperties.getProperties().clear();
        this.attachmentHandlerProperties.getProperties().put("identity.mimetype", this.mimeTypeField.getText());
        this.parent.setSaveEnabled(true);
        this.dispose();
    }
}

