/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.attachments;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class RegexAttachmentDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private AttachmentHandlerProperties attachmentHandlerProperties;
    public static final int DATA_TYPE_COLUMN_NUMBER = 1;
    private JPanel regularExpressionPanel;
    private JTextField regexExampleTextField;
    private MirthTable regexTable;
    private JScrollPane regexTableScrollPane;
    private JButton regexNewButton;
    private JButton regexDeleteButton;
    private JPanel stringReplacementPanel;
    private JLabel stringReplacementLabel;
    private MirthTable inboundReplacementTable;
    private JScrollPane inboundScrollPane;
    private MirthTable outboundReplacementTable;
    private JScrollPane outboundScrollPane;
    private JPanel inboundButtonPanel;
    private JButton inboundNewButton;
    private JButton inboundDeleteButton;
    private JPanel outboundButtonPanel;
    private JButton outboundNewButton;
    private JButton outboundDeleteButton;
    private JSeparator separator;
    private JButton closeButton;

    public RegexAttachmentDialog(AttachmentHandlerProperties properties) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        DefaultTableModel tableModel;
        this.setTitle("Set Attachment Properties");
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 12", "[fill, grow]"));
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(650, 550));
        this.initComponents();
        this.initLayout();
        this.initInboundReplacementTable();
        this.initOutboundReplacementTable();
        this.attachmentHandlerProperties = properties;
        ArrayList<RegexInfo> regexInfoList = new ArrayList<RegexInfo>();
        if (this.attachmentHandlerProperties.getProperties().containsKey("regex.pattern")) {
            String regex = StringUtils.defaultString((String)((String)this.attachmentHandlerProperties.getProperties().get("regex.pattern")));
            String mimeType = StringUtils.defaultString((String)((String)this.attachmentHandlerProperties.getProperties().get("regex.mimetype")));
            regexInfoList.add(new RegexInfo(regex, mimeType));
        }
        int count = 0;
        while (this.attachmentHandlerProperties.getProperties().containsKey("regex.pattern" + count)) {
            String regex = StringUtils.defaultString((String)((String)this.attachmentHandlerProperties.getProperties().get("regex.pattern" + count)));
            String mimeType = StringUtils.defaultString((String)((String)this.attachmentHandlerProperties.getProperties().get("regex.mimetype" + count)));
            regexInfoList.add(new RegexInfo(regex, mimeType));
            ++count;
        }
        Object[][] regexTableData = new Object[regexInfoList.size()][2];
        int i = 0;
        for (RegexInfo regexInfo : regexInfoList) {
            regexTableData[i][0] = regexInfo.pattern;
            regexTableData[i][1] = regexInfo.mimeType;
            ++i;
        }
        ((RefreshTableModel)this.regexTable.getModel()).refreshDataVector(regexTableData);
        count = 0;
        while (this.attachmentHandlerProperties.getProperties().containsKey("regex.replaceKey" + count)) {
            tableModel = (DefaultTableModel)this.inboundReplacementTable.getModel();
            tableModel.addRow(new Object[]{this.attachmentHandlerProperties.getProperties().get("regex.replaceKey" + count), this.attachmentHandlerProperties.getProperties().get("regex.replaceValue" + count)});
            ++count;
        }
        count = 0;
        while (this.attachmentHandlerProperties.getProperties().containsKey("outbound.regex.replaceKey" + count)) {
            tableModel = (DefaultTableModel)this.outboundReplacementTable.getModel();
            tableModel.addRow(new Object[]{this.attachmentHandlerProperties.getProperties().get("outbound.regex.replaceKey" + count), this.attachmentHandlerProperties.getProperties().get("outbound.regex.replaceValue" + count)});
            ++count;
        }
        this.setLocationRelativeTo((Component)((Object)this.parent));
        this.setVisible(true);
    }

    private void initInboundReplacementTable() {
        this.inboundReplacementTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"Replace All", "Replace With"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        this.inboundReplacementTable.setSortable(false);
        this.inboundReplacementTable.getTableHeader().setReorderingAllowed(false);
        this.inboundReplacementTable.setModel(model);
        this.inboundReplacementTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegexAttachmentDialog.this.inboundDeleteButton.setEnabled(RegexAttachmentDialog.this.inboundReplacementTable.getSelectedRow() != -1);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.inboundReplacementTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.inboundDeleteButton.setEnabled(false);
    }

    private void initOutboundReplacementTable() {
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"Replace All", "Replace With"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        this.outboundReplacementTable.setSortable(false);
        this.outboundReplacementTable.getTableHeader().setReorderingAllowed(false);
        this.outboundReplacementTable.setModel(model);
        this.outboundReplacementTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegexAttachmentDialog.this.outboundDeleteButton.setEnabled(RegexAttachmentDialog.this.outboundReplacementTable.getSelectedRow() != -1);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.outboundReplacementTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.outboundDeleteButton.setEnabled(false);
    }

    private void initComponents() {
        this.regularExpressionPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 3, fill, insets 0"));
        this.regularExpressionPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.regularExpressionPanel.setBorder(BorderFactory.createTitledBorder("Regular Expressions"));
        this.regexExampleTextField = new JTextField();
        this.regexExampleTextField.setText("(?:OBX\\|(?:[^|]*\\|){4}(?:[^|^]*\\^){4})([^|^\\r\\n]*)(?:[|^\\r\\n]|$)");
        this.regexExampleTextField.setEditable(false);
        this.regexExampleTextField.setBorder(null);
        this.regexExampleTextField.setOpaque(false);
        this.regexTable = new MirthTable();
        this.regexTable.setModel(new RefreshTableModel(new Object[]{"Regular Expression", "MIME Type"}, 0));
        this.regexTable.setDragEnabled(false);
        this.regexTable.setRowSelectionAllowed(true);
        this.regexTable.setSelectionMode(0);
        this.regexTable.setRowHeight(20);
        this.regexTable.setFocusable(true);
        this.regexTable.setOpaque(true);
        this.regexTable.getTableHeader().setReorderingAllowed(false);
        this.regexTable.setEditable(true);
        this.regexTable.setSortable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.regexTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.regexTable.getColumnExt(0).setMinWidth(105);
        this.regexTable.getColumnExt(0).setPreferredWidth(350);
        this.regexTable.getColumnExt(0).setToolTipText("<html>The regular expression that will be used to match and extract attachments.<br>If capturing groups are used, only the last group will be extracted.</html>");
        this.regexTable.getColumnExt(1).setMinWidth(63);
        this.regexTable.getColumnExt(1).setToolTipText("The MIME type of the extracted attachment data. Source map variables may be used here.");
        this.regexTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegexAttachmentDialog.this.regexDeleteButton.setEnabled(RegexAttachmentDialog.this.regexTable.getSelectedRow() >= 0);
            }
        });
        this.regexTableScrollPane = new JScrollPane((Component)((Object)this.regexTable));
        this.regexNewButton = new JButton("New");
        this.regexNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.regexNewButtonActionPerformed();
            }
        });
        this.regexDeleteButton = new JButton("Delete");
        this.regexDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.regexDeleteButtonActionPerformed();
            }
        });
        this.regexDeleteButton.setEnabled(false);
        this.stringReplacementPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0"));
        this.stringReplacementPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.stringReplacementPanel.setBorder(BorderFactory.createTitledBorder("String Replacement"));
        this.stringReplacementLabel = new JLabel();
        this.stringReplacementLabel.setText("<html>Replace strings on the matched data before storing. Do not use regular expressions in these fields or surround with quotes.<br>\nExample: Use <b>\\\\X0D0A\\\\</b> and <b>\\r\\n</b> to replace \\X0D0A\\ with actual CRLF characters. </html>");
        this.inboundReplacementTable = new MirthTable();
        this.inboundScrollPane = new JScrollPane();
        this.inboundScrollPane.setViewportView((Component)((Object)this.inboundReplacementTable));
        this.outboundReplacementTable = new MirthTable();
        this.outboundScrollPane = new JScrollPane();
        this.outboundScrollPane.setViewportView((Component)((Object)this.outboundReplacementTable));
        this.inboundButtonPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0", "", ""));
        this.inboundButtonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.inboundNewButton = new JButton("New");
        this.inboundNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.inboundNewButtonActionPerformed(evt);
            }
        });
        this.inboundDeleteButton = new JButton("Delete");
        this.inboundDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.inboundDeleteButtonActionPerformed(evt);
            }
        });
        this.outboundButtonPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0", "", ""));
        this.outboundButtonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.outboundNewButton = new JButton("New");
        this.outboundNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.outboundNewButtonActionPerformed(evt);
            }
        });
        this.outboundDeleteButton = new JButton("Delete");
        this.outboundDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.outboundDeleteButtonActionPerformed(evt);
            }
        });
        this.separator = new JSeparator();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexAttachmentDialog.this.closeButtonActionPerformed(evt);
            }
        });
    }

    private void initLayout() {
        this.regularExpressionPanel.add((Component)new JLabel("Example for OBX 5.5: "), "sx, split 2");
        this.regularExpressionPanel.add((Component)this.regexExampleTextField, "push");
        this.regularExpressionPanel.add((Component)this.regexTableScrollPane, "newline, h 80:, grow, push");
        this.regularExpressionPanel.add((Component)this.regexNewButton, "w 50!, top, split 2, flowy");
        this.regularExpressionPanel.add((Component)this.regexDeleteButton, "w 50!");
        this.stringReplacementPanel.add((Component)this.stringReplacementLabel, "left, sx, growx, wrap");
        this.stringReplacementPanel.add((Component)new JLabel("<html><b>Inbound Replacements</b></html>"), "newline, wrap");
        this.stringReplacementPanel.add((Component)this.inboundScrollPane, "right, grow, push");
        this.inboundButtonPanel.add((Component)this.inboundNewButton, "w 50!, wrap");
        this.inboundButtonPanel.add((Component)this.inboundDeleteButton, "w 50!");
        this.stringReplacementPanel.add((Component)this.inboundButtonPanel, "aligny top, left");
        this.stringReplacementPanel.add((Component)new JLabel("<html><b>Outbound Replacements</b></html>"), "newline, wrap");
        this.stringReplacementPanel.add((Component)this.outboundScrollPane, "right, grow, push");
        this.outboundButtonPanel.add((Component)this.outboundNewButton, "w 50!, wrap");
        this.outboundButtonPanel.add((Component)this.outboundDeleteButton, "w 50!");
        this.stringReplacementPanel.add((Component)this.outboundButtonPanel, "aligny top, left");
        this.add((Component)this.regularExpressionPanel, "grow, wrap");
        this.add((Component)this.stringReplacementPanel, "wrap");
        this.add((Component)this.separator, "wrap");
        this.add((Component)this.closeButton, " w 50!, right");
        this.pack();
    }

    private void regexNewButtonActionPerformed() {
        int row = this.regexTable.getSelectedRow() + 1;
        ((RefreshTableModel)this.regexTable.getModel()).insertRow(row, new Object[]{"", ""});
        this.regexTable.getSelectionModel().setSelectionInterval(row, row);
        this.regexTable.scrollRowToVisible(row);
    }

    private void regexDeleteButtonActionPerformed() {
        int selectedRow = this.regexTable.getSelectedRow();
        if (selectedRow >= 0) {
            ((RefreshTableModel)this.regexTable.getModel()).removeRow(selectedRow);
            if (selectedRow < this.regexTable.getRowCount()) {
                this.regexTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            } else if (this.regexTable.getRowCount() > 0) {
                this.regexTable.getSelectionModel().setSelectionInterval(this.regexTable.getRowCount() - 1, this.regexTable.getRowCount() - 1);
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.regexTable.isEditing()) {
            this.regexTable.getCellEditor().stopCellEditing();
        }
        if (this.inboundReplacementTable.isEditing()) {
            this.inboundReplacementTable.getCellEditor().stopCellEditing();
        }
        if (this.outboundReplacementTable.isEditing()) {
            this.outboundReplacementTable.getCellEditor().stopCellEditing();
        }
        this.attachmentHandlerProperties.getProperties().clear();
        for (int row = 0; row < this.regexTable.getModel().getRowCount(); ++row) {
            String regex = (String)this.regexTable.getModel().getValueAt(row, 0);
            String mimeType = (String)this.regexTable.getModel().getValueAt(row, 1);
            this.attachmentHandlerProperties.getProperties().put("regex.pattern" + row, regex);
            this.attachmentHandlerProperties.getProperties().put("regex.mimetype" + row, mimeType);
        }
        DefaultTableModel inboundTableModel = (DefaultTableModel)this.inboundReplacementTable.getModel();
        for (int row = 0; row < inboundTableModel.getRowCount(); ++row) {
            String replaceKey = (String)inboundTableModel.getValueAt(row, 0);
            String replaceValue = (String)inboundTableModel.getValueAt(row, 1);
            this.attachmentHandlerProperties.getProperties().put("regex.replaceKey" + row, replaceKey);
            this.attachmentHandlerProperties.getProperties().put("regex.replaceValue" + row, replaceValue);
        }
        DefaultTableModel outboundTableModel = (DefaultTableModel)this.outboundReplacementTable.getModel();
        for (int row = 0; row < outboundTableModel.getRowCount(); ++row) {
            String replaceKey = (String)outboundTableModel.getValueAt(row, 0);
            String replaceValue = (String)outboundTableModel.getValueAt(row, 1);
            this.attachmentHandlerProperties.getProperties().put("outbound.regex.replaceKey" + row, replaceKey);
            this.attachmentHandlerProperties.getProperties().put("outbound.regex.replaceValue" + row, replaceValue);
        }
        this.attachmentHandlerProperties = null;
        this.parent.setSaveEnabled(true);
        this.dispose();
    }

    private void inboundNewButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.inboundReplacementTable.getModel();
        int row = model.getRowCount();
        model.addRow(new Object[]{"", ""});
        this.inboundReplacementTable.setRowSelectionInterval(row, row);
    }

    private void inboundDeleteButtonActionPerformed(ActionEvent evt) {
        int rowCount;
        int selectedRow = this.inboundReplacementTable.getSelectedRow();
        if (selectedRow != -1 && !this.inboundReplacementTable.isEditing()) {
            ((DefaultTableModel)this.inboundReplacementTable.getModel()).removeRow(selectedRow);
        }
        if ((rowCount = this.inboundReplacementTable.getRowCount()) > 0) {
            if (selectedRow >= rowCount) {
                --selectedRow;
            }
            this.inboundReplacementTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void outboundNewButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.outboundReplacementTable.getModel();
        int row = model.getRowCount();
        model.addRow(new Object[]{"", ""});
        this.outboundReplacementTable.setRowSelectionInterval(row, row);
    }

    private void outboundDeleteButtonActionPerformed(ActionEvent evt) {
        int rowCount;
        int selectedRow = this.outboundReplacementTable.getSelectedRow();
        if (selectedRow != -1 && !this.outboundReplacementTable.isEditing()) {
            ((DefaultTableModel)this.outboundReplacementTable.getModel()).removeRow(selectedRow);
        }
        if ((rowCount = this.outboundReplacementTable.getRowCount()) > 0) {
            if (selectedRow >= rowCount) {
                --selectedRow;
            }
            this.outboundReplacementTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private class RegexInfo {
        public String pattern;
        public String mimeType;

        public RegexInfo(String pattern, String mimeType) {
            this.pattern = pattern;
            this.mimeType = mimeType;
        }
    }
}

