/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.browsers.event;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.PaginatedEventList;
import com.mirth.connect.client.core.RequestAbortedException;
import com.mirth.connect.client.core.api.servlets.EventServletInterface;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.DateCellRenderer;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.ViewContentDialog;
import com.mirth.connect.client.ui.browsers.event.EventBrowserAdvancedFilter;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthDatePicker;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTimePicker;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.User;
import com.mirth.connect.model.filters.EventFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DateFormatter;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class EventBrowser
extends JPanel {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final String EVENT_ID_COLUMN_NAME = "ID";
    private final String EVENT_LEVEL_COLUMN_NAME = "Level";
    private final String EVENT_DATE_COLUMN_NAME = "Date & Time";
    private final String EVENT_NAME_COLUMN_NAME = "Name";
    private final String EVENT_SERVER_ID_COLUMN_NAME = "Server ID";
    private final String EVENT_USER_COLUMN_NAME = "User";
    private final String EVENT_OUTCOME_COLUMN_NAME = "Outcome";
    private final String EVENT_IP_ADDRESS_COLUMN_NAME = "IP Address";
    private final String EVENT_PATIENT_ID_NAME = "Patient ID";
    private final String EVENT_CHANNEL_MESSAGE_COLUMN_NAME = "Channel ID - Message ID";
    private final String EVENT_CHANNEL_NAME_COLUMN_NAME = "Channel Name";
    private final String ATTRIBUTES_NAME_COLUMN_NAME = "Name";
    private final String ATTRIBUTES_VALUE_COLUMN_NAME = "Value";
    private final int ATTRIBUTES_VALUE_COLUMN_NUMBER = 1;
    private Frame parent;
    private PaginatedEventList events;
    private EventFilter eventFilter;
    private EventBrowserAdvancedFilter advancedSearchPopup;
    private Map<Integer, String> userMapById = new LinkedHashMap<Integer, String>();
    private SwingWorker<Void, Void> worker;
    private JButton advSearchButton;
    private MirthCheckBox allDayCheckBox;
    private MirthButton countButton;
    private MirthDatePicker endDatePicker;
    private MirthTimePicker endTimePicker;
    private JScrollPane eventAttributesPane;
    private MirthTable eventAttributesTable;
    private JPanel eventDetailsPanel;
    private JScrollPane eventPane;
    private JSplitPane eventSplitPane;
    private MirthTable eventTable;
    private JButton filterButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextArea lastSearchCriteria;
    private JScrollPane lastSearchCriteriaPane;
    private MirthCheckBox levelBoxError;
    private MirthCheckBox levelBoxInformation;
    private MirthCheckBox levelBoxWarning;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton nextPageButton;
    private JButton pageGoButton;
    private MirthTextField pageNumberField;
    private JLabel pageNumberLabel;
    private MirthTextField pageSizeField;
    private JLabel pageSizeLabel;
    private JLabel pageTotalLabel;
    private JButton previousPageButton;
    private JButton resetButton;
    private JLabel resultsLabel;
    private MirthDatePicker startDatePicker;
    private MirthTimePicker startTimePicker;

    public EventBrowser() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.initComponentsManual();
        this.makeEventTable();
        this.makeAttributesTable();
    }

    public void initComponentsManual() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    EventBrowser.this.parent.eventPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    EventBrowser.this.parent.eventPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.pageSizeField.setDocument(new MirthFieldConstraints(3, false, false, true));
        this.pageNumberField.setDocument(new MirthFieldConstraints(7, false, false, true));
        LineBorder lineBorder = new LineBorder(new Color(0, 0, 0));
        TitledBorder titledBorder = new TitledBorder("Current Search");
        titledBorder.setBorder(lineBorder);
        this.lastSearchCriteriaPane.setBorder(titledBorder);
        this.lastSearchCriteriaPane.setBackground(Color.white);
        this.lastSearchCriteria.setBackground(Color.white);
        this.startDatePicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                EventBrowser.this.allDayCheckBox.setEnabled(EventBrowser.this.startDatePicker.getDate() != null || EventBrowser.this.endDatePicker.getDate() != null);
                EventBrowser.this.startTimePicker.setEnabled(EventBrowser.this.startDatePicker.getDate() != null && !EventBrowser.this.allDayCheckBox.isSelected());
            }
        });
        this.endDatePicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                EventBrowser.this.allDayCheckBox.setEnabled(EventBrowser.this.startDatePicker.getDate() != null || EventBrowser.this.endDatePicker.getDate() != null);
                EventBrowser.this.endTimePicker.setEnabled(EventBrowser.this.endDatePicker.getDate() != null && !EventBrowser.this.allDayCheckBox.isSelected());
            }
        });
        this.pageNumberField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10 && EventBrowser.this.pageGoButton.isEnabled()) {
                    EventBrowser.this.jumpToPageNumber();
                }
            }
        });
        this.updateCachedUserMap();
        this.advancedSearchPopup = new EventBrowserAdvancedFilter(this.parent, "Advanced Search Filter", true, this.userMapById);
        this.advancedSearchPopup.setVisible(false);
        this.eventSplitPane.setDividerLocation(0.8);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                EventBrowser.this.parent.mirthClient.getServerConnection().abort(EventBrowser.this.getAbortOperations());
                EventBrowser.this.parent.eventBrowser.clearCache();
            }
        });
    }

    public void loadNew(String eventNameFilter) {
        this.pageSizeField.setText(String.valueOf(Preferences.userNodeForPackage(Mirth.class).getInt("eventBrowserPageSize", 100)));
        if (eventNameFilter != null) {
            this.nameField.setText(eventNameFilter);
        } else {
            this.nameField.setText("");
        }
        this.updateCachedUserMap();
        this.advancedSearchPopup.reset();
        this.runSearch();
    }

    private Calendar getCalendar(MirthDatePicker datePicker, MirthTimePicker timePicker) throws ParseException {
        DateFormatter timeFormatter = new DateFormatter(new SimpleDateFormat("hh:mm aa"));
        Date date = datePicker.getDate();
        String time = timePicker.getDate();
        if (date != null && time != null) {
            Calendar dateCalendar = Calendar.getInstance();
            Calendar timeCalendar = Calendar.getInstance();
            Calendar dateTimeCalendar = Calendar.getInstance();
            dateCalendar.setTime(date);
            timeCalendar.setTime((Date)timeFormatter.stringToValue(time));
            dateTimeCalendar.setTime(date);
            if (timePicker.isEnabled()) {
                dateTimeCalendar.set(11, timeCalendar.get(11));
                dateTimeCalendar.set(12, timeCalendar.get(12));
                dateTimeCalendar.set(13, timeCalendar.get(13));
            }
            return dateTimeCalendar;
        }
        return null;
    }

    public boolean generateEventFilter() {
        this.eventFilter = new EventFilter();
        try {
            this.eventFilter.setStartDate(this.getCalendar(this.startDatePicker, this.startTimePicker));
            Calendar endCalendar = this.getCalendar(this.endDatePicker, this.endTimePicker);
            if (endCalendar != null && !this.endTimePicker.isEnabled()) {
                endCalendar.add(5, 1);
                endCalendar.add(14, -1);
            }
            this.eventFilter.setEndDate(endCalendar);
        }
        catch (ParseException e) {
            this.parent.alertError((Component)((Object)this.parent), "Invalid date.");
            return false;
        }
        Calendar startDate = this.eventFilter.getStartDate();
        Calendar endDate = this.eventFilter.getEndDate();
        if (startDate != null && endDate != null && startDate.getTimeInMillis() > endDate.getTimeInMillis()) {
            this.parent.alertError((Component)((Object)this.parent), "Start date cannot be after the end date.");
            return false;
        }
        if (!this.nameField.getText().equals("")) {
            this.eventFilter.setName(this.nameField.getText());
        }
        HashSet<ServerEvent.Level> levels = new HashSet<ServerEvent.Level>();
        if (this.levelBoxInformation.isSelected()) {
            levels.add(ServerEvent.Level.INFORMATION);
        }
        if (this.levelBoxWarning.isSelected()) {
            levels.add(ServerEvent.Level.WARNING);
        }
        if (this.levelBoxError.isSelected()) {
            levels.add(ServerEvent.Level.ERROR);
        }
        if (!levels.isEmpty()) {
            this.eventFilter.setLevels(levels);
        }
        if (this.advancedSearchPopup.getUser() != -1) {
            this.eventFilter.setUserId(this.advancedSearchPopup.getUser());
        }
        if (!this.advancedSearchPopup.getOutcome().equals("ALL")) {
            for (int i = 0; i < ServerEvent.Outcome.values().length; ++i) {
                if (!this.advancedSearchPopup.getOutcome().equalsIgnoreCase(ServerEvent.Outcome.values()[i].toString())) continue;
                this.eventFilter.setOutcome(ServerEvent.Outcome.values()[i]);
            }
        }
        if (!this.advancedSearchPopup.getAttributeSearch().equals("")) {
            this.eventFilter.setAttributeSearch(this.advancedSearchPopup.getAttributeSearch());
        }
        if (!this.advancedSearchPopup.getIpAddress().equals("")) {
            this.eventFilter.setIpAddress(this.advancedSearchPopup.getIpAddress());
        }
        if (!StringUtils.isBlank((CharSequence)this.advancedSearchPopup.getServerId())) {
            this.eventFilter.setServerId(this.advancedSearchPopup.getServerId());
        }
        try {
            Integer maxEventId = this.parent.mirthClient.getMaxEventId();
            this.eventFilter.setMaxEventId(maxEventId);
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
            return false;
        }
        return true;
    }

    public void runSearch() {
        if (this.generateEventFilter()) {
            this.updateFilterButtonFont(0);
            this.events = new PaginatedEventList();
            this.events.setClient(this.parent.mirthClient);
            this.events.setEventFilter(this.eventFilter);
            try {
                this.events.setPageSize(Integer.parseInt(this.pageSizeField.getText()));
            }
            catch (NumberFormatException e) {
                this.parent.alertError((Component)((Object)this.parent), "Invalid page size.");
                return;
            }
            this.countButton.setVisible(true);
            this.clearCache();
            this.loadPageNumber(1);
            this.updateSearchCriteriaPane();
        }
    }

    private void updateSearchCriteriaPane() {
        StringBuilder text = new StringBuilder();
        Calendar startDate = this.eventFilter.getStartDate();
        Calendar endDate = this.eventFilter.getEndDate();
        String padding = "\n";
        text.append("Max Event Id: ");
        text.append(this.eventFilter.getMaxEventId());
        String startDateFormatString = this.startTimePicker.isEnabled() ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd";
        String endDateFormatString = this.endTimePicker.isEnabled() ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd";
        SimpleDateFormat startDateFormat = new SimpleDateFormat(startDateFormatString);
        SimpleDateFormat endDateFormat = new SimpleDateFormat(endDateFormatString);
        text.append(padding + "Date Range: ");
        if (startDate == null) {
            text.append("(any)");
        } else {
            text.append(startDateFormat.format(startDate.getTime()));
            if (!this.startTimePicker.isEnabled()) {
                text.append(" (all day)");
            }
        }
        text.append(" to ");
        if (endDate == null) {
            text.append("(any)");
        } else {
            text.append(endDateFormat.format(endDate.getTime()));
            if (!this.endTimePicker.isEnabled()) {
                text.append(" (all day)");
            }
        }
        text.append(padding + "Levels: ");
        if (this.eventFilter.getLevels() == null) {
            text.append("(any)");
        } else {
            text.append(StringUtils.join((Iterable)this.eventFilter.getLevels(), (String)", "));
        }
        if (this.eventFilter.getName() != null) {
            text.append(padding + "Name: " + this.eventFilter.getName());
        }
        if (this.eventFilter.getUserId() != null) {
            text.append(padding + "User Id: " + this.eventFilter.getUserId());
        }
        if (this.eventFilter.getOutcome() != null) {
            text.append(padding + "Outcome: " + String.valueOf(this.eventFilter.getOutcome()));
        }
        if (this.eventFilter.getAttributeSearch() != null) {
            text.append(padding + "AttributeSearch: " + this.eventFilter.getAttributeSearch());
        }
        if (this.eventFilter.getIpAddress() != null) {
            text.append(padding + "IP Address: " + this.eventFilter.getIpAddress());
        }
        this.lastSearchCriteria.setText(text.toString());
    }

    public void clearCache() {
    }

    public void jumpToPageNumber() {
        if (this.events.getPageCount() != null && this.events.getPageCount() > 0 && StringUtils.isNotEmpty((CharSequence)this.pageNumberField.getText())) {
            this.loadPageNumber(Math.min(Math.max(Integer.parseInt(this.pageNumberField.getText()), 1), this.events.getPageCount()));
        }
    }

    public void loadPageNumber(final int pageNumber) {
        final String workingId = this.parent.startWorking("Loading page...");
        if (this.worker != null && !this.worker.isDone()) {
            this.parent.mirthClient.getServerConnection().abort(this.getAbortOperations());
            this.worker.cancel(true);
        }
        this.filterButton.setEnabled(false);
        this.nextPageButton.setEnabled(false);
        this.previousPageButton.setEnabled(false);
        this.countButton.setEnabled(false);
        this.pageGoButton.setEnabled(false);
        this.eventTable.requestFocus();
        this.worker = new SwingWorker<Void, Void>(){
            private boolean foundItems = false;
            private int retrievedPageNumber = 1;

            @Override
            public Void doInBackground() {
                try {
                    this.foundItems = EventBrowser.this.events.loadPageNumber(pageNumber);
                }
                catch (Throwable t) {
                    if (t.getMessage().contains("Java heap space")) {
                        EventBrowser.this.parent.alertError((Component)((Object)EventBrowser.this.parent), "There was an out of memory error when trying to retrieve events.\nIncrease your heap size or decrease your page size and search again.");
                    } else if (!(t instanceof RequestAbortedException)) {
                        EventBrowser.this.parent.alertThrowable((Component)((Object)EventBrowser.this.parent), t);
                    }
                    this.cancel(true);
                }
                return null;
            }

            @Override
            public void done() {
                if (!this.isCancelled()) {
                    boolean enableCountButton = EventBrowser.this.events.getItemCount() == null;
                    EventBrowser.this.deselectRows();
                    if (this.foundItems) {
                        this.retrievedPageNumber = EventBrowser.this.events.getPageNumber();
                        EventBrowser.this.pageNumberField.setText(String.valueOf(this.retrievedPageNumber));
                        EventBrowser.this.updateEventTable((List<ServerEvent>)EventBrowser.this.events);
                        if (!EventBrowser.this.events.hasNextPage()) {
                            EventBrowser.this.events.setItemCount(new Long((this.retrievedPageNumber - 1) * EventBrowser.this.events.getPageSize() + EventBrowser.this.events.size()));
                            enableCountButton = false;
                        }
                    } else {
                        if (EventBrowser.this.eventTable != null) {
                            RefreshTableModel model = (RefreshTableModel)EventBrowser.this.eventTable.getModel();
                            model.refreshDataVector(new Object[0][0]);
                        }
                        EventBrowser.this.events.setItemCount(new Long((this.retrievedPageNumber - 1) * EventBrowser.this.events.getPageSize()));
                        enableCountButton = false;
                        EventBrowser.this.pageNumberField.setText("0");
                    }
                    EventBrowser.this.updatePagination();
                    if (enableCountButton) {
                        EventBrowser.this.countButton.setEnabled(true);
                    }
                    EventBrowser.this.filterButton.setEnabled(true);
                }
                EventBrowser.this.parent.stopWorking(workingId);
            }
        };
        this.worker.execute();
    }

    public void updatePagination() {
        int endOffset;
        int startOffset;
        int pageNumber = this.events.getPageNumber();
        Integer pageCount = this.events.getPageCount();
        if (this.events.size() == 0) {
            startOffset = 0;
            endOffset = 0;
        } else {
            startOffset = this.events.getOffset(pageNumber) + 1;
            endOffset = startOffset + this.events.size() - 1;
        }
        String resultText = "Results " + DisplayUtil.formatNumber(startOffset) + " - " + DisplayUtil.formatNumber(endOffset) + " of ";
        this.previousPageButton.setEnabled(pageNumber > 1);
        this.nextPageButton.setEnabled(this.events.hasNextPage());
        if (pageCount != null) {
            this.resultsLabel.setText(resultText + DisplayUtil.formatNumber(this.events.getItemCount()));
            this.pageTotalLabel.setText("of " + DisplayUtil.formatNumber(this.events.getPageCount()));
            this.pageTotalLabel.setEnabled(true);
            this.pageGoButton.setEnabled(true);
            this.pageNumberLabel.setEnabled(true);
            this.pageNumberField.setEnabled(true);
        } else {
            this.resultsLabel.setText(resultText + "?");
            this.pageTotalLabel.setText("of ?");
            this.pageGoButton.setEnabled(false);
            this.pageTotalLabel.setEnabled(false);
            this.pageNumberLabel.setEnabled(false);
            this.pageNumberField.setEnabled(false);
        }
    }

    private void updateCachedUserMap() {
        try {
            this.parent.retrieveUsers();
        }
        catch (ClientException e) {
            this.parent.alertThrowable(this, e);
        }
        this.userMapById.clear();
        this.userMapById.put(-1, "ALL");
        this.userMapById.put(0, "System");
        for (User user : this.parent.users) {
            this.userMapById.put(user.getId(), user.getUsername());
        }
    }

    public void refresh(Integer page) {
        this.clearCache();
        if (page == null) {
            this.loadPageNumber(this.events.getPageNumber());
        } else {
            this.loadPageNumber(page);
        }
    }

    public Set<Operation> getAbortOperations() {
        return OperationUtil.getAbortableOperations(EventServletInterface.class);
    }

    public void resetSearchCriteria() {
        this.startDatePicker.setDate(null);
        this.endDatePicker.setDate(null);
        this.nameField.setText("");
        this.allDayCheckBox.setSelected(false);
        this.levelBoxInformation.setSelected(false);
        this.levelBoxWarning.setSelected(false);
        this.levelBoxError.setSelected(false);
        this.pageSizeField.setText(String.valueOf(Preferences.userNodeForPackage(Mirth.class).getInt("eventBrowserPageSize", 100)));
        this.advancedSearchPopup.reset();
        this.updateAdvancedSearchButtonFont();
    }

    public void updateFilterButtonFont(int font) {
        this.filterButton.setFont(this.filterButton.getFont().deriveFont(font));
        this.filterButton.requestFocus();
    }

    public void updateAdvancedSearchButtonFont() {
        if (this.advancedSearchPopup.hasAdvancedCriteria().booleanValue()) {
            this.advSearchButton.setFont(this.advSearchButton.getFont().deriveFont(1));
        } else {
            this.advSearchButton.setFont(this.advSearchButton.getFont().deriveFont(0));
        }
    }

    public void updateEventTable(List<ServerEvent> systemEventList) {
        Object[][] tableData = null;
        if (systemEventList != null) {
            tableData = new Object[systemEventList.size()][11];
            for (int i = 0; i < systemEventList.size(); ++i) {
                ServerEvent systemEvent = systemEventList.get(i);
                tableData[i][0] = systemEvent.getId();
                tableData[i][1] = systemEvent.getLevel().equals((Object)ServerEvent.Level.INFORMATION) ? new CellData(UIConstants.ICON_INFORMATION, "") : (systemEvent.getLevel().equals((Object)ServerEvent.Level.WARNING) ? new CellData(UIConstants.ICON_WARNING, "") : (systemEvent.getLevel().equals((Object)ServerEvent.Level.ERROR) ? new CellData(UIConstants.ICON_ERROR, "") : new CellData(null, systemEvent.getLevel().toString())));
                tableData[i][2] = systemEvent.getEventTime();
                tableData[i][3] = systemEvent.getName();
                tableData[i][4] = systemEvent.getServerId();
                int userId = systemEvent.getUserId();
                Object user = String.valueOf(userId);
                if (this.userMapById.containsKey(userId)) {
                    user = (String)user + " (" + this.userMapById.get(userId) + ")";
                }
                tableData[i][5] = user;
                tableData[i][6] = systemEvent.getOutcome().equals((Object)ServerEvent.Outcome.SUCCESS) ? new CellData(UIConstants.ICON_CHECK, "") : (systemEvent.getOutcome().equals((Object)ServerEvent.Outcome.FAILURE) ? new CellData(UIConstants.ICON_X, "") : new CellData(null, systemEvent.getOutcome().toString()));
                tableData[i][7] = systemEvent.getIpAddress();
                tableData[i][8] = systemEvent.getChannelIdWithMessageId();
                tableData[i][9] = systemEvent.getChannelName();
                tableData[i][10] = systemEvent.getPatientId();
            }
        } else {
            tableData = new Object[0][11];
        }
        if (this.eventTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.eventTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            LinkedHashSet<String> defaultVisibleColumns = new LinkedHashSet<String>();
            defaultVisibleColumns.add("Level");
            defaultVisibleColumns.add("Date & Time");
            defaultVisibleColumns.add("Name");
            defaultVisibleColumns.add("Server ID");
            defaultVisibleColumns.add("User");
            defaultVisibleColumns.add("Outcome");
            defaultVisibleColumns.add("IP Address");
            defaultVisibleColumns.add("Channel ID - Message ID");
            defaultVisibleColumns.add("Channel Name");
            defaultVisibleColumns.add("Patient ID");
            this.eventTable = new MirthTable("eventBrowser", defaultVisibleColumns);
            this.eventTable.setModel(new RefreshTableModel(tableData, new String[]{"ID", "Level", "Date & Time", "Name", "Server ID", "User", "Outcome", "IP Address", "Channel ID - Message ID", "Channel Name", "Patient ID"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
    }

    private void makeEventTable() {
        Highlighter highlighter;
        this.updateEventTable(null);
        this.eventTable.setSelectionMode(0);
        this.eventTable.setMirthColumnControlEnabled(true);
        this.eventTable.restoreColumnPreferences();
        this.eventTable.getColumnExt("Level").setCellRenderer((TableCellRenderer)new ImageCellRenderer(0));
        this.eventTable.getColumnExt("Outcome").setCellRenderer((TableCellRenderer)new ImageCellRenderer(0));
        this.eventTable.getColumnExt("ID").setVisible(false);
        DateCellRenderer dateCellRenderer = new DateCellRenderer();
        dateCellRenderer.setDateFormat(new SimpleDateFormat(DATE_FORMAT));
        this.eventTable.getColumnExt("Date & Time").setCellRenderer((TableCellRenderer)dateCellRenderer);
        this.eventTable.getColumnExt("Date & Time").setMinWidth(140);
        this.eventTable.getColumnExt("Date & Time").setMaxWidth(140);
        this.eventTable.getColumnExt("Level").setMinWidth(50);
        this.eventTable.getColumnExt("Level").setMaxWidth(50);
        this.eventTable.getColumnExt("Server ID").setMinWidth(220);
        this.eventTable.getColumnExt("Server ID").setMaxWidth(220);
        this.eventTable.getColumnExt("Outcome").setMinWidth(65);
        this.eventTable.getColumnExt("Outcome").setMaxWidth(65);
        this.eventTable.setRowHeight(20);
        this.eventTable.setOpaque(true);
        this.eventTable.setRowSelectionAllowed(true);
        this.deselectRows();
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.eventTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.eventPane.setViewportView((Component)((Object)this.eventTable));
        this.eventSplitPane.setLeftComponent(this.eventPane);
        this.eventTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EventBrowser.this.EventListSelected(evt);
            }
        });
        this.eventTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EventBrowser.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EventBrowser.this.checkSelectionAndPopupMenu(evt);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.eventTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    private void checkSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.eventTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.eventTable.setRowSelectionInterval(row, row);
            }
            this.parent.eventPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void deselectRows() {
        if (this.eventTable != null) {
            this.eventTable.clearSelection();
            this.setEventAttributes(null, true);
        }
    }

    private void EventListSelected(ListSelectionEvent evt) {
        int row;
        if (!evt.getValueIsAdjusting() && (row = this.eventTable.getSelectedModelIndex()) >= 0) {
            this.setEventAttributes(((ServerEvent)this.events.get(row)).getAttributes(), false);
        }
    }

    private void makeAttributesTable() {
        this.setEventAttributes(null, true);
        this.eventAttributesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (EventBrowser.this.eventAttributesTable.rowAtPoint(new Point(evt.getX(), evt.getY())) == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2) {
                    new ViewContentDialog((String)EventBrowser.this.eventAttributesTable.getModel().getValueAt(EventBrowser.this.eventAttributesTable.getSelectedModelIndex(), 1));
                }
            }
        });
        this.eventAttributesTable.setSelectionMode(0);
        DefaultTableCellRenderer noHTMLRenderer = new DefaultTableCellRenderer();
        noHTMLRenderer.putClientProperty("html.disable", Boolean.TRUE);
        this.eventAttributesTable.getColumnExt("Value").setCellRenderer((TableCellRenderer)noHTMLRenderer);
        this.eventAttributesPane.setViewportView((Component)((Object)this.eventAttributesTable));
    }

    private void setEventAttributes(Map<String, String> attributes, boolean cleared) {
        Object[][] tableData;
        if (attributes == null || attributes.size() == 0) {
            tableData = new String[1][2];
            tableData[0][0] = cleared ? "Please select an event to view its attributes." : "There are no attributes for this event.";
            tableData[0][1] = "";
        } else {
            tableData = new String[attributes.size()][2];
            int i = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                tableData[i][0] = entry.getKey();
                tableData[i][1] = entry.getValue();
                ++i;
            }
        }
        if (this.eventAttributesTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.eventAttributesTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.eventAttributesTable = new MirthTable();
            this.eventAttributesTable.setModel(new RefreshTableModel(tableData, new String[]{"Name", "Value"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.eventAttributesTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    public EventFilter getCurrentFilter() {
        return this.eventFilter;
    }

    private void initComponents() {
        this.eventSplitPane = new JSplitPane();
        this.eventPane = new JScrollPane();
        this.eventTable = null;
        this.eventDetailsPanel = new JPanel();
        this.eventAttributesPane = new JScrollPane();
        this.eventAttributesTable = null;
        this.resetButton = new JButton();
        this.allDayCheckBox = new MirthCheckBox();
        this.lastSearchCriteriaPane = new JScrollPane();
        this.lastSearchCriteria = new JTextArea();
        this.nextPageButton = new JButton();
        this.pageGoButton = new JButton();
        this.pageSizeField = new MirthTextField();
        this.previousPageButton = new JButton();
        this.pageNumberField = new MirthTextField();
        this.pageNumberLabel = new JLabel();
        this.pageSizeLabel = new JLabel();
        this.countButton = new MirthButton();
        this.resultsLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameLabel = new JLabel();
        this.endDatePicker = new MirthDatePicker();
        this.startDatePicker = new MirthDatePicker();
        this.nameField = new JTextField();
        this.startTimePicker = new MirthTimePicker();
        this.endTimePicker = new MirthTimePicker();
        this.filterButton = new JButton();
        this.advSearchButton = new JButton();
        this.levelBoxInformation = new MirthCheckBox();
        this.levelBoxWarning = new MirthCheckBox();
        this.levelBoxError = new MirthCheckBox();
        this.pageTotalLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.eventSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.eventSplitPane.setDividerLocation(250);
        this.eventSplitPane.setOrientation(0);
        this.eventSplitPane.setResizeWeight(1.0);
        this.eventPane.setViewportView((Component)((Object)this.eventTable));
        this.eventSplitPane.setLeftComponent(this.eventPane);
        this.eventDetailsPanel.setBackground(new Color(255, 255, 255));
        this.eventDetailsPanel.setMinimumSize(new Dimension(0, 150));
        this.eventAttributesPane.setViewportView((Component)((Object)this.eventAttributesTable));
        GroupLayout eventDetailsPanelLayout = new GroupLayout(this.eventDetailsPanel);
        this.eventDetailsPanel.setLayout(eventDetailsPanelLayout);
        eventDetailsPanelLayout.setHorizontalGroup(eventDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eventDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.eventAttributesPane, -1, 832, Short.MAX_VALUE).addContainerGap()));
        eventDetailsPanelLayout.setVerticalGroup(eventDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, eventDetailsPanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.eventAttributesPane, -1, 154, Short.MAX_VALUE).addContainerGap()));
        this.eventSplitPane.setRightComponent(this.eventDetailsPanel);
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.resetButtonActionPerformed(evt);
            }
        });
        this.allDayCheckBox.setBackground(new Color(255, 255, 255));
        this.allDayCheckBox.setText("All Day");
        this.allDayCheckBox.setFont(new Font("Lucida Grande", 0, 11));
        this.allDayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.allDayCheckBoxActionPerformed(evt);
            }
        });
        this.lastSearchCriteriaPane.setBorder(null);
        this.lastSearchCriteriaPane.setHorizontalScrollBarPolicy(31);
        this.lastSearchCriteria.setEditable(false);
        this.lastSearchCriteria.setColumns(20);
        this.lastSearchCriteria.setForeground(new Color(96, 96, 96));
        this.lastSearchCriteria.setLineWrap(true);
        this.lastSearchCriteria.setRows(5);
        this.lastSearchCriteria.setAlignmentX(0.0f);
        this.lastSearchCriteria.setDisabledTextColor(new Color(255, 255, 255));
        this.lastSearchCriteriaPane.setViewportView(this.lastSearchCriteria);
        this.nextPageButton.setText("Next >");
        this.nextPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.nextPageButtonActionPerformed(evt);
            }
        });
        this.pageGoButton.setText("Go");
        this.pageGoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.pageGoButtonActionPerformed(evt);
            }
        });
        this.pageSizeField.setToolTipText("<html>\nAfter changing the page size, a new search must be performed for the changes to<br/>\ntake effect.  The default page size can also be configured on the Settings panel.\n</html>");
        this.previousPageButton.setText("< Prev");
        this.previousPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.previousPageButtonActionPerformed(evt);
            }
        });
        this.pageNumberField.setHorizontalAlignment(4);
        this.pageNumberField.setToolTipText("Enter a page number and press Enter to jump to that page.");
        this.pageNumberField.setPreferredSize(new Dimension(40, 22));
        this.pageNumberLabel.setHorizontalAlignment(4);
        this.pageNumberLabel.setText("Page");
        this.pageSizeLabel.setHorizontalAlignment(4);
        this.pageSizeLabel.setText("Page Size:");
        this.pageSizeLabel.setMaximumSize(new Dimension(78, 15));
        this.countButton.setText("Count");
        this.countButton.setToolTipText("Count the number of overall messages for the current search criteria.");
        this.countButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.countButtonActionPerformed(evt);
            }
        });
        this.resultsLabel.setForeground(new Color(204, 0, 0));
        this.resultsLabel.setHorizontalAlignment(4);
        this.resultsLabel.setText("Results");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Start Time:");
        this.jLabel3.setMaximumSize(new Dimension(78, 15));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("End Time:");
        this.jLabel2.setMaximumSize(new Dimension(78, 15));
        this.nameLabel.setHorizontalAlignment(4);
        this.nameLabel.setText("Name:");
        this.nameField.setToolTipText("<html>\nSearch all message content for the given string. This process could take a long<br/>\ntime depending on the amount of message content currently stored. Any message<br/>\ncontent that was encrypted by this channel will not be searchable.\n</html>");
        this.filterButton.setText("Search");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.filterButtonActionPerformed(evt);
            }
        });
        this.advSearchButton.setText("Advanced...");
        this.advSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowser.this.advSearchButtonActionPerformed(evt);
            }
        });
        this.levelBoxInformation.setBackground(new Color(255, 255, 255));
        this.levelBoxInformation.setText("INFORMATION");
        this.levelBoxInformation.setFont(new Font("Lucida Grande", 0, 11));
        this.levelBoxInformation.setPreferredSize(new Dimension(90, 22));
        this.levelBoxWarning.setBackground(new Color(255, 255, 255));
        this.levelBoxWarning.setText("WARNING");
        this.levelBoxWarning.setFont(new Font("Lucida Grande", 0, 11));
        this.levelBoxWarning.setMaximumSize(new Dimension(83, 23));
        this.levelBoxWarning.setMinimumSize(new Dimension(83, 23));
        this.levelBoxError.setBackground(new Color(255, 255, 255));
        this.levelBoxError.setText("ERROR");
        this.levelBoxError.setFont(new Font("Lucida Grande", 0, 11));
        this.levelBoxError.setMaximumSize(new Dimension(83, 23));
        this.levelBoxError.setMinimumSize(new Dimension(83, 23));
        this.pageTotalLabel.setHorizontalAlignment(4);
        this.pageTotalLabel.setText("of ?");
        this.pageTotalLabel.setAlignmentY(0.0f);
        this.pageTotalLabel.setHorizontalTextPosition(4);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventSplitPane).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.pageSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.pageSizeField, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advSearchButton, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)((Object)this.startDatePicker), -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startTimePicker, -2, 80, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)((Object)this.endDatePicker), -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endTimePicker, -2, 80, -2)).addComponent(this.nameField, GroupLayout.Alignment.TRAILING, -2, 218, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.allDayCheckBox, -2, -1, -2).addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.levelBoxInformation, -1, 95, Short.MAX_VALUE).addComponent(this.levelBoxError, -1, -1, Short.MAX_VALUE).addComponent(this.levelBoxWarning, -2, -1, -2))).addComponent(this.filterButton, -2, 63, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lastSearchCriteriaPane, -2, 0, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.previousPageButton, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextPageButton, -2, 55, -2)).addGroup(layout.createSequentialGroup().addComponent(this.resultsLabel).addGap(5, 5, 5).addComponent(this.countButton, -2, 55, -2)).addGroup(layout.createSequentialGroup().addComponent(this.pageNumberLabel).addGap(4, 4, 4).addComponent(this.pageNumberField, -2, 50, -2).addGap(6, 6, 6).addComponent(this.pageTotalLabel).addGap(5, 5, 5).addComponent(this.pageGoButton, -2, 29, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startTimePicker, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.startDatePicker), -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.endTimePicker, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.endDatePicker), -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.nameLabel))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.countButton, -2, -1, -2).addComponent(this.resultsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pageGoButton).addComponent(this.pageTotalLabel).addComponent(this.pageNumberField, -2, -1, -2).addComponent(this.pageNumberLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.nextPageButton).addComponent(this.previousPageButton)).addGap(10, 10, 10).addComponent(this.eventSplitPane, -1, 440, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(90, 90, 90).addComponent(this.pageSizeLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(87, 87, 87).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pageSizeField, -2, -1, -2).addComponent(this.advSearchButton).addComponent(this.resetButton).addComponent(this.filterButton))).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.levelBoxInformation, -2, 16, -2).addComponent(this.allDayCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.levelBoxWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.levelBoxError, -2, 16, -2)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lastSearchCriteriaPane, -2, 107, -2))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.resetSearchCriteria();
    }

    private void allDayCheckBoxActionPerformed(ActionEvent evt) {
        this.startTimePicker.setEnabled(this.startDatePicker.getDate() != null && !this.allDayCheckBox.isSelected());
        this.endTimePicker.setEnabled(this.endDatePicker.getDate() != null && !this.allDayCheckBox.isSelected());
    }

    private void nextPageButtonActionPerformed(ActionEvent evt) {
        this.loadPageNumber(this.events.getPageNumber() + 1);
    }

    private void pageGoButtonActionPerformed(ActionEvent evt) {
        this.jumpToPageNumber();
    }

    private void previousPageButtonActionPerformed(ActionEvent evt) {
        this.loadPageNumber(this.events.getPageNumber() - 1);
    }

    private void countButtonActionPerformed(ActionEvent evt) {
        final String workingId = this.parent.startWorking("Counting search result size...");
        this.filterButton.setEnabled(false);
        this.nextPageButton.setEnabled(false);
        this.previousPageButton.setEnabled(false);
        this.countButton.setEnabled(false);
        this.pageGoButton.setEnabled(false);
        final EventBrowser eventBrowser = this;
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<Void, Void>(){
            private Exception e;

            @Override
            public Void doInBackground() {
                try {
                    EventBrowser.this.events.setItemCount(EventBrowser.this.parent.mirthClient.getEventCount(EventBrowser.this.eventFilter));
                }
                catch (ClientException e) {
                    if (!(e instanceof RequestAbortedException)) {
                        EventBrowser.this.parent.alertThrowable((Component)((Object)EventBrowser.this.parent), e);
                    }
                    this.cancel(true);
                }
                return null;
            }

            @Override
            public void done() {
                if (!this.isCancelled()) {
                    if (this.e != null) {
                        EventBrowser.this.countButton.setEnabled(true);
                        EventBrowser.this.parent.alertThrowable(eventBrowser, this.e);
                    } else {
                        EventBrowser.this.updatePagination();
                        EventBrowser.this.countButton.setEnabled(false);
                    }
                    EventBrowser.this.filterButton.setEnabled(true);
                }
                EventBrowser.this.parent.stopWorking(workingId);
            }
        };
        this.worker.execute();
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        this.runSearch();
    }

    private void advSearchButtonActionPerformed(ActionEvent evt) {
        this.advancedSearchPopup.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.advancedSearchPopup.setLocationRelativeTo((Component)((Object)this.parent));
        this.advancedSearchPopup.setVisible(true);
        this.updateAdvancedSearchButtonFont();
    }
}

