/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.codetemplate;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class CodeTemplateImportDialog
extends MirthDialog {
    private static final int IMPORT_SELECTED_COLUMN = 0;
    private static final int IMPORT_NAME_COLUMN = 1;
    private static final int IMPORT_OVERWRITE_COLUMN = 2;
    private static final int IMPORT_CONFLICTS_COLUMN = 3;
    private static final int IMPORT_ID_COLUMN = 4;
    private List<CodeTemplateLibrary> importLibraries;
    private Map<String, CodeTemplateLibrary> importLibraryMap;
    private Map<String, CodeTemplate> importCodeTemplateMap;
    private boolean unassignedCodeTemplates;
    private boolean showCancelAlert;
    private boolean saved;
    private Map<String, CodeTemplateLibrary> updatedLibraries;
    private Map<String, CodeTemplate> updatedCodeTemplates;
    private JPanel topPanel;
    private JPanel linkPanel;
    private JPanel linkLeftPanel;
    private JLabel linkLeftSelectAllLabel;
    private JLabel linkLeftDeselectAllLabel;
    private JPanel linkRightPanel;
    private JLabel linkRightOverwriteAllLabel;
    private JLabel linkRightOverwriteNoneLabel;
    private JXTreeTable importTreeTable;
    private JScrollPane importTreeTableScrollPane;
    private JPanel errorsPanel;
    private JLabel errorsLabel;
    private JTextArea errorsTextArea;
    private JPanel warningsPanel;
    private JLabel warningsLabel;
    private JTextArea warningsTextArea;
    private JSeparator separator;
    private JPanel buttonPanel;
    private JButton importButton;
    private JButton cancelButton;

    public CodeTemplateImportDialog(Frame owner, List<CodeTemplateLibrary> importLibraries, boolean unassignedCodeTemplates) {
        this(owner, importLibraries, unassignedCodeTemplates, false);
    }

    public CodeTemplateImportDialog(Frame owner, List<CodeTemplateLibrary> importLibraries, boolean unassignedCodeTemplates, boolean showCancelAlert) {
        super((Window)owner, "Import Code Templates / Libraries", true);
        for (CodeTemplateLibrary library : importLibraries) {
            Iterator it = library.getCodeTemplates().iterator();
            while (it.hasNext()) {
                if (((CodeTemplate)it.next()).getProperties() != null) continue;
                it.remove();
            }
        }
        this.importLibraries = importLibraries;
        this.unassignedCodeTemplates = unassignedCodeTemplates;
        this.showCancelAlert = showCancelAlert;
        this.importLibraryMap = new HashMap<String, CodeTemplateLibrary>();
        this.importCodeTemplateMap = new HashMap<String, CodeTemplate>();
        this.initComponents();
        this.initLayout();
        if (showCancelAlert) {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    if (CodeTemplateImportDialog.this.confirmClose()) {
                        CodeTemplateImportDialog.this.dispose();
                    }
                }
            });
            ActionListener closeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CodeTemplateImportDialog.this.confirmClose()) {
                        CodeTemplateImportDialog.this.dispose();
                    }
                }
            };
            this.getRootPane().registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 2);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.updateErrorsAndWarnings();
        this.setPreferredSize(new Dimension(420, 420));
        this.pack();
        this.setLocationRelativeTo(owner);
        DisplayUtil.setResizable(this, false);
        this.setVisible(true);
    }

    public boolean wasSaved() {
        return this.saved;
    }

    public Map<String, CodeTemplateLibrary> getUpdatedLibraries() {
        return this.updatedLibraries;
    }

    public Map<String, CodeTemplate> getUpdatedCodeTemplates() {
        return this.updatedCodeTemplates;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.topPanel = new JPanel();
        this.topPanel.setBackground(this.getBackground());
        this.linkPanel = new JPanel();
        this.linkPanel.setBackground(this.topPanel.getBackground());
        this.linkLeftPanel = new JPanel();
        this.linkLeftPanel.setBackground(this.linkPanel.getBackground());
        this.linkLeftSelectAllLabel = new JLabel("<html><u>All</u></html>");
        this.linkLeftSelectAllLabel.setForeground(Color.BLUE);
        this.linkLeftSelectAllLabel.setCursor(new Cursor(12));
        this.linkLeftSelectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (int row = 0; row < CodeTemplateImportDialog.this.importTreeTable.getRowCount(); ++row) {
                    CodeTemplateImportDialog.this.importTreeTable.getModel().setValueAt(true, row, 0);
                }
            }
        });
        this.linkLeftDeselectAllLabel = new JLabel("<html><u>None</u></html>");
        this.linkLeftDeselectAllLabel.setForeground(Color.BLUE);
        this.linkLeftDeselectAllLabel.setCursor(new Cursor(12));
        this.linkLeftDeselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (int row = 0; row < CodeTemplateImportDialog.this.importTreeTable.getRowCount(); ++row) {
                    CodeTemplateImportDialog.this.importTreeTable.getModel().setValueAt(false, row, 0);
                }
            }
        });
        this.linkRightPanel = new JPanel();
        this.linkRightPanel.setBackground(this.linkPanel.getBackground());
        this.linkRightOverwriteAllLabel = new JLabel("<html><u>All</u></html>");
        this.linkRightOverwriteAllLabel.setForeground(Color.BLUE);
        this.linkRightOverwriteAllLabel.setCursor(new Cursor(12));
        this.linkRightOverwriteAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (int row = 0; row < CodeTemplateImportDialog.this.importTreeTable.getRowCount(); ++row) {
                    ImportCodeTemplateTreeTableNode codeTemplateNode;
                    TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
                    if (path == null) continue;
                    ImportTreeTableNode node = (ImportTreeTableNode)((Object)path.getLastPathComponent());
                    if (node instanceof ImportLibraryTreeTableNode) {
                        ImportLibraryTreeTableNode libraryNode = (ImportLibraryTreeTableNode)node;
                        if (libraryNode.getConflicts().getMatchingLibrary() == null) continue;
                        CodeTemplateImportDialog.this.importTreeTable.getModel().setValueAt(true, row, 2);
                        continue;
                    }
                    if (!(node instanceof ImportCodeTemplateTreeTableNode) || (codeTemplateNode = (ImportCodeTemplateTreeTableNode)node).getConflicts().getMatchingCodeTemplate() == null) continue;
                    CodeTemplateImportDialog.this.importTreeTable.getModel().setValueAt(true, row, 2);
                }
            }
        });
        this.linkRightOverwriteNoneLabel = new JLabel("<html><u>None</u></html>");
        this.linkRightOverwriteNoneLabel.setForeground(Color.BLUE);
        this.linkRightOverwriteNoneLabel.setCursor(new Cursor(12));
        this.linkRightOverwriteNoneLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (int row = 0; row < CodeTemplateImportDialog.this.importTreeTable.getRowCount(); ++row) {
                    ImportCodeTemplateTreeTableNode codeTemplateNode;
                    TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
                    if (path == null) continue;
                    ImportTreeTableNode node = (ImportTreeTableNode)((Object)path.getLastPathComponent());
                    if (node instanceof ImportLibraryTreeTableNode) {
                        ImportLibraryTreeTableNode libraryNode = (ImportLibraryTreeTableNode)node;
                        if (libraryNode.getConflicts().getMatchingLibrary() == null) continue;
                        CodeTemplateImportDialog.this.importTreeTable.getModel().setValueAt(false, row, 2);
                        continue;
                    }
                    if (!(node instanceof ImportCodeTemplateTreeTableNode) || (codeTemplateNode = (ImportCodeTemplateTreeTableNode)node).getConflicts().getMatchingCodeTemplate() == null) continue;
                    CodeTemplateImportDialog.this.importTreeTable.getModel().setValueAt(false, row, 2);
                }
            }
        });
        final NameCellEditor templateCellEditor = new NameCellEditor();
        this.importTreeTable = new JXTreeTable(){

            public boolean isCellEditable(int row, int column) {
                return column == 2 || column == 0 || column == 1;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                if (this.isHierarchical(column)) {
                    return templateCellEditor;
                }
                return super.getCellEditor(row, column);
            }
        };
        this.importTreeTable.setLargeModel(true);
        ImportTreeTableModel model = new ImportTreeTableModel();
        model.setColumnIdentifiers(Arrays.asList("", "Name", "Overwrite", "Conflicts", "Id"));
        DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode();
        model.setRoot((TreeTableNode)rootNode);
        this.importTreeTable.setTreeTableModel((TreeTableModel)model);
        HashSet<String> addedCodeTemplateIds = new HashSet<String>();
        if (this.unassignedCodeTemplates) {
            ImportUnassignedLibraryTreeTableNode libraryNode = new ImportUnassignedLibraryTreeTableNode("Select a library", "");
            CodeTemplateLibrary library = this.importLibraries.get(0);
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                if (addedCodeTemplateIds.contains(codeTemplate.getId())) continue;
                libraryNode.add((MutableTreeTableNode)new ImportCodeTemplateTreeTableNode(codeTemplate.getName(), codeTemplate.getId()));
                addedCodeTemplateIds.add(codeTemplate.getId());
                this.importCodeTemplateMap.put(codeTemplate.getId(), codeTemplate);
            }
            rootNode.add((MutableTreeTableNode)libraryNode);
        } else {
            HashSet<String> addedLibraryIds = new HashSet<String>();
            for (CodeTemplateLibrary library : this.importLibraries) {
                if (addedLibraryIds.contains(library.getId())) continue;
                ImportLibraryTreeTableNode libraryNode = new ImportLibraryTreeTableNode(library.getName(), library.getId());
                this.importLibraryMap.put(library.getId(), library);
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    if (addedCodeTemplateIds.contains(codeTemplate.getId())) continue;
                    libraryNode.add((MutableTreeTableNode)new ImportCodeTemplateTreeTableNode(codeTemplate.getName(), codeTemplate.getId()));
                    addedCodeTemplateIds.add(codeTemplate.getId());
                    this.importCodeTemplateMap.put(codeTemplate.getId(), codeTemplate);
                }
                rootNode.add((MutableTreeTableNode)libraryNode);
                addedLibraryIds.add(library.getId());
            }
        }
        this.importTreeTable.setOpenIcon(null);
        this.importTreeTable.setClosedIcon(null);
        this.importTreeTable.setLeafIcon(null);
        this.importTreeTable.setRootVisible(false);
        this.importTreeTable.setDoubleBuffered(true);
        this.importTreeTable.setDragEnabled(false);
        this.importTreeTable.setRowSelectionAllowed(true);
        this.importTreeTable.setSelectionMode(0);
        this.importTreeTable.setRowHeight(20);
        this.importTreeTable.setFocusable(true);
        this.importTreeTable.setOpaque(true);
        this.importTreeTable.getTableHeader().setReorderingAllowed(false);
        this.importTreeTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.importTreeTable.setEditable(true);
        this.importTreeTable.setSortable(false);
        this.importTreeTable.setAutoCreateColumnsFromModel(false);
        this.importTreeTable.setShowGrid(true, true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.importTreeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.importTreeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                int row = CodeTemplateImportDialog.this.importTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
                if (row < 0) {
                    CodeTemplateImportDialog.this.importTreeTable.clearSelection();
                }
            }
        });
        this.importTreeTable.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                throw new ExpandVetoException(event);
            }
        });
        this.importTreeTable.setTreeCellRenderer((TreeCellRenderer)new NameCellRenderer());
        this.importTreeTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                if (evt.getColumn() != 3) {
                    for (int row = evt.getFirstRow(); row <= evt.getLastRow() && row < CodeTemplateImportDialog.this.importTreeTable.getRowCount(); ++row) {
                        TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
                        if (path == null) continue;
                        ImportTreeTableNode node = (ImportTreeTableNode)((Object)path.getLastPathComponent());
                        if (path.getPathCount() == 2) {
                            if (node instanceof ImportUnassignedLibraryTreeTableNode) {
                                String libraryName = (String)node.getValueAt(1);
                                String libraryId = null;
                                for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                                    if (!library.getName().equals(libraryName)) continue;
                                    libraryId = library.getId();
                                    break;
                                }
                                node.setValueAt(libraryId, 4);
                            } else if (node instanceof ImportLibraryTreeTableNode) {
                                ImportLibraryTreeTableNode libraryNode = (ImportLibraryTreeTableNode)node;
                                libraryNode.setConflicts(CodeTemplateImportDialog.this.getLibraryConflicts(node));
                            }
                            Enumeration codeTemplateNodes = node.children();
                            while (codeTemplateNodes.hasMoreElements()) {
                                ImportCodeTemplateTreeTableNode codeTemplateNode = (ImportCodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                                codeTemplateNode.setConflicts(CodeTemplateImportDialog.this.getCodeTemplateConflicts(codeTemplateNode));
                            }
                            CodeTemplateImportDialog.this.importTreeTable.updateUI();
                            continue;
                        }
                        if (path.getPathCount() != 3) continue;
                        ImportCodeTemplateTreeTableNode codeTemplateNode = (ImportCodeTemplateTreeTableNode)node;
                        codeTemplateNode.setConflicts(CodeTemplateImportDialog.this.getCodeTemplateConflicts(node));
                    }
                }
                CodeTemplateImportDialog.this.updateImportButton();
                CodeTemplateImportDialog.this.updateErrorsAndWarnings();
            }
        });
        this.importTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    CodeTemplateImportDialog.this.updateImportButton();
                    CodeTemplateImportDialog.this.updateErrorsAndWarnings();
                }
            }
        });
        this.importTreeTable.expandAll();
        this.importTreeTable.getColumnModel().getColumn(0).setMinWidth(20);
        this.importTreeTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.importTreeTable.getColumnModel().getColumn(0).setCellRenderer(new ImportSelectedCellRenderer());
        this.importTreeTable.getColumnModel().getColumn(0).setCellEditor(new ImportSelectedCellEditor());
        this.importTreeTable.getColumnModel().getColumn(2).setMinWidth(60);
        this.importTreeTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.importTreeTable.getColumnModel().getColumn(2).setCellRenderer(new OverwriteCellRenderer());
        this.importTreeTable.getColumnModel().getColumn(2).setCellEditor(new OverwriteCellEditor());
        this.importTreeTable.getColumnModel().getColumn(3).setMinWidth(60);
        this.importTreeTable.getColumnModel().getColumn(3).setMaxWidth(60);
        this.importTreeTable.getColumnModel().getColumn(3).setCellRenderer(new IconCellRenderer());
        this.importTreeTable.getColumnModel().removeColumn(this.importTreeTable.getColumnModel().getColumn(4));
        this.importTreeTableScrollPane = new JScrollPane((Component)this.importTreeTable);
        this.importTreeTableScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0x6E6E6E)));
        this.warningsPanel = new JPanel();
        this.warningsPanel.setBackground(this.getBackground());
        this.warningsPanel.setVisible(false);
        this.warningsLabel = new JLabel(UIConstants.ICON_WARNING);
        this.warningsTextArea = new JTextArea();
        this.warningsTextArea.setLineWrap(true);
        this.warningsTextArea.setWrapStyleWord(true);
        this.errorsPanel = new JPanel();
        this.errorsPanel.setBackground(this.getBackground());
        this.errorsPanel.setVisible(false);
        this.errorsLabel = new JLabel(UIConstants.ICON_ERROR);
        this.errorsTextArea = new JTextArea();
        this.errorsTextArea.setLineWrap(true);
        this.errorsTextArea.setWrapStyleWord(true);
        this.separator = new JSeparator();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(this.getBackground());
        this.importButton = new JButton("Import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    boolean warnings = false;
                    Enumeration libraryNodes = ((TreeTableNode)CodeTemplateImportDialog.this.importTreeTable.getTreeTableModel().getRoot()).children();
                    while (libraryNodes.hasMoreElements()) {
                        Enumeration codeTemplateNodes = ((TreeTableNode)libraryNodes.nextElement()).children();
                        while (codeTemplateNodes.hasMoreElements()) {
                            CodeTemplateConflicts conflicts;
                            ImportCodeTemplateTreeTableNode codeTemplateNode = (ImportCodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                            if (!((Boolean)codeTemplateNode.getValueAt(0)).booleanValue() || (conflicts = codeTemplateNode.getConflicts()).getMatchingCodeTemplate() == null) continue;
                            warnings = true;
                            break;
                        }
                        if (!warnings) continue;
                    }
                    if (!warnings || PlatformUI.MIRTH_FRAME.alertOption(CodeTemplateImportDialog.this, "Some selected rows have warnings. Are you sure you wish to continue?")) {
                        CodeTemplateImportDialog.this.save();
                        CodeTemplateImportDialog.this.dispose();
                    }
                }
                catch (Exception e) {
                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)CodeTemplateImportDialog.this, (Throwable)e, "Unable to import: " + e.getMessage());
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CodeTemplateImportDialog.this.confirmClose()) {
                    CodeTemplateImportDialog.this.dispose();
                }
            }
        });
        this.updateImportButton();
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill"));
        this.topPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.linkPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.linkLeftPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.linkLeftPanel.add(new JLabel("Select:"));
        this.linkLeftPanel.add(this.linkLeftSelectAllLabel);
        this.linkLeftPanel.add(new JLabel("|"));
        this.linkLeftPanel.add(this.linkLeftDeselectAllLabel);
        this.linkPanel.add((Component)this.linkLeftPanel, "left");
        this.linkRightPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.linkRightPanel.add(new JLabel("Overwrite:"));
        this.linkRightPanel.add(this.linkRightOverwriteAllLabel);
        this.linkRightPanel.add(new JLabel("|"));
        this.linkRightPanel.add(this.linkRightOverwriteNoneLabel);
        this.linkPanel.add((Component)this.linkRightPanel, "right");
        this.topPanel.add((Component)this.linkPanel, "grow");
        this.topPanel.add((Component)this.importTreeTableScrollPane, "newline, grow, push");
        this.add((Component)this.topPanel, "grow");
        this.errorsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.errorsPanel.add((Component)this.errorsLabel, "top");
        this.errorsPanel.add((Component)this.errorsTextArea, "grow, push");
        this.add((Component)this.errorsPanel, "newline, grow");
        this.warningsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.warningsPanel.add((Component)this.warningsLabel, "top");
        this.warningsPanel.add((Component)this.warningsTextArea, "grow, push");
        this.add((Component)this.warningsPanel, "newline, grow");
        this.add((Component)this.separator, "newline, growx, pushx");
        this.buttonPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.buttonPanel.add(this.importButton);
        this.buttonPanel.add(this.cancelButton);
        this.add((Component)this.buttonPanel, "newline, right");
    }

    private EffectiveNames getEffectiveNames() {
        HashMap<String, String> libraryNameMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> codeTemplateNameMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> newLibraryNames = new HashMap<String, String>();
        HashMap<String, Map<String, String>> newCodeTemplateNames = new HashMap<String, Map<String, String>>();
        for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
            libraryNameMap.put(library.getId(), library.getName().toLowerCase());
            HashMap<String, String> codeTemplateMap = new HashMap<String, String>();
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                codeTemplate = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplates().get(codeTemplate.getId());
                codeTemplateMap.put(codeTemplate.getId(), codeTemplate.getName().toLowerCase());
            }
            codeTemplateNameMap.put(library.getId(), codeTemplateMap);
        }
        Enumeration libraryNodes = ((TreeTableNode)this.importTreeTable.getTreeTableModel().getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            ImportTreeTableNode libraryNode = (ImportTreeTableNode)((Object)libraryNodes.nextElement());
            String libraryId = (String)libraryNode.getValueAt(4);
            String libraryName = (String)libraryNode.getValueAt(1);
            boolean librarySelected = (Boolean)libraryNode.getValueAt(0);
            Boolean libraryOverwrite = (Boolean)libraryNode.getValueAt(2);
            if (libraryNode instanceof ImportLibraryTreeTableNode && librarySelected) {
                CodeTemplateLibrary matchingLibrary = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().get(libraryId);
                if (matchingLibrary != null && libraryOverwrite != null && libraryOverwrite.booleanValue()) {
                    libraryNameMap.put(libraryId, libraryName.toLowerCase());
                } else {
                    newLibraryNames.put(libraryId, libraryName.toLowerCase());
                    newCodeTemplateNames.put(libraryId, new HashMap());
                }
            }
            Enumeration codeTemplateNodes = libraryNode.children();
            while (codeTemplateNodes.hasMoreElements()) {
                Map<String, String> codeTemplateMap;
                ImportTreeTableNode codeTemplateNode = (ImportTreeTableNode)((Object)codeTemplateNodes.nextElement());
                String codeTemplateId = (String)codeTemplateNode.getValueAt(4);
                String codeTemplateName = (String)codeTemplateNode.getValueAt(1);
                boolean codeTemplateSelected = (Boolean)codeTemplateNode.getValueAt(0);
                Boolean codeTemplateOverwrite = (Boolean)codeTemplateNode.getValueAt(2);
                if (!codeTemplateSelected) continue;
                CodeTemplate matchingCodeTemplate = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplates().get(codeTemplateId);
                if (matchingCodeTemplate != null && codeTemplateOverwrite != null && codeTemplateOverwrite.booleanValue()) {
                    codeTemplateMap = (Map)codeTemplateNameMap.get(libraryId);
                    if (codeTemplateMap == null) {
                        codeTemplateMap = new HashMap();
                        codeTemplateNameMap.put(libraryId, codeTemplateMap);
                    }
                    codeTemplateMap.put(codeTemplateId, codeTemplateName.toLowerCase());
                    continue;
                }
                codeTemplateMap = (HashMap<String, String>)newCodeTemplateNames.get(libraryId);
                if (codeTemplateMap == null) {
                    codeTemplateMap = new HashMap<String, String>();
                    newCodeTemplateNames.put(libraryId, codeTemplateMap);
                }
                codeTemplateMap.put(codeTemplateId, codeTemplateName.toLowerCase());
            }
        }
        return new EffectiveNames(libraryNameMap, codeTemplateNameMap, newLibraryNames, newCodeTemplateNames);
    }

    private LibraryConflicts getLibraryConflicts(ImportTreeTableNode libraryNode) {
        LibraryConflicts conflicts = new LibraryConflicts();
        String libraryId = (String)libraryNode.getValueAt(4);
        String libraryName = ((String)libraryNode.getValueAt(1)).toLowerCase();
        Boolean libraryOverwrite = (Boolean)libraryNode.getValueAt(2);
        boolean overwrite2 = libraryOverwrite != null && libraryOverwrite != false;
        CodeTemplateLibrary matchingLibrary = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().get(libraryId);
        conflicts.setMatchingLibrary(matchingLibrary);
        EffectiveNames effectiveNames = this.getEffectiveNames();
        for (Map.Entry<String, String> entry : effectiveNames.getLibraryNameMap().entrySet()) {
            if (!entry.getValue().equals(libraryName) || entry.getKey().equals(libraryId) && (matchingLibrary == null || overwrite2)) continue;
            conflicts.setConflictByName(true);
        }
        for (Map.Entry<String, String> entry : effectiveNames.getNewLibraryNames().entrySet()) {
            if (!entry.getValue().equals(libraryName) || entry.getKey().equals(libraryId)) continue;
            conflicts.setConflictByName(true);
        }
        return conflicts;
    }

    private CodeTemplateConflicts getCodeTemplateConflicts(ImportTreeTableNode codeTemplateNode) {
        CodeTemplateConflicts conflicts = new CodeTemplateConflicts();
        String codeTemplateId = (String)codeTemplateNode.getValueAt(4);
        String codeTemplateName = ((String)codeTemplateNode.getValueAt(1)).toLowerCase();
        Boolean codeTemplateOverwrite = (Boolean)codeTemplateNode.getValueAt(2);
        boolean overwrite2 = codeTemplateOverwrite != null && codeTemplateOverwrite != false;
        CodeTemplate matchingCodeTemplate = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplates().get(codeTemplateId);
        conflicts.setMatchingCodeTemplate(matchingCodeTemplate);
        ImportTreeTableNode libraryNode = (ImportTreeTableNode)codeTemplateNode.getParent();
        String libraryId = (String)libraryNode.getValueAt(4);
        boolean librarySelected = (Boolean)libraryNode.getValueAt(0);
        EffectiveNames effectiveNames = this.getEffectiveNames();
        if (effectiveNames.getCodeTemplateNameMap().containsKey(libraryId)) {
            for (Map.Entry<String, String> entry : effectiveNames.getCodeTemplateNameMap().get(libraryId).entrySet()) {
                if (!entry.getValue().equals(codeTemplateName) || entry.getKey().equals(codeTemplateId) && (matchingCodeTemplate == null || overwrite2)) continue;
                conflicts.setConflictByName(true);
            }
        }
        if (effectiveNames.getNewCodeTemplateNames().containsKey(libraryId)) {
            for (Map.Entry<String, String> entry : effectiveNames.getNewCodeTemplateNames().get(libraryId).entrySet()) {
                if (!entry.getValue().equals(codeTemplateName) || entry.getKey().equals(codeTemplateId)) continue;
                conflicts.setConflictByName(true);
            }
        }
        CodeTemplateLibrary matchingLibrary = null;
        for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                if (!codeTemplate.getId().equals(codeTemplateId)) continue;
                matchingLibrary = library;
                break;
            }
            if (matchingLibrary == null) continue;
            break;
        }
        if (matchingLibrary == null) {
            matchingLibrary = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().get(libraryId);
        }
        conflicts.setMatchingLibrary(matchingLibrary);
        if (StringUtils.isBlank((CharSequence)libraryId) || !librarySelected && (matchingLibrary == null || !overwrite2)) {
            conflicts.setUnassignedConflict(true);
        }
        return conflicts;
    }

    private void updateImportButton() {
        if (this.importButton != null) {
            boolean enabled = true;
            boolean noneSelected = true;
            Enumeration libraryNodes = ((TreeTableNode)this.importTreeTable.getTreeTableModel().getRoot()).children();
            while (libraryNodes.hasMoreElements()) {
                ImportTreeTableNode libraryNode = (ImportTreeTableNode)((Object)libraryNodes.nextElement());
                if (libraryNode instanceof ImportLibraryTreeTableNode && ((Boolean)libraryNode.getValueAt(0)).booleanValue()) {
                    noneSelected = false;
                    if (((ImportLibraryTreeTableNode)libraryNode).getConflicts().isConflictByName()) {
                        enabled = false;
                        break;
                    }
                }
                Enumeration codeTemplateNodes = libraryNode.children();
                while (codeTemplateNodes.hasMoreElements()) {
                    ImportCodeTemplateTreeTableNode codeTemplateNode = (ImportCodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                    if (!((Boolean)codeTemplateNode.getValueAt(0)).booleanValue()) continue;
                    noneSelected = false;
                    if (!codeTemplateNode.getConflicts().isConflictByName() && !codeTemplateNode.getConflicts().isUnassignedConflict()) continue;
                    enabled = false;
                    break;
                }
                if (enabled) continue;
                break;
            }
            if (noneSelected) {
                enabled = false;
            }
            this.importButton.setEnabled(enabled);
        }
    }

    private void updateErrorsAndWarnings() {
        if (this.warningsPanel != null && this.warningsPanel != null) {
            this.errorsPanel.setVisible(false);
            this.warningsPanel.setVisible(false);
            int selectedRow = this.importTreeTable.getSelectedRow();
            if (selectedRow >= 0) {
                ImportTreeTableNode node;
                TreePath selectedPath = this.importTreeTable.getPathForRow(selectedRow);
                if (selectedPath != null && ((Boolean)(node = (ImportTreeTableNode)((Object)selectedPath.getLastPathComponent())).getValueAt(0)).booleanValue()) {
                    String name = (String)node.getValueAt(1);
                    Boolean overwrite2 = (Boolean)node.getValueAt(2);
                    overwrite2 = overwrite2 != null && overwrite2 != false;
                    if (node instanceof ImportLibraryTreeTableNode) {
                        ImportLibraryTreeTableNode libraryNode = (ImportLibraryTreeTableNode)node;
                        if (libraryNode.getConflicts().isConflictByName()) {
                            this.errorsPanel.setVisible(true);
                            StringBuilder text = new StringBuilder();
                            if (libraryNode.getConflicts().getMatchingLibrary() != null && StringUtils.equalsIgnoreCase((CharSequence)libraryNode.getConflicts().getMatchingLibrary().getName(), (CharSequence)name) && !overwrite2.booleanValue()) {
                                text.append("The selected library already exists. Edit its name, or select overwrite.");
                            } else {
                                text.append("Another library (with a different ID) is already using the name \"");
                                text.append(name);
                                text.append("\". Please enter a new name.");
                            }
                            this.errorsTextArea.setText(text.toString());
                        }
                    } else if (node instanceof ImportCodeTemplateTreeTableNode) {
                        ImportCodeTemplateTreeTableNode codeTemplateNode = (ImportCodeTemplateTreeTableNode)node;
                        if (codeTemplateNode.getConflicts().isConflictByName()) {
                            this.errorsPanel.setVisible(true);
                            StringBuilder text = new StringBuilder();
                            if (codeTemplateNode.getConflicts().getMatchingCodeTemplate() != null && StringUtils.equalsIgnoreCase((CharSequence)codeTemplateNode.getConflicts().getMatchingCodeTemplate().getName(), (CharSequence)name) && !overwrite2.booleanValue()) {
                                if (this.unassignedCodeTemplates) {
                                    text.append("The selected code template already exists. Edit its name, select overwrite, or switch the library.");
                                } else {
                                    text.append("The selected code template already exists. Edit its name, or select overwrite.");
                                }
                            } else {
                                text.append("Another code template (with a different ID) is already using the name \"");
                                text.append(name);
                                text.append("\". Please enter a new name");
                                if (this.unassignedCodeTemplates) {
                                    text.append(", or switch the library");
                                }
                                text.append('.');
                            }
                            this.errorsTextArea.setText(text.toString());
                        } else if (codeTemplateNode.getConflicts().isUnassignedConflict()) {
                            this.errorsPanel.setVisible(true);
                            if (this.unassignedCodeTemplates) {
                                this.errorsTextArea.setText("Please select a parent library in order to import the selected code template.");
                            } else {
                                ImportTreeTableNode tableLibraryNode = (ImportTreeTableNode)codeTemplateNode.getParent();
                                StringBuilder text = new StringBuilder("The parent library \"");
                                text.append((String)tableLibraryNode.getValueAt(1));
                                text.append("\" does not currently exist, so it must be imported in order to import the selected code template.");
                                this.errorsTextArea.setText(text.toString());
                            }
                        }
                        if (codeTemplateNode.getConflicts().getMatchingCodeTemplate() != null) {
                            this.warningsPanel.setVisible(true);
                            if (codeTemplateNode.getConflicts().getMatchingLibrary() != null) {
                                this.warningsTextArea.setText("The selected code template already exists in library \"" + codeTemplateNode.getConflicts().getMatchingLibrary().getName() + "\".");
                            } else {
                                this.warningsTextArea.setText("The selected code template already exists.");
                            }
                        }
                    }
                }
            } else {
                boolean errors = false;
                boolean warnings = false;
                for (int row = 0; row < this.importTreeTable.getRowCount(); ++row) {
                    Object conflicts;
                    ImportTreeTableNode node;
                    TreePath path = this.importTreeTable.getPathForRow(row);
                    if (path == null || !((Boolean)(node = (ImportTreeTableNode)((Object)path.getLastPathComponent())).getValueAt(0)).booleanValue()) continue;
                    if (node instanceof ImportLibraryTreeTableNode) {
                        conflicts = ((ImportLibraryTreeTableNode)node).getConflicts();
                        if (!((LibraryConflicts)conflicts).isConflictByName()) continue;
                        errors = true;
                        break;
                    }
                    if (!(node instanceof ImportCodeTemplateTreeTableNode)) continue;
                    conflicts = ((ImportCodeTemplateTreeTableNode)node).getConflicts();
                    if (((CodeTemplateConflicts)conflicts).isConflictByName() || ((CodeTemplateConflicts)conflicts).isUnassignedConflict()) {
                        errors = true;
                        break;
                    }
                    if (((CodeTemplateConflicts)conflicts).getMatchingCodeTemplate() == null) continue;
                    warnings = true;
                }
                if (errors) {
                    this.errorsPanel.setVisible(true);
                    if (this.unassignedCodeTemplates) {
                        this.errorsTextArea.setText("One or more libraries / code templates have name conflicts. Edit their names, select overwrite, or switch the library.");
                    } else {
                        this.errorsTextArea.setText("One or more libraries / code templates have name conflicts. Edit their names, or select overwrite.");
                    }
                } else if (warnings) {
                    this.warningsPanel.setVisible(true);
                    this.warningsTextArea.setText("One or more libraries / code templates have warnings.");
                }
            }
        }
    }

    private void save() throws Exception {
        this.updatedLibraries = new HashMap<String, CodeTemplateLibrary>();
        this.updatedCodeTemplates = new HashMap<String, CodeTemplate>();
        for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
            this.updatedLibraries.put(library.getId(), new CodeTemplateLibrary(library));
        }
        Enumeration libraryNodes = ((TreeTableNode)this.importTreeTable.getTreeTableModel().getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            ImportTreeTableNode libraryNode = (ImportTreeTableNode)((Object)libraryNodes.nextElement());
            String libraryId = (String)libraryNode.getValueAt(4);
            String libraryName = (String)libraryNode.getValueAt(1);
            boolean librarySelected = (Boolean)libraryNode.getValueAt(0);
            Boolean libraryOverwrite = (Boolean)libraryNode.getValueAt(2);
            libraryOverwrite = libraryOverwrite != null && libraryOverwrite != false;
            CodeTemplateLibrary library = this.updatedLibraries.get(libraryId);
            HashSet<String> libraryCodeTemplateIds = new HashSet<String>();
            if (library != null) {
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    libraryCodeTemplateIds.add(codeTemplate.getId());
                }
            }
            if (librarySelected && !this.unassignedCodeTemplates) {
                library = new CodeTemplateLibrary(this.importLibraryMap.get(libraryId));
                library.setName(libraryName);
                CodeTemplateLibrary matchingLibrary = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().get(libraryId);
                if (matchingLibrary != null) {
                    if (libraryOverwrite.booleanValue()) {
                        library.getEnabledChannelIds().addAll(matchingLibrary.getEnabledChannelIds());
                        library.getDisabledChannelIds().addAll(matchingLibrary.getDisabledChannelIds());
                        library.getDisabledChannelIds().removeAll(library.getEnabledChannelIds());
                    } else {
                        library.setId(PlatformUI.MIRTH_FRAME.mirthClient.getGuid());
                        library.setRevision(Integer.valueOf(0));
                    }
                }
                this.updatedLibraries.put(library.getId(), library);
            }
            Enumeration codeTemplateNodes = libraryNode.children();
            while (codeTemplateNodes.hasMoreElements()) {
                ImportCodeTemplateTreeTableNode codeTemplateNode = (ImportCodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                String codeTemplateId = (String)codeTemplateNode.getValueAt(4);
                String codeTemplateName = (String)codeTemplateNode.getValueAt(1);
                boolean codeTemplateSelected = (Boolean)codeTemplateNode.getValueAt(0);
                Boolean codeTemplateOverwrite = (Boolean)codeTemplateNode.getValueAt(2);
                codeTemplateOverwrite = codeTemplateOverwrite != null && codeTemplateOverwrite != false && codeTemplateNode.getConflicts().getMatchingLibrary() != null && codeTemplateNode.getConflicts().getMatchingLibrary().getId().equals(libraryId);
                if (!codeTemplateSelected) continue;
                CodeTemplate codeTemplate = new CodeTemplate(this.importCodeTemplateMap.get(codeTemplateId));
                codeTemplate.setName(codeTemplateName);
                if (codeTemplateNode.getConflicts().getMatchingCodeTemplate() != null && !codeTemplateOverwrite.booleanValue()) {
                    codeTemplate.setId(PlatformUI.MIRTH_FRAME.mirthClient.getGuid());
                    codeTemplate.setRevision(Integer.valueOf(0));
                }
                libraryCodeTemplateIds.add(codeTemplate.getId());
                this.updatedCodeTemplates.put(codeTemplate.getId(), codeTemplate);
            }
            if (library == null) continue;
            ArrayList<CodeTemplate> libraryCodeTemplates = new ArrayList<CodeTemplate>();
            for (String libraryCodeTemplateId : libraryCodeTemplateIds) {
                libraryCodeTemplates.add(new CodeTemplate(libraryCodeTemplateId));
            }
            library.setCodeTemplates(libraryCodeTemplates);
        }
        this.saved = true;
    }

    private boolean confirmClose() {
        return !this.showCancelAlert || PlatformUI.MIRTH_FRAME.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "Are you sure you wish to continue without importing any code templates / libraries?");
    }

    private class NameCellEditor
    extends DefaultCellEditor {
        private OffsetPanel panel;
        private JTextField field;
        private JComboBox<String> comboBox;

        public NameCellEditor() {
            super(new JTextField());
            this.panel = new OffsetPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.field = (JTextField)this.editorComponent;
            this.field.setBackground(UIConstants.BACKGROUND_COLOR);
            this.field.setVisible(false);
            this.panel.add((Component)this.field, "grow, push");
            this.comboBox = new JComboBox();
            ArrayList<String> libraryNames = new ArrayList<String>();
            for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                libraryNames.add(library.getName());
            }
            this.comboBox.setModel(new DefaultComboBoxModel<String>(libraryNames.toArray(new String[libraryNames.size()])));
            this.comboBox.setMaximumRowCount(20);
            this.comboBox.setRenderer(new DataTypeListCellRenderer());
            for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
                if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
                ((AbstractButton)this.comboBox.getComponent(i)).setBorderPainted(false);
            }
            this.comboBox.setVisible(false);
            this.panel.add(this.comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JXTreeTable treeTable = (JXTreeTable)table;
            JTree tree = (JTree)((Object)treeTable.getCellRenderer(0, treeTable.getHierarchicalColumn()));
            this.panel.setOffset(tree.getRowBounds((int)row).x);
            this.panel.setBackground(table.getSelectionBackground());
            ImportTreeTableNode node = (ImportTreeTableNode)((Object)treeTable.getPathForRow(row).getLastPathComponent());
            if (node instanceof ImportUnassignedLibraryTreeTableNode) {
                this.field.setVisible(false);
                this.comboBox.setVisible(true);
                this.comboBox.setBackground(this.panel.getBackground());
                for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
                    if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
                    this.comboBox.getComponent(i).setBackground(this.comboBox.getBackground());
                }
                String name = (String)value;
                ArrayList<String> libraryNames = new ArrayList<String>();
                for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                    libraryNames.add(library.getName());
                }
                if (!libraryNames.contains(name)) {
                    libraryNames.add(0, name);
                }
                this.comboBox.setModel(new DefaultComboBoxModel<String>(libraryNames.toArray(new String[libraryNames.size()])));
                this.comboBox.setSelectedItem(name);
                this.comboBox.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                        NameCellEditor.this.fireEditingStopped();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent evt) {
                        NameCellEditor.this.fireEditingCanceled();
                    }
                });
            } else {
                this.field.setVisible(true);
                this.comboBox.setVisible(false);
                this.field.setText((String)value);
            }
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            TreePath selectedPath;
            int selectedRow = CodeTemplateImportDialog.this.importTreeTable.getSelectedRow();
            if (selectedRow >= 0 && (selectedPath = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(selectedRow)) != null && !(selectedPath.getLastPathComponent() instanceof ImportUnassignedLibraryTreeTableNode) && !((Boolean)CodeTemplateImportDialog.this.importTreeTable.getModel().getValueAt(selectedRow, 0)).booleanValue()) {
                return false;
            }
            return evt != null && evt instanceof MouseEvent && ((MouseEvent)evt).getClickCount() >= 2;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.field.isVisible()) {
                return StringUtils.trim((String)((String)super.getCellEditorValue()));
            }
            return (String)this.comboBox.getSelectedItem();
        }

        @Override
        public boolean stopCellEditing() {
            String value = (String)this.getCellEditorValue();
            boolean valid = true;
            if (StringUtils.isBlank((CharSequence)value)) {
                valid = false;
            }
            if (valid) {
                Enumeration libraryNodes = ((MutableTreeTableNode)CodeTemplateImportDialog.this.importTreeTable.getTreeTableModel().getRoot()).children();
                while (libraryNodes.hasMoreElements()) {
                    ImportTreeTableNode libraryNode = (ImportTreeTableNode)((Object)libraryNodes.nextElement());
                    if (libraryNode.getValueAt(1).equals(value)) {
                        valid = false;
                        break;
                    }
                    Enumeration codeTemplateNodes = libraryNode.children();
                    while (codeTemplateNodes.hasMoreElements()) {
                        ImportTreeTableNode codeTemplateNode = (ImportTreeTableNode)((Object)codeTemplateNodes.nextElement());
                        if (!codeTemplateNode.getValueAt(1).equals(value)) continue;
                        valid = false;
                        break;
                    }
                    if (valid) continue;
                    break;
                }
            }
            if (!valid) {
                super.cancelCellEditing();
            }
            return super.stopCellEditing();
        }

        private class OffsetPanel
        extends JPanel {
            private int offset;

            public OffsetPanel(LayoutManager layout) {
                super(layout);
            }

            public void setOffset(int offset) {
                this.offset = offset;
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x + this.offset, y, width - this.offset, height);
            }
        }

        private class DataTypeListCellRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index >= 0 && !isSelected) {
                    component.setBackground(UIConstants.BACKGROUND_COLOR);
                }
                return component;
            }
        }
    }

    private class ImportTreeTableModel
    extends DefaultTreeTableModel {
        private ImportTreeTableModel() {
        }

        public int getHierarchicalColumn() {
            return 1;
        }

        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return ConflictValue.class;
                }
                case 4: {
                    return String.class;
                }
            }
            return String.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0 || column == 1 || column == 2;
        }
    }

    private class ImportUnassignedLibraryTreeTableNode
    extends ImportTreeTableNode {
        public ImportUnassignedLibraryTreeTableNode(String name, String id) {
            super(name, id);
        }

        @Override
        public void setValueAt(Object value, int i) {
            if (i != 0) {
                super.setValueAt(value, i);
            }
        }
    }

    private class ImportCodeTemplateTreeTableNode
    extends ImportTreeTableNode {
        private CodeTemplateConflicts conflicts;

        public ImportCodeTemplateTreeTableNode(String name, String id) {
            super(name, id);
            this.conflicts = new CodeTemplateConflicts();
        }

        public CodeTemplateConflicts getConflicts() {
            return this.conflicts;
        }

        public void setConflicts(CodeTemplateConflicts conflicts) {
            this.conflicts = conflicts;
            if (this.selectionValue) {
                if (conflicts.isConflictByName() || conflicts.isUnassignedConflict()) {
                    this.setValueAt((Object)ConflictValue.ERROR, 3);
                } else if (conflicts.getMatchingCodeTemplate() != null) {
                    this.setValueAt((Object)ConflictValue.WARNING, 3);
                } else {
                    this.setValueAt((Object)ConflictValue.NONE, 3);
                }
            } else {
                this.setValueAt((Object)ConflictValue.NONE, 3);
            }
        }
    }

    private abstract class ImportTreeTableNode
    extends AbstractMutableTreeTableNode {
        protected boolean selectionValue = true;
        private String name;
        private Boolean overwrite;
        private ConflictValue conflictValue;
        private String id;

        public ImportTreeTableNode(String name, String id) {
            this.name = name;
            this.overwrite = null;
            this.conflictValue = ConflictValue.NONE;
            this.id = id;
        }

        public int getColumnCount() {
            return 6;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.selectionValue;
                }
                case 1: {
                    return this.name;
                }
                case 2: {
                    return this.overwrite;
                }
                case 3: {
                    return this.conflictValue;
                }
                case 4: {
                    return this.id;
                }
            }
            return null;
        }

        public void setValueAt(Object value, int i) {
            switch (i) {
                case 0: {
                    this.selectionValue = (Boolean)value;
                    break;
                }
                case 1: {
                    this.name = (String)value;
                    break;
                }
                case 2: {
                    this.overwrite = (Boolean)value;
                    break;
                }
                case 3: {
                    this.conflictValue = (ConflictValue)((Object)value);
                    break;
                }
                case 4: {
                    this.id = (String)value;
                }
            }
        }
    }

    private class ImportLibraryTreeTableNode
    extends ImportTreeTableNode {
        private LibraryConflicts conflicts;

        public ImportLibraryTreeTableNode(String name, String id) {
            super(name, id);
            this.conflicts = new LibraryConflicts();
        }

        public LibraryConflicts getConflicts() {
            return this.conflicts;
        }

        public void setConflicts(LibraryConflicts conflicts) {
            this.conflicts = conflicts;
            if (this.selectionValue && conflicts.isConflictByName()) {
                this.setValueAt((Object)ConflictValue.ERROR, 3);
            } else {
                this.setValueAt((Object)ConflictValue.NONE, 3);
            }
        }
    }

    private class NameCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JLabel label;
        private JComboBox<String> comboBox;

        public NameCellRenderer() {
            this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.label = new JLabel();
            this.label.setVisible(false);
            this.add(this.label);
            this.comboBox = new JComboBox();
            ArrayList<String> libraryNames = new ArrayList<String>();
            for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                libraryNames.add(library.getName());
            }
            this.comboBox.setModel(new DefaultComboBoxModel<String>(libraryNames.toArray(new String[libraryNames.size()])));
            this.comboBox.setVisible(false);
            this.add(this.comboBox);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.setBackground(CodeTemplateImportDialog.this.importTreeTable.getSelectionBackground());
            } else {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            if (value != null && value instanceof ImportTreeTableNode) {
                ImportTreeTableNode node = (ImportTreeTableNode)((Object)value);
                if (node instanceof ImportUnassignedLibraryTreeTableNode) {
                    int i;
                    this.label.setVisible(false);
                    this.comboBox.setVisible(true);
                    for (i = 0; i < this.comboBox.getComponentCount(); ++i) {
                        if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
                        ((AbstractButton)this.comboBox.getComponent(i)).setBorderPainted(false);
                    }
                    this.comboBox.setBackground(this.getBackground());
                    for (i = 0; i < this.comboBox.getComponentCount(); ++i) {
                        if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
                        this.comboBox.getComponent(i).setBackground(this.comboBox.getBackground());
                    }
                    String name = (String)node.getValueAt(1);
                    ArrayList<String> libraryNames = new ArrayList<String>();
                    for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                        libraryNames.add(library.getName());
                    }
                    if (!libraryNames.contains(name)) {
                        libraryNames.add(0, name);
                    }
                    this.comboBox.setModel(new DefaultComboBoxModel<String>(libraryNames.toArray(new String[libraryNames.size()])));
                    this.comboBox.setSelectedItem(name);
                } else {
                    this.label.setVisible(true);
                    this.comboBox.setVisible(false);
                    this.label.setEnabled(true);
                    this.label.setBackground(this.getBackground());
                    this.label.setText((String)node.getValueAt(1));
                    if (!((Boolean)node.getValueAt(0)).booleanValue()) {
                        this.label.setEnabled(false);
                    }
                }
            }
            return this;
        }
    }

    private class ImportSelectedCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JCheckBox checkBox;

        public ImportSelectedCellRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = new JCheckBox();
            this.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ImportTreeTableNode node;
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.setSelected(value != null && (Boolean)value != false);
            boolean visible = true;
            TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
            if (path != null && (node = (ImportTreeTableNode)((Object)path.getLastPathComponent())) instanceof ImportUnassignedLibraryTreeTableNode) {
                visible = false;
            }
            this.checkBox.setVisible(visible);
            return this;
        }
    }

    private class ImportSelectedCellEditor
    extends DefaultCellEditor {
        private JPanel panel;
        private JCheckBox checkBox;

        public ImportSelectedCellEditor() {
            super(new JCheckBox());
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = (JCheckBox)this.editorComponent;
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ImportTreeTableNode node;
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.panel.setBackground(table.getSelectionBackground());
            this.checkBox.setBackground(this.panel.getBackground());
            this.checkBox.setSelected(value != null && (Boolean)value != false);
            boolean visible = true;
            TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
            if (path != null && (node = (ImportTreeTableNode)((Object)path.getLastPathComponent())) instanceof ImportUnassignedLibraryTreeTableNode) {
                visible = false;
            }
            this.checkBox.setVisible(visible);
            return this.panel;
        }
    }

    private class OverwriteCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JCheckBox checkBox;

        public OverwriteCellRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = new JCheckBox();
            this.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.setSelected(value != null && (Boolean)value != false);
            this.checkBox.setEnabled(true);
            boolean visible = false;
            TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
            if (path != null) {
                ImportCodeTemplateTreeTableNode codeTemplateNode;
                CodeTemplateConflicts conflicts;
                ImportTreeTableNode node = (ImportTreeTableNode)((Object)path.getLastPathComponent());
                this.checkBox.setEnabled((Boolean)node.getValueAt(0));
                if (node instanceof ImportLibraryTreeTableNode) {
                    ImportLibraryTreeTableNode libraryNode = (ImportLibraryTreeTableNode)node;
                    LibraryConflicts conflicts2 = libraryNode.getConflicts();
                    if (conflicts2.getMatchingLibrary() != null) {
                        visible = true;
                    }
                } else if (node instanceof ImportCodeTemplateTreeTableNode && (conflicts = (codeTemplateNode = (ImportCodeTemplateTreeTableNode)node).getConflicts()).getMatchingCodeTemplate() != null && conflicts.getMatchingLibrary() != null && conflicts.getMatchingLibrary().getId().equals(node.getParent().getValueAt(4))) {
                    visible = true;
                }
            }
            this.checkBox.setVisible(visible);
            return this;
        }
    }

    private class OverwriteCellEditor
    extends DefaultCellEditor {
        private JPanel panel;
        private JCheckBox checkBox;

        public OverwriteCellEditor() {
            super(new JCheckBox());
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = (JCheckBox)this.editorComponent;
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            int selectedRow = CodeTemplateImportDialog.this.importTreeTable.getSelectedRow();
            return super.isCellEditable(anEvent) && (selectedRow < 0 || (Boolean)CodeTemplateImportDialog.this.importTreeTable.getModel().getValueAt(selectedRow, 0) != false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.panel.setBackground(table.getSelectionBackground());
            this.checkBox.setBackground(this.panel.getBackground());
            this.checkBox.setSelected(value != null && (Boolean)value != false);
            boolean visible = false;
            TreePath path = CodeTemplateImportDialog.this.importTreeTable.getPathForRow(row);
            if (path != null) {
                ImportCodeTemplateTreeTableNode codeTemplateNode;
                CodeTemplateConflicts conflicts;
                ImportTreeTableNode node = (ImportTreeTableNode)((Object)path.getLastPathComponent());
                if (node instanceof ImportLibraryTreeTableNode) {
                    ImportLibraryTreeTableNode libraryNode = (ImportLibraryTreeTableNode)node;
                    LibraryConflicts conflicts2 = libraryNode.getConflicts();
                    if (conflicts2.getMatchingLibrary() != null) {
                        visible = true;
                    }
                } else if (node instanceof ImportCodeTemplateTreeTableNode && (conflicts = (codeTemplateNode = (ImportCodeTemplateTreeTableNode)node).getConflicts()).getMatchingCodeTemplate() != null && conflicts.getMatchingLibrary() != null && conflicts.getMatchingLibrary().getId().equals(node.getParent().getValueAt(4))) {
                    visible = true;
                }
            }
            this.checkBox.setVisible(visible);
            return this.panel;
        }
    }

    private class IconCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label;

        public IconCellRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.label = new JLabel();
            this.add((Component)this.label, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            this.label.setBackground(this.getBackground());
            if (value != null) {
                ConflictValue conflictValue = (ConflictValue)((Object)value);
                this.label.setVisible(conflictValue != ConflictValue.NONE);
                this.label.setIcon(conflictValue == ConflictValue.ERROR ? UIConstants.ICON_ERROR : UIConstants.ICON_WARNING);
            } else {
                this.label.setVisible(false);
            }
            return this;
        }
    }

    private class EffectiveNames {
        private Map<String, String> libraryNameMap;
        private Map<String, Map<String, String>> codeTemplateNameMap;
        private Map<String, String> newLibraryNames;
        private Map<String, Map<String, String>> newCodeTemplateNames;

        public EffectiveNames(Map<String, String> libraryNameMap, Map<String, Map<String, String>> codeTemplateNameMap, Map<String, String> newLibraryNames, Map<String, Map<String, String>> newCodeTemplateNames) {
            this.libraryNameMap = libraryNameMap;
            this.codeTemplateNameMap = codeTemplateNameMap;
            this.newLibraryNames = newLibraryNames;
            this.newCodeTemplateNames = newCodeTemplateNames;
        }

        public Map<String, String> getLibraryNameMap() {
            return this.libraryNameMap;
        }

        public Map<String, Map<String, String>> getCodeTemplateNameMap() {
            return this.codeTemplateNameMap;
        }

        public Map<String, String> getNewLibraryNames() {
            return this.newLibraryNames;
        }

        public Map<String, Map<String, String>> getNewCodeTemplateNames() {
            return this.newCodeTemplateNames;
        }
    }

    private class LibraryConflicts {
        private CodeTemplateLibrary matchingLibrary;
        private boolean conflictByName;

        private LibraryConflicts() {
        }

        public CodeTemplateLibrary getMatchingLibrary() {
            return this.matchingLibrary;
        }

        public void setMatchingLibrary(CodeTemplateLibrary matchingLibrary) {
            this.matchingLibrary = matchingLibrary;
        }

        public boolean isConflictByName() {
            return this.conflictByName;
        }

        public void setConflictByName(boolean conflictByName) {
            this.conflictByName = conflictByName;
        }
    }

    private class CodeTemplateConflicts {
        private CodeTemplate matchingCodeTemplate;
        private CodeTemplateLibrary matchingLibrary;
        private boolean conflictByName;
        private boolean unassignedConflict;

        private CodeTemplateConflicts() {
        }

        public CodeTemplate getMatchingCodeTemplate() {
            return this.matchingCodeTemplate;
        }

        public void setMatchingCodeTemplate(CodeTemplate matchingCodeTemplate) {
            this.matchingCodeTemplate = matchingCodeTemplate;
        }

        public CodeTemplateLibrary getMatchingLibrary() {
            return this.matchingLibrary;
        }

        public void setMatchingLibrary(CodeTemplateLibrary matchingLibrary) {
            this.matchingLibrary = matchingLibrary;
        }

        public boolean isConflictByName() {
            return this.conflictByName;
        }

        public void setConflictByName(boolean conflictByName) {
            this.conflictByName = conflictByName;
        }

        public boolean isUnassignedConflict() {
            return this.unassignedConflict;
        }

        public void setUnassignedConflict(boolean unassignedConflict) {
            this.unassignedConflict = unassignedConflict;
        }
    }

    private static enum ConflictValue {
        NONE,
        WARNING,
        ERROR;

    }
}

