/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.codetemplate;

import com.mirth.connect.client.ui.ChannelDependenciesDialog;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.util.CodeTemplateUtil;
import com.mirth.connect.util.MirthXmlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class CodeTemplateLibrariesPanel
extends JPanel {
    private ChannelDependenciesDialog parent;
    private Map<String, CodeTemplateLibrary> libraryMap = new HashMap<String, CodeTemplateLibrary>();
    private String channelId;
    private boolean changed = false;
    private JLabel selectAllLabel;
    private JLabel selectSeparatorLabel;
    private JLabel deselectAllLabel;
    private JLabel expandAllLabel;
    private JLabel expandSeparatorLabel;
    private JLabel collapseAllLabel;
    private MirthTreeTable libraryTreeTable;
    private JScrollPane libraryTreeTableScrollPane;
    private JTextPane descriptionTextPane;
    private JScrollPane descriptionScrollPane;

    public CodeTemplateLibrariesPanel(ChannelDependenciesDialog parent, Channel channel) {
        this.parent = parent;
        this.channelId = channel.getId();
        this.initComponents(channel);
        this.initLayout();
    }

    public void initialize() {
        PlatformUI.MIRTH_FRAME.codeTemplatePanel.doRefreshCodeTemplates(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                    CodeTemplateLibrariesPanel.this.libraryMap.put(library.getId(), new CodeTemplateLibrary(library));
                }
                Map<String, CodeTemplate> codeTemplateMap = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplates();
                DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode();
                for (CodeTemplateLibrary library : CodeTemplateLibrariesPanel.this.libraryMap.values()) {
                    boolean enabled = library.getEnabledChannelIds().contains(CodeTemplateLibrariesPanel.this.channelId) || library.isIncludeNewChannels() && !library.getDisabledChannelIds().contains(CodeTemplateLibrariesPanel.this.channelId);
                    DefaultMutableTreeTableNode libraryNode = new DefaultMutableTreeTableNode((Object)new ImmutableTriple((Object)library.getId(), (Object)library.getName(), (Object)enabled));
                    for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                        if ((codeTemplate = codeTemplateMap.get(codeTemplate.getId())) == null) continue;
                        libraryNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new ImmutableTriple((Object)codeTemplate.getId(), (Object)codeTemplate.getName(), (Object)enabled)));
                    }
                    rootNode.add((MutableTreeTableNode)libraryNode);
                }
                ((DefaultTreeTableModel)CodeTemplateLibrariesPanel.this.libraryTreeTable.getTreeTableModel()).setRoot((TreeTableNode)rootNode);
                CodeTemplateLibrariesPanel.this.libraryTreeTable.expandAll();
                CodeTemplateLibrariesPanel.this.libraryTreeTable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent evt) {
                        Enumeration libraryNodes = ((DefaultMutableTreeTableNode)CodeTemplateLibrariesPanel.this.libraryTreeTable.getTreeTableModel().getRoot()).children();
                        while (libraryNodes.hasMoreElements()) {
                            Triple triple = (Triple)((MutableTreeTableNode)libraryNodes.nextElement()).getUserObject();
                            CodeTemplateLibrary library = CodeTemplateLibrariesPanel.this.libraryMap.get(triple.getLeft());
                            if (((Boolean)triple.getRight()).booleanValue()) {
                                library.getDisabledChannelIds().remove(CodeTemplateLibrariesPanel.this.channelId);
                                library.getEnabledChannelIds().add(CodeTemplateLibrariesPanel.this.channelId);
                                continue;
                            }
                            library.getDisabledChannelIds().add(CodeTemplateLibrariesPanel.this.channelId);
                            library.getEnabledChannelIds().remove(CodeTemplateLibrariesPanel.this.channelId);
                        }
                    }
                });
                CodeTemplateLibrariesPanel.this.parent.codeTemplateLibrariesReady();
            }
        });
    }

    public Map<String, CodeTemplateLibrary> getLibraryMap() {
        return this.libraryMap;
    }

    public boolean wasChanged() {
        return this.changed;
    }

    private void initComponents(Channel channel) {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.selectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.selectAllLabel.setForeground(Color.BLUE);
        this.selectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Enumeration libraryNodes = ((MutableTreeTableNode)CodeTemplateLibrariesPanel.this.libraryTreeTable.getTreeTableModel().getRoot()).children();
                while (libraryNodes.hasMoreElements()) {
                    MutableTreeTableNode libraryNode = (MutableTreeTableNode)libraryNodes.nextElement();
                    Triple triple = (Triple)libraryNode.getUserObject();
                    CodeTemplateLibrariesPanel.this.libraryTreeTable.getTreeTableModel().setValueAt((Object)new MutableTriple((Object)((String)triple.getLeft()), (Object)((String)triple.getMiddle()), (Object)true), (Object)libraryNode, CodeTemplateLibrariesPanel.this.libraryTreeTable.getHierarchicalColumn());
                }
                CodeTemplateLibrariesPanel.this.libraryTreeTable.updateUI();
                CodeTemplateLibrariesPanel.this.changed = true;
            }
        });
        this.selectSeparatorLabel = new JLabel("|");
        this.deselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.deselectAllLabel.setForeground(Color.BLUE);
        this.deselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Enumeration libraryNodes = ((MutableTreeTableNode)CodeTemplateLibrariesPanel.this.libraryTreeTable.getTreeTableModel().getRoot()).children();
                while (libraryNodes.hasMoreElements()) {
                    MutableTreeTableNode libraryNode = (MutableTreeTableNode)libraryNodes.nextElement();
                    Triple triple = (Triple)libraryNode.getUserObject();
                    CodeTemplateLibrariesPanel.this.libraryTreeTable.getTreeTableModel().setValueAt((Object)new MutableTriple((Object)((String)triple.getLeft()), (Object)((String)triple.getMiddle()), (Object)false), (Object)libraryNode, CodeTemplateLibrariesPanel.this.libraryTreeTable.getHierarchicalColumn());
                }
                CodeTemplateLibrariesPanel.this.libraryTreeTable.updateUI();
                CodeTemplateLibrariesPanel.this.changed = true;
            }
        });
        this.expandAllLabel = new JLabel("<html><u>Expand All</u></html>");
        this.expandAllLabel.setForeground(Color.BLUE);
        this.expandAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                CodeTemplateLibrariesPanel.this.libraryTreeTable.expandAll();
            }
        });
        this.expandSeparatorLabel = new JLabel("|");
        this.collapseAllLabel = new JLabel("<html><u>Collapse All</u></html>");
        this.collapseAllLabel.setForeground(Color.BLUE);
        this.collapseAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                CodeTemplateLibrariesPanel.this.libraryTreeTable.collapseAll();
            }
        });
        final LibraryTreeCellEditor libraryCellEditor = new LibraryTreeCellEditor();
        this.libraryTreeTable = new MirthTreeTable(){

            public TableCellEditor getCellEditor(int row, int column) {
                if (this.isHierarchical(column)) {
                    return libraryCellEditor;
                }
                return super.getCellEditor(row, column);
            }
        };
        SortableTreeTableModel model = new SortableTreeTableModel();
        DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode();
        model.setRoot((TreeTableNode)rootNode);
        this.libraryTreeTable.setLargeModel(true);
        this.libraryTreeTable.setTreeTableModel((TreeTableModel)model);
        this.libraryTreeTable.setOpenIcon(null);
        this.libraryTreeTable.setClosedIcon(null);
        this.libraryTreeTable.setLeafIcon(null);
        this.libraryTreeTable.setRootVisible(false);
        this.libraryTreeTable.setDoubleBuffered(true);
        this.libraryTreeTable.setDragEnabled(false);
        this.libraryTreeTable.setRowSelectionAllowed(true);
        this.libraryTreeTable.setSelectionMode(0);
        this.libraryTreeTable.setRowHeight(20);
        this.libraryTreeTable.setFocusable(true);
        this.libraryTreeTable.setOpaque(true);
        this.libraryTreeTable.setEditable(true);
        this.libraryTreeTable.setSortable(false);
        this.libraryTreeTable.setAutoCreateColumnsFromModel(false);
        this.libraryTreeTable.setShowGrid(true, true);
        this.libraryTreeTable.setTableHeader(null);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.libraryTreeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.libraryTreeTable.setTreeCellRenderer(new LibraryTreeCellRenderer());
        this.libraryTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                if (CodeTemplateLibrariesPanel.this.libraryTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY())) < 0) {
                    CodeTemplateLibrariesPanel.this.libraryTreeTable.clearSelection();
                }
            }
        });
        this.libraryTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    TreePath selectedPath;
                    boolean visible = false;
                    int selectedRow = CodeTemplateLibrariesPanel.this.libraryTreeTable.getSelectedRow();
                    if (selectedRow >= 0 && (selectedPath = CodeTemplateLibrariesPanel.this.libraryTreeTable.getPathForRow(selectedRow)) != null) {
                        visible = true;
                        Triple triple = (Triple)((MutableTreeTableNode)selectedPath.getLastPathComponent()).getUserObject();
                        String description = "";
                        if (selectedPath.getPathCount() == 2) {
                            description = CodeTemplateLibrariesPanel.this.libraryMap.get(triple.getLeft()).getDescription();
                        } else if (selectedPath.getPathCount() == 3) {
                            description = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplates().get(triple.getLeft()).getDescription();
                        }
                        if (StringUtils.isBlank((CharSequence)description) || StringUtils.equals((CharSequence)description, (CharSequence)CodeTemplateUtil.getDocumentation((String)"/**\n\tModify the description here. Modify the function name and parameters as needed. One function per\n\ttemplate is recommended; create a new code template for each new function.\n\n\t@param {String} arg1 - arg1 description\n\t@return {String} return description\n*/\nfunction new_function1(arg1) {\n\t// TODO: Enter code here\n}").getDescription())) {
                            CodeTemplateLibrariesPanel.this.descriptionTextPane.setText("<html><body class=\"code-template-libraries-panel\"><i>No description.</i></body></html>");
                        } else {
                            CodeTemplateLibrariesPanel.this.descriptionTextPane.setText("<html><body class=\"code-template-libraries-panel\">" + MirthXmlUtil.encode((String)description) + "</body></html>");
                        }
                    }
                    CodeTemplateLibrariesPanel.this.descriptionScrollPane.setVisible(visible);
                    CodeTemplateLibrariesPanel.this.updateUI();
                }
            }
        });
        this.libraryTreeTableScrollPane = new JScrollPane((Component)((Object)this.libraryTreeTable));
        this.descriptionTextPane = new JTextPane();
        this.descriptionTextPane.setContentType("text/html");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        StyleSheet styleSheet = editorKit.getStyleSheet();
        styleSheet.addRule(".code-template-libraries-panel {font-family:\"Tahoma\";font-size:11;text-align:top}");
        this.descriptionTextPane.setEditorKit(editorKit);
        this.descriptionTextPane.setEditable(false);
        this.descriptionScrollPane = new JScrollPane(this.descriptionTextPane);
        this.descriptionScrollPane.setHorizontalScrollBarPolicy(31);
        this.descriptionScrollPane.setVisible(false);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.add((Component)this.selectAllLabel, "split 3");
        this.add(this.selectSeparatorLabel);
        this.add(this.deselectAllLabel);
        this.add((Component)this.expandAllLabel, "right, split, w 51!");
        this.add(this.expandSeparatorLabel);
        this.add((Component)this.collapseAllLabel, "w 60!");
        this.add((Component)this.libraryTreeTableScrollPane, "newline, grow, sx, push");
        this.add((Component)this.descriptionScrollPane, "newline, grow, sx, h 90!");
    }

    private class LibraryTreeCellEditor
    extends DefaultCellEditor {
        private CheckBoxPanel panel;
        private JCheckBox checkBox;
        private JLabel filler;
        private JLabel label;
        private String id;

        public LibraryTreeCellEditor() {
            super(new JCheckBox());
            this.panel = new CheckBoxPanel((LayoutManager)new MigLayout("insets 1 0 0 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = (JCheckBox)this.editorComponent;
            this.panel.add(this.checkBox);
            this.filler = new JLabel();
            this.panel.add((Component)this.filler, "w 13!");
            this.label = new JLabel();
            this.panel.add((Component)this.label, "grow, push");
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CodeTemplateLibrariesPanel.this.changed = true;
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return new ImmutableTriple((Object)this.id, (Object)this.label.getText(), (Object)this.checkBox.isSelected());
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Triple triple = (Triple)value;
            if (triple != null) {
                this.id = (String)triple.getLeft();
                this.label.setText((String)triple.getMiddle());
                this.checkBox.setSelected((Boolean)triple.getRight());
            }
            MirthTreeTable treeTable = (MirthTreeTable)((Object)table);
            JTree tree = (JTree)((Object)treeTable.getCellRenderer(0, treeTable.getHierarchicalColumn()));
            this.panel.setOffset(tree.getRowBounds((int)row).x);
            this.panel.setBackground(table.getSelectionBackground());
            this.checkBox.setBackground(this.panel.getBackground());
            this.label.setBackground(this.panel.getBackground());
            TreePath path = treeTable.getPathForRow(row);
            if (path != null && path.getPathCount() == 2) {
                this.checkBox.setVisible(true);
                this.filler.setVisible(false);
            } else {
                this.checkBox.setVisible(false);
                this.filler.setVisible(true);
            }
            return this.panel;
        }

        private class CheckBoxPanel
        extends JPanel {
            private int offset;

            public CheckBoxPanel(LayoutManager layout) {
                super(layout);
            }

            public void setOffset(int offset) {
                this.offset = offset;
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x + this.offset, y, width - this.offset, height);
            }
        }
    }

    private class LibraryTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JCheckBox checkBox;
        private JLabel filler;
        private JLabel label;

        public LibraryTreeCellRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = new JCheckBox();
            this.add(this.checkBox);
            this.filler = new JLabel();
            this.add((Component)this.filler, "w 13!");
            this.label = new JLabel();
            this.add((Component)this.label, "grow, push");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MutableTreeTableNode node;
            if (selected) {
                this.setBackground(CodeTemplateLibrariesPanel.this.libraryTreeTable.getSelectionBackground());
            } else {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            this.checkBox.setBackground(this.getBackground());
            this.label.setBackground(this.getBackground());
            if (value != null && (node = (MutableTreeTableNode)value).getUserObject() != null) {
                Triple triple = (Triple)node.getUserObject();
                this.label.setText((String)triple.getMiddle());
                this.checkBox.setSelected((Boolean)triple.getRight());
                if (node.getParent().getParent() == null) {
                    this.checkBox.setVisible(true);
                    this.filler.setVisible(false);
                } else {
                    this.checkBox.setVisible(false);
                    this.filler.setVisible(true);
                }
            }
            return this;
        }
    }
}

