/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.AbstractChannelTableNode;
import com.mirth.connect.client.ui.components.ChannelTableTransferable;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.model.Channel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.apache.commons.io.FilenameUtils;

public abstract class ChannelTableTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent c) {
        MirthTreeTable channelTable = (MirthTreeTable)((Object)c);
        int[] rows = channelTable.getSelectedModelRows();
        if (rows.length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int row : rows) {
            AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)channelTable.getPathForRow(row).getLastPathComponent());
            if (node.isGroupNode()) {
                list.add(node.getGroupStatus().getGroup());
                continue;
            }
            list.add(node.getChannelStatus().getChannel());
        }
        if (list.isEmpty()) {
            return null;
        }
        return new ChannelTableTransferable(list);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.canImport(support)) {
            try {
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    final boolean showAlerts = fileList.size() == 1;
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    for (final File file : fileList) {
                        if (!FilenameUtils.isExtension((String)file.getName(), (String)"xml")) continue;
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ChannelTableTransferHandler.this.importFile(file, showAlerts);
                            }
                        });
                    }
                    return true;
                }
                if (support.isDataFlavorSupported(ChannelTableTransferable.CHANNEL_DATA_FLAVOR)) {
                    List list = (List)support.getTransferable().getTransferData(ChannelTableTransferable.CHANNEL_DATA_FLAVOR);
                    ArrayList<Channel> channels = new ArrayList<Channel>();
                    for (Object obj : list) {
                        if (obj instanceof Channel) {
                            channels.add((Channel)obj);
                            continue;
                        }
                        return false;
                    }
                    if (support.getDropLocation() instanceof JTable.DropLocation) {
                        return this.moveChannels(channels, ((JTable.DropLocation)support.getDropLocation()).getRow());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        try {
            if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    if (FilenameUtils.isExtension((String)file.getName(), (String)"xml")) continue;
                    return false;
                }
                return true;
            }
            if (support.isDataFlavorSupported(ChannelTableTransferable.CHANNEL_DATA_FLAVOR)) {
                List list = (List)support.getTransferable().getTransferData(ChannelTableTransferable.CHANNEL_DATA_FLAVOR);
                ArrayList<Channel> channels = new ArrayList<Channel>();
                for (Object obj : list) {
                    if (obj instanceof Channel) {
                        channels.add((Channel)obj);
                        continue;
                    }
                    return false;
                }
                if (support.getDropLocation() instanceof JTable.DropLocation) {
                    return this.canMoveChannels(channels, ((JTable.DropLocation)support.getDropLocation()).getRow());
                }
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public abstract void importFile(File var1, boolean var2);

    public abstract boolean canMoveChannels(List<Channel> var1, int var2);

    public abstract boolean moveChannels(List<Channel> var1, int var2);
}

