/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelGroup;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ChannelTableTransferable
implements Transferable {
    public static final DataFlavor CHANNEL_DATA_FLAVOR = new DataFlavor(List.class, "BridgeLink Channel");
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor, CHANNEL_DATA_FLAVOR};
    private List<?> list;
    private boolean includesGroups;

    public ChannelTableTransferable(Channel channel) {
        this(Collections.singletonList(channel));
    }

    public ChannelTableTransferable(ChannelGroup group) {
        this(Collections.singletonList(group));
    }

    public ChannelTableTransferable(List<?> list) {
        this.list = list;
        for (Object obj : list) {
            if (!(obj instanceof ChannelGroup)) continue;
            this.includesGroups = true;
            break;
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.includesGroups) {
            return flavor.equals(DataFlavor.stringFlavor) || flavor.equals(DataFlavor.plainTextFlavor);
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.includesGroups) {
            return new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
        }
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getStringData();
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringReader(this.getStringData());
        }
        if (flavor.equals(CHANNEL_DATA_FLAVOR) && !this.includesGroups) {
            return this.list;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String getStringData() {
        StringBuilder builder = new StringBuilder();
        Iterator<?> it = this.list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Channel) {
                Channel channel = (Channel)obj;
                builder.append(channel.getName()).append(" (").append(channel.getId()).append(')');
            } else if (obj instanceof ChannelGroup) {
                ChannelGroup group = (ChannelGroup)obj;
                builder.append(group.getName()).append(" (").append(group.getId()).append(')');
            }
            if (!it.hasNext()) continue;
            builder.append('\n');
        }
        return builder.toString();
    }
}

