/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ItemSelectionTableModel<K, V>
extends AbstractTableModel {
    public static final int NUM_COLUMNS = 3;
    public static final int VALUE_COLUMN = 1;
    public static final int CHECKBOX_COLUMN = 2;
    public static final int KEY_COLUMN = 0;
    private Object[][] tableData = null;
    private String[] columnNames = new String[3];
    private boolean[] canEdit = new boolean[]{false, false, true};

    public ItemSelectionTableModel(Map<K, V> items, List<K> selectedKeys, String valueColumnName, String checkboxColumnName, String keyColumnName) {
        this.tableData = new Object[items.size()][3];
        int i = 0;
        for (Map.Entry<K, V> entry : items.entrySet()) {
            this.tableData[i][1] = entry.getValue();
            this.tableData[i][2] = selectedKeys == null || selectedKeys.contains(entry.getKey()) ? Boolean.TRUE : Boolean.FALSE;
            this.tableData[i][0] = entry.getKey();
            ++i;
        }
        this.columnNames[0] = keyColumnName;
        this.columnNames[1] = valueColumnName;
        this.columnNames[2] = checkboxColumnName;
    }

    public ItemSelectionTableModel(Map<K, V> items, List<K> selectedKeys, String valueColumnName, String checkboxColumnName) {
        this(items, selectedKeys, valueColumnName, checkboxColumnName, null);
    }

    public List<K> getKeys(boolean selected) {
        ArrayList<Object> selectedKeys = new ArrayList<Object>();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if ((Boolean)this.getValueAt(i, 2) != selected) continue;
            selectedKeys.add(this.getValueAt(i, 0));
        }
        return selectedKeys;
    }

    public void unselectAllKeys() {
        for (int i = 0; i < this.tableData.length; ++i) {
            this.tableData[i][2] = Boolean.FALSE;
        }
        this.fireTableDataChanged();
    }

    public void selectKey(K key) {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!key.equals(this.getValueAt(i, 0))) continue;
            this.tableData[i][2] = Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    public void selectAllKeys() {
        for (int i = 0; i < this.tableData.length; ++i) {
            this.tableData[i][2] = Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    public void invertSelection() {
        for (int i = 0; i < this.tableData.length; ++i) {
            this.tableData[i][2] = (Boolean)this.tableData[i][2] != false ? Boolean.FALSE : Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.tableData.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int i, int j) {
        return this.tableData[i][j];
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.tableData[rowIndex][columnIndex] = value;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.canEdit[columnIndex];
    }

    protected Object[][] getTableData() {
        return this.tableData;
    }
}

