/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import javax.swing.AbstractSpinnerModel;

public class MirthBlankableSpinnerModel
extends AbstractSpinnerModel {
    private Object value = "";
    private Integer minimum;
    private Integer maximum;
    private int startValue;

    public MirthBlankableSpinnerModel() {
        this(null, null);
    }

    public MirthBlankableSpinnerModel(Integer minimum, Integer maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.startValue = minimum == null && maximum == null ? 0 : (minimum != null ? minimum.intValue() : maximum.intValue());
    }

    @Override
    public Object getNextValue() {
        return this.value.equals("") ? this.startValue : this.min(new Integer(this.value.toString()) + 1, this.maximum);
    }

    @Override
    public Object getPreviousValue() {
        return this.value.equals("") ? this.startValue : this.max(new Integer(this.value.toString()) - 1, this.minimum);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.value = null;
        } else {
            try {
                this.value = new Integer(object.toString());
                if (this.minimum != null && (Integer)this.value < this.minimum) {
                    this.value = this.minimum;
                } else if (this.maximum != null && (Integer)this.value > this.maximum) {
                    this.value = this.maximum;
                }
            }
            catch (NumberFormatException e) {
                this.value = "";
            }
        }
        this.fireStateChanged();
    }

    private int min(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.min(a, b);
    }

    private int max(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.max(a, b);
    }
}

