/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;

public class MirthComboBox<E>
extends JComboBox<E> {
    private Frame parent;
    private boolean autoResizeDropdown = false;
    private boolean canEnableSave = true;
    private Object initialValue = "";

    public MirthComboBox() {
        this.setFocusable(true);
        this.parent = PlatformUI.MIRTH_FRAME;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MirthComboBox.this.comboBoxChanged(evt);
            }
        });
        this.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isAccelerated;
                boolean bl = isAccelerated = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 || (e.getModifiers() & 2) > 0;
                if (e.getKeyCode() == 83 && isAccelerated) {
                    PlatformUI.MIRTH_FRAME.doContextSensitiveSave();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (MirthComboBox.this.canEnableSave && !MirthComboBox.this.getEditor().getItem().equals(MirthComboBox.this.initialValue)) {
                    MirthComboBox.this.initialValue = MirthComboBox.this.getEditor().getItem();
                    MirthComboBox.this.parent.setSaveEnabled(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void comboBoxChanged(ActionEvent evt) {
        if (this.canEnableSave) {
            this.parent.setSaveEnabled(true);
        }
    }

    public void setCanEnableSave(boolean canEnableSave) {
        this.canEnableSave = canEnableSave;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        this.initialValue = anObject;
        super.setSelectedItem(anObject);
    }

    @Override
    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (this.autoResizeDropdown) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int maxWidth = 0;
            for (int index = 0; index < this.getItemCount(); ++index) {
                String entry = this.getItemAt(index).toString();
                int width = fontMetrics.stringWidth(entry);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            dimension.setSize((double)maxWidth > dimension.getWidth() ? (double)(maxWidth + 4) : dimension.getWidth(), dimension.getHeight());
        }
        return dimension;
    }

    public void setAutoResizeDropdown(boolean autoResizeDropdown) {
        this.autoResizeDropdown = autoResizeDropdown;
    }
}

