/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MirthComboBoxTableCellRenderer
implements TableCellRenderer {
    protected JComboBox comboBox;

    public MirthComboBoxTableCellRenderer(Object[] items) {
        this.comboBox = new JComboBox<Object>(items);
        for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
            if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
            ((AbstractButton)this.comboBox.getComponent(i)).setBorderPainted(false);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.comboBox.setForeground(table.getSelectionForeground());
            this.comboBox.setBackground(table.getSelectionBackground());
        } else {
            this.comboBox.setForeground(table.getForeground());
            this.comboBox.setBackground(table.getBackground());
        }
        for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
            Component component = this.comboBox.getComponent(i);
            component.setBackground(this.comboBox.getBackground());
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
                button.setVisible(table.isCellEditable(row, column));
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setBorder(new EmptyBorder(0, 3, 0, 0));
            if (isSelected) {
                ((JComponent)component).setBackground(table.getSelectionBackground());
                continue;
            }
            if (row % 2 != 0) continue;
            ((JComponent)component).setBackground(new Color(242, 242, 242));
        }
        if (value != null) {
            this.comboBox.setSelectedItem(value);
        } else {
            this.comboBox.setSelectedIndex(-1);
        }
        return this.comboBox;
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setEditable(boolean editable) {
        this.comboBox.setEditable(editable);
    }
}

