/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class MirthPropertiesTable
extends MirthTable {
    private static final String PROPERTY_TITLE = "Property";
    private static final String VALUE_TITLE = "Value";
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private DefaultTableModel model = new DefaultTableModel(null, new String[]{"Property", "Value"}){
        boolean[] canEdit;
        {
            this.canEdit = new boolean[]{true, true};
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }
    };
    private int lastIndex;

    public MirthPropertiesTable() {
        this.setModel(this.model);
        this.getPropertyColumn().setCellEditor(new CellEditor(true, null));
        this.getValueColumn().setCellEditor(new CellEditor(false, null));
        this.setCustomEditorControls(true);
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(20);
        this.setDragEnabled(false);
        this.setOpaque(true);
        this.setSortable(false);
        this.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    public TableColumn getPropertyColumn() {
        return this.getColumnModel().getColumn(this.getColumnModel().getColumnIndex(PROPERTY_TITLE));
    }

    public TableColumn getValueColumn() {
        return this.getColumnModel().getColumn(this.getColumnModel().getColumnIndex(VALUE_TITLE));
    }

    public void setNewButton(JButton newButton) {
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirthPropertiesTable.this.model.addRow(new String[]{MirthPropertiesTable.this.getNewPropertyName(), ""});
                MirthPropertiesTable.this.setRowSelectionInterval(MirthPropertiesTable.this.getRowCount() - 1, MirthPropertiesTable.this.getRowCount() - 1);
                MirthPropertiesTable.this.parent.setSaveEnabled(true);
            }
        });
    }

    public void setDeleteButton(final JButton deleteButton) {
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                int n = selectedRow = MirthPropertiesTable.this.isEditing() ? MirthPropertiesTable.this.getEditingRow() : MirthPropertiesTable.this.getSelectedRow();
                if (selectedRow != -1 && !MirthPropertiesTable.this.isEditing()) {
                    MirthPropertiesTable.this.model.removeRow(selectedRow);
                    if (MirthPropertiesTable.this.getRowCount() != 0) {
                        if (MirthPropertiesTable.this.lastIndex == 0) {
                            MirthPropertiesTable.this.setRowSelectionInterval(0, 0);
                        } else if (MirthPropertiesTable.this.lastIndex == MirthPropertiesTable.this.getRowCount()) {
                            MirthPropertiesTable.this.setRowSelectionInterval(MirthPropertiesTable.this.lastIndex - 1, MirthPropertiesTable.this.lastIndex - 1);
                        } else {
                            MirthPropertiesTable.this.setRowSelectionInterval(MirthPropertiesTable.this.lastIndex, MirthPropertiesTable.this.lastIndex);
                        }
                    }
                    MirthPropertiesTable.this.parent.setSaveEnabled(true);
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                int selectedRow;
                int n = selectedRow = MirthPropertiesTable.this.isEditing() ? MirthPropertiesTable.this.getEditingRow() : MirthPropertiesTable.this.getSelectedRow();
                if (selectedRow != -1) {
                    MirthPropertiesTable.this.lastIndex = selectedRow;
                    deleteButton.setEnabled(true);
                } else {
                    deleteButton.setEnabled(false);
                }
            }
        });
        this.getColumnModel().getColumn(this.getColumnModel().getColumnIndex(PROPERTY_TITLE)).setCellEditor(new CellEditor(true, deleteButton));
        this.getColumnModel().getColumn(this.getColumnModel().getColumnIndex(VALUE_TITLE)).setCellEditor(new CellEditor(false, deleteButton));
    }

    public void setProperties(Map<String, String> properties) {
        this.model.setRowCount(0);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.model.addRow(new String[]{entry.getKey(), entry.getValue()});
        }
    }

    public Map<String, String> getProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            properties.put(this.model.getValueAt(i, 0).toString(), this.model.getValueAt(i, 1).toString());
        }
        return properties;
    }

    private String getNewPropertyName() {
        String temp = "Property ";
        for (int i = 1; i <= this.getRowCount() + 1; ++i) {
            boolean exists = false;
            for (int j = 0; j < this.getRowCount(); ++j) {
                if (!((String)this.getValueAt(j, 0)).equalsIgnoreCase(temp + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return temp + i;
        }
        return "";
    }

    private class CellEditor
    extends TextFieldCellEditor {
        private boolean checkProperties;
        private JButton deleteButton;

        CellEditor(boolean checkProperties, JButton deleteButton) {
            this.checkProperties = checkProperties;
            this.deleteButton = deleteButton;
        }

        boolean checkUniqueProperty(String property) {
            boolean exists = false;
            for (int i = 0; i < MirthPropertiesTable.this.getRowCount(); ++i) {
                if (MirthPropertiesTable.this.getValueAt(i, 0) == null || !((String)MirthPropertiesTable.this.getValueAt(i, 0)).equalsIgnoreCase(property)) continue;
                exists = true;
            }
            return exists;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            boolean editable = super.isCellEditable(evt);
            if (editable && this.deleteButton != null) {
                this.deleteButton.setEnabled(false);
            }
            return editable;
        }

        @Override
        protected boolean valueChanged(String value) {
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(true);
            }
            if (this.checkProperties && (value.length() == 0 || this.checkUniqueProperty(value))) {
                return false;
            }
            MirthPropertiesTable.this.parent.setSaveEnabled(true);
            return true;
        }
    }
}

