/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MirthTable
extends JXTable {
    private Preferences userPreferences;
    private String prefix;
    private Set<String> defaultVisibleColumns;
    private Map<String, Integer> columnOrderMap;
    private List<RowSorter.SortKey> sortKeys;
    private MouseAdapter tableSortAdapter;

    public MirthTable() {
        this(null, null);
    }

    public MirthTable(String prefix, Set<String> defaultVisibleColumns) {
        this.prefix = prefix;
        this.defaultVisibleColumns = defaultVisibleColumns;
        this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
        this.columnOrderMap = new HashMap<String, Integer>();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            try {
                this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
                String columns = this.userPreferences.get(prefix + "ColumnOrderMap", "");
                if (StringUtils.isNotEmpty((CharSequence)columns)) {
                    this.columnOrderMap = (Map)ObjectXMLSerializer.getInstance().deserialize(columns, Map.class);
                }
            }
            catch (Exception columns) {
                // empty catch block
            }
            this.sortKeys = new ArrayList<RowSorter.SortKey>();
            try {
                String sortOrder = this.userPreferences.get(prefix + "SortOrder", "");
                if (StringUtils.isNotEmpty((CharSequence)sortOrder)) {
                    this.sortKeys = (List)ObjectXMLSerializer.getInstance().deserialize(sortOrder, List.class);
                }
            }
            catch (Exception sortOrder) {
                // empty catch block
            }
        }
        this.setDragEnabled(true);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isAccelerated;
                boolean bl = isAccelerated = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 || (e.getModifiers() & 2) > 0;
                if (e.getKeyCode() == 83 && isAccelerated) {
                    PlatformUI.MIRTH_FRAME.doContextSensitiveSave();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                MirthTable.this.saveColumnOrder();
            }
        });
        final JButton columnControlButton = new JButton(new ColumnControlButton((JXTable)this).getIcon());
        columnControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu columnMenu = MirthTable.this.getColumnMenu();
                Dimension buttonSize = columnControlButton.getSize();
                int xPos = columnControlButton.getComponentOrientation().isLeftToRight() ? buttonSize.width - columnMenu.getPreferredSize().width : 0;
                columnMenu.show(columnControlButton, xPos, columnControlButton.getHeight());
            }
        });
        this.setColumnControl(columnControlButton);
    }

    public void setMirthColumnControlEnabled(boolean enabled) {
        if (enabled) {
            if (this.tableSortAdapter == null) {
                this.tableSortAdapter = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            MirthTable.this.getColumnMenu().show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                };
                this.getTableHeader().addMouseListener(this.tableSortAdapter);
            }
        } else if (this.tableSortAdapter != null) {
            this.getTableHeader().removeMouseListener(this.tableSortAdapter);
            this.tableSortAdapter = null;
        }
        this.setColumnControlVisible(enabled);
    }

    private JPopupMenu getColumnMenu() {
        JPopupMenu columnMenu = new JPopupMenu();
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            String columnName = model.getColumnName(i);
            TableColumnExt column = this.getColumnExt(columnName);
            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(columnName);
            menuItem.setSelected(column.isVisible());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean enable;
                    TableColumnExt column = MirthTable.this.getColumnExt(menuItem.getText());
                    boolean bl = enable = !column.isVisible();
                    if (enable || MirthTable.this.getColumnCount() > 1) {
                        column.setVisible(enable);
                        MirthTable.this.saveColumnOrder();
                    }
                }
            });
            columnMenu.add(menuItem);
        }
        columnMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Restore Default");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MirthTable.this.restoreDefaultColumnPreferences();
            }
        });
        columnMenu.add(menuItem);
        return columnMenu;
    }

    public void sorterChanged(RowSorterEvent event) {
        super.sorterChanged(event);
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                this.sortKeys = new ArrayList<RowSorter.SortKey>(this.getRowSorter().getSortKeys());
                this.userPreferences.put(this.prefix + "SortOrder", ObjectXMLSerializer.getInstance().serialize(this.sortKeys));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restoreColumnPreferences() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                TableColumnModelExt columnModel = (TableColumnModelExt)this.getColumnModel();
                TreeMap<Integer, Integer> columnOrder = new TreeMap<Integer, Integer>();
                int columnIndex = 0;
                for (TableColumn column : columnModel.getColumns(true)) {
                    String columnName = (String)column.getIdentifier();
                    Integer viewIndex = this.columnOrderMap.get(columnName);
                    TableColumnExt columnExt = this.getColumnExt(columnName);
                    boolean visible = false;
                    visible = viewIndex == null ? this.defaultVisibleColumns == null || this.defaultVisibleColumns.contains(columnName) : viewIndex > -1;
                    columnExt.setVisible(visible);
                    if (viewIndex != null && viewIndex > -1) {
                        columnOrder.put(viewIndex, columnIndex);
                    }
                    ++columnIndex;
                }
                int viewIndex = 0;
                Iterator iterator = columnOrder.values().iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    columnModel.moveColumn(this.convertColumnIndexToView(index), viewIndex++);
                }
                if (this.sortKeys != null && !this.sortKeys.isEmpty()) {
                    this.getRowSorter().setSortKeys(this.sortKeys);
                }
            }
        }
        catch (Exception e) {
            this.restoreDefaultColumnPreferences();
        }
    }

    private void restoreDefaultColumnPreferences() {
        try {
            this.userPreferences.put(this.prefix + "ColumnOrderMap", "");
            this.userPreferences.put(this.prefix + "SortOrder", "");
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                TableColumnExt columnExt;
                this.columnOrderMap.clear();
                for (TableColumn column : this.getColumns(true)) {
                    TableColumnExt columnExt2 = (TableColumnExt)column;
                    columnExt2.setVisible(true);
                }
                int index = 0;
                for (TableColumn column : this.getColumns(true)) {
                    columnExt = (TableColumnExt)column;
                    this.columnModel.moveColumn(this.columnModel.getColumnIndex(columnExt.getTitle()), index++);
                }
                for (TableColumn column : this.getColumns(true)) {
                    columnExt = (TableColumnExt)column;
                    columnExt.setVisible(this.defaultVisibleColumns.contains(columnExt.getTitle()));
                }
                this.sortKeys.clear();
                this.getRowSorter().setSortKeys(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveColumnOrder() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                this.columnOrderMap.clear();
                for (TableColumn column : this.getColumns(true)) {
                    this.columnOrderMap.put((String)column.getHeaderValue(), this.convertColumnIndexToView(column.getModelIndex()));
                }
                this.userPreferences.put(this.prefix + "ColumnOrderMap", ObjectXMLSerializer.getInstance().serialize(this.columnOrderMap));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCustomEditorControls(boolean enabled) {
        if (enabled) {
            AbstractAction toggleEditing = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MirthTable.this.isEditing()) {
                        MirthTable.this.getCellEditor().stopCellEditing();
                    } else {
                        boolean success = MirthTable.this.editCellAt(MirthTable.this.getSelectedRow(), MirthTable.this.getSelectedColumn(), e);
                        if (success && MirthTable.this.getCellEditor() instanceof TextFieldCellEditor) {
                            ((TextFieldCellEditor)MirthTable.this.getCellEditor()).getTextField().requestFocusInWindow();
                        }
                    }
                }
            };
            this.setAutoStartEditOnKeyStroke(false);
            this.setSurrendersFocusOnKeystroke(true);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "toggleEditing");
            this.getActionMap().put("toggleEditing", toggleEditing);
        } else {
            this.setAutoStartEditOnKeyStroke(true);
            this.setSurrendersFocusOnKeystroke(false);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextRowCell");
        }
    }

    public Class getColumnClass(int column) {
        try {
            if (this.getRowCount() >= 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                return this.getValueAt(0, column).getClass();
            }
            return Object.class;
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public int getColumnViewIndex(String columnName) {
        return this.getColumnModel().getColumnIndex(columnName);
    }

    public int getColumnModelIndex(String columnName) {
        return this.convertColumnIndexToModel(this.getColumnModel().getColumnIndex(columnName));
    }

    public int getSelectedModelIndex() {
        int index = -1;
        index = this.isEditing() ? this.getEditingRow() : this.getSelectedRow();
        if (index == -1) {
            return index;
        }
        return this.convertRowIndexToModel(index);
    }

    public int[] getSelectedModelRows() {
        int[] views = this.getSelectedRows();
        for (int i = 0; i < views.length; ++i) {
            views[i] = this.convertRowIndexToModel(views[i]);
        }
        return views;
    }
}

