/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class MirthTextIcon
implements Icon {
    private static final Color DEFAULT_BACKGROUND = new Color(220, 220, 220);
    private String text;
    private boolean includeSpace;
    private Color background;
    private int width;
    private int widthWithSpace;
    private int height;

    public MirthTextIcon(JComponent component, String text) {
        this(component, text, false);
    }

    public MirthTextIcon(JComponent component, String text, boolean includeSpace) {
        this(component, text, includeSpace, null);
    }

    public MirthTextIcon(JComponent component, String text, boolean includeSpace, int background) {
        this(component, text, includeSpace, new Color(background));
    }

    public MirthTextIcon(JComponent component, String text, boolean includeSpace, Color background) {
        this.text = " " + text + " ";
        this.includeSpace = includeSpace;
        Color color = this.background = background != null ? background : component.getBackground();
        if (this.background == null) {
            this.background = DEFAULT_BACKGROUND;
        }
        FontMetrics fm = component.getFontMetrics(component.getFont());
        this.width = fm.stringWidth(this.text);
        if (includeSpace) {
            this.widthWithSpace = fm.stringWidth(this.text + " ");
        }
        this.height = fm.getHeight();
        component.revalidate();
    }

    @Override
    public int getIconWidth() {
        return this.includeSpace ? this.widthWithSpace : this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(c.getFont());
        if (this.background.equals(DEFAULT_BACKGROUND)) {
            g2.setColor(this.background);
        } else {
            g2.setColor(c.isEnabled() ? this.background : this.brighter(this.background));
        }
        g2.fillRoundRect(x, y, this.width, this.height + 1, 6, 6);
        g2.translate(x, y + g2.getFontMetrics().getAscent());
        if (this.background.equals(DEFAULT_BACKGROUND) && c instanceof JTextComponent) {
            g2.setColor(c.isEnabled() ? c.getForeground() : ((JTextComponent)c).getDisabledTextColor());
        } else {
            g2.setColor(c.isEnabled() ? c.getForeground() : this.darker(this.background));
        }
        g2.drawString(this.text, 0, 0);
        g2.dispose();
    }

    private Color brighter(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        float factor = 0.85f;
        int min = (int)(1.0 / (1.0 - (double)factor));
        if (red == 0 && green == 0 && blue == 0) {
            red = min;
            green = min;
            blue = min;
        } else {
            red = this.transform(red, min, factor);
            green = this.transform(green, min, factor);
            blue = this.transform(blue, min, factor);
        }
        return new Color(red, green, blue, alpha);
    }

    private int transform(int value, int min, float factor) {
        if (value > 0 && value < min) {
            value = min;
        }
        return Math.min((int)((float)value / factor), 255);
    }

    private Color darker(Color color) {
        return color.darker().darker();
    }
}

