/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class MirthTimePicker
extends JSpinner {
    private DateFormatter formatter;
    private final JSpinner spinner;
    private Frame parent;
    private boolean saveEnabled = true;

    public MirthTimePicker() {
        this.init("hh:mm aa", 12);
        this.spinner = this;
    }

    public MirthTimePicker(String format, int accuracy) {
        this.init(format, accuracy);
        this.spinner = this;
    }

    public void init(String format, int accuracy) {
        this.parent = PlatformUI.MIRTH_FRAME;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        GregorianCalendar calendar = new GregorianCalendar();
        Date now = calendar.getTime();
        SpinnerDateModel dateModel = new SpinnerDateModel(now, null, null, accuracy);
        this.getEditor().setFont(UIConstants.TEXTFIELD_PLAIN_FONT);
        this.setModel(dateModel);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (MirthTimePicker.this.saveEnabled) {
                    MirthTimePicker.this.parent.setSaveEnabled(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        this.formatter = (DateFormatter)factory.getDefaultFormatter();
        this.formatter.setFormat(dateFormat);
        this.fireStateChanged();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (MirthTimePicker.this.saveEnabled) {
                    MirthTimePicker.this.parent.setSaveEnabled(true);
                }
            }
        });
    }

    public void setSaveEnabled(boolean saveEnabled) {
        this.saveEnabled = saveEnabled;
    }

    public void setDate(String date) {
        try {
            this.setValue(this.formatter.stringToValue(date));
            if (this.saveEnabled) {
                this.parent.setSaveEnabled(false);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getDate() {
        return ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().getText();
    }
}

