/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;

public class AutoCompleteProperties {
    private boolean activateAfterLetters;
    private String activateAfterOthers;
    private int activationDelay;

    public AutoCompleteProperties() {
        this(null);
    }

    public AutoCompleteProperties(AutoCompleteProperties properties) {
        if (properties != null) {
            this.init(properties.isActivateAfterLetters(), properties.getActivateAfterOthers(), properties.getActivationDelay());
        } else {
            this.init(null, null, null);
        }
    }

    public AutoCompleteProperties(Boolean activateAfterLetters, String activateAfterOthers, Integer activationDelay) {
        this.init(activateAfterLetters, activateAfterOthers, activationDelay);
    }

    private void init(Boolean activateAfterLetters, String activateAfterOthers, Integer activationDelay) {
        this.activateAfterLetters = false;
        this.activateAfterOthers = ".";
        this.activationDelay = 300;
        if (activateAfterLetters != null) {
            this.activateAfterLetters = activateAfterLetters;
        }
        if (activateAfterOthers != null) {
            this.activateAfterOthers = activateAfterOthers;
        }
        if (activationDelay != null) {
            this.activationDelay = activationDelay;
        }
    }

    public boolean isActivateAfterLetters() {
        return this.activateAfterLetters;
    }

    public void setActivateAfterLetters(boolean activateAfterLetters) {
        this.activateAfterLetters = activateAfterLetters;
    }

    public String getActivateAfterOthers() {
        return this.activateAfterOthers;
    }

    public void setActivateAfterOthers(String activateAfterOthers) {
        this.activateAfterOthers = activateAfterOthers;
    }

    public int getActivationDelay() {
        return this.activationDelay;
    }

    public void setActivationDelay(int activationDelay) {
        this.activationDelay = activationDelay;
    }

    JsonNode toJsonNode() {
        ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
        rootNode.put("activateAfterLetters", this.activateAfterLetters);
        rootNode.put("activateAfterOthers", this.activateAfterOthers);
        rootNode.put("activationDelay", this.activationDelay);
        return rootNode;
    }

    static AutoCompleteProperties fromJSON(String autoCompleteJSON) {
        Boolean activateAfterLetters = null;
        String activateAfterOthers = null;
        Integer activationDelay = null;
        if (StringUtils.isNotBlank((CharSequence)autoCompleteJSON)) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode rootNode = (ObjectNode)mapper.readTree(autoCompleteJSON);
                JsonNode node = rootNode.get("activateAfterLetters");
                if (node != null) {
                    activateAfterLetters = node.asBoolean();
                }
                if ((node = rootNode.get("activateAfterOthers")) != null) {
                    activateAfterOthers = node.asText();
                }
                if ((node = rootNode.get("activationDelay")) != null) {
                    activationDelay = node.asInt();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new AutoCompleteProperties(activateAfterLetters, activateAfterOthers, activationDelay);
    }
}

