/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.rsta.FindReplaceProperties;
import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxTextArea;
import com.mirth.connect.client.ui.util.DisplayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

public class FindReplaceDialog
extends MirthDialog {
    private MirthRSyntaxTextArea textArea;
    private JPanel findPanel;
    private JLabel findLabel;
    private JComboBox<String> findComboBox;
    private JLabel replaceLabel;
    private JComboBox<String> replaceComboBox;
    private JPanel directionPanel;
    private JRadioButton directionForwardRadio;
    private JRadioButton directionBackwardRadio;
    private JPanel optionsPanel;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox regularExpressionCheckBox;
    private JCheckBox wholeWordCheckBox;
    private JCheckBox wrapSearchCheckBox;
    private JButton findButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JLabel warningLabel;
    private JButton closeButton;

    public FindReplaceDialog(MirthRSyntaxTextArea textArea) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), "Find / Replace", true);
        this.textArea = textArea;
        this.initComponents();
        this.initLayout();
        this.setProperties();
        DisplayUtil.setResizable(this, false);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.setVisible(true);
    }

    private void find() {
        this.search(true, false);
    }

    private void replace() {
        this.search(false, false);
    }

    private void replaceAll() {
        this.search(false, true);
    }

    private void search(boolean find2, boolean replaceAll) {
        this.warningLabel.setText("");
        if (StringUtils.isEmpty((CharSequence)((String)this.findComboBox.getSelectedItem()))) {
            return;
        }
        SearchContext context = this.getContext();
        SearchResult result = this.getResult(context, find2, replaceAll);
        boolean wrapped = false;
        if (result.getCount() == 0 && this.wrapSearchCheckBox.isSelected()) {
            int position = this.textArea.getCaretPosition();
            this.textArea.setCaretPosition(this.directionForwardRadio.isSelected() ? 0 : this.textArea.getDocument().getLength());
            result = this.getResult(context, find2, replaceAll);
            if (result.getCount() == 0) {
                this.textArea.setCaretPosition(position);
            } else {
                wrapped = true;
                Toolkit.getDefaultToolkit().beep();
            }
        }
        if ((find2 || !replaceAll) && result.getMarkedCount() == 0 || replaceAll && result.getCount() == 0) {
            this.warningLabel.setText("No results found.");
        } else if (find2) {
            this.warningLabel.setText(result.getMarkedCount() + " results found" + (wrapped ? "; wrapped." : "."));
        } else {
            this.warningLabel.setText(result.getCount() + " out of " + (replaceAll ? result.getCount() : result.getMarkedCount()) + " results replaced.");
        }
        this.updateProperties();
    }

    private SearchContext getContext() {
        SearchContext context = new SearchContext();
        context.setSearchFor((String)this.findComboBox.getSelectedItem());
        context.setReplaceWith((String)this.replaceComboBox.getSelectedItem());
        context.setSearchForward(this.directionForwardRadio.isSelected());
        context.setMatchCase(this.matchCaseCheckBox.isSelected());
        context.setRegularExpression(this.regularExpressionCheckBox.isSelected());
        context.setWholeWord(this.wholeWordCheckBox.isSelected());
        return context;
    }

    private SearchResult getResult(SearchContext context, boolean find2, boolean replaceAll) {
        if (find2) {
            return SearchEngine.find((JTextArea)((Object)this.textArea), context);
        }
        if (!replaceAll) {
            return SearchEngine.replace((RTextArea)((Object)this.textArea), context);
        }
        return SearchEngine.replaceAll((RTextArea)((Object)this.textArea), context);
    }

    private void setProperties() {
        FindReplaceProperties findReplaceProperties = MirthRSyntaxTextArea.getRSTAPreferences().getFindReplaceProperties();
        List<String> findHistory = findReplaceProperties.getFindHistory();
        this.findComboBox.setModel(new DefaultComboBoxModel<String>(findHistory.toArray(new String[findHistory.size()])));
        if (StringUtils.isNotEmpty((CharSequence)this.textArea.getSelectedText())) {
            this.findComboBox.setSelectedItem(this.textArea.getSelectedText());
        }
        List<String> replaceHistory = findReplaceProperties.getReplaceHistory();
        this.replaceComboBox.setModel(new DefaultComboBoxModel<String>(replaceHistory.toArray(new String[replaceHistory.size()])));
        if (findReplaceProperties.isForward()) {
            this.directionForwardRadio.setSelected(true);
        } else {
            this.directionBackwardRadio.setSelected(true);
        }
        this.wrapSearchCheckBox.setSelected(findReplaceProperties.isWrapSearch());
        this.matchCaseCheckBox.setSelected(findReplaceProperties.isMatchCase());
        this.regularExpressionCheckBox.setSelected(findReplaceProperties.isRegularExpression());
        this.wholeWordCheckBox.setSelected(findReplaceProperties.isWholeWord());
        if (!this.textArea.isEditable()) {
            this.replaceLabel.setEnabled(false);
            this.replaceComboBox.setEnabled(false);
            this.replaceButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
        }
    }

    private void updateProperties() {
        FindReplaceProperties findReplaceProperties = MirthRSyntaxTextArea.getRSTAPreferences().getFindReplaceProperties();
        String findText = (String)this.findComboBox.getSelectedItem();
        List<String> findHistory = findReplaceProperties.getFindHistory();
        findHistory.remove(findText);
        findHistory.add(0, findText);
        while (findHistory.size() > 10) {
            findHistory.remove(10);
        }
        this.findComboBox.setModel(new DefaultComboBoxModel<String>(findHistory.toArray(new String[findHistory.size()])));
        this.findComboBox.setSelectedIndex(0);
        String replaceText = (String)this.replaceComboBox.getSelectedItem();
        if (StringUtils.isNotEmpty((CharSequence)replaceText)) {
            List<String> replaceHistory = findReplaceProperties.getReplaceHistory();
            replaceHistory.remove(replaceText);
            replaceHistory.add(0, replaceText);
            while (replaceHistory.size() > 10) {
                replaceHistory.remove(10);
            }
            this.replaceComboBox.setModel(new DefaultComboBoxModel<String>(replaceHistory.toArray(new String[replaceHistory.size()])));
            this.replaceComboBox.setSelectedIndex(0);
        }
        findReplaceProperties.setForward(this.directionForwardRadio.isSelected());
        findReplaceProperties.setWrapSearch(this.wrapSearchCheckBox.isSelected());
        findReplaceProperties.setMatchCase(this.matchCaseCheckBox.isSelected());
        findReplaceProperties.setRegularExpression(this.regularExpressionCheckBox.isSelected());
        findReplaceProperties.setWholeWord(this.wholeWordCheckBox.isSelected());
        MirthRSyntaxTextArea.updateFindReplacePreferences();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 11, novisualpadding, hidemode 3, fill, gap 6"));
        this.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.getContentPane().setBackground(this.getBackground());
        this.findPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6"));
        this.findPanel.setBackground(this.getBackground());
        ActionListener findActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.find();
            }
        };
        this.findLabel = new JLabel("Find text:");
        this.findComboBox = new JComboBox();
        this.findComboBox.setEditable(true);
        this.findComboBox.setBackground(UIConstants.BACKGROUND_COLOR);
        this.findComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10 && evt.getModifiers() == 0) {
                    FindReplaceDialog.this.find();
                }
            }
        });
        ActionListener replaceActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.replace();
            }
        };
        this.replaceLabel = new JLabel("Replace with:");
        this.replaceComboBox = new JComboBox();
        this.replaceComboBox.setEditable(true);
        this.replaceComboBox.setBackground(UIConstants.BACKGROUND_COLOR);
        this.directionPanel = new JPanel((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill, gap 6"));
        this.directionPanel.setBackground(this.getBackground());
        this.directionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)), "Direction", 0, 0, new Font("Tahoma", 1, 11)));
        ButtonGroup directionButtonGroup = new ButtonGroup();
        this.directionForwardRadio = new JRadioButton("Forward");
        this.directionForwardRadio.setBackground(this.directionPanel.getBackground());
        directionButtonGroup.add(this.directionForwardRadio);
        this.directionBackwardRadio = new JRadioButton("Backward");
        this.directionBackwardRadio.setBackground(this.directionPanel.getBackground());
        directionButtonGroup.add(this.directionBackwardRadio);
        this.optionsPanel = new JPanel((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill, gap 6"));
        this.optionsPanel.setBackground(this.getBackground());
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)), "Options", 0, 0, new Font("Tahoma", 1, 11)));
        this.wrapSearchCheckBox = new JCheckBox("Wrap Search");
        this.matchCaseCheckBox = new JCheckBox("Match Case");
        this.regularExpressionCheckBox = new JCheckBox("Regular Expression");
        this.wholeWordCheckBox = new JCheckBox("Whole Word");
        this.findButton = new JButton("Find");
        this.findButton.addActionListener(findActionListener);
        this.replaceButton = new JButton("Replace");
        this.replaceButton.addActionListener(replaceActionListener);
        this.replaceAllButton = new JButton("Replace All");
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.replaceAll();
            }
        });
        this.warningLabel = new JLabel();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        this.findPanel.add((Component)this.findLabel, "right");
        this.findPanel.add(this.findComboBox, "grow, pushx");
        this.findPanel.add((Component)this.replaceLabel, "newline, right");
        this.findPanel.add(this.replaceComboBox, "grow, pushx");
        this.add((Component)this.findPanel, "grow");
        this.directionPanel.add((Component)this.directionForwardRadio, "w 96!");
        this.directionPanel.add(this.directionBackwardRadio);
        this.add((Component)this.directionPanel, "newline, sx, grow");
        this.optionsPanel.add(this.wrapSearchCheckBox);
        this.optionsPanel.add(this.matchCaseCheckBox);
        this.optionsPanel.add((Component)this.regularExpressionCheckBox, "newline");
        this.optionsPanel.add(this.wholeWordCheckBox);
        this.add((Component)this.optionsPanel, "newline, sx, grow, push");
        this.add((Component)this.findButton, "newline, split 3, w 81!");
        this.add((Component)this.replaceButton, "w 81!");
        this.add((Component)this.replaceAllButton, "w 81!");
        this.add((Component)new JSeparator(), "newline, sx, grow");
        this.add((Component)this.warningLabel, "newline, split, growx, pushx");
        this.add((Component)this.closeButton, "right, w 81!");
    }
}

