/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class FindReplaceProperties {
    private static final String KEY_FORWARD = "forward";
    private static final String KEY_WRAP_SEARCH = "wrapSearch";
    private static final String KEY_MATCH_CASE = "matchCase";
    private static final String KEY_REGULAR_EXPRESSION = "regularExpression";
    private static final String KEY_WHOLE_WORD = "wholeWord";
    private List<String> findHistory = new ArrayList<String>();
    private List<String> replaceHistory = new ArrayList<String>();
    private Map<String, Boolean> optionsMap = new HashMap<String, Boolean>();

    public FindReplaceProperties() {
        this(null);
    }

    public FindReplaceProperties(FindReplaceProperties properties) {
        if (properties != null) {
            this.init(properties.getFindHistory(), properties.getReplaceHistory(), properties.getOptionsMap());
        } else {
            this.init(null, null, null);
        }
    }

    public FindReplaceProperties(List<String> findHistory, List<String> replaceHistory, Map<String, Boolean> optionsMap) {
        this.init(findHistory, replaceHistory, optionsMap);
    }

    private void init(List<String> findHistory, List<String> replaceHistory, Map<String, Boolean> optionsMap) {
        this.setForward(true);
        this.setWrapSearch(true);
        this.setMatchCase(false);
        this.setRegularExpression(false);
        this.setWholeWord(false);
        if (findHistory != null) {
            this.findHistory = findHistory;
        }
        if (replaceHistory != null) {
            this.replaceHistory = replaceHistory;
        }
        if (optionsMap != null) {
            this.optionsMap.putAll(optionsMap);
        }
    }

    public List<String> getFindHistory() {
        return this.findHistory;
    }

    public void setFindHistory(List<String> findHistory) {
        this.findHistory = findHistory;
    }

    public List<String> getReplaceHistory() {
        return this.replaceHistory;
    }

    public void setReplaceHistory(List<String> replaceHistory) {
        this.replaceHistory = replaceHistory;
    }

    public boolean isForward() {
        return this.getOption(KEY_FORWARD, true);
    }

    public void setForward(boolean forward) {
        this.putOption(KEY_FORWARD, forward);
    }

    public boolean isWrapSearch() {
        return this.getOption(KEY_WRAP_SEARCH, true);
    }

    public void setWrapSearch(boolean wrapSearch) {
        this.putOption(KEY_WRAP_SEARCH, wrapSearch);
    }

    public boolean isMatchCase() {
        return this.getOption(KEY_MATCH_CASE);
    }

    public void setMatchCase(boolean matchCase) {
        this.putOption(KEY_MATCH_CASE, matchCase);
    }

    public boolean isRegularExpression() {
        return this.getOption(KEY_REGULAR_EXPRESSION);
    }

    public void setRegularExpression(boolean regularExpression) {
        this.putOption(KEY_REGULAR_EXPRESSION, regularExpression);
    }

    public boolean isWholeWord() {
        return this.getOption(KEY_WHOLE_WORD);
    }

    public void setWholeWord(boolean wholeWord) {
        this.putOption(KEY_WHOLE_WORD, wholeWord);
    }

    protected Map<String, Boolean> getOptionsMap() {
        return this.optionsMap;
    }

    JsonNode toJsonNode() {
        ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
        ArrayNode findHistoryNode = rootNode.putArray("findHistory");
        for (String string : this.findHistory) {
            findHistoryNode.add(StringUtils.abbreviate((String)string, (int)40));
        }
        ArrayNode replaceHistoryNode = rootNode.putArray("replaceHistory");
        for (String element : this.replaceHistory) {
            replaceHistoryNode.add(StringUtils.abbreviate((String)element, (int)40));
        }
        ObjectNode objectNode = rootNode.putObject("options");
        for (Map.Entry<String, Boolean> entry : this.optionsMap.entrySet()) {
            objectNode.put(entry.getKey(), entry.getValue());
        }
        return rootNode;
    }

    static FindReplaceProperties fromJSON(String findReplaceJSON) {
        ArrayList<String> findHistory = new ArrayList<String>();
        ArrayList<String> replaceHistory = new ArrayList<String>();
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        if (StringUtils.isNotBlank((CharSequence)findReplaceJSON)) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode rootNode = (ObjectNode)mapper.readTree(findReplaceJSON);
                ArrayNode findHistoryNode = (ArrayNode)rootNode.get("findHistory");
                Iterator it = findHistoryNode.elements();
                while (it.hasNext()) {
                    findHistory.add(((JsonNode)it.next()).asText());
                }
                ArrayNode replaceHistoryNode = (ArrayNode)rootNode.get("replaceHistory");
                Iterator it2 = replaceHistoryNode.elements();
                while (it2.hasNext()) {
                    replaceHistory.add(((JsonNode)it2.next()).asText());
                }
                ObjectNode optionsNode = (ObjectNode)rootNode.get("options");
                Iterator it3 = optionsNode.fields();
                while (it3.hasNext()) {
                    Map.Entry entry = (Map.Entry)it3.next();
                    if (((JsonNode)entry.getValue()).isNull()) continue;
                    optionsMap.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asBoolean());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new FindReplaceProperties(findHistory, replaceHistory, optionsMap);
    }

    private boolean getOption(String key) {
        return this.getOption(key, false);
    }

    private boolean getOption(String key, boolean def) {
        return MapUtils.getBooleanValue(this.optionsMap, (Object)key, (boolean)def);
    }

    private void putOption(String key, boolean value) {
        this.optionsMap.put(key, value);
    }
}

