/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTextInterface;
import com.mirth.connect.client.ui.components.rsta.AutoCompleteProperties;
import com.mirth.connect.client.ui.components.rsta.CustomJCheckBoxMenuItem;
import com.mirth.connect.client.ui.components.rsta.CustomMenuItem;
import com.mirth.connect.client.ui.components.rsta.MirthInputMap;
import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxDocument;
import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxTextAreaUI;
import com.mirth.connect.client.ui.components.rsta.RSTAPreferences;
import com.mirth.connect.client.ui.components.rsta.ac.MirthLanguageSupport;
import com.mirth.connect.client.ui.components.rsta.actions.ActionInfo;
import com.mirth.connect.client.ui.components.rsta.actions.BeginMacroAction;
import com.mirth.connect.client.ui.components.rsta.actions.ClearMarkedOccurrencesAction;
import com.mirth.connect.client.ui.components.rsta.actions.CollapseAllCommentFoldsAction;
import com.mirth.connect.client.ui.components.rsta.actions.CollapseAllFoldsAction;
import com.mirth.connect.client.ui.components.rsta.actions.CollapseFoldAction;
import com.mirth.connect.client.ui.components.rsta.actions.CopyAction;
import com.mirth.connect.client.ui.components.rsta.actions.CutAction;
import com.mirth.connect.client.ui.components.rsta.actions.DeleteAction;
import com.mirth.connect.client.ui.components.rsta.actions.DeleteLineAction;
import com.mirth.connect.client.ui.components.rsta.actions.DeleteRestOfLineAction;
import com.mirth.connect.client.ui.components.rsta.actions.DocumentEndAction;
import com.mirth.connect.client.ui.components.rsta.actions.DocumentStartAction;
import com.mirth.connect.client.ui.components.rsta.actions.EndMacroAction;
import com.mirth.connect.client.ui.components.rsta.actions.ExpandAllFoldsAction;
import com.mirth.connect.client.ui.components.rsta.actions.ExpandFoldAction;
import com.mirth.connect.client.ui.components.rsta.actions.FindNextAction;
import com.mirth.connect.client.ui.components.rsta.actions.FindReplaceAction;
import com.mirth.connect.client.ui.components.rsta.actions.GoToMatchingBracketAction;
import com.mirth.connect.client.ui.components.rsta.actions.HorizontalPageAction;
import com.mirth.connect.client.ui.components.rsta.actions.InsertBreakAction;
import com.mirth.connect.client.ui.components.rsta.actions.JoinLineAction;
import com.mirth.connect.client.ui.components.rsta.actions.LineEndAction;
import com.mirth.connect.client.ui.components.rsta.actions.LineStartAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveDownAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveLeftAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveLeftWordAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveLineAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveRightAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveRightWordAction;
import com.mirth.connect.client.ui.components.rsta.actions.MoveUpAction;
import com.mirth.connect.client.ui.components.rsta.actions.PageDownAction;
import com.mirth.connect.client.ui.components.rsta.actions.PageUpAction;
import com.mirth.connect.client.ui.components.rsta.actions.PasteAction;
import com.mirth.connect.client.ui.components.rsta.actions.PlaybackMacroAction;
import com.mirth.connect.client.ui.components.rsta.actions.RedoAction;
import com.mirth.connect.client.ui.components.rsta.actions.ScrollAction;
import com.mirth.connect.client.ui.components.rsta.actions.SelectAllAction;
import com.mirth.connect.client.ui.components.rsta.actions.ShowLineEndingsAction;
import com.mirth.connect.client.ui.components.rsta.actions.ShowTabLinesAction;
import com.mirth.connect.client.ui.components.rsta.actions.ShowWhitespaceAction;
import com.mirth.connect.client.ui.components.rsta.actions.ToggleCommentAction;
import com.mirth.connect.client.ui.components.rsta.actions.UndoAction;
import com.mirth.connect.client.ui.components.rsta.actions.ViewUserAPIAction;
import com.mirth.connect.client.ui.components.rsta.actions.WrapLinesAction;
import com.mirth.connect.model.codetemplates.ContextType;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.LanguageAwareCompletionProvider;
import org.fife.ui.rsyntaxtextarea.EOLPreservingRSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rtextarea.RTextAreaUI;

public class MirthRSyntaxTextArea
extends RSyntaxTextArea
implements MirthTextInterface {
    private static final String PREFERENCES_KEYSTROKES = "rstaPreferencesKeyStrokes";
    private static final String PREFERENCES_FIND_REPLACE = "rstaPreferencesFindReplace";
    private static final String PREFERENCES_TOGGLE_OPTIONS = "rstaPreferencesToggleOptions";
    private static final String PREFERENCES_AUTO_COMPLETE = "rstaPreferencesAutoComplete";
    private static RSTAPreferences rstaPreferences;
    private static ResourceBundle resourceBundle;
    private ContextType contextType;
    private boolean saveEnabled = true;
    private String cachedStyleKey;
    private Action[] actions;
    private CustomMenuItem undoMenuItem;
    private CustomMenuItem redoMenuItem;
    private CustomMenuItem cutMenuItem;
    private CustomMenuItem copyMenuItem;
    private CustomMenuItem pasteMenuItem;
    private CustomMenuItem deleteMenuItem;
    private CustomMenuItem selectAllMenuItem;
    private CustomMenuItem findReplaceMenuItem;
    private CustomMenuItem findNextMenuItem;
    private CustomMenuItem clearMarkedOccurrencesMenuItem;
    private JMenu foldingMenu;
    private CustomMenuItem collapseFoldMenuItem;
    private CustomMenuItem expandFoldMenuItem;
    private CustomMenuItem collapseAllFoldsMenuItem;
    private CustomMenuItem collapseAllCommentFoldsMenuItem;
    private CustomMenuItem expandAllFoldsMenuItem;
    private JMenu displayMenu;
    private CustomJCheckBoxMenuItem showTabLinesMenuItem;
    private CustomJCheckBoxMenuItem showWhitespaceMenuItem;
    private CustomJCheckBoxMenuItem showLineEndingsMenuItem;
    private CustomJCheckBoxMenuItem wrapLinesMenuItem;
    private JMenu macroMenu;
    private CustomMenuItem beginMacroMenuItem;
    private CustomMenuItem endMacroMenuItem;
    private CustomMenuItem playbackMacroMenuItem;
    private CustomMenuItem viewUserAPIMenuItem;

    public MirthRSyntaxTextArea() {
        this(null);
    }

    public MirthRSyntaxTextArea(ContextType contextType) {
        this(contextType, "text/javascript");
    }

    public MirthRSyntaxTextArea(ContextType contextType, String styleKey) {
        this(contextType, styleKey, true);
    }

    public MirthRSyntaxTextArea(ContextType contextType, String styleKey, boolean autoCompleteEnabled) {
        super((RSyntaxDocument)new MirthRSyntaxDocument(styleKey));
        this.contextType = contextType;
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setSyntaxEditingStyle(styleKey);
        this.setCodeFoldingEnabled(true);
        this.setAntiAliasingEnabled(true);
        this.setWrapStyleWord(true);
        this.setAutoIndentEnabled(true);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChange();
            }

            private void onChange() {
                if (MirthRSyntaxTextArea.this.saveEnabled) {
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (MirthRSyntaxTextArea.this.saveEnabled) {
                    boolean isAccelerated;
                    boolean bl = isAccelerated = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 || (e.getModifiers() & 2) > 0;
                    if (e.getKeyCode() == 83 && isAccelerated) {
                        PlatformUI.MIRTH_FRAME.doContextSensitiveSave();
                    }
                }
            }
        });
        this.undoMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new UndoAction()), ActionInfo.UNDO);
        this.redoMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new RedoAction()), ActionInfo.REDO);
        this.cutMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new CutAction(this)), ActionInfo.CUT);
        this.copyMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new CopyAction(this)), ActionInfo.COPY);
        this.pasteMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new PasteAction()), ActionInfo.PASTE);
        this.deleteMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new DeleteAction()), ActionInfo.DELETE);
        this.selectAllMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new SelectAllAction()), ActionInfo.SELECT_ALL);
        this.findReplaceMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new FindReplaceAction(this)), ActionInfo.FIND_REPLACE);
        this.findNextMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new FindNextAction(this)), ActionInfo.FIND_NEXT);
        this.clearMarkedOccurrencesMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new ClearMarkedOccurrencesAction(this)), ActionInfo.CLEAR_MARKED_OCCURRENCES);
        this.foldingMenu = new JMenu("Folding");
        this.collapseFoldMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new CollapseFoldAction()), ActionInfo.FOLD_COLLAPSE);
        this.expandFoldMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new ExpandFoldAction()), ActionInfo.FOLD_EXPAND);
        this.collapseAllFoldsMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new CollapseAllFoldsAction()), ActionInfo.FOLD_COLLAPSE_ALL);
        this.collapseAllCommentFoldsMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new CollapseAllCommentFoldsAction()), ActionInfo.FOLD_COLLAPSE_ALL_COMMENTS);
        this.expandAllFoldsMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new ExpandAllFoldsAction()), ActionInfo.FOLD_EXPAND_ALL);
        this.displayMenu = new JMenu("Display");
        this.showTabLinesMenuItem = new CustomJCheckBoxMenuItem((JComponent)((Object)this), (Action)((Object)new ShowTabLinesAction(this)), ActionInfo.DISPLAY_SHOW_TAB_LINES);
        this.showWhitespaceMenuItem = new CustomJCheckBoxMenuItem((JComponent)((Object)this), (Action)((Object)new ShowWhitespaceAction(this)), ActionInfo.DISPLAY_SHOW_WHITESPACE);
        this.showLineEndingsMenuItem = new CustomJCheckBoxMenuItem((JComponent)((Object)this), (Action)((Object)new ShowLineEndingsAction(this)), ActionInfo.DISPLAY_SHOW_LINE_ENDINGS);
        this.wrapLinesMenuItem = new CustomJCheckBoxMenuItem((JComponent)((Object)this), (Action)((Object)new WrapLinesAction(this)), ActionInfo.DISPLAY_WRAP_LINES);
        this.macroMenu = new JMenu("Macro");
        this.beginMacroMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new BeginMacroAction()), ActionInfo.MACRO_BEGIN);
        this.endMacroMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new EndMacroAction()), ActionInfo.MACRO_END);
        this.playbackMacroMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new PlaybackMacroAction()), ActionInfo.MACRO_PLAYBACK);
        this.viewUserAPIMenuItem = new CustomMenuItem((JComponent)((Object)this), (Action)((Object)new ViewUserAPIAction(this)), ActionInfo.VIEW_USER_API);
        this.getActionMap().put(ActionInfo.DELETE_REST_OF_LINE.getActionMapKey(), (Action)((Object)new DeleteRestOfLineAction()));
        this.getActionMap().put(ActionInfo.DELETE_LINE.getActionMapKey(), (Action)((Object)new DeleteLineAction()));
        this.getActionMap().put(ActionInfo.JOIN_LINE.getActionMapKey(), (Action)((Object)new JoinLineAction()));
        this.getActionMap().put(ActionInfo.GO_TO_MATCHING_BRACKET.getActionMapKey(), (Action)((Object)new GoToMatchingBracketAction()));
        this.getActionMap().put(ActionInfo.TOGGLE_COMMENT.getActionMapKey(), (Action)((Object)new ToggleCommentAction()));
        this.getActionMap().put(ActionInfo.DOCUMENT_START.getActionMapKey(), (Action)((Object)new DocumentStartAction(false)));
        this.getActionMap().put(ActionInfo.DOCUMENT_SELECT_START.getActionMapKey(), (Action)((Object)new DocumentStartAction(true)));
        this.getActionMap().put(ActionInfo.DOCUMENT_END.getActionMapKey(), (Action)((Object)new DocumentEndAction(false)));
        this.getActionMap().put(ActionInfo.DOCUMENT_SELECT_END.getActionMapKey(), (Action)((Object)new DocumentEndAction(true)));
        this.getActionMap().put(ActionInfo.LINE_START.getActionMapKey(), (Action)((Object)new LineStartAction(false)));
        this.getActionMap().put(ActionInfo.LINE_SELECT_START.getActionMapKey(), (Action)((Object)new LineStartAction(true)));
        this.getActionMap().put(ActionInfo.LINE_END.getActionMapKey(), (Action)((Object)new LineEndAction(false)));
        this.getActionMap().put(ActionInfo.LINE_SELECT_END.getActionMapKey(), (Action)((Object)new LineEndAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_LEFT.getActionMapKey(), (Action)((Object)new MoveLeftAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_LEFT_SELECT.getActionMapKey(), (Action)((Object)new MoveLeftAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_LEFT_WORD.getActionMapKey(), (Action)((Object)new MoveLeftWordAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_LEFT_WORD_SELECT.getActionMapKey(), (Action)((Object)new MoveLeftWordAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_RIGHT.getActionMapKey(), (Action)((Object)new MoveRightAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_RIGHT_SELECT.getActionMapKey(), (Action)((Object)new MoveRightAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_RIGHT_WORD.getActionMapKey(), (Action)((Object)new MoveRightWordAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_RIGHT_WORD_SELECT.getActionMapKey(), (Action)((Object)new MoveRightWordAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_UP.getActionMapKey(), (Action)((Object)new MoveUpAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_UP_SELECT.getActionMapKey(), (Action)((Object)new MoveUpAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_UP_SCROLL.getActionMapKey(), (Action)((Object)new ScrollAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_UP_LINE.getActionMapKey(), (Action)((Object)new MoveLineAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_DOWN.getActionMapKey(), (Action)((Object)new MoveDownAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_DOWN_SELECT.getActionMapKey(), (Action)((Object)new MoveDownAction(true)));
        this.getActionMap().put(ActionInfo.MOVE_DOWN_SCROLL.getActionMapKey(), (Action)((Object)new ScrollAction(false)));
        this.getActionMap().put(ActionInfo.MOVE_DOWN_LINE.getActionMapKey(), (Action)((Object)new MoveLineAction(false)));
        this.getActionMap().put(ActionInfo.PAGE_UP.getActionMapKey(), (Action)((Object)new PageUpAction(false)));
        this.getActionMap().put(ActionInfo.PAGE_UP_SELECT.getActionMapKey(), (Action)((Object)new PageUpAction(true)));
        this.getActionMap().put(ActionInfo.PAGE_LEFT_SELECT.getActionMapKey(), (Action)((Object)new HorizontalPageAction(this, true)));
        this.getActionMap().put(ActionInfo.PAGE_DOWN.getActionMapKey(), (Action)((Object)new PageDownAction(false)));
        this.getActionMap().put(ActionInfo.PAGE_DOWN_SELECT.getActionMapKey(), (Action)((Object)new PageDownAction(true)));
        this.getActionMap().put(ActionInfo.PAGE_RIGHT_SELECT.getActionMapKey(), (Action)((Object)new HorizontalPageAction(this, false)));
        this.getActionMap().put(ActionInfo.INSERT_LF_BREAK.getActionMapKey(), (Action)((Object)new InsertBreakAction("\n")));
        this.getActionMap().put(ActionInfo.INSERT_CR_BREAK.getActionMapKey(), (Action)((Object)new InsertBreakAction("\r")));
        ArrayList<Action> actionList = new ArrayList<Action>();
        for (Object key : this.getActionMap().allKeys()) {
            actionList.add(this.getActionMap().get(key));
        }
        this.actions = actionList.toArray(new Action[actionList.size()]);
        if (autoCompleteEnabled) {
            LanguageSupportFactory.get().register((RSyntaxTextArea)this);
            this.getInputMap().remove(AutoCompletion.getDefaultTriggerKey());
        }
    }

    public static RSTAPreferences getRSTAPreferences() {
        return rstaPreferences;
    }

    public static void updateKeyStrokePreferences() {
        MirthRSyntaxTextArea.updateKeyStrokePreferences(Preferences.userNodeForPackage(Mirth.class));
    }

    public static void updateKeyStrokePreferences(Preferences userPreferences) {
        MirthInputMap.getInstance().update(rstaPreferences.getKeyStrokeMap());
        userPreferences.put(PREFERENCES_KEYSTROKES, rstaPreferences.getKeyStrokesJSON());
    }

    public static void updateFindReplacePreferences() {
        MirthRSyntaxTextArea.updateFindReplacePreferences(Preferences.userNodeForPackage(Mirth.class));
    }

    public static void updateFindReplacePreferences(Preferences userPreferences) {
        userPreferences.put(PREFERENCES_FIND_REPLACE, rstaPreferences.getFindReplaceJSON());
    }

    public static void updateToggleOptionPreferences() {
        MirthRSyntaxTextArea.updateToggleOptionPreferences(Preferences.userNodeForPackage(Mirth.class));
    }

    public static void updateToggleOptionPreferences(Preferences userPreferences) {
        userPreferences.put(PREFERENCES_TOGGLE_OPTIONS, rstaPreferences.getToggleOptionsJSON());
    }

    public static void updateAutoCompletePreferences() {
        MirthRSyntaxTextArea.updateAutoCompletePreferences(Preferences.userNodeForPackage(Mirth.class));
    }

    public static void updateAutoCompletePreferences(Preferences userPreferences) {
        userPreferences.put(PREFERENCES_AUTO_COMPLETE, rstaPreferences.getAutoCompleteJSON());
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public ContextType getContextType() {
        return this.contextType;
    }

    public void setContextType(ContextType contextType) {
        this.contextType = contextType;
    }

    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    public void setSaveEnabled(boolean saveEnabled) {
        this.saveEnabled = saveEnabled;
    }

    public String getEOLFixedText() {
        if (this.getDocument() instanceof EOLPreservingRSyntaxDocument) {
            try {
                return ((EOLPreservingRSyntaxDocument)((Object)this.getDocument())).getEOLFixedText(0, this.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.getText();
    }

    public String getEOLFixedSelectedText() {
        int p1;
        String txt = null;
        int p0 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        if (p0 != (p1 = Math.max(this.getCaret().getDot(), this.getCaret().getMark()))) {
            try {
                MirthRSyntaxDocument doc = (MirthRSyntaxDocument)((Object)this.getDocument());
                txt = doc.getEOLFixedText(p0, p1 - p0);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return txt;
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean discardEdits) {
        boolean visible = PlatformUI.MIRTH_FRAME.changesHaveBeenMade();
        super.setText(text);
        this.setCaretPosition(0);
        if (discardEdits) {
            this.discardAllEdits();
        }
        if (visible) {
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        } else {
            PlatformUI.MIRTH_FRAME.setSaveEnabled(false);
        }
        if (!this.isEnabled()) {
            this.setBracketMatchingEnabled(false);
            super.setSyntaxEditingStyle("text/plain");
        }
        this.updateDisplayOptions();
    }

    public void updateDisplayOptions() {
        AutoCompletion autoCompletion;
        this.showTabLinesMenuItem.setSelected(BooleanUtils.toBoolean((Boolean)rstaPreferences.getToggleOptions().get(ActionInfo.DISPLAY_SHOW_TAB_LINES.getActionMapKey())));
        this.showWhitespaceMenuItem.setSelected(BooleanUtils.toBoolean((Boolean)rstaPreferences.getToggleOptions().get(ActionInfo.DISPLAY_SHOW_WHITESPACE.getActionMapKey())));
        this.showLineEndingsMenuItem.setSelected(BooleanUtils.toBoolean((Boolean)rstaPreferences.getToggleOptions().get(ActionInfo.DISPLAY_SHOW_LINE_ENDINGS.getActionMapKey())));
        this.wrapLinesMenuItem.setSelected(BooleanUtils.toBoolean((Boolean)rstaPreferences.getToggleOptions().get(ActionInfo.DISPLAY_WRAP_LINES.getActionMapKey())));
        LanguageSupport languageSupport = LanguageSupportFactory.get().getSupportFor(this.getSyntaxEditingStyle());
        if (languageSupport != null && languageSupport instanceof MirthLanguageSupport && (autoCompletion = ((MirthLanguageSupport)languageSupport).getAutoCompletionFor(this)) != null) {
            LanguageAwareCompletionProvider provider = (LanguageAwareCompletionProvider)autoCompletion.getCompletionProvider();
            AutoCompleteProperties autoCompleteProperties = rstaPreferences.getAutoCompleteProperties();
            autoCompletion.setAutoActivationDelay(autoCompleteProperties.getActivationDelay());
            this.setAutoActivationRules((CompletionProvider)provider, autoCompleteProperties.isActivateAfterLetters(), autoCompleteProperties.getActivateAfterOthers());
        }
    }

    private void setAutoActivationRules(CompletionProvider provider, boolean letters, String others) {
        if (provider != null) {
            if (provider instanceof CompletionProviderBase) {
                ((CompletionProviderBase)provider).setAutoActivationRules(letters, others);
            }
            if (provider instanceof LanguageAwareCompletionProvider) {
                LanguageAwareCompletionProvider langProvider = (LanguageAwareCompletionProvider)provider;
                this.setAutoActivationRules(langProvider.getDefaultCompletionProvider(), letters, others);
                this.setAutoActivationRules(langProvider.getStringCompletionProvider(), letters, others);
                this.setAutoActivationRules(langProvider.getCommentCompletionProvider(), letters, others);
                this.setAutoActivationRules(langProvider.getDocCommentCompletionProvider(), letters, others);
            }
        }
    }

    public void setSelectedText(String text) {
        this.replaceSelection(text);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setForeground(UIManager.getColor(enabled ? "Label.foreground" : "Label.disabledForeground"));
        this.setHighlightCurrentLine(enabled);
        this.setBracketMatchingEnabled(enabled);
        if (enabled) {
            if (this.cachedStyleKey != null) {
                super.setSyntaxEditingStyle(this.cachedStyleKey);
            }
        } else {
            super.setSyntaxEditingStyle("text/plain");
        }
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new MirthRSyntaxTextAreaUI((JComponent)((Object)this));
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.undoMenuItem);
        menu.add(this.redoMenuItem);
        menu.addSeparator();
        menu.add(this.cutMenuItem);
        menu.add(this.copyMenuItem);
        menu.add(this.pasteMenuItem);
        menu.add(this.deleteMenuItem);
        menu.addSeparator();
        menu.add(this.selectAllMenuItem);
        menu.add(this.findReplaceMenuItem);
        menu.add(this.findNextMenuItem);
        menu.add(this.clearMarkedOccurrencesMenuItem);
        menu.addSeparator();
        this.foldingMenu.add(this.collapseFoldMenuItem);
        this.foldingMenu.add(this.expandFoldMenuItem);
        this.foldingMenu.add(this.collapseAllFoldsMenuItem);
        this.foldingMenu.add(this.collapseAllCommentFoldsMenuItem);
        this.foldingMenu.add(this.expandAllFoldsMenuItem);
        menu.add(this.foldingMenu);
        menu.addSeparator();
        this.displayMenu.add(this.showTabLinesMenuItem);
        this.displayMenu.add(this.showWhitespaceMenuItem);
        this.displayMenu.add(this.showLineEndingsMenuItem);
        this.displayMenu.add(this.wrapLinesMenuItem);
        menu.add(this.displayMenu);
        menu.addSeparator();
        this.macroMenu.add(this.beginMacroMenuItem);
        this.macroMenu.add(this.endMacroMenuItem);
        this.macroMenu.add(this.playbackMacroMenuItem);
        menu.add(this.macroMenu);
        menu.addSeparator();
        menu.add(this.viewUserAPIMenuItem);
        return menu;
    }

    protected void configurePopupMenu(JPopupMenu popupMenu) {
        if (popupMenu != null) {
            boolean canType = this.isEditable() && this.isEnabled();
            this.undoMenuItem.setEnabled(this.undoMenuItem.getAction().isEnabled() && canType && this.canUndo());
            this.redoMenuItem.setEnabled(this.redoMenuItem.getAction().isEnabled() && canType && this.canRedo());
            this.cutMenuItem.setEnabled(this.cutMenuItem.getAction().isEnabled() && canType);
            this.copyMenuItem.setEnabled(this.copyMenuItem.getAction().isEnabled() && canType);
            this.pasteMenuItem.setEnabled(this.pasteMenuItem.getAction().isEnabled() && canType);
            this.deleteMenuItem.setEnabled(this.deleteMenuItem.getAction().isEnabled() && canType);
            this.findNextMenuItem.setEnabled(this.findNextMenuItem.getAction().isEnabled() && CollectionUtils.isNotEmpty(rstaPreferences.getFindReplaceProperties().getFindHistory()));
            this.clearMarkedOccurrencesMenuItem.setEnabled(this.clearMarkedOccurrencesMenuItem.getAction().isEnabled() && canType && ((RSyntaxTextAreaHighlighter)this.getHighlighter()).getMarkAllHighlightCount() > 0);
            this.foldingMenu.setEnabled(this.getFoldManager().isCodeFoldingSupportedAndEnabled());
            this.beginMacroMenuItem.setEnabled(!MirthRSyntaxTextArea.isRecordingMacro());
            this.endMacroMenuItem.setEnabled(MirthRSyntaxTextArea.isRecordingMacro());
            this.playbackMacroMenuItem.setEnabled(!MirthRSyntaxTextArea.isRecordingMacro() && MirthRSyntaxTextArea.getCurrentMacro() != null);
            this.undoMenuItem.updateAccelerator();
            this.redoMenuItem.updateAccelerator();
            this.cutMenuItem.updateAccelerator();
            this.copyMenuItem.updateAccelerator();
            this.pasteMenuItem.updateAccelerator();
            this.deleteMenuItem.updateAccelerator();
            this.selectAllMenuItem.updateAccelerator();
            this.findReplaceMenuItem.updateAccelerator();
            this.findNextMenuItem.updateAccelerator();
            this.clearMarkedOccurrencesMenuItem.updateAccelerator();
            this.collapseFoldMenuItem.updateAccelerator();
            this.expandFoldMenuItem.updateAccelerator();
            this.collapseAllFoldsMenuItem.updateAccelerator();
            this.collapseAllCommentFoldsMenuItem.updateAccelerator();
            this.expandAllFoldsMenuItem.updateAccelerator();
            this.beginMacroMenuItem.updateAccelerator();
            this.endMacroMenuItem.updateAccelerator();
            this.playbackMacroMenuItem.updateAccelerator();
            this.viewUserAPIMenuItem.updateAccelerator();
        }
    }

    public void setSyntaxEditingStyle(String styleKey) {
        super.setSyntaxEditingStyle(styleKey);
        this.cachedStyleKey = styleKey;
    }

    public Action[] getActions() {
        return this.actions != null ? this.actions : this.getUI().getEditorKit((JTextComponent)((Object)this)).getActions();
    }

    static {
        resourceBundle = ResourceBundle.getBundle(MirthRSyntaxTextArea.class.getName());
        Preferences userPreferences = Preferences.userNodeForPackage(Mirth.class);
        String keyStrokesJSON = userPreferences.get(PREFERENCES_KEYSTROKES, null);
        String findReplaceJSON = userPreferences.get(PREFERENCES_FIND_REPLACE, null);
        String toggleOptionsJSON = userPreferences.get(PREFERENCES_TOGGLE_OPTIONS, null);
        String autoCompleteJSON = userPreferences.get(PREFERENCES_AUTO_COMPLETE, null);
        rstaPreferences = RSTAPreferences.fromJSON(keyStrokesJSON, findReplaceJSON, toggleOptionsJSON, autoCompleteJSON);
        MirthRSyntaxTextArea.updateKeyStrokePreferences(userPreferences);
        MirthRSyntaxTextArea.updateFindReplacePreferences(userPreferences);
        MirthRSyntaxTextArea.updateToggleOptionPreferences(userPreferences);
        MirthRSyntaxTextArea.updateAutoCompletePreferences(userPreferences);
    }
}

