/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mirth.connect.client.ui.components.rsta.AutoCompleteProperties;
import com.mirth.connect.client.ui.components.rsta.FindReplaceProperties;
import com.mirth.connect.client.ui.components.rsta.actions.ActionInfo;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rtextarea.RTextArea;

public class RSTAPreferences {
    private Map<String, KeyStroke> keyStrokeMap;
    private FindReplaceProperties findReplaceProperties;
    private Map<String, Boolean> toggleOptions;
    private AutoCompleteProperties autoCompleteProperties;

    public RSTAPreferences() {
        this(null, null, null, null);
    }

    public RSTAPreferences(Map<String, KeyStroke> keyStrokeMap, FindReplaceProperties findReplaceProperties, Map<String, Boolean> toggleOptions, AutoCompleteProperties autoCompleteProperties) {
        this.setDefaultKeyStrokeMap();
        this.setDefaultFindReplaceProperties();
        this.setDefaultToggleOptions();
        this.setDefaultAutoCompleteProperties();
        if (keyStrokeMap != null) {
            this.keyStrokeMap.putAll(keyStrokeMap);
        }
        if (findReplaceProperties != null) {
            this.findReplaceProperties = new FindReplaceProperties(findReplaceProperties);
        }
        if (toggleOptions != null) {
            this.toggleOptions.putAll(toggleOptions);
        }
        if (autoCompleteProperties != null) {
            this.autoCompleteProperties = new AutoCompleteProperties(autoCompleteProperties);
        }
    }

    public Map<String, KeyStroke> getKeyStrokeMap() {
        this.check();
        return this.keyStrokeMap;
    }

    public void setKeyStrokeMap(Map<String, KeyStroke> keyStrokeMap) {
        this.keyStrokeMap = keyStrokeMap;
    }

    public FindReplaceProperties getFindReplaceProperties() {
        this.check();
        return this.findReplaceProperties;
    }

    public void setFindReplaceProperties(FindReplaceProperties findReplaceProperties) {
        this.findReplaceProperties = findReplaceProperties;
    }

    public Map<String, Boolean> getToggleOptions() {
        this.check();
        return this.toggleOptions;
    }

    public void setToggleOptions(Map<String, Boolean> toggleOptions) {
        this.toggleOptions = toggleOptions;
    }

    public AutoCompleteProperties getAutoCompleteProperties() {
        this.check();
        return this.autoCompleteProperties;
    }

    public void setAutoCompleteProperties(AutoCompleteProperties autoCompleteProperties) {
        this.autoCompleteProperties = autoCompleteProperties;
    }

    String getKeyStrokesJSON() {
        ObjectNode keyStrokesNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, KeyStroke> entry : this.getKeyStrokeMap().entrySet()) {
            if (entry.getValue() != null) {
                ArrayNode arrayNode = keyStrokesNode.putArray(entry.getKey());
                arrayNode.add(entry.getValue().getKeyCode());
                arrayNode.add(entry.getValue().getModifiers());
                continue;
            }
            keyStrokesNode.putNull(entry.getKey());
        }
        return keyStrokesNode.toString();
    }

    String getFindReplaceJSON() {
        return this.getFindReplaceProperties().toJsonNode().toString();
    }

    String getToggleOptionsJSON() {
        ObjectNode toggleOptionsNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, Boolean> entry : this.getToggleOptions().entrySet()) {
            toggleOptionsNode.put(entry.getKey(), entry.getValue());
        }
        return toggleOptionsNode.toString();
    }

    String getAutoCompleteJSON() {
        return this.getAutoCompleteProperties().toJsonNode().toString();
    }

    static RSTAPreferences fromJSON(String keyStrokesJSON, String findReplaceJSON, String toggleOptionsJSON, String autoCompleteJSON) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, KeyStroke> keyStrokeMap = new HashMap<String, KeyStroke>();
        if (StringUtils.isNotBlank((CharSequence)keyStrokesJSON)) {
            try {
                ObjectNode keyStrokesNode = (ObjectNode)mapper.readTree(keyStrokesJSON);
                Iterator it = keyStrokesNode.fields();
                while (it.hasNext()) {
                    ArrayNode arrayNode;
                    Map.Entry entry = (Map.Entry)it.next();
                    KeyStroke keyStroke = null;
                    if (!((JsonNode)entry.getValue()).isNull() && (arrayNode = (ArrayNode)entry.getValue()).size() > 1) {
                        keyStroke = KeyStroke.getKeyStroke(arrayNode.get(0).asInt(), arrayNode.get(1).asInt());
                    }
                    keyStrokeMap.put((String)entry.getKey(), keyStroke);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FindReplaceProperties findReplaceProperties = FindReplaceProperties.fromJSON(findReplaceJSON);
        HashMap<String, Boolean> toggleOptions = new HashMap<String, Boolean>();
        if (StringUtils.isNotBlank((CharSequence)toggleOptionsJSON)) {
            try {
                ObjectNode toggleOptionsNode = (ObjectNode)mapper.readTree(toggleOptionsJSON);
                Iterator it = toggleOptionsNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    if (((JsonNode)entry.getValue()).isNull()) continue;
                    toggleOptions.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asBoolean());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AutoCompleteProperties autoCompleteProperties = AutoCompleteProperties.fromJSON(autoCompleteJSON);
        return new RSTAPreferences(keyStrokeMap, findReplaceProperties, toggleOptions, autoCompleteProperties);
    }

    private void check() {
        if (this.keyStrokeMap == null) {
            this.setDefaultKeyStrokeMap();
        }
        if (this.findReplaceProperties == null) {
            this.setDefaultFindReplaceProperties();
        }
        if (this.toggleOptions == null) {
            this.setDefaultToggleOptions();
        }
        if (this.autoCompleteProperties == null) {
            this.setDefaultAutoCompleteProperties();
        }
    }

    private void setDefaultKeyStrokeMap() {
        this.keyStrokeMap = new HashMap<String, KeyStroke>();
        boolean isOSX = RTextArea.isOSX();
        int defaultModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        int ctrl = 2;
        int alt = 8;
        int shift = 1;
        int defaultShift = defaultModifier | shift;
        int moveByWordMod = isOSX ? alt : defaultModifier;
        int moveByWordModShift = moveByWordMod | shift;
        this.putKeyStroke(ActionInfo.UNDO, 90, defaultModifier);
        if (isOSX) {
            this.putKeyStroke(ActionInfo.REDO, 90, defaultShift);
        } else {
            this.putKeyStroke(ActionInfo.REDO, 89, defaultModifier);
        }
        this.putKeyStroke(ActionInfo.CUT, 88, defaultModifier);
        this.putKeyStroke(ActionInfo.COPY, 67, defaultModifier);
        this.putKeyStroke(ActionInfo.PASTE, 86, defaultModifier);
        this.putKeyStroke(ActionInfo.DELETE, 127, 0);
        this.putKeyStroke(ActionInfo.DELETE_REST_OF_LINE, 127, defaultModifier);
        this.putKeyStroke(ActionInfo.DELETE_LINE, 68, defaultModifier);
        this.putKeyStroke(ActionInfo.JOIN_LINE, 74, defaultModifier);
        this.putKeyStroke(ActionInfo.SELECT_ALL, 65, defaultModifier);
        this.putKeyStroke(ActionInfo.FIND_REPLACE, 70, defaultModifier);
        this.putKeyStroke(ActionInfo.FIND_NEXT, 71, defaultModifier);
        this.putKeyStroke(ActionInfo.CLEAR_MARKED_OCCURRENCES, 27, 0);
        this.putKeyStroke(ActionInfo.FOLD_COLLAPSE, 109, defaultModifier);
        this.putKeyStroke(ActionInfo.FOLD_EXPAND, 107, defaultModifier);
        this.putKeyStroke(ActionInfo.FOLD_COLLAPSE_ALL, 111, defaultModifier);
        this.putKeyStroke(ActionInfo.FOLD_COLLAPSE_ALL_COMMENTS, 111, defaultShift);
        this.putKeyStroke(ActionInfo.FOLD_EXPAND_ALL, 106, defaultModifier);
        this.putKeyStroke(ActionInfo.GO_TO_MATCHING_BRACKET, 91, defaultModifier);
        this.putKeyStroke(ActionInfo.TOGGLE_COMMENT, 47, defaultModifier);
        this.putKeyStroke(ActionInfo.AUTO_COMPLETE, 32, ctrl);
        if (isOSX) {
            this.putKeyStroke(ActionInfo.DOCUMENT_START, 36, 0);
            this.putKeyStroke(ActionInfo.DOCUMENT_END, 35, 0);
            this.putKeyStroke(ActionInfo.DOCUMENT_SELECT_START, 36, shift);
            this.putKeyStroke(ActionInfo.DOCUMENT_SELECT_END, 35, shift);
            this.putKeyStroke(ActionInfo.LINE_START, 37, defaultModifier);
            this.putKeyStroke(ActionInfo.LINE_END, 39, defaultModifier);
            this.putKeyStroke(ActionInfo.LINE_SELECT_START, 37, defaultShift);
            this.putKeyStroke(ActionInfo.LINE_SELECT_END, 39, defaultShift);
        } else {
            this.putKeyStroke(ActionInfo.DOCUMENT_START, 36, defaultModifier);
            this.putKeyStroke(ActionInfo.DOCUMENT_END, 35, defaultModifier);
            this.putKeyStroke(ActionInfo.DOCUMENT_SELECT_START, 36, defaultShift);
            this.putKeyStroke(ActionInfo.DOCUMENT_SELECT_END, 35, defaultShift);
            this.putKeyStroke(ActionInfo.LINE_START, 36, 0);
            this.putKeyStroke(ActionInfo.LINE_END, 35, 0);
            this.putKeyStroke(ActionInfo.LINE_SELECT_START, 36, shift);
            this.putKeyStroke(ActionInfo.LINE_SELECT_END, 35, shift);
        }
        this.putKeyStroke(ActionInfo.MOVE_LEFT, 37, 0);
        this.putKeyStroke(ActionInfo.MOVE_LEFT_SELECT, 37, shift);
        this.putKeyStroke(ActionInfo.MOVE_LEFT_WORD, 37, moveByWordMod);
        this.putKeyStroke(ActionInfo.MOVE_LEFT_WORD_SELECT, 37, moveByWordModShift);
        this.putKeyStroke(ActionInfo.MOVE_RIGHT, 39, 0);
        this.putKeyStroke(ActionInfo.MOVE_RIGHT_SELECT, 39, shift);
        this.putKeyStroke(ActionInfo.MOVE_RIGHT_WORD, 39, moveByWordMod);
        this.putKeyStroke(ActionInfo.MOVE_RIGHT_WORD_SELECT, 39, moveByWordModShift);
        this.putKeyStroke(ActionInfo.MOVE_UP, 38, 0);
        this.putKeyStroke(ActionInfo.MOVE_UP_SELECT, 38, shift);
        this.putKeyStroke(ActionInfo.MOVE_UP_SCROLL, 38, defaultModifier);
        this.putKeyStroke(ActionInfo.MOVE_UP_LINE, 38, alt);
        this.putKeyStroke(ActionInfo.MOVE_DOWN, 40, 0);
        this.putKeyStroke(ActionInfo.MOVE_DOWN_SELECT, 40, shift);
        this.putKeyStroke(ActionInfo.MOVE_DOWN_SCROLL, 40, defaultModifier);
        this.putKeyStroke(ActionInfo.MOVE_DOWN_LINE, 40, alt);
        this.putKeyStroke(ActionInfo.PAGE_UP, 33, 0);
        this.putKeyStroke(ActionInfo.PAGE_UP_SELECT, 33, shift);
        this.putKeyStroke(ActionInfo.PAGE_LEFT_SELECT, 33, defaultShift);
        this.putKeyStroke(ActionInfo.PAGE_DOWN, 34, 0);
        this.putKeyStroke(ActionInfo.PAGE_DOWN_SELECT, 34, shift);
        this.putKeyStroke(ActionInfo.PAGE_RIGHT_SELECT, 34, defaultShift);
        this.putKeyStroke(ActionInfo.INSERT_LF_BREAK, 10, 0);
        this.putKeyStroke(ActionInfo.INSERT_CR_BREAK, 10, shift);
        this.putKeyStroke(ActionInfo.MACRO_BEGIN, 66, defaultShift);
        this.putKeyStroke(ActionInfo.MACRO_END, 78, defaultShift);
        this.putKeyStroke(ActionInfo.MACRO_PLAYBACK, 77, defaultShift);
    }

    private void putKeyStroke(ActionInfo actionInfo, int keyCode, int modifiers) {
        this.keyStrokeMap.put(actionInfo.getActionMapKey(), KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    private void setDefaultFindReplaceProperties() {
        this.findReplaceProperties = new FindReplaceProperties();
    }

    private void setDefaultToggleOptions() {
        this.toggleOptions = new HashMap<String, Boolean>();
        this.toggleOptions.put(ActionInfo.DISPLAY_SHOW_TAB_LINES.getActionMapKey(), false);
        this.toggleOptions.put(ActionInfo.DISPLAY_SHOW_WHITESPACE.getActionMapKey(), false);
        this.toggleOptions.put(ActionInfo.DISPLAY_SHOW_LINE_ENDINGS.getActionMapKey(), false);
        this.toggleOptions.put(ActionInfo.DISPLAY_WRAP_LINES.getActionMapKey(), false);
    }

    private void setDefaultAutoCompleteProperties() {
        this.autoCompleteProperties = new AutoCompleteProperties();
    }
}

