/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta.ac;

import com.mirth.connect.client.ui.components.rsta.ac.MirthCompletion;
import com.mirth.connect.client.ui.reference.FunctionReference;
import com.mirth.connect.client.ui.reference.Reference;
import com.mirth.connect.model.Parameter;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.util.MirthXmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ac.js.IconFactory;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public abstract class MirthFunctionCompletion
extends FunctionCompletion
implements MirthCompletion {
    protected String id;
    protected CodeTemplateContextSet contextSet;
    protected List<ParameterizedCompletion.Parameter> parameters;
    protected String iconName;
    protected boolean deprecated;

    public MirthFunctionCompletion(CompletionProvider provider, FunctionReference reference) {
        super(provider, reference.getFunctionDefinition().getName(), MirthXmlUtil.encode((String)StringUtils.defaultString((String)reference.getFunctionDefinition().getReturnType())));
        this.id = reference.getId();
        this.contextSet = reference.getContextSet();
        this.setShortDescription(reference.getDescription());
        this.setReturnValueDescription(reference.getFunctionDefinition().getReturnDescription());
        ArrayList<ParameterizedCompletion.Parameter> list = new ArrayList<ParameterizedCompletion.Parameter>();
        if (CollectionUtils.isNotEmpty((Collection)reference.getFunctionDefinition().getParameters())) {
            for (Parameter param : reference.getFunctionDefinition().getParameters()) {
                ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter((Object)param.getType(), param.getName());
                parameter.setDescription(param.getDescription());
                list.add(parameter);
            }
        }
        this.setParams(list);
        this.iconName = reference.getIconName();
        this.deprecated = reference.isDeprecated();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CodeTemplateContextSet getContextSet() {
        return this.contextSet;
    }

    public List<ParameterizedCompletion.Parameter> getParams() {
        return this.parameters;
    }

    public void setParams(List<ParameterizedCompletion.Parameter> params) {
        if (params != null) {
            this.parameters = new ArrayList<ParameterizedCompletion.Parameter>(params);
            super.setParams(params);
        }
    }

    public Icon getIcon() {
        if (StringUtils.isNotBlank((CharSequence)this.iconName)) {
            return IconFactory.getIcon((String)this.iconName);
        }
        return IconFactory.getIcon((String)"methpub_obj");
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public int getRelevance() {
        return 100;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MirthCompletion) {
            return ((MirthCompletion)obj).getId().equals(this.id);
        }
        if (obj instanceof Reference) {
            return ((Reference)obj).getId().equals(this.id);
        }
        return false;
    }

    public int compareTo(Completion c2) {
        int result = this.compare((Comparable)((Object)this.getReplacementText()), (Object)c2.getReplacementText());
        if (result != 0) {
            return result;
        }
        if (c2 instanceof ParameterizedCompletion) {
            ParameterizedCompletion completion = (ParameterizedCompletion)c2;
            result = this.compare(Integer.valueOf(this.getParamCount()), completion.getParamCount());
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < this.getParamCount(); ++i) {
                ParameterizedCompletion.Parameter param1 = this.getParam(i);
                ParameterizedCompletion.Parameter param2 = completion.getParam(i);
                result = this.compare((Comparable)((Object)param1.getName()), (Object)param2.getName());
                if (result != 0) {
                    return result;
                }
                result = this.compare((Comparable)((Object)param1.getType()), (Object)param2.getType());
                if (result == 0) continue;
                return result;
            }
        }
        return super.compareTo(c2);
    }

    private <T> int compare(Comparable<T> obj1, T obj2) {
        if (obj1 == null) {
            if (obj2 == null) {
                return 0;
            }
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        return obj1.compareTo(obj2);
    }
}

